# ###############################################################
# variables related to TAGS
# ###############################################################
variable "company" {
    type  = string 
    description = "company name"
}

variable "project" {
    type  = string 
    description = "project name"
}

variable "costcenter" {
    type  = string 
    description = "cost center name"
}


variable "environment" {
    type  = string 
    description = "environment name"
}



# ###############################################################
# variables related to RESOURCE GROUP
# ###############################################################
variable "rg_core" {
    type  = string 
    description = "radical to resource group name"
    #default = "SSC"
}


variable "rg_preffix" {
    type  = string 
    description = "preffix to resource group name"
    #default = "rg"
}


variable "location" {
    type  = string 
    description = "code related to Azure Region"
    #default = "eastus"
}    




# ###############################################################
# variables related to COSMOS DB ACCOUNT
# ###############################################################
variable "cosmos_preffix" {
    type  = string 
    description = "preffix to Cosmos Db Account name"
}

variable "cosmosdb_offer_type" {
    type  = string 
    description = "type Standard or Premium"
}  

variable "cosmosdb_kind" {
    type  = string 
    description = "type of API used. Documentation specifies valid values are GlobalDocumentDB and MongoDB only"
}  
 

variable "cosmosdb_consistency_level" {
  type  = string 
  description = "Consistency Level to use for this CosmosDB Account - \n Values are {BoundedStaleness, Eventual, Session, Strong or ConsistentPrefix} \n https://docs.microsoft.com/en-us/azure/cosmos-db/consistency-levels"
  # https://docs.microsoft.com/en-us/azure/cosmos-db/consistency-levels
 } 
 
#geo_location (replication)
variable "cosmosdb_replica_location" {
  type  = string 
  description = "Secondary region that will hold replicated data"
 }  
variable "cosmosdb_failover_priority" {
  type  = string 
  description = "Failover priority in case of crash. Must be a value equal or less than number of replicas minus 1"
 } 


# ###############################################################
# variables related to COSMOS DB DATABASE
# ###############################################################
variable "cosmosdb_dbsqlname" {
  type  = string 
  description = "name of the database (SQL API)"
}

variable "cosmosdb_throughput" {
  type  = string 
  description = "database throughput"
}
           

# ###############################################################
# variables related to DATABRICKS WORKSPACE
# ###############################################################
variable "databricks_preffix" {
  type  = string 
  description = "preffix to Databricks Workspace name"
}  

variable "databricks_sku" {
  type  = string 
  description = "type standard, premium or Trial"
}


# ###############################################################
# variables related to MS SQL SERVER
# ###############################################################
variable "sql_version" {
  type  = string 
  description = "MS SQL Server version"
}

variable "sql_login" {
  type  = string 
  description = "SQL login with SYSADMIN privileges"
}

variable "sql_loginpass" {
  type  = string 
  description = "Password"
 }  

variable "sql_tls" {
  type  = string 
  description = "TLS version"
 }  

variable "aadadmin_name" {
  type  = string
  description = "AAD login with SYSADMIN privileges"
 } 

variable "aadadmin_oid" {
  type  = string
  description = "Object Id correspondent to AAD login <aadadmin_name>"
 } 

variable "sql_preffix" {
    type  =  string
    description = "preffix to MS SQL Server name"
}


# ###############################################################
# variables related to MS SQL SERVER DATABASE
# ###############################################################
variable "mssqldatabase_name" {
  type  = string 
  description = "MS SQL DATABASE name"
 }  

variable "mssqldatabase_collation" {
  type  = string
  description = "database collation"

 } 

variable "mssqldatabase_license" {
  type  = string
  description = "inform type of licensing to be used"

 } 

variable "mssqldatabase_maxsizegb" {
  type  = string
  description = "estabilish the max size allocated to the database (limit 4096 GB)"

 } 

variable "mssqldatabase_sku" {
  type  = string
  description = "database capacity"

 } 


# ###############################################################
# variables related to STORAGE ACCOUNT 
# ###############################################################
variable "stoacct_preffix" {
    type  =  string
    description = "preffix to Storage Account name"
}

variable "stoacct_tier" {
    type  =  string
    description = "Tier for Storage Account . Valid values are STANDARD and PREMIUM"
}

variable "stoacct_replication" {
    type  =  string
    description = "Type of replication for Storage Account . Valid values are LRS, GRS, RAGRS, ZRS, GZRS and RAGZRS"
}



# ###############################################################
# variables related to STORAGE ACCOUNT CONTAINER
# ###############################################################
variable "stoacctcont_name" {
    type  =  string
    description = "Storage Account Container name"
}

variable "stoacctcont_access" {
    type  =  string
    description = "Container access type. Valid values are blob, container or private. Defaults to private."
}




# ###############################################################
# variables related to DATA LAKE GEN2 ACCOUNT (STORAGE ACCOUNT)
# ###############################################################
variable "dtlkg2_acctpreffix" {
    type  =  string
    description = "preffix to resource group name"
}

variable "dtlkg2_tier" {
    type  =  string
    description = "Tier for Storage Account . Valid values are STANDARD and PREMIUM"
}

variable "dtlkg2_replication" {
    type  =  string
    description = "Type of replication for Storage Account . Valid values are LRS, GRS, RAGRS, ZRS, GZRS and RAGZRS"
}

# ###############################################################
# variables related to DATA LAKE GEN2 FILESYSTEM
# ###############################################################
variable "dtlkg2_filesystemname" {
    type  =  string
    description = "Name of Data Lake Gen2"
}

# ###############################################################
# variables related to SYNAPSE WORKSPACE
# ###############################################################
variable "synapsewkspc_preffix" {
  type  = string 
  description = "preffix of resource name."
}  

variable "synapsewkspc_sqladmin_login" {
  type  = string 
  description = "SQL admin login (SQL Pools)"
}

variable "synapsewkspc_sqladmin_pass" {
  type  = string 
  description = "SQL admin password (SQL Pools)"
 }  

variable "synapsewkspc_aadadmin_login" {
  type  = string 
  description = "AAD login for workspace administrator (SQL Pool + Spark Pool)"
 }  

variable "synapsewkspc_aadadmin_objectid" {
  type  = string
  description = "AAD ID for workspace administrator (SQL Pool + Spark Pool)"
 } 

variable "synapsewkspc_aadadmin_tenantid" {
  type  = string
  description = "Tenant associated to workspace administrator's AAD ID (SQL Pool + Spark Pool)"
 } 

variable "synapsewkspc_type" {
  type  = string
  description = "Type of Managed Service Identity used by Synapse Workspace. Valid values: SystemAssigned"
 } 

# ###############################################################
# variables related to SYNAPSE SQL POOL
# ###############################################################
variable "synsqlpool_name" {
  type  = string 
  description = "resource name."
}  

variable "synsqlpool_sku" {
  type  = string 
  description = "SKU for the SQL Pools"
}

variable "synsqlpool_mode" {
  type  = string 
  description = "Create mode for SQL Pools. Vaid values are Default, Recovery or PointInTimeRestore"
 }  
