# Terraform and Azure Provider configuration

terraform {
  required_providers {
    azurerm = {
      source = "hashicorp/azurerm"
      version = "~>3.0"
      ##any azurerm version, from 3.0.0 or above
    }
  }
}

provider "azurerm" {
  features {}
  #tenant_id & subscription_id are not declared, so DEFAULT values associated to login will be assumed here

}

module "ResourceGroup" {
  source                                = "./modules/ResourceGroup"
  rgname   	                            = local.rgname
  location                              = var.location
  tags                                  = local.tags
}

module "cosmosdbaccount" {
  source                                = "./modules/CosmosDB-Acct"
  cosmosdb_accountname                  = local.cosmosdb_accountname
  location                              = var.location
  rgname                                = local.rgname
  cosmosdb_offer_type                   = var.cosmosdb_offer_type
  cosmosdb_kind                         = var.cosmosdb_kind
  cosmosdb_consistency_level            = var.cosmosdb_consistency_level
  cosmosdb_replica_location             = var.cosmosdb_replica_location
  cosmosdb_failover_priority            = var.cosmosdb_failover_priority
  tags                                  = local.tags     

  depends_on = [module.ResourceGroup]               
} 

module "cosmosdbdatabase" {
  source                                = "./modules/CosmosDB-DB"
  cosmosdb_dbsqlname                    = var.cosmosdb_dbsqlname
  rgname                                = local.rgname
  cosmosdb_accountname                  = local.cosmosdb_accountname
  cosmosdb_throughput                   = var.cosmosdb_throughput

  depends_on = [module.cosmosdbaccount]
}

module "databricks" {
  source                                = "./modules/Databricks"
  databricks_name                       = local.databricks_name
  rgname                                = local.rgname
  location                              = var.location
  databricks_sku                        = var.databricks_sku
  tags                                  = local.tags   

  depends_on = [module.ResourceGroup]
}

module "mssqlserver" {
  source                                = "./modules/SQL-Server"
  sql_name                              = local.sql_name
  rgname                                = local.rgname
  location                              = var.location
  sql_version                           = var.sql_version
  sql_login                             = var.sql_login
  sql_loginpass                         = var.sql_loginpass
  sql_tls                               = var.sql_tls
  aadadmin_name                         = var.aadadmin_name 
  aadadmin_oid                          = var.aadadmin_oid

  tags                                  = local.tags

  depends_on = [module.ResourceGroup]
}

module "mssqldatabase" {
  source                                = "./modules/SQL-DB"
  mssqldatabase_name                    = var.mssqldatabase_name
  mssqldatabase_serverid                = module.mssqlserver.sqlserver_id
  mssqldatabase_collation               = var.mssqldatabase_collation
  mssqldatabase_license                 = var.mssqldatabase_license
  mssqldatabase_maxsizegb               = var.mssqldatabase_maxsizegb
  mssqldatabase_sku                     = var.mssqldatabase_sku
  tags                                  = local.tags 
  depends_on = [module.mssqlserver]
}


module "storageaccount" {
  source                                = "./modules/StorageAccount"
  stoacct_name                          = local.stoacct_name
  rgname                                = local.rgname
  location                              = var.location
  stoacct_tier                          = var.stoacct_tier
  stoacct_replication                   = var.stoacct_replication

  tags                                  = local.tags

  depends_on = [module.ResourceGroup]
}


module "storageaccountcontainer" {
  source                                = "./modules/StorageAccountContainer"
  stoacctcont_name                      = var.stoacctcont_name
  stoacct_name                          = local.stoacct_name
  stoacctcont_access                    = var.stoacctcont_access

  depends_on = [module.storageaccount]
}


# SYNAPSE WORKSPACE REQUISITES
# Storage Account + Data Lake Filesystem
module "datalakegen2account" {  
  source                                = "./modules/StorageAccount"
  stoacct_name                          = local.dtlkg2_acctname
  rgname                                = local.rgname
  location                              = var.location
  stoacct_tier                          = var.dtlkg2_tier
  stoacct_replication                   = var.dtlkg2_replication

  tags                                  = local.tags

  depends_on = [module.ResourceGroup]
}

module "datalakegen2filesystem" {
  source                                = "./modules/DataLakeGen2"
  dtlkg2_name                           = var.dtlkg2_filesystemname
  dtlkg2_acctid                         = module.datalakegen2account.id

  depends_on = [module.datalakegen2account]
}


module "synapseworkspace" {
  source                                = "./modules/SynapseWorkspace"
  synapsewkspc_name                     = local.synapsewkspc_name
  location                              = var.location
  rgname                                = local.rgname
  synapsewkspc_datalakeid               = module.datalakegen2filesystem.id
  synapsewkspc_sqladmin_login           = var.synapsewkspc_sqladmin_login 
  synapsewkspc_sqladmin_pass            = var.synapsewkspc_sqladmin_pass

  synapsewkspc_aadadmin_login           = var.synapsewkspc_aadadmin_login
  synapsewkspc_aadadmin_objectid        = var.synapsewkspc_aadadmin_objectid  
  synapsewkspc_aadadmin_tenantid        = var.synapsewkspc_aadadmin_tenantid

  synapsewkspc_type                     = var.synapsewkspc_type

  tags                                  = local.tags

  depends_on = [module.datalakegen2filesystem]
}



module "synapsesqlpool" {
  source                                = "./modules/SynapseSQLPool"
  synsqlpool_name                       = var.synsqlpool_name
  synsqlpool_wrkspcid                   = module.synapseworkspace.id
  synsqlpool_sku                        = var.synsqlpool_sku
  synsqlpool_mode                       = var.synsqlpool_mode

  depends_on = [module.synapseworkspace]
}

