resource "azurerm_synapse_workspace" "synapsewokspace" {
  name                                  = var.synapsewkspc_name
  location                              = var.location
  resource_group_name                   = var.rgname
  storage_data_lake_gen2_filesystem_id  = var.synapsewkspc_datalakeid
  sql_administrator_login               = var.synapsewkspc_sqladmin_login            
  sql_administrator_login_password      = var.synapsewkspc_sqladmin_pass

  aad_admin  {
     login            = var.synapsewkspc_aadadmin_login
     object_id        = var.synapsewkspc_aadadmin_objectid  
     tenant_id        = var.synapsewkspc_aadadmin_tenantid
  }

  identity  {
    type              = var.synapsewkspc_type
  }

  tags                                  = var.tags
}
