variable "rgname" {
  type  = string 
  description = "The resource group name."
}
variable "location" {
  type  = string 
  description = "The region were the resource will be deployed."
}

variable "cosmosdb_accountname" {
  type  = string 
  description = "The Cosmos DB account name."
}  

variable "cosmosdb_offer_type" {
  type  = string 
  description = "type Standard or Premium"
}

variable "cosmosdb_kind" {
  type  = string 
  description = "type of API used. Documentation specifies valid values are GlobalDocumentDB and MongoDB only"
}
 

variable "cosmosdb_replica_location" {
  type  = string 
  description = "Secondary region that will hold replicated data"
 }  
variable "cosmosdb_failover_priority" {
  type  = string 
  description = "Failover priority in case of crash. Must be a value equal or less than number of replicas minus 1"
 }  

variable "cosmosdb_consistency_level" {
  type  = string
  description = "block definition for Consistency Policy"
  # https://docs.microsoft.com/en-us/azure/cosmos-db/consistency-levels
 } 


variable "tags" {
    type  = map(string) 
    description = "tags related to project"
}
