resource "azurerm_cosmosdb_account" "cosmosdbaccount" {
  name                                  = var.cosmosdb_accountname
  location                              = var.location
  resource_group_name                   = var.rgname
  offer_type                            = var.cosmosdb_offer_type
  kind                                  = var.cosmosdb_kind
  consistency_policy {
     consistency_level          = var.cosmosdb_consistency_level
  }
  geo_location  {
    location            = var.cosmosdb_replica_location
    failover_priority   = var.cosmosdb_failover_priority
  }

  tags                                  = var.tags
}
