#Random ID for unique naming
resource "random_integer" "rand" {
  min = 000001
  max = 999999
}


locals {
  #TAGS
  tags = {
    company      = var.company
    project      = "${var.company}-${var.project}"
    costcenter   = var.costcenter
    environment  = var.environment
  }  

  #RESOURCE GROUP
  randomSuffix          = "${format("%06s", random_integer.rand.result)}"
  rgname = "${var.rg_preffix}${var.rg_core}-${local.randomSuffix}"

  #COSMOSDB_ACCOUNT
  cosmosdb_accountname   = lower("${var.cosmos_preffix}${var.rg_core}-${local.randomSuffix}")
  
  #DATABRICKS
  databricks_name        = "${var.databricks_preffix}${var.rg_core}-${local.randomSuffix}"

  #MS SQL SERVER
  sql_name               = lower("${var.sql_preffix}${var.rg_core}-${local.randomSuffix}")

  #STORAGE ACCOUNT
  stoacct_name           = lower("${var.stoacct_preffix}${var.rg_core}${local.randomSuffix}")

  #DATA LAKE GEN2 (ACCOUNT)
  dtlkg2_acctname        = lower("${var.dtlkg2_acctpreffix}${var.rg_core}${local.randomSuffix}")

  #SYNAPSE WORKSPACE
  synapsewkspc_name        = lower("${var.synapsewkspc_preffix}-${var.rg_core}${local.randomSuffix}")

}