# variables related to RESOURCE GROUP
variable "rgName" {
    type  = string 
    description = "preffix to resource group name"
    default = "SSC"
}


variable "rgPreffix" {
    type  = string 
    description = "preffix to resource group name"
    default = "rg"
}


variable "location" {
    type  = string 
    description = "code related to Azure Region"
    default = "eastus"
}    


# variables related to SQL SERVER
variable "sqlserverPreffix" {
    type  = string 
    description = "preffix to SQL server name"
    default = "srv"
}


variable "sql_login" {
    type  = string 
    description = "Server administrator - SQL login"
    default = "admSSC"
}


variable "sql_password" {
    type  = string 
    description = "Server administrator - Password"
    default = "sqlserver@dM$sC2022"
}


variable "sql_tls" {
    type  = string 
    description = "sql minimum tls version accepted"
    default = "1.2"
}    


# variables related to STORAGE ACCOUNT
variable "bckPreffix" {
    type  = string 
    description = "preffix of to storage account name"
    default = "sto"
}  

variable "bckStoTier" {
    type  = string 
    description = "Storage account tier"
    default = "Standard"
}  

variable "bckStoReplication" {
    type  = string 
    description = "Storage account replication type"
    default = "LRS"
}  


# variables related to DATABASE
variable "dbName" {
    type  = string 
    description = "database name"
    default = "myFirstDB"
}  


variable "dbCollation" {
    type  = string 
    description = "database collation"
    default = "SQL_Latin1_General_CP1_CI_AS"
}  


variable "dbLicense" {
    type  = string 
    description = "database license type"
    default = "LicenseIncluded"
}  

#check terraform variable types in here
#https://www.terraform.io/language/expressions/types
variable "dbMax_size_gb" {
    type  = number 
    description = "database maximum size GB"
    default = 50
}  


variable "dbSku_name" {
    type  = string 
    description = "database capacity"
    default = "S0" # <=== STANDARD tier
}  

#this parameter is not available for STANDARD & BASIC tiers
variable "dbRead_scale" {
    type  = bool 
    description = "database read scale"
    default = null
}


#this parameter is not available for STANDARD & BASIC tiers
variable "dbZone_redundant" {
    type  = bool 
    description = "database zone redundancy"
    default = null
}


variable "company" {
    type  = string 
    description = "company name"
    default = "WideWorldImporters"
}

variable "project" {
    type  = string 
    description = "project name"
    default = "terraforming"
}

variable "costcenter" {
    type  = string 
    description = "cost center name"
    default = "xyz"
}


variable "environment" {
    type  = string 
    description = "environment name"
    default = "DEV"
}

