# Terraform and Azure Provider configuration

terraform {
  required_providers {
    azurerm = {
      source = "hashicorp/azurerm"
      version = "~>3.0"
      ##any azurerm version, from 3.0.0 or above
    }
  }
}

provider "azurerm" {
  features {}
  #tenant_id & subscription_id are not declared, so DEFAULT values associated to login will be assumed here

}

#reference https://registry.terraform.io/providers/hashicorp/azurerm/latest/docs/resources/resource_group
resource "azurerm_resource_group" "rg" {
    name              	       	 = local.rgname
    location	         		    	 = var.location
    tags                    		 = local.common_tags
  }


# reference https://registry.terraform.io/providers/hashicorp/azurerm/latest/docs/resources/mssql_server
resource "azurerm_mssql_server" "sqlserver" {
    name                         = local.sqlservername
    resource_group_name          = local.rgname
    location                     = var.location
    version                      = "12.0"
    administrator_login          = var.sql_login
    administrator_login_password = var.sql_password
    minimum_tls_version          = var.sql_tls

    #azuread_administrator {
    #login_username               = var.aad_admname
    #object_id               		 = var.aad_admname.id
    #}

    tags                         = local.common_tags

    #depends_on                   = azurerm_resource_group.rg
}


# IMPORTANT : a storage account is also deployed to store DB backups
# reference https://registry.terraform.io/providers/hashicorp/azurerm/latest/docs/resources/mssql_database
resource "azurerm_storage_account" "stoacct" {
    name                         = local.backupstoragename
    resource_group_name          = local.rgname
    location                     = var.location
    account_tier                 = var.bckStoTier
    account_replication_type     = var.bckStoReplication

    #depends_on                   = azurerm_resource_group.rg
}


# reference https://registry.terraform.io/providers/hashicorp/azurerm/latest/docs/resources/mssql_database
resource "azurerm_mssql_database" "sqldb" {
    name                         = var.dbName
    server_id                    = azurerm_mssql_server.sqlserver.id
    collation                    = var.dbCollation
    license_type                 = var.dbLicense
    max_size_gb                  = var.dbMax_size_gb
    sku_name                     = var.dbSku_name
    read_scale                   = var.dbRead_scale
    zone_redundant               = var.dbZone_redundant

    tags                         = local.common_tags

    #depends_on                   = azurerm_mssql_server.sqlserver
}
