#Random ID for unique naming
resource "random_integer" "rand" {
  min = 000001
  max = 999999
}


locals {

  randomSuffix = "${format("%06s", random_integer.rand.result)}"
  
  rgname = "${var.rgPreffix}${var.rgName}-${local.randomSuffix}"

  sqlservername = lower("${var.sqlserverPreffix}${var.rgName}-${local.randomSuffix}")


  backupstoragename = lower("${var.bckPreffix}${var.rgName}${local.randomSuffix}")

  common_tags = {
    company      = var.company
    project      = "${var.company}-${var.project}"
    costcenter   = var.costcenter
    environment  = var.environment
  }  
}
