/*
Script:		Build bipartite graph manually
Comment:	SET @Block = N below (N = 1, 2, ...) to populate graph
Queries:

SELECT * FROM dbo.[LeftNodes] ORDER BY LeftNode
SELECT * FROM dbo.[RightNodes] ORDER BY RightNode
SELECT * FROM dbo.Graph ORDER BY LeftNode, RightNode
SELECT * FROM dbo.Graph WHERE M = 1 ORDER BY LeftNode, RightNode
SELECT count(*) FROM dbo.Graph WHERE M = 1
*/

SET NOCOUNT ON
GO

/*
Create LeftNodes
*/

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[LeftNodes]') AND type in (N'U'))
	DROP TABLE [dbo].[LeftNodes]
GO

CREATE TABLE [dbo].[LeftNodes](
	[LeftNode]	int NULL,
	[U]			bit NULL,
	[S]			bit NULL,
	Path		varchar(max) NULL
) ON [PRIMARY]
GO

/*
Create RightNodes
*/

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RightNodes]') AND type in (N'U'))
	DROP TABLE [dbo].[RightNodes]
GO

CREATE TABLE [dbo].[RightNodes](
	[RightNode]	int NULL,
	[V]			bit NULL,
	[T]			bit NULL,
	[Path]		varchar(max) NULL

) ON [PRIMARY]
GO

/*
Create Graph
*/

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Graph]') AND type in (N'U'))
	DROP TABLE [dbo].[Graph]
GO

CREATE TABLE [dbo].[Graph](
	[LeftNode]	int NULL,
	[RightNode]	int NULL,
	[M]			bit NULL
) ON [PRIMARY]
GO

/*
Populate tables
*/

-- LeftNodes
INSERT INTO dbo.LeftNodes(LeftNode, U, S, Path) VALUES (1, 0, 0, '')
INSERT INTO dbo.LeftNodes(LeftNode, U, S, Path) VALUES (2, 0, 0, '')
INSERT INTO dbo.LeftNodes(LeftNode, U, S, Path) VALUES (3, 0, 0, '')
INSERT INTO dbo.LeftNodes(LeftNode, U, S, Path) VALUES (4, 0, 0, '')
INSERT INTO dbo.LeftNodes(LeftNode, U, S, Path) VALUES (5, 0, 0, '')
INSERT INTO dbo.LeftNodes(LeftNode, U, S, Path) VALUES (6, 0, 0, '')

-- RightNodes
INSERT INTO dbo.RightNodes(RightNode, V, T, Path) VALUES (1, 0, 0, '')
INSERT INTO dbo.RightNodes(RightNode, V, T, Path) VALUES (2, 0, 0, '')
INSERT INTO dbo.RightNodes(RightNode, V, T, Path) VALUES (3, 0, 0, '')
INSERT INTO dbo.RightNodes(RightNode, V, T, Path) VALUES (4, 0, 0, '')
INSERT INTO dbo.RightNodes(RightNode, V, T, Path) VALUES (5, 0, 0, '')
INSERT INTO dbo.RightNodes(RightNode, V, T, Path) VALUES (6, 0, 0, '')

-- Graph
DECLARE @Block int
SET @Block = 1	-- Select data to populate graph

-- Perfect match
IF @Block = 1
BEGIN
INSERT INTO dbo.Graph(LeftNode, RightNode, M) VALUES (1, 1, 0) 
INSERT INTO dbo.Graph(LeftNode, RightNode, M) VALUES (2, 2, 0) 
INSERT INTO dbo.Graph(LeftNode, RightNode, M) VALUES (2, 3, 0) 
INSERT INTO dbo.Graph(LeftNode, RightNode, M) VALUES (2, 6, 0) 
INSERT INTO dbo.Graph(LeftNode, RightNode, M) VALUES (3, 3, 0) 
INSERT INTO dbo.Graph(LeftNode, RightNode, M) VALUES (3, 4, 0) 
INSERT INTO dbo.Graph(LeftNode, RightNode, M) VALUES (3, 5, 0)
INSERT INTO dbo.Graph(LeftNode, RightNode, M) VALUES (4, 3, 0) 
INSERT INTO dbo.Graph(LeftNode, RightNode, M) VALUES (4, 4, 0) 
INSERT INTO dbo.Graph(LeftNode, RightNode, M) VALUES (5, 4, 0) 
INSERT INTO dbo.Graph(LeftNode, RightNode, M) VALUES (6, 2, 0) 
END

-- Greedy algorithm fails to capture at least half the nodes
IF @Block = 2
BEGIN
INSERT INTO dbo.Graph(LeftNode, RightNode, M) VALUES (1, 1, 0)
INSERT INTO dbo.Graph(LeftNode, RightNode, M) VALUES (1, 3, 0)
INSERT INTO dbo.Graph(LeftNode, RightNode, M) VALUES (2, 2, 0)
INSERT INTO dbo.Graph(LeftNode, RightNode, M) VALUES (3, 1, 0)
INSERT INTO dbo.Graph(LeftNode, RightNode, M) VALUES (2, 4, 0)
INSERT INTO dbo.Graph(LeftNode, RightNode, M) VALUES (2, 5, 0)
INSERT INTO dbo.Graph(LeftNode, RightNode, M) VALUES (2, 6, 0)
INSERT INTO dbo.Graph(LeftNode, RightNode, M) VALUES (4, 2, 0)
INSERT INTO dbo.Graph(LeftNode, RightNode, M) VALUES (5, 1, 0)
INSERT INTO dbo.Graph(LeftNode, RightNode, M) VALUES (6, 2, 0)
END

-- Not enough RightNodes for matching LeftNodes
IF @Block = 3
BEGIN
INSERT INTO dbo.Graph(LeftNode, RightNode, M) VALUES (1, 1, 0) 
INSERT INTO dbo.Graph(LeftNode, RightNode, M) VALUES (1, 6, 0) 
INSERT INTO dbo.Graph(LeftNode, RightNode, M) VALUES (2, 2, 0) 
INSERT INTO dbo.Graph(LeftNode, RightNode, M) VALUES (2, 3, 0) 
INSERT INTO dbo.Graph(LeftNode, RightNode, M) VALUES (3, 3, 0) 
INSERT INTO dbo.Graph(LeftNode, RightNode, M) VALUES (3, 4, 0) 
INSERT INTO dbo.Graph(LeftNode, RightNode, M) VALUES (3, 5, 0)
INSERT INTO dbo.Graph(LeftNode, RightNode, M) VALUES (4, 3, 0) 
INSERT INTO dbo.Graph(LeftNode, RightNode, M) VALUES (4, 4, 0) 
INSERT INTO dbo.Graph(LeftNode, RightNode, M) VALUES (5, 4, 0) 
INSERT INTO dbo.Graph(LeftNode, RightNode, M) VALUES (6, 2, 0) 
END

-- Greedy algorithm produces perfect match
IF @Block = 4
BEGIN
INSERT INTO dbo.Graph(LeftNode, RightNode, M) VALUES (1, 1, 0) 
INSERT INTO dbo.Graph(LeftNode, RightNode, M) VALUES (2, 2, 0) 
INSERT INTO dbo.Graph(LeftNode, RightNode, M) VALUES (3, 3, 0) 
INSERT INTO dbo.Graph(LeftNode, RightNode, M) VALUES (4, 4, 0) 
INSERT INTO dbo.Graph(LeftNode, RightNode, M) VALUES (5, 5, 0) 
INSERT INTO dbo.Graph(LeftNode, RightNode, M) VALUES (6, 6, 0) 

END
