EXEC tsqlt.NewTestClass @ClassName = N'AdminChecks' -- nvarchar(max)
GO
CREATE PROCEDURE [AdminChecks].[test JobFailureProc with No Failures]
AS
BEGIN
    --------------------------------------------
	----- Assemble
	--------------------------------------------
    DECLARE @expected INT
	      , @actual INT

	SELECT @expected = 0

	CREATE TABLE #ProcResult (actual INT)
    
    --------------------------------------------
	----- Act
	--------------------------------------------
	-- Clear jobs
    EXEC msdb.dbo.sp_start_job @job_name = 'Second Job with Two Errors', @step_name='Fourth Step'
	 WAITFOR DELAY '00:00:02'
    EXEC msdb.dbo.sp_start_job @job_name = 'A Job with a Step Failure', @step_name='Export Data'
	 WAITFOR DELAY '00:00:02'
    EXEC msdb.dbo.sp_start_job @job_name = 'Job that always fails', @step_name='Success Step'
	 WAITFOR DELAY '00:00:02'
	-- run the job
	EXEC msdb.dbo.sp_start_job @job_name = 'A Job that Always Succeeds'
	 WAITFOR DELAY '00:00:02'
	
	-- GET results
	INSERT #ProcResult
		EXEC CheckForFailedJobSteps

	SELECT @actual = actual FROM #ProcResult AS pr
    --------------------------------------------
	----- Assert
	--------------------------------------------
	EXEC tsqlt.AssertEquals @Expected = @expected, 
	                        @Actual = @actual,   
	                        @Message = N'Incorrect result'
	
END    
GO

CREATE PROCEDURE [AdminChecks].[test JobFailureProc with 1 Failures]
AS
BEGIN
    --------------------------------------------
	----- Assemble
	--------------------------------------------
    DECLARE @expected INT
	      , @actual INT

	SELECT @expected = 1

	CREATE TABLE #ProcResult (actual INT)
    
    --------------------------------------------
	----- Act
	--------------------------------------------
	-- Clear jobs
    EXEC msdb.dbo.sp_start_job @job_name = 'Second Job with Two Errors', @step_name='Fourth Step'
	 WAITFOR DELAY '00:00:02'
    EXEC msdb.dbo.sp_start_job @job_name = 'A Job with a Step Failure', @step_name='Export Data'
	 WAITFOR DELAY '00:00:02'
    EXEC msdb.dbo.sp_start_job @job_name = 'Job that always fails', @step_name='Success Step'
	 WAITFOR DELAY '00:00:02'
	-- run the job
	EXEC msdb.dbo.sp_start_job @job_name = 'A Job with a Step Failure'
	 WAITFOR DELAY '00:00:02'
	
	-- GET results
	INSERT #ProcResult
		EXEC CheckForFailedJobSteps

	SELECT @actual = actual FROM #ProcResult AS pr
    --------------------------------------------
	----- Assert
	--------------------------------------------
	EXEC tsqlt.AssertEquals @Expected = @expected, 
	                        @Actual = @actual,   
	                        @Message = N'Incorrect result'
	
END    
GO

CREATE PROCEDURE [AdminChecks].[test JobFailureProc with 2 Failures]
AS
BEGIN
    --------------------------------------------
	----- Assemble
	--------------------------------------------
    DECLARE @expected INT
	      , @actual INT

	SELECT @expected = 2

    
    --------------------------------------------
	----- Act
	--------------------------------------------
	-- Clear jobs
    EXEC msdb.dbo.sp_start_job @job_name = 'Second Job with Two Errors', @step_name='Fourth Step'
	 WAITFOR DELAY '00:00:02'
    EXEC msdb.dbo.sp_start_job @job_name = 'A Job with a Step Failure', @step_name='Export Data'
	 WAITFOR DELAY '00:00:02'
    EXEC msdb.dbo.sp_start_job @job_name = 'Job that always fails', @step_name='Success Step'
	 WAITFOR DELAY '00:00:02'
	-- run the job
	EXEC msdb.dbo.sp_start_job @job_name = 'Second Job with Two Errors'
	 WAITFOR DELAY '00:00:02'
	
	-- GET results
		EXEC @actual = CheckForFailedJobSteps
    --------------------------------------------
	----- Assert
	--------------------------------------------
	EXEC tsqlt.AssertEquals @Expected = @expected, 
	                        @Actual = @actual,   
	                        @Message = N'Incorrect result'
	
END    
GO

CREATE PROCEDURE [AdminChecks].[test JobFailureProc with Failures and then success]
AS
BEGIN
    --------------------------------------------
	----- Assemble
	--------------------------------------------
    DECLARE @expected INT
	      , @actual INT

	SELECT @expected = 0

    
    --------------------------------------------
	----- Act
	--------------------------------------------
	-- Clear jobs
    EXEC msdb.dbo.sp_start_job @job_name = 'Second Job with Two Errors', @step_name='Fourth Step'
	 WAITFOR DELAY '00:00:02'
    EXEC msdb.dbo.sp_start_job @job_name = 'A Job with a Step Failure', @step_name='Export Data'
	 WAITFOR DELAY '00:00:02'
    EXEC msdb.dbo.sp_start_job @job_name = 'Job that always fails', @step_name='Success Step'
	 WAITFOR DELAY '00:00:02'
	-- run the job
	EXEC msdb.dbo.sp_start_job @job_name = 'A Job with a Step Failure'
	 WAITFOR DELAY '00:00:02'
	EXEC msdb.dbo.sp_start_job @job_name = 'A Job with a Step Failure', @step_name = 'Export Data'
	 WAITFOR DELAY '00:00:02'
	
	-- GET results
		EXEC @actual = CheckForFailedJobSteps
    --------------------------------------------
	----- Assert
	--------------------------------------------
	EXEC tsqlt.AssertEquals @Expected = @expected, 
	                        @Actual = @actual,   
	                        @Message = N'Incorrect result'
	
END    
GO

