CREATE OR ALTER PROC CheckForFailedJobSteps AS;
WITH  cteJobStep (Job_ID, Step_Name, run_date, run_time)
      AS (SELECT jh.job_id,
                 jh.step_name AS JobStepName,
                 jh.run_date,
                 jh.run_time
          FROM msdb.dbo.sysjobhistory jh
              INNER JOIN msdb.dbo.sysjobactivity ja
                  ON jh.job_id = ja.job_id
          WHERE jh.run_status = 0 --step failed
                AND jh.step_id != 0
                --         and jh.job_id = CONVERT(uniqueidentifier, '8C673935-F8C1-4E7D-94D3-1F3CAE50D7DC')
                AND --this block ensures that we just pull information from the most recent job run
              (
              -- The start time of the step, converted to datetime
              CONVERT(DATETIME, RTRIM(jh.run_date))
              + (jh.run_time * 9 + jh.run_time % 10000 * 6 + jh.run_time % 100
                 * 10
                ) / 216e4 >= ja.start_execution_date -- the time the job last started
              ))
SELECT COUNT(*) AS Failures
FROM cteJobStep c
    INNER JOIN msdb.dbo.sysjobhistory
    AS
    h
        ON h.job_id = c.Job_ID
           AND h.run_date = c.run_date
           AND h.run_time = c.run_time
           AND h.step_id = 0
           AND h.run_status = 1;
RETURN;
GO
    EXEC msdb.dbo.sp_start_job @job_name = 'Second Job with Two Errors', @step_name='Fourth Step'
	 WAITFOR DELAY '00:00:02'
    EXEC msdb.dbo.sp_start_job @job_name = 'A Job with a Step Failure', @step_name='Export Data'
	 WAITFOR DELAY '00:00:02'
    EXEC msdb.dbo.sp_start_job @job_name = 'Job that always fails', @step_name='Success Step'
	 WAITFOR DELAY '00:00:02'
	-- run the job
	EXEC msdb.dbo.sp_start_job @job_name = 'A Job with a Step Failure'
	 WAITFOR DELAY '00:00:02'
EXEC dbo.CheckForFailedJobSteps
