USE [SQLErrorLogMonitor]
GO

IF (OBJECT_ID('Mail_SQLErrorlog')) IS NULL
  EXEC ('CREATE PROC [Mail_SQLErrorlog] AS PRINT ''STUB''')
GO


ALTER PROC [dbo].[Mail_SQLErrorlog]
      @recipients   VARCHAR(MAX)
    , @profile_name SYSNAME
AS
/* Script to mail 'unusual' SQL Error Log entries, after collection in a holding table on the monitor server.
   This script should be run after retrieval of linked server error logs (procedure 'Retrieve_LinkedServer_ErrorLog') 
   and removal of trivial messages (procedure 'Cleanup_Errorlog_Holding_Table')
*/
    -- Send message if the error log holding table contains entries other than failed logins  
IF EXISTS (SELECT 1 FROM tempdb.dbo.SQLErrorlog WHERE CHARINDEX('Login failed for user', [text]) = 0)
 BEGIN
  DECLARE  @subj  VARCHAR(200)
         , @xml   NVARCHAR(MAX)
         , @body  NVARCHAR(MAX)
  SELECT   @subj   = 'SQL Error Log entries'
  SET @body = '<html><body>
               <p><font size="2" face="monaco">
               (This mail was sent by the procedure ''' + DB_NAME() + '.' + OBJECT_SCHEMA_NAME (@@PROCID) + '.' + OBJECT_NAME(@@PROCID) + ''') <BR><BR>               
               The table below contains unusual SQL Log entries recorded during the past 24 hours.
               <H3>SQL Errorlog entries</H3>
               <table border="1" cellpadding="5"> 
               <p><font size="2" face="monaco">               
               <tr>
               <th> Server </th> <th> Date </th> <th> Process </th> <th> Count </th> <th> Text </th> </tr>'    
  
  SET @xml = CAST(
           (SELECT   [SQLInstance]                  AS 'td',''
                   , CONVERT(CHAR(30),[LogDate],21) AS 'td',''
                   , [Processinfo]                  AS 'td',''
                   , [Count]                        AS 'td',''
                   , [Text]                         AS 'td','' 
            FROM     tempdb.dbo.SQLErrorlog 
            WHERE    CHARINDEX('Login failed for user', [text]) = 0     -- no regular failed login warnings
            ORDER BY [SQLInstance]
                   , [Count] DESC
                   , [LogDate] DESC
            FOR XML PATH('tr'), ELEMENTS) 
            AS NVARCHAR(MAX))
  SET @body = @body + @xml +'</table></body></html>'
  EXEC msdb.dbo.sp_send_dbmail              -- Send email 
       @profile_name = @profile_name
     , @recipients   = @recipients
     , @subject      = @subj
     , @body         = @body
     , @body_format  ='HTML'
END
GO


