-- Populate exclusion table (lines from the SQL error log we do not want to show up in the error log warning mail)
USE [SQLErrorLogMonitor]
GO

IF OBJECT_ID('SQLErrorLog_Exclude') IS NULL 
  CREATE TABLE [dbo].[SQLErrorLog_Exclude] (
      [Text]        [VARCHAR](200) NOT NULL,
      [SQLInstance] [SYSNAME] NULL,
      [StartHour]   [SMALLINT] NULL,
      [EndHour]     [SMALLINT] NULL  
  ) ;

TRUNCATE TABLE [SQLErrorLog_exclude] ;

/*
  Columns and order:
  1) Error Text 2) Server name 3) Start hour 4) End hour
  Examples:
  -Exclude all occurrences of 'error text' on any server, any time
  INSERT INTO [SQLErrorLog_exclude] 
    SELECT '%error text%', null, null, null 
  -Exclude all occurrences of 'AppDomain xx created', where 'xx' is any number, on any server, any time
  INSERT INTO [SQLErrorLog_exclude] 
    SELECT '%AppDomain % created%', null, null, null 

  - Only exclude an error if it occurs on ServerA
  INSERT INTO [SQLErrorLog_exclude] 
    SELECT '%error text%', 'ServerA', null, null 
  - Only exclude an error if it occurs on ServerA between 7PM and 9PM
  INSERT INTO [SQLErrorLog_exclude] 
    SELECT '%error text%', 'ServerA', 19, 21
*/

-- Columns and order:
-- 1) Error Text 2) Server name 3) Start hour 4) End hour
INSERT INTO [SQLErrorLog_exclude] 
          SELECT '%(c)%',                                                        null, null, null 
UNION ALL SELECT '%Microsoft SQL Server%',                                       null, null, null
UNION ALL SELECT '%A self-generated certificate was successfully loaded %',      null, null, null
UNION ALL SELECT '%All rights reserved%',                                        null, null, null
UNION ALL SELECT '%Authentication mode is MIXED%',                               null, null, null
UNION ALL SELECT '%backed up%',                                                  null, null, null 
UNION ALL SELECT '%changed from 0 to 0%',                                        null, null, null
UNION ALL SELECT '%Clearing tempdb database%',                                   null, null, null
UNION ALL SELECT '%Configuration option ''show advanced options'' changed%',     null, null, null
UNION ALL SELECT '%Database mirroring has been enabled on this instance%',       null, null, null
UNION ALL SELECT '%Dedicated admin connection support was established%',         null, null, null
UNION ALL SELECT '%Error: 14420%',                                               null, null, null
UNION ALL SELECT '%Error: 14421%',                                               null, null, null
UNION ALL SELECT '%Error: 18456%',                                               null, null, null
UNION ALL SELECT '%FILESTREAM: effective level = 0, configured level = 0%',      null, null, null  
UNION ALL SELECT '%found 0 errors and repaired 0 errors%',                       null, null, null 
UNION ALL SELECT '%I/O is frozen on database%',                                  null, null, null
UNION ALL SELECT '%I/O was resumed on database%',                                null, null, null
UNION ALL SELECT '%informational message%',                                      null, null, null 
UNION ALL SELECT '%Log was restored%',                                           null, null, null
UNION ALL SELECT '%Logging SQL Server messages in file%',                        null, null, null
UNION ALL SELECT '%provider is ready to accept connection%',                     null, null, null
UNION ALL SELECT '%Registry startup parameters%',                                null, null, null
UNION ALL SELECT '%Service Broker manager has started%',                         null, null, null
UNION ALL SELECT '%Server is listening on%',                                     null, null, null
UNION ALL SELECT '%Server process ID is%',                                       null, null, null
UNION ALL SELECT '%Starting up database%',                                       null, null, null
UNION ALL SELECT '%System Manufacturer: ''VMware, Inc.''%',                      null, null, null
UNION ALL SELECT '%The Database Mirroring protocol transport is now listening%', null, null, null
UNION ALL SELECT '%The error log has been reinitialized%',                       null, null, null
UNION ALL SELECT '%The Service Broker protocol transport is disabled%',          null, null, null
UNION ALL SELECT '%Using locked pages for buffer pool%',                         null, null, null   
UNION ALL SELECT '%Error 778263, severity 16, state 1 was raised%',              null, null, null
UNION ALL SELECT '%Failure to calculate super-latch promotion threshold%',       null, null, null
UNION ALL SELECT '%Using ''dbghelp.dll'' version ''4.0.5''%',                    null, null, null
UNION ALL SELECT '%BACKUP DATABASE successfully processed%',                     null, null, null
UNION ALL SELECT '%BACKUP DATABASE WITH DIFFERENTIAL successfully processed%',   null, null, null
UNION ALL SELECT '%Command Line Startup Parameters: -s%',                        null, null, null
UNION ALL SELECT '%Using conventional memory%',                                  null, null, null
UNION ALL SELECT '%Resource governor reconfiguration%',                          null, null, null
UNION ALL SELECT '%Software Usage Metrics is enabled%',                          null, null, null
UNION ALL SELECT '%A new instance of the full-text filter daemon host process%', null, null, null
UNION ALL SELECT '%Common language runtime (CLR) functionality initialized%',    null, null, null
UNION ALL SELECT '%Authentication mode is WINDOWS-ONLY%',                        null, null, null
UNION ALL SELECT '%Command Line Startup Parameters:%',                           null, null, null
UNION ALL SELECT '%Buffer pool extension is already disabled. No action%',       null, null, null
UNION ALL SELECT '%Default collation:%',                                         null, null, null 
UNION ALL SELECT '%In-Memory OLTP initialized on lowend machine%',               null, null, null
UNION ALL SELECT '%Query Store settings initialized with enabled = 1%',          null, null, null
UNION ALL SELECT '%Setting database option % to % for database%',                null, null, null 
UNION ALL SELECT '%Polybase feature disabled%',                                  null, null, null
UNION ALL SELECT '%The tempdb database has % data file(s)%',                     null, null, null
UNION ALL SELECT '%The maximum number of dedicated administrator connections%',  null, null, null
UNION ALL SELECT '%UTC adjustment: %',                                           null, null, null
UNION ALL SELECT '%The activated proc % running on queue%',                      null, null, null
UNION ALL SELECT '%The Service Broker endpoint is in disabled or stopped state%',null, null, null
-- If you do not want to monitor failed logins, uncomment the line below:
-- UNION ALL SELECT '%Login failed%', null, null, null
;