USE [SQLErrorLogMonitor]
GO

IF (OBJECT_ID('Mail_Warning_SQLErrorlog')) IS NULL
  EXEC ('CREATE PROC Mail_Warning_SQLErrorlog AS PRINT ''STUB''')
GO

ALTER PROC [dbo].[Mail_Warning_SQLErrorlog]
      @recipients   VARCHAR(MAX)
    , @profile_name SYSNAME
AS
/* Script to mail a warning that a large number of 'unusual' SQL Error Log entries have been found. 
   Normally, these entries are mailed to the recipient, but when the number of entries exceeds a threshold, 
   only the warning below is sent, asking the recipient to review the entries in the relevant table.
*/
    -- Send message 
DECLARE  @subj  VARCHAR(200)
       , @body  NVARCHAR(MAX)
SELECT   @subj   = 'Large number of SQL Error Log entries'
SET @body = ''
         + CHAR(10)+CHAR(13)
         + '(This mail was sent by the procedure ''' + DB_NAME() + '.' + OBJECT_SCHEMA_NAME (@@PROCID) + '.' + OBJECT_NAME(@@PROCID) + ''') '
         + CHAR(10)+CHAR(13)
         + 'A large number of unusual SQL Error log entries were found.'
         + CHAR(10)+CHAR(13)
         + 'Please review the recent records in the table ''SQLErrorLog'' in database ''' + DB_NAME() + ''' for any follow-up required. '    
 
  EXEC msdb.dbo.sp_send_dbmail              -- Send email 
       @profile_name = @profile_name
     , @recipients   = @recipients
     , @subject      = @subj
     , @body         = @body

GO


