USE [SQLErrorLogMonitor]
GO

IF (OBJECT_ID('Process_SQLErrorlogResults')) IS NULL
  EXEC ('CREATE PROC [Process_SQLErrorlogResults] AS PRINT ''STUB''')
GO

/* Script to mail 'unusual' SQL Error Log entries, after collection in a holding table on the management server.
   This script should be run after storage of the error log entries in the holding table nd removal of trivial messages (procedure 'Cleanup_Errorlog_Holding_Table').
   To avoid excessively large mails, a general warning is sent if the number of (distinct) messages exceeds 2000. 
*/

ALTER PROC [dbo].[Process_SQLErrorlogResults]
      @MailRecipients  VARCHAR(MAX) 
    , @MailProfileName SYSNAME      
AS

DECLARE @errlogmessages      INT,
        @failedloginmessages INT

SELECT @errlogmessages      = COUNT(*) FROM tempdb.dbo.SQLErrorlog WHERE CHARINDEX('Login failed for user', [text]) = 0  
SELECT @failedloginmessages = COUNT(*) FROM tempdb.dbo.SQLErrorlog WHERE CHARINDEX('Login failed for user', [Text]) > 0

IF @errlogmessages < 2000
  EXEC [Mail_SQLErrorlog] 
        @recipients = @MailRecipients
      , @profile_name = @MailProfileName
ELSE
  EXEC [Mail_Warning_SQLErrorlog]
        @recipients = @MailRecipients
      , @profile_name = @MailProfileName

IF @failedloginmessages < 2000
  EXEC [Mail_Failed_Logins]
        @recipients = @MailRecipients
      , @profile_name = @MailProfileName
ELSE
  EXEC [Mail_Warning_FailedLogins]
        @recipients = @MailRecipients
      , @profile_name = @MailProfileName

