USE [SQLErrorLogMonitor]
GO

IF (OBJECT_ID('Mail_Failed_Logins')) IS NULL
  EXEC ('CREATE PROC [Mail_Failed_Logins] AS PRINT ''STUB''')
GO

ALTER PROC [dbo].[Mail_Failed_Logins]
      @recipients   VARCHAR(MAX)
    , @profile_name SYSNAME
AS

  /* Script to mail failed login attempts recorded in SQL Error Logs, after collection in a holding table on the monitor server.
     This script should be run after retrieval of all error logs and removal of trivial messages (procedure 'Cleanup_Errorlog_Holding_Table')
     Messages other than failed login attempts are excluded; these are mailed by a separate procedure ('Mail_SQLErrorlog').
  */

IF EXISTS (SELECT 1 FROM tempdb.dbo.SQLErrorlog WHERE  CHARINDEX('Login failed for user', [Text]) > 0)
BEGIN
  DECLARE  @subj  VARCHAR(200)
         , @body  NVARCHAR(MAX)
         , @xml   NVARCHAR(MAX)
         
  SELECT   @subj = 'Failed SQL logins'
  SET      @body = '<html><body>
               <p><font size="2" face="monaco">
               (This mail was sent by the procedure ''' + DB_NAME() + '.' + OBJECT_SCHEMA_NAME (@@PROCID) + '.' + OBJECT_NAME(@@PROCID) + ''') <BR><BR>                              
               The table below contains the most recent overview of SQL failed logins.  
               <H3>SQL Failed Logins</H3>
               <table border="1" cellpadding="5"> 
               <p><font size="2" face="monaco">
               <tr>
               <th> Server </th> <th> Date </th> <th> Login Name </th> <th> Count </th> <th> Client Name </th> <th> Extra Info </th> </tr>'
  SELECT  @xml = CAST( 
                (SELECT   [SQLInstance]                             AS 'td',''            -- SQL Instance
                        , CONVERT(CHAR(30),[LogDate],21)            AS 'td',''            -- Date
                        , CASE 
                            WHEN CHARINDEX('''''' , [Text]) > 0 
                            THEN ''
                            ELSE LEFT(SUBSTRING([Text], CHARINDEX('''' , [Text]) + 1, CHARINDEX('''', [Text], CHARINDEX('''' , [Text]) + 1) - CHARINDEX('''' , [Text]) - 1),30)
                          END                                       AS 'td',''            -- Login Name
                        , [COUNT]                                   AS 'td',''            -- Count
                        , LEFT(SUBSTRING([Text], CHARINDEX('[CLIENT', [Text]) + 9, CHARINDEX(']', [Text]) - CHARINDEX('[CLIENT', [Text]) - 9),17)
                                                                    AS 'td',''            -- Client Name
                        , SUBSTRING([Text], CHARINDEX('Reason: ', [Text]), CHARINDEX('. [CLIENT:',[Text]) - CHARINDEX('Reason: ', [Text]) ) 
                                                                    AS 'td',''            -- Extra info between the strings 'Reason:' and '[CLIENT:'
                 FROM   tempdb.dbo.SQLErrorlog 
                 WHERE  CHARINDEX('Login failed for user', [Text]) > 0
                 ORDER BY 1, 2, 3, 5
                 FOR XML PATH('tr'), ELEMENTS ) 
                 AS NVARCHAR(MAX))
           
  SET @body = @body + @xml +'</table></body></html>'
  EXEC msdb.dbo.sp_send_dbmail              -- Send email
       @profile_name = @profile_name
     , @recipients   = @recipients
     , @subject      = @subj
     , @body         = @body
     , @body_format  ='HTML'
END