CREATE PROCEDURE
     [usp_Employee_Select_Up_Param_EmpID]
        @selectEmpID int, -- required
        @maxSupLevel int = 10 --null=no limit
AS

SET @selectEmpID = IsNull(@selectEmpID, 0)

--
--  Declare variables
--

DECLARE @workTbl
    TABLE  (ID int IDENTITY(1,1),
        EmpID int, EmpName varchar(50),
        SupID int, SupLevel int)

DECLARE @prevHits int
SET @prevHits = 0

DECLARE @nextEmpID int
SET @nextEmpID = 0

DECLARE @supLevel int
SET @supLevel = 0

DECLARE @maxFoundSupLevel int
SET @maxFoundSupLevel = 0

--
--  Insert the starting record into @workTbl
--
INSERT INTO @workTbl
    SELECT
        Employee.EmpID, Employee.EmpName,
        Employee.SupID, @supLevel
    FROM Employee
    WHERE
        IsNull(Employee.EmpID, 0) =
            @selectEmpID

    SET @prevHits = @@ROWCOUNT

    IF @prevHits > 0
    BEGIN
        SET @nextEmpID = 999999
            -- any number gt zero
        SET @supLevel = @supLevel + 1
    END
    ELSE
        SET @nextEmpID = NULL

--
--  Insert a subsequent records into @workTbl
--  The Supervisor ID of the most recently
--     inserted record in the work table
--     is the Employee ID of the next
--     addition to the work table.
--
WHILE
    ((@nextEmpID > 0)
        AND
        ((@maxSupLevel is NULL)
            OR (@supLevel <= @maxSupLevel))
        )
BEGIN

    -- Set the @nextEmpID to the SupID of
    -- the most recent record in the table
    SET @nextEmpID =
        (SELECT
            SupID
            FROM @workTbl
            WHERE ID =
              (SELECT MAX(ID) FROM @workTbl)
        )

    INSERT INTO @workTbl
        SELECT
            Employee.EmpID,
            Employee.EmpName,
            Employee.SupID,
            @supLevel
        FROM Employee
        WHERE Employee.EmpID = @nextEmpID

    SET @prevHits = @@ROWCOUNT
    SET @supLevel = @supLevel + 1

END

-- Find the max SupLevel so numbering can go
-- from low to high
SET @maxFoundSupLevel
    = (SELECT MAX(SupLevel) FROM @workTbl)

--
--  Return the contents of the work table
--  as the result set.
--
SELECT
    EmpID, EmpName, SupID,
    @maxFoundSupLevel - SupLevel AS SupLevel
FROM @workTbl
ORDER BY SupLevel, SupID, EmpID