CREATE PROCEDURE
    [usp_Employee_Select_Down_Param_EmpID]
        @selectEmpID int = NULL, -- NULL=all
        @maxSupLevel int=10 -- NULL=no limit
AS

SET @selectEmpID = IsNull(@selectEmpID, 0)

DECLARE @workTbl
    TABLE  (EmpID int,
        EmpName varchar(50),
        SupID int, SupLevel int)

DECLARE @prevHits int
SET @prevHits = 0
DECLARE @supLevel int
SET @supLevel = 0

--
--Insert work record(s) into @workTbl
--
INSERT INTO @workTbl
    SELECT
        Employee.EmpID, Employee.EmpName,
        Employee.SupID, @supLevel
    FROM Employee
    WHERE
        ((@selectEmpID = 0)
        AND (IsNull(Employee.SupID, 0) = 0)
        )
        OR
        (Employee.EmpID = @selectEmpID)

SET @prevHits = @@ROWCOUNT
IF @prevHits > 0
    SET @supLevel = @supLevel + 1

WHILE
    (   (@prevHits > 0)
        AND
            ((@maxSupLevel is NULL)
                OR
            (@supLevel <= @maxSupLevel))
    )

BEGIN
    INSERT INTO @workTbl
        SELECT
            Employee.EmpID,
            Employee.EmpName,
            Employee.SupID,
            @supLevel
        FROM Employee
            WHERE
                NOT EXISTS
                    (SELECT EmpID
                    FROM @workTbl
                    WHERE EmpID
                        = Employee.EmpID)
                AND EXISTS
					(SELECT EmpID
					FROM @workTbl
					WHERE EmpID = Employee.SupID)

    SET @prevHits = @@ROWCOUNT
    SET @supLevel = @supLevel + 1

END


SELECT
        EmpID, EmpName, SupID, SupLevel
FROM @worktbl
ORDER BY SupLevel, SupID, EmpID