'Marios Philippopoulos - Aug 28 2008
'*************************************************************************
'Change iWaitInMinutes to 10 before deploying to prod
'Change iAlertFreq to 10 before deploying to prod
'Change sAnalysisInstance to proper value before deploying to prod
'Change sAnalysisDB to proper value before deploying to prod
'Change UID, PWD to proper settings
'*************************************************************************

Set objParameters = WScript.Arguments
sManagedInstance = objParameters(0)

Set objParameters = Nothing

iWaitInMinutes = 10
iAlertFreq = 10
sAnalysisInstance = "server\instance"
sAnalysisDB = "dbName"

SCRIPT_SQL = _
        "SET NOCOUNT ON; " & _
        "" & _
        "CREATE TABLE #blocks " & _
        "( " & _
	    "   OID SMALLINT IDENTITY(1,1) " & _
        ",	SPID SMALLINT " & _
        ",	BlockingSPID SMALLINT " & _
        ",	WaitTime BIGINT " & _
        ",	LastWaitType VARCHAR(32) " & _
        ",	WaitResource VARCHAR(32) " & _
        ",	DBName VARCHAR(100) " & _
        ",	CPU_Time INT " & _
        ",	Physical_IO BIGINT " & _
        ",	Memory_Usage INT " & _
        ",	Login_Time DATETIME " & _
        ",	Last_Batch DATETIME " & _
        ",	[Status] VARCHAR(30) " & _
        ",	HostName VARCHAR(128) " & _
        ",	ProgramName VARCHAR(128) " & _
        ",	Command VARCHAR(16) " & _
        ",	NT_User_Name VARCHAR(128) " & _
        ",	Login_Name VARCHAR(128) " & _
        "); " & _
        "" & _
        "INSERT INTO " & _ 
	    "   #blocks " & _
        "SELECT " & _
	    "   spid " & _
        ",	blocked AS blockingSPID " & _
        ",	waittime " & _
        ",	lastwaittype " & _
        ",	waitresource " & _
        ",	DB_NAME(dbid) AS dbName " & _
        ",	cpu " & _
        ",	physical_io " & _
        ",	memusage " & _
        ",	login_time " & _
        ",	last_batch " & _
        ",	status " & _
        ",	HostName " & _
        ",	program_name " & _
        ",	cmd " & _
        ",	nt_username " & _
        ",	loginame " & _
        "FROM " & _
	    "    dbo.sysprocesses WITH (NOLOCK) " & _
	    "WHERE " & _
	    "   spid > 50 " & _
	    "   AND " & _
	    "   ( " & _
		"       (blocked <> 0 AND waittime > " & CStr(iWaitInMinutes*60) & " * 1000 ) " & _
		"       OR  " & _
		"       (blocked = 0 AND spid IN (SELECT blocked FROM dbo.sysprocesses WITH (NOLOCK) WHERE blocked <> 0 )) " & _
	    "   ) " & _
        "ORDER BY " & _ 
	    "   blocked; " & _ 
        "" & _
	    "IF EXISTS (SELECT * FROM #blocks WHERE BlockingSPID > 0) " & _
        "BEGIN " & _
	    "   SELECT * FROM #blocks " & _
	    "   WHERE BlockingSPID > 0 " & _
	    "   OR SPID IN (SELECT BlockingSPID FROM #blocks WHERE BlockingSPID > 0); " & _
        "END " & _
        "ELSE " & _
        "BEGIN " & _
	    "   TRUNCATE TABLE #blocks; " & _
	    "   SELECT * FROM #blocks; " & _
        "END " & _ 
        "" & _
        "DROP TABLE #blocks; "
	    
'************************** CREATE ADO OBJECTS **********************************************************

Set cnManagedInstance = CreateObject("ADODB.Connection")
cnManagedInstance.Provider = "sqloledb"
cnManagedInstance.ConnectionTimeout = 30
sConnString = "Server=" & sManagedInstance & ";Database=master;Trusted_Connection=yes"

cnManagedInstance.Open sConnString
Set rsBlockedSPIDS = cnManagedInstance.Execute(SCRIPT_SQL)

Set cnAnalysisInstance = CreateObject("ADODB.Connection")
cnAnalysisInstance.Provider = "sqloledb"
cnAnalysisInstance.ConnectionTimeout = 30
sConnString = "Server=" & sAnalysisInstance & ";Database=" & sAnalysisDB & ";UID=xxx;PWD=xxx"

cnAnalysisInstance.Open sConnString

Set cmd = CreateObject("ADODB.Command")
Set cmd.ActiveConnection = cnAnalysisInstance
cmd.CommandText = "[dbo].[SCOM_InsertBlockingInfo_2000]"
cmd.CommandType = 4 'adCmdStoredProc

'********************************************************************************************************

sAlertDescription = vBCrLf & vBCrLf & "Server\Instance: " & sManagedInstance & vBCrLf & vBCrLf
sAlertDescription = sAlertDescription & "BLOCKING SPID(S)" & vBCrLf
sAlertDescription = sAlertDescription & "----------------" & vBCrLf

bWriteLOG = False 'write to Evt Log
bBlockedStart = False
bRunStart = True

Do While Not rsBlockedSPIDS.EOF
        
    If rsBlockedSPIDS("blockingSPID").Value = 0 Then 'Blocking SPID
    
        sAlertDescription = sAlertDescription & vBCrLf & "Blocking SPID: " & CStr(rsBlockedSPIDS("SPID").Value) & vBCrLf
        sAlertDescription = sAlertDescription & "Database: " & rsBlockedSPIDS("DBName").Value & vBCrLf
        sAlertDescription = sAlertDescription & "Host: " & TRIM(rsBlockedSPIDS("HostName").Value) & vBTab
        sAlertDescription = sAlertDescription & "Program: " & TRIM(rsBlockedSPIDS("ProgramName").Value) & vBCrLf
        sAlertDescription = sAlertDescription & "Cmd: " & TRIM(rsBlockedSPIDS("Command").Value) & vBTab
        sAlertDescription = sAlertDescription & "Login: " & TRIM(rsBlockedSPIDS("Login_Name").Value) & vBCrLf
        
    Else 'blocked SPID
    
        If bBlockedStart = False Then
            bBlockedStart = True
            sAlertDescription = sAlertDescription & vBCrLf & "BLOCKED SPID(S)" & vBCrLf
            sAlertDescription = sAlertDescription &          "---------------" & vBCrLf
        End If 
         
        sAlertDescription = sAlertDescription & vBCrLf & "Blocked SPID: " & CStr(rsBlockedSPIDS("SPID").Value) & vBCrLf
        sAlertDescription = sAlertDescription & "Blocked By: " & CStr(rsBlockedSPIDS("BlockingSPID").Value) & vBTab
        sAlertDescription = sAlertDescription & "Wait time (ms): " & CStr(rsBlockedSPIDS("WaitTime").Value) & vBCrLf
        sAlertDescription = sAlertDescription & "Host: " & TRIM(rsBlockedSPIDS("HostName").Value) & vBTab
        sAlertDescription = sAlertDescription & "Program: " & TRIM(rsBlockedSPIDS("ProgramName").Value) & vBCrLf
        sAlertDescription = sAlertDescription & "Cmd: " & TRIM(rsBlockedSPIDS("Command").Value) & vBTab
        sAlertDescription = sAlertDescription & "Login: " & TRIM(rsBlockedSPIDS("Login_Name").Value) & vBCrLf
    End If
    
    If bRunStart = True Then
        cmd.Parameters("@RunStart").Value = "T"
        bRunStart = False
    Else
        cmd.Parameters("@RunStart").Value = "F" 
    End If 
    
    cmd.Parameters("@ServerInstance").Value = sManagedInstance
    cmd.Parameters("@SPID").Value = rsBlockedSPIDS("SPID").Value
    cmd.Parameters("@BlockingSPID").Value = rsBlockedSPIDS("BlockingSPID").Value
    cmd.Parameters("@WaitTime").Value = rsBlockedSPIDS("WaitTime").Value
    cmd.Parameters("@LastWaitType").Value = rsBlockedSPIDS("LastWaitType").Value
    cmd.Parameters("@WaitResource").Value = rsBlockedSPIDS("WaitResource").Value
    cmd.Parameters("@DBName").Value = rsBlockedSPIDS("DBName").Value
    cmd.Parameters("@CPU_Time").Value = rsBlockedSPIDS("CPU_Time").Value 
    cmd.Parameters("@Physical_IO").Value = rsBlockedSPIDS("Physical_IO").Value
    cmd.Parameters("@Memory_Usage").Value = rsBlockedSPIDS("Memory_Usage").Value
    cmd.Parameters("@Login_Time").Value = rsBlockedSPIDS("Login_Time").Value
    cmd.Parameters("@Last_Batch").Value = rsBlockedSPIDS("Last_Batch").Value
    cmd.Parameters("@Status").Value = rsBlockedSPIDS("Status").Value
    cmd.Parameters("@HostName").Value = rsBlockedSPIDS("HostName").Value
    cmd.Parameters("@ProgramName").Value = rsBlockedSPIDS("ProgramName").Value
    cmd.Parameters("@Command").Value = rsBlockedSPIDS("Command").Value
    cmd.Parameters("@NT_User_Name").Value = rsBlockedSPIDS("NT_User_Name").Value
    cmd.Parameters("@Login_Name").Value = rsBlockedSPIDS("Login_Name").Value
    cmd.Parameters("@AlertFreq").Value = iAlertFreq
    
    'Store in analysis database
    cmd.Execute
     
    If cmd.Parameters("@WriteLog").Value = True Then
        bWriteLOG = True
    End If
    
    rsBlockedSPIDS.MoveNext
    
Loop

Set cmd = Nothing
Set rsBlockedSPIDS = Nothing
Set cnManagedInstance = Nothing 
Set cnAnalysisInstance = Nothing
   
'Write to Evt Log   
If bWriteLOG = True Then
    Set objShell = CreateObject("Wscript.Shell")
    strCmd = "eventcreate /SO SQLBlocks /T WARNING /ID 999 /L APPLICATION /D" & " """ & sAlertDescription & """"
    ReturnCode = objShell.Run(strCmd,vbHide,True)
    Set objShell = Nothing
End If
