-- Script to return blocking and blocked spids with wait times > 1 min
-- SQL 2005

SET NOCOUNT ON;

CREATE TABLE #blocks
(
	SPID SMALLINT
,	BlockingSPID SMALLINT
,	WaitTime BIGINT
,	LastWaitType VARCHAR(32)
,	WaitResource VARCHAR(32)
,	DBName VARCHAR(100)
,	CPU_Time INT
,	Total_Elapsed_Time INT
,	Physical_IO BIGINT
,	Logical_Reads BIGINT
,	Memory_Usage INT
,	Login_Time DATETIME
,	[Status] VARCHAR(30)
,	HostName VARCHAR(128)
,	ProgramName VARCHAR(128)
,	Command VARCHAR(16)
,	NT_User_Name VARCHAR(128)
,	Login_Name VARCHAR(128)
,	SQL_Text VARCHAR(1000)
);

INSERT INTO
	#blocks
SELECT
	R.session_id 
,	R.blocking_session_id 
,	R.wait_time 
,	R.last_wait_type 
,	R.wait_resource 
,	DB_NAME(R.database_id) 
,	R.cpu_time  
,	R.total_elapsed_time 
,	R.reads + R.writes  
,	R.logical_reads  
,	S.memory_usage  
,	S.login_time  
,	R.status  
,	S.[host_name]  
,	S.[program_name]  
,	R.command  
,	S.nt_user_name  
,	S.login_name 
,	LEFT(H.text, 1000) 
FROM
	sys.dm_exec_requests R
INNER JOIN
	sys.dm_exec_sessions S
ON
	R.session_id = S.session_id
CROSS APPLY 
	sys.dm_exec_sql_text(R.sql_handle) H
WHERE
	R.session_id > 50
	AND 
	(
		(R.blocking_session_id <> 0 AND R.wait_time > 60000)  -- 1 min
		OR 
		(R.blocking_session_id = 0 AND R.session_id IN (SELECT blocking_session_id FROM sys.dm_exec_requests WHERE blocking_session_id <> 0 ))
	)
ORDER BY 
	R.blocking_session_id;

IF EXISTS (SELECT * FROM #blocks WHERE BlockingSPID > 0)
BEGIN
	SELECT * FROM #blocks
	WHERE BlockingSPID > 0 
	OR SPID IN (SELECT BlockingSPID FROM #blocks WHERE BlockingSPID > 0);
END
ELSE
BEGIN
	TRUNCATE TABLE #blocks;
	SELECT * FROM #blocks;
END

DROP TABLE #blocks;