--Returns blocking and blocked SPID info
--blocking over 1 min

SET NOCOUNT ON;

DECLARE @handle binary(20);
DECLARE @cnt SMALLINT;
DECLARE @loopCnt SMALLINT;
DECLARE @spid SMALLINT;
DECLARE @sql_text VARCHAR(1000);

CREATE TABLE #blocks
(
	OID SMALLINT IDENTITY(1,1)
,	SPID SMALLINT
,	BlockingSPID SMALLINT
,	WaitTime BIGINT
,	LastWaitType VARCHAR(32)
,	WaitResource VARCHAR(32)
,	DBName VARCHAR(100)
,	CPU_Time INT
,	Physical_IO BIGINT
,	Memory_Usage INT
,	Login_Time DATETIME
,	Last_Batch DATETIME
,	[Status] VARCHAR(30)
,	HostName VARCHAR(128)
,	ProgramName VARCHAR(128)
,	Command VARCHAR(16)
,	NT_User_Name VARCHAR(128)
,	Login_Name VARCHAR(128)
,	SQL_Text VARCHAR(1000)
);

INSERT INTO 
	#blocks
SELECT
	spid
,	blocked AS blockingSPID
,	waittime
,	lastwaittype
,	waitresource
,	DB_NAME(dbid) AS dbName
,	cpu
,	physical_io
,	memusage
,	login_time
,	last_batch
,	status
,	hostname
,	program_name
,	cmd
,	nt_username
,	loginame
,	NULL
FROM
	dbo.sysprocesses WITH (NOLOCK)
WHERE
	spid > 50
	AND 
	(
		(blocked <> 0 AND waittime > 60000)  -- 1 min
		OR 
		(blocked = 0 AND spid IN (SELECT blocked FROM dbo.sysprocesses WITH (NOLOCK) WHERE blocked <> 0 ))
	)
ORDER BY 
	blocked;

IF EXISTS (SELECT * FROM #blocks WHERE BlockingSPID > 0)
BEGIN
	
	SELECT @cnt = COUNT(*) FROM #blocks;
	SET @loopCnt = 1

	WHILE @loopCnt <= @cnt
	BEGIN

		SELECT @spid = SPID FROM #blocks WHERE OID = @loopCnt;
		
		SELECT @handle = sql_handle FROM dbo.sysprocesses WITH (NOLOCK) WHERE spid = @spid;
		SELECT @sql_text = [text] FROM ::fn_get_sql(@Handle);
	
		UPDATE #blocks SET SQL_Text = @sql_text WHERE OID = @loopCnt;

		SET @loopCnt = @loopCnt + 1;

	END

	SELECT * FROM #blocks
	WHERE BlockingSPID > 0 
	OR SPID IN (SELECT BlockingSPID FROM #blocks WHERE BlockingSPID > 0);
END
ELSE
BEGIN
	TRUNCATE TABLE #blocks;
	SELECT * FROM #blocks;
END

DROP TABLE #blocks;


