SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[SCOM_InsertBlockingInfo_2000]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[SCOM_InsertBlockingInfo_2000]
GO

/*******************************************************************************************************************************
	Name		:	dbo.SCOM_InsertBlockingInfo_2000

	Purpose		:	Inserts SQL-2000 blocking information into tables of the ANALYSISDB database for later analysis

	Called From	:	SCOM rule running a vbs script

	Notes		:	@WriteLog: write to Evt App Log from SCOM rule

	History		:	Marios Philippopoulos		2008-08-23		Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE dbo.SCOM_InsertBlockingInfo_2000
(
	@RunStart				CHAR(1)			-- 'T', true; 'F', false
,	@ServerInstance			VARCHAR(128)
,	@SPID					SMALLINT
,	@BlockingSPID			SMALLINT
,	@WaitTime				BIGINT
,	@LastWaitType			VARCHAR(32)
,	@WaitResource			VARCHAR(32)
,	@DBName					VARCHAR(100)
,	@CPU_Time				INT
,	@Physical_IO			BIGINT
,	@Memory_Usage			INT
,	@Login_Time				DATETIME
,	@Last_Batch				DATETIME
,	@Status					VARCHAR(30)
,	@HostName				VARCHAR(128)
,	@ProgramName			VARCHAR(128)
,	@Command				VARCHAR(16)
,	@NT_User_Name			VARCHAR(128)
,	@Login_Name				VARCHAR(128) 
,	@AlertFreq				SMALLINT
,	@WriteLog				BIT				OUTPUT
)
AS

SET NOCOUNT ON;

DECLARE @runID INT;
DECLARE @timeEventCreated DATETIME; -- time event written to Evt Log

SET @WriteLog = 0;

IF @RunStart = 'T'
BEGIN
	UPDATE dbo.SCOM_BlockingInfo_Runs
	SET LatestRunID = LatestRunID + 1;
END

SELECT @runID = LatestRunID
FROM dbo.SCOM_BlockingInfo_Runs;

INSERT INTO 
	[dbo].[SCOM_BlockingInfo_2000]
(
	RunID
,	ServerInstance
,	SPID
,	BlockingSPID
,	WaitTime		
,	LastWaitType
,	WaitResource	
,	DBName			
,	CPU_Time 
,	Physical_IO	 
,	Memory_Usage		 
,	Login_Time
,	Last_Batch
,	[Status]			 
,	HostName			 
,	ProgramName		 
,	Command	
,	NT_User_Name			 
,	Login_Name	 
)
VALUES
(
	@runID
,	@ServerInstance 
,	@SPID			 
,	@BlockingSPID		 
,	@WaitTime
,	@LastWaitType			 
,	@WaitResource			 
,	@DBName					 
,	@CPU_Time 
,	@Physical_IO			  
,	@Memory_Usage			 
,	@Login_Time
,	@Last_Batch
,	@Status				 
,	@HostName				 
,	@ProgramName			 
,	@Command
,	@NT_User_Name				 
,	@Login_Name	 
);

SELECT @timeEventCreated = MAX(db_recordtimestamp)
FROM dbo.SCOM_BlockingInfo_2000
WHERE ServerInstance = @ServerInstance;

IF @BlockingSPID > 0 
	AND NOT EXISTS (
		SELECT * FROM dbo.SCOM_BlockingInfo_Staging 
		WHERE ServerInstance = @ServerInstance 
		)
BEGIN

	INSERT INTO 
		dbo.SCOM_BlockingInfo_Staging 
	(
		RunID
	,	ServerInstance
	,	BlockingSPID
	,	BlockedSPID
	,	TimeEventCreated
	)
	VALUES
	(
		@runID 	
	,	@ServerInstance  
	,	@BlockingSPID	
	,	@SPID
	,	@timeEventCreated
	);

	SET @WriteLog = 1;

END

--Purge records in SCOM_BlockingInfo_Staging older than the @AlertFreq setting:
DELETE 
	dbo.SCOM_BlockingInfo_Staging 
WHERE
	ServerInstance = @ServerInstance
	AND DATEDIFF(mi, TimeEventCreated, @timeEventCreated) >= @AlertFreq;

---------- / dbo.SCOM_InsertBlockingInfo_2000 --------------------------------------------

GO

GRANT EXECUTE ON dbo.SCOM_InsertBlockingInfo TO ROLE_UID
GO
