SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[SCOM_InsertBlockingInfo]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[SCOM_InsertBlockingInfo]
GO

/*******************************************************************************************************************************
	Name		:	dbo.SCOM_InsertBlockingInfo

	Purpose		:	Inserts SQL-2005 blocking information into tables of the ANALYSISDB database for later analysis

	Called From	:	SCOM rule running a vbs script

	Notes		:	@WriteLog: write to Evt App Log from SCOM rule

	History		:	Marios Philippopoulos		2008-08-22		Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE dbo.SCOM_InsertBlockingInfo
(
	@RunStart				CHAR(1)			-- 'T', true; 'F', false
,	@ServerInstance			VARCHAR(128)
,	@SPID					SMALLINT
,	@BlockingSPID			SMALLINT
,	@Waittime				BIGINT
,	@LastWaitType			VARCHAR(32)
,	@WaitResource			VARCHAR(32)
,	@DBName					VARCHAR(100)
,	@CPU_Time				INT
,	@Total_Elapsed_Time		INT
,	@Physical_IO			BIGINT
,	@Logical_Reads			BIGINT
,	@Memory_Usage			INT
,	@Login_Time				DATETIME
,	@Status					VARCHAR(30)
,	@HostName				VARCHAR(128)
,	@ProgramName			VARCHAR(128)
,	@Command				VARCHAR(16)
,	@NT_User_Name			VARCHAR(128)
,	@Login_Name				VARCHAR(128)
,	@SQL_Text				VARCHAR(1000)
,	@AlertFreq				SMALLINT
,	@WriteLog				BIT				OUTPUT
)
AS

SET NOCOUNT ON;

DECLARE @runID INT;
DECLARE @timeEventCreated DATETIME; -- time event written to Evt Log

SET @WriteLog = 0;

IF @RunStart = 'T'
BEGIN
	UPDATE dbo.SCOM_BlockingInfo_Runs
	SET LatestRunID = LatestRunID + 1;
END

SELECT @runID = LatestRunID
FROM dbo.SCOM_BlockingInfo_Runs;

INSERT INTO 
	[dbo].[SCOM_BlockingInfo]
(
	RunID
,	ServerInstance
,	SPID
,	BlockingSPID
,	Waittime		
,	LastWaitType
,	WaitResource	
,	DBName			
,	CPU_Time		 
,	Total_Elapsed_Time 
,	Physical_IO		 
,	Logical_Reads		 
,	Memory_Usage		 
,	Login_Time
,	[Status]			 
,	HostName			 
,	ProgramName		 
,	Command	
,	NT_User_Name			 
,	Login_Name			 
,	SQL_Text	
)
VALUES
(
	@runID
,	@ServerInstance 
,	@SPID			 
,	@BlockingSPID		 
,	@Waittime
,	@LastWaitType			 
,	@WaitResource			 
,	@DBName					 
,	@CPU_Time				 
,	@Total_Elapsed_Time		 
,	@Physical_IO			 
,	@Logical_Reads			 
,	@Memory_Usage			 
,	@Login_Time
,	@Status				 
,	@HostName				 
,	@ProgramName			 
,	@Command
,	@NT_User_Name				 
,	@Login_Name				 
,	@SQL_Text
);

SELECT @timeEventCreated = MAX(db_recordtimestamp)
FROM dbo.SCOM_BlockingInfo
WHERE ServerInstance = @ServerInstance;

IF @BlockingSPID > 0 
	AND NOT EXISTS (
		SELECT * FROM dbo.SCOM_BlockingInfo_Staging 
		WHERE ServerInstance = @ServerInstance 
		)
BEGIN

	INSERT INTO 
		dbo.SCOM_BlockingInfo_Staging 
	(
		RunID
	,	ServerInstance
	,	BlockingSPID
	,	BlockedSPID
	,	TimeEventCreated
	)
	VALUES
	(
		@runID 	
	,	@ServerInstance  
	,	@BlockingSPID	
	,	@SPID
	,	@timeEventCreated
	);

	SET @WriteLog = 1;

END

--Purge records in SCOM_BlockingInfo_Staging older than the @AlertFreq setting:
DELETE 
	dbo.SCOM_BlockingInfo_Staging 
WHERE
	ServerInstance = @ServerInstance
	AND DATEDIFF(mi, TimeEventCreated, @timeEventCreated) >= @AlertFreq;

---------- / dbo.SCOM_InsertBlockingInfo --------------------------------------------

GO

GRANT EXECUTE ON dbo.SCOM_InsertBlockingInfo TO ROLE_UID
GO
