--Script to create tables for recording blocking info from SCOM

create default [DF_GETDATE] as getdate()
go

Exec sp_addtype 'UDT_RECORDTIMESTAMP', 'Datetime', 'NOT NULL', 'dbo'
go
Exec sp_bindefault 'DF_GETDATE', 'UDT_RECORDTIMESTAMP'
go

Create table [dbo].[SCOM_BlockingInfo]
(
	[SCOM_BlockingInfo_OID] Integer Identity(1,1) NOT NULL,
	[RunID] Integer NOT NULL,
	[ServerInstance] Varchar(128) NOT NULL,
	[SPID] Smallint NOT NULL,
	[BlockingSPID] Smallint NOT NULL,
	[WaitTime] Bigint NOT NULL,
	[LastWaitType] Varchar(32) NOT NULL,
	[WaitResource] Varchar(32) NOT NULL,
	[DBName] Varchar(100) NOT NULL,
	[CPU_Time] Integer NOT NULL,
	[Total_Elapsed_Time] Integer NOT NULL,
	[Physical_IO] Bigint NOT NULL,
	[Logical_Reads] Bigint NOT NULL,
	[Memory_Usage] Integer NOT NULL,
	[Login_Time] Datetime NOT NULL,
	[Status] Varchar(30) NOT NULL,
	[HostName] Varchar(128) NULL,
	[ProgramName] Varchar(128) NULL,
	[Command] Varchar(16) NOT NULL,
	[NT_User_Name] Varchar(128) NOT NULL,
	[Login_Name] Varchar(128) NOT NULL,
	[SQL_Text] Varchar(1000) NULL,
	[db_recordtimestamp] [UDT_RECORDTIMESTAMP] NOT NULL,
Constraint [PK_SCOM_BlockingInfo] Primary Key nonclustered ([SCOM_BlockingInfo_OID]) ON [PRIMARY]
) 
ON [PRIMARY]
go

Create table [dbo].[SCOM_BlockingInfo_Runs]
(
	[LatestRunID] Integer NOT NULL
) 
ON [PRIMARY]
go

Create table [dbo].[SCOM_BlockingInfo_Staging]
(
	[RunID] Integer NOT NULL,
	[ServerInstance] Varchar(128) NOT NULL,
	[BlockingSPID] Smallint NOT NULL,
	[BlockedSPID] Smallint NOT NULL,
	[TimeEventCreated] Datetime NOT NULL,
Constraint [PK_SCOM_BlockingInfo_Staging] Primary Key nonclustered ([RunID]) ON [PRIMARY]
) 
ON [PRIMARY]
go

Create table [dbo].[SCOM_BlockingInfo_2000]
(
	[SCOM_BlockingInfo_OID] Integer Identity(1,1) NOT NULL,
	[RunID] Integer NOT NULL,
	[ServerInstance] Varchar(128) NOT NULL,
	[SPID] Smallint NOT NULL,
	[BlockingSPID] Smallint NOT NULL,
	[WaitTime] Bigint NOT NULL,
	[LastWaitType] Varchar(32) NOT NULL,
	[WaitResource] Varchar(32) NOT NULL,
	[DBName] Varchar(100) NOT NULL,
	[CPU_Time] Integer NOT NULL,
	[Physical_IO] Bigint NOT NULL,
	[Memory_Usage] Integer NOT NULL,
	[Login_Time] Datetime NOT NULL,
	[Last_Batch] Datetime NOT NULL,
	[Status] Varchar(30) NOT NULL,
	[HostName] Varchar(128) NULL,
	[ProgramName] Varchar(128) NULL,
	[Command] Varchar(16) NOT NULL,
	[NT_User_Name] Varchar(128) NOT NULL,
	[Login_Name] Varchar(128) NOT NULL,
	[db_recordtimestamp] [UDT_RECORDTIMESTAMP] NOT NULL,
Constraint [PK_SCOM_BlockingInfo_2000] Primary Key nonclustered ([SCOM_BlockingInfo_OID]) ON [PRIMARY]
) 
ON [PRIMARY]
go

INSERT INTO [dbo].[SCOM_BlockingInfo_Runs]
VALUES(0)
GO