
--run sql statements twice in sqlcmd mode with correct source and target db server names
:on error exit
:setvar SourceDB DB1
:setvar DestinationDB DB2
:setvar SourceServer ServerA
:setvar TargetServer ServerB


:CONNECT $(SourceServer) 
GO
--sql code to start service-broker communication and message transmission
use $(SourceDB)
GO
-- sql code to create a conversation dialog
DECLARE @conversation_handle UNIQUEIDENTIFIER
BEGIN DIALOG @conversation_handle
FROM SERVICE [SampleServiceSource]
 TO SERVICE 'SampleServiceTarget'
 ON CONTRACT [SampleContract]
 WITH ENCRYPTION= OFF

--sql code to send a message and start communication
 Declare @XMLMessage as XML;
 SET @XMLMessage = (SELECT  TOP 1 * FROM [Order]
					 FOR
					 XML PATH('SampleMessage'),
					ELEMENTS XSINIL,
					TYPE
					) ;
								-- send success message to the queue
SEND ON CONVERSATION  @conversation_handle MESSAGE TYPE [SampleMessage]  (@XMLMessage) ;    
GO

:CONNECT $(TargetServer) 
GO
--sql code to query sb queue to view received messages on the target broker instance
use $(DestinationDB)
GO
SELECT cast(message_body as XML), * FROM [SampleQueue]                          
GO

:CONNECT $(SourceServer) 
GO
--this code is commented out and can be used only on demand
--use $(SourceDB)
--GO
----disable internal activation
--ALTER QUEUE [SampleQueue] WITH RETENTION = OFF, ACTIVATION ( DROP )
--GO
----enable internal activation
--ALTER QUEUE [SampleQueue] WITH RETENTION = OFF, 
--ACTIVATION (STATUS = ON, PROCEDURE_NAME = dbo.InternalActivationProcedure,
--MAX_QUEUE_READERS = 2, EXECUTE AS 'dbo' )
--GO

use $(SourceDB)
GO
--sql code to amend the queue to invoke message processing routine. 
ALTER QUEUE [dbo].[SampleQueue] WITH ACTIVATION ( STATUS = ON , PROCEDURE_NAME = [dbo].[InternalActivationProcedure] , MAX_QUEUE_READERS = 2 , EXECUTE AS N'dbo' )
GO
:CONNECT $(TargetServer) 
GO
use $(DestinationDB)
GO
--sql code to amend the queue to invoke message processing routine. 
ALTER QUEUE [dbo].[SampleQueue] WITH ACTIVATION ( STATUS = ON , PROCEDURE_NAME = [dbo].[InternalActivationProcedure] , MAX_QUEUE_READERS = 2 , EXECUTE AS N'dbo' )

/*
--sql code to check system catalog view in order to troubleshoot sb issues.
use $(DatabaseName)
GO
SELECT * FROM sys.databases 
SELECT * FROM sys.routes 
SELECT * FROM sys.tcp_endpoints 
SELECT * FROM sys.service_broker_endpoints 
SELECT * FROM sys.dm_broker_activated_tasks 
SELECT * FROM sys.dm_broker_connections 
SELECT * FROM sys.dm_broker_forwarded_messages 
SELECT * FROM sys.dm_broker_queue_monitors 
SELECT * FROM sys.transmission_queue 
SELECT * FROM sys.service_broker_endpoints  
SELECT * FROM sys.certificates 
SELECT * FROM sys.conversation_endpoints
*/
/*
--If you encounter this error: "An error occurred while receiving data: '10054(An existing connection was forcibly closed by the remote host.)'.4"
--Solution would be to grant CONNECT permissions to sql service account on remote instance. However, you can troubleshoot your configuration by 
 1.start -> cmd.exe 
 2.run -> ssbdiagnose runtime connect to -S <ServerA> connect to -S <ServerB> 
  with correct server names or IPs
*/