
--run sql statements in sqlcmd mode on the source db server 
:on error exit
:setvar DatabaseName SourceDB
:setvar ServerName SourceServer 

:CONNECT $(ServerName) 
GO 
--sql code to enable service broker  
USE master 
ALTER DATABASE $(DatabaseName) SET NEW_BROKER; 
ALTER DATABASE $(DatabaseName) SET ENABLE_BROKER; 
GO

SELECT name, is_broker_enabled,service_broker_guid FROM sys.databases
where name = '$(DatabaseName)'
GO

--sql code to create master key on initiator db
USE $(DatabaseName)
GO
CREATE MASTER KEY ENCRYPTION BY PASSWORD = 'MyPa$$w0rd'
GO
-----you can run below sql code once you have enabled service broker on the target database
:setvar TargetServer ReplaceWithServerNameOrIP
:setvar TargetDB ReplaceWithDatabaseName 
 
:CONNECT $(TargetServer)
GO
USE [master]
GO
-- run below sql code on SourceServer instance or via linked server to get service account name   
DECLARE @TargetServerSVCAccountName varchar(200), @SQL varchar(max);
select @TargetServerSVCAccountName = service_account 
FROM    sys.dm_server_services
where servicename not like '%Agent%'

PRINT 'TargetServerSVCAccountName:'+@TargetServerSVCAccountName
GO
USE master
GO
DECLARE @SB_GUID UNIQUEIDENTIFIER;
SELECT @SB_GUID = service_broker_guid FROM sys.databases
WHERE name = '$(TargetDB)'

PRINT 'BROKER_GUID:' + CAST(@SB_GUID AS VARCHAR(100))
GO

-----you can run below sql code once you have set all variables values and enabled sb on the dbs
:on error exit
:setvar DatabaseName SourceDB
:setvar ServerName SourceServer 
:setvar TargetServer ReplaceWithServerNameOrIP
:setvar TargetDB ReplaceWithDatabaseName
:setvar LoginName sa
--set target db server ip
:setvar TargetServerIP 127.0.0.1
--set target db broker_instance guid 
:setvar BROKER_GUID  <REPLACE WITH DestinationDB SERVICE BROKER GUID>
:setvar TargetServerSVCAccountName <REPLACE WITH sql service account name>

:CONNECT $(ServerName) 
GO 
--sql code to create service broker message type 
USE $(DatabaseName)
GO
CREATE MESSAGE TYPE [SampleMessage]
AUTHORIZATION [dbo]
VALIDATION = WELL_FORMED_XML;
GO

--sql code to create service broker contract 
USE $(DatabaseName)
GO
CREATE  CONTRACT [SampleContract] 
( 
SampleMessage SENT BY ANY 
) ;
GO   

--sql code to create service broker queue object 
USE $(DatabaseName)
GO

CREATE	QUEUE [dbo].[SampleQueue]
WITH	STATUS = ON,
		RETENTION = OFF;

GO
--sql code to create a service and bind the queue with the contract 
USE $(DatabaseName)
GO
CREATE SERVICE [SampleServiceSource] ON QUEUE [SampleQueue]([SampleContract]);
GO
--sql code to grant permission on the service
GRANT SEND on SERVICE::SampleServiceSource to public
GO

USE master
GO 
--sql code to create an endpoint based on Windows authentication
CREATE ENDPOINT ServiceBrokerEndpoint AUTHORIZATION $(LoginName)
STATE= STARTED AS TCP 
( LISTENER_PORT=4022,  LISTENER_IP= ALL ) FOR SERVICE_BROKER 
( AUTHENTICATION = WINDOWS, ENCRYPTION= REQUIRED ALGORITHM RC4 )
GO

--run sql code on SourceServer instance to create remote sql service account
IF NOT EXISTS(select * from syslogins where name = '$(TargetServerSVCAccountName)')
BEGIN 
 CREATE LOGIN [$(TargetServerSVCAccountName)] FROM WINDOWS WITH DEFAULT_DATABASE=[master]
END
GO
-- sql code to grant permissions to remote sql instance service account
GRANT CONNECT ON ENDPOINT::ServiceBrokerEndpoint to [$(TargetServerSVCAccountName)]
GO


use $(DatabaseName)
GO
--sql code to create a route to a remote broker instance
CREATE ROUTE [SampleServiceRoute] AUTHORIZATION [dbo]
WITH SERVICE_NAME  = N'SampleServiceTarget' , BROKER_INSTANCE  = N'$(BROKER_GUID)' , ADDRESS  = N'TCP://$(TargetServerIP):4022'               
GO


---sql code to create dbo.Order table
USE $(DatabaseName)
GO

CREATE TABLE dbo.[Order](
 OrderID INT NOT NULL,
 CustomerID INT NOT NULL,
 ServiceName VARCHAR(50) NOT NULL,
 OrderDate DATETIME DEFAULT(GETDATE()),
 CONSTRAINT PK_Order_OrderID PRIMARY KEY CLUSTERED 
(
	[OrderID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
--sql code to populate dbo.Order table

INSERT INTO [dbo].[Order]
           ([OrderID]
           ,[CustomerID]
           ,[ServiceName]
           ,[OrderDate])
     VALUES
           (1 ,1001,'SPA & Massage',GETDATE())
GO

--sql code to create routine to process sb messages
CREATE proc [dbo].[InternalActivationProcedure]
as
begin
	set nocount on;

  	    DECLARE @ConversationHandle UNIQUEIDENTIFIER,
            @ConvHandle UNIQUEIDENTIFIER ;
        DECLARE @ReceivedMessage XML ;
        DECLARE @ReceivedMessageName SYSNAME ;
        DECLARE @ReplyMessage XML ;		
        DECLARE @Status NVARCHAR(10) ;
        DECLARE @StartTime DATETIME ;
        DECLARE @EndTime DATETIME ;                
		DECLARE @Orderdate DATETIME,@ServiceName VARCHAR(50), @CustomerID INT, @OrderID INT;
			       
        BEGIN TRY
		BEGIN TRANSACTION ;

            WAITFOR
			( RECEIVE TOP(1)
				@ConversationHandle	= [conversation_handle],
				@ReceivedMessage	= CAST(message_body AS XML),
				@ReceivedMessageName = message_type_name		
				--select * 		
			  FROM [dbo].[SampleQueue]			 
			), TIMEOUT 2000 ;
			
		Commit tran
		
            IF @ReceivedMessageName = N'SampleMessage' 
                BEGIN
                  --  PRINT N'SampleMessage' ;
				
				;WITH XMLNAMESPACES('http://www.w3.org/2001/XMLSchema-instance' AS xsi)
				SELECT	@Orderdate		= 
						CASE
							WHEN Element.Val.value('(./OrderDate/@xsi:nil)[1]','bit') = 1 THEN NULL
							ELSE Element.Val.value('./OrderDate[1]','DATETIME')	
						END,
						@ServiceName		= 
						CASE
							WHEN Element.Val.value('(./ServiceName/@xsi:nil)[1]','bit') = 1 THEN NULL
							ELSE Element.Val.value('./ServiceName[1]','VARCHAR(50)')	
						END,						
						@CustomerID		= 
						CASE
							WHEN Element.Val.value('(./CustomerID/@xsi:nil)[1]','bit') = 1 THEN NULL
							ELSE Element.Val.value('./CustomerID[1]','INT')	
						END,
						@OrderID		= 
						CASE
							WHEN Element.Val.value('(./OrderID/@xsi:nil)[1]','bit') = 1 THEN NULL
							ELSE Element.Val.value('./OrderID[1]','INT')	
						END
						FROM @ReceivedMessage.nodes('//SampleMessage')  Element(Val);
				--insert sp invocation code here in order to process received message.
				        INSERT INTO dbo.[Order]
				                ( OrderID,
								  CustomerID,
								  ServiceName,
								  OrderDate
				                )
				        VALUES  ( @OrderID,@CustomerID,@ServiceName,@Orderdate )
                    END CONVERSATION @ConversationHandle ;
			
                END	
       
	        ELSE --in case of error message - close conversation
                IF @ReceivedMessageName = N'http://schemas.microsoft.com/SQL/ServiceBroker/Error' 
                    BEGIN
                        PRINT N'http://schemas.microsoft.com/SQL/ServiceBroker/Error' ;
			
                        DECLARE @error INT ;
                        DECLARE @description NVARCHAR(4000) ;
			
                        WITH XMLNAMESPACES ('http://schemas.microsoft.com/SQL/ServiceBroker/Error' AS ssb)		
						SELECT	@error = CAST(@ReceivedMessage AS XML).value('(//ssb:Error/ssb:Code)[1]', 'INT'),
							@description = CAST(@ReceivedMessage AS XML).value('(//ssb:Error/ssb:Description)[1]', 'NVARCHAR(4000)') ;
                       -- RAISERROR(N'Received error Code:%i Description:"%s"', 	16, 1, @error, @description) WITH LOG ;
                        
       			-- Insert your error handling code here 
	   
	                    END CONVERSATION @ConversationHandle ;
                    END
		
                ELSE  -- in case of end dialog message - close conversation
                    IF @ReceivedMessageName = N'http://schemas.microsoft.com/SQL/ServiceBroker/EndDialog' 
                        BEGIN
                            PRINT N'http://schemas.microsoft.com/SQL/ServiceBroker/EndDialog' ;
			
                            END CONVERSATION @ConversationHandle ;
                        END		 
        END TRY
        BEGIN CATCH	
			IF (@@TRANCOUNT>0) ROLLBACK TRAN
			
			--error handling code here
        END CATCH
    
    
end
GO


/*--rollback section

:on error exit
:setvar DatabaseName SourceDB
:setvar ServerName SourceServer

:CONNECT $(ServerName)
GO
use $(DatabaseName)
GO
--sql code to drop sb objects
DROP ROUTE [SampleServiceRoute]
DROP SERVICE  [SampleServiceSource]
DROP QUEUE [dbo].[SampleQueue]
DROP CONTRACT [SampleContract]
DROP MESSAGE TYPE [SampleMessage]
DROP Table dbo.[Order]
drop proc [dbo].[InternalActivationProcedure]
DROP ENDPOINT ServiceBrokerEndpoint
DROP MASTER KEY
*/