/*

SK: This script will create the empty sample databases DeploymentTest1 and DeploymentTest2 as well as the SQL Agent Job "Application_Release_Job".


*/



--create sample database shell
IF EXISTS (select 1 from sys.databases where name = 'DeploymentTest1')
	DROP DATABASE [DeploymentTest1];

CREATE DATABASE [DeploymentTest1];

--create sample database shell
IF EXISTS (select 1 from sys.databases where name = 'DeploymentTest2')
	DROP DATABASE [DeploymentTest2];

CREATE DATABASE [DeploymentTest2];
GO





USE [msdb]
GO

/****** Object:  Job [Application_Release_Job]    Script Date: 08/05/2010 22:39:24 ******/
IF  EXISTS (SELECT job_id FROM msdb.dbo.sysjobs_view WHERE name = N'Application_Release_Job')
EXEC msdb.dbo.sp_delete_job @job_name=N'Application_Release_Job', @delete_unused_schedule=1
GO

USE [msdb]
GO

/****** Object:  Job [Application_Release_Job]    Script Date: 08/05/2010 22:39:24 ******/
BEGIN TRANSACTION
DECLARE @ReturnCode INT
SELECT @ReturnCode = 0
/****** Object:  JobCategory [[Uncategorized (Local)]]]    Script Date: 08/05/2010 22:39:24 ******/
IF NOT EXISTS (SELECT name FROM msdb.dbo.syscategories WHERE name=N'[Uncategorized (Local)]' AND category_class=1)
BEGIN
EXEC @ReturnCode = msdb.dbo.sp_add_category @class=N'JOB', @type=N'LOCAL', @name=N'[Uncategorized (Local)]'
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback

END

DECLARE @jobId BINARY(16)
EXEC @ReturnCode =  msdb.dbo.sp_add_job @job_name=N'Application_Release_Job', 
		@enabled=1, 
		@notify_level_eventlog=0, 
		@notify_level_email=0, 
		@notify_level_netsend=0, 
		@notify_level_page=0, 
		@delete_level=0, 
		@description=N'No description available.', 
		@category_name=N'[Uncategorized (Local)]', 
		@owner_login_name=N'sa', @job_id = @jobId OUTPUT
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
/****** Object:  Step [Kick off sqlcmd (content from 01_main_release.sql)]    Script Date: 08/05/2010 22:39:24 ******/
EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id=@jobId, @step_name=N'Kick off sqlcmd (content from 01_main_release.sql)', 
		@step_id=1, 
		@cmdexec_success_code=0, 
		@on_success_action=3, 
		@on_success_step_id=0, 
		@on_fail_action=2, 
		@on_fail_step_id=0, 
		@retry_attempts=0, 
		@retry_interval=0, 
		@os_run_priority=0, @subsystem=N'TSQL', 
		@command=N'/*

SK: This script will turn on xp_cmdshell and then call sqlcmd to begin the execution of all of the DB scripts.

	*Update the -S switch of sqlcmd to point to your SQL Server
	This is the only script to be ran to do the deployment.

*/

--enable xpcmdshell

--check the status before turning option to 1
USE master;
GO

--turn advanced options on
EXEC sp_configure ''show advanced option'', ''1'';
RECONFIGURE WITH OVERRIDE;

--create temp table to store status
CREATE TABLE #tmp_cmdShellStatus (name sysname, minimum int, maximum int, config_value int, run_value int);

--insert values into temp table
INSERT INTO #tmp_cmdShellStatus
EXEC sp_configure ''xp_cmdshell'';
GO

--set status to 1 regardless of whether it is already on or not
EXEC master.dbo.sp_configure ''show advanced options'', 1
RECONFIGURE WITH OVERRIDE;
GO

EXEC master.dbo.sp_configure ''xp_cmdshell'', 1
RECONFIGURE WITH OVERRIDE;
GO



/***** Perform the deployment by calling the script that references each of the DB update scripts. *****/
EXEC xp_cmdshell   ''SQLCMD -S"SQLServerA" -E -d"master" -i"C:\releases\2010\July\01a_main_release.sql" -o"C:\releases\2010\July\01a_main_release_output.txt"''




/******  Return xp_cmdshell to its previous state  ******/

--turn xp_cmdshell off if it was off before running the deployment script
If exists (SELECT run_value FROM #tmp_cmdShellStatus where run_value = 0)
BEGIN
	/* Disable xp_cmdshell following SSIS package deployment */
	/* Off is the default */
	EXEC master.dbo.sp_configure ''show advanced options'', 1
	RECONFIGURE WITH OVERRIDE;

	EXEC master.dbo.sp_configure ''xp_cmdshell'', 0
	RECONFIGURE WITH OVERRIDE;
END

DROP TABLE #tmp_cmdShellStatus;
GO
', 
		@database_name=N'master', 
		@flags=0
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
/****** Object:  Step [Email Output File]    Script Date: 08/05/2010 22:39:24 ******/
EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id=@jobId, @step_name=N'Email Output File', 
		@step_id=2, 
		@cmdexec_success_code=0, 
		@on_success_action=1, 
		@on_success_step_id=0, 
		@on_fail_action=2, 
		@on_fail_step_id=0, 
		@retry_attempts=0, 
		@retry_interval=0, 
		@os_run_priority=0, @subsystem=N'TSQL', 
		@command=N'DECLARE @v_recipients VARCHAR(255),
		@v_body VARCHAR(1000),
		@v_subject VARCHAR(255),
		@v_profile_name VARCHAR(255),
		@v_importance VARCHAR(6),
		@v_body_format VARCHAR (20)
		
SET @v_recipients = ''email_address@sqlservercentral.com''; --semicolon delimited list
SET @v_subject = @@servername+'': Release Script Reported Success''
SET @v_body = ''Release Script Reported Success. Output attached.''
SET @v_profile_name = ''SQL_DBA_Profile'' --datbase mail profile name
SET @v_importance = ''Normal'' --Low, Normal, High
SET @v_body_format = ''TEXT'' --TEXT, HTML

EXECUTE msdb.dbo.sp_send_dbmail
			@recipients=@v_recipients,
			@body= @v_body, 
			@subject = @v_subject,
			@profile_name = @v_profile_name,
			@importance = @v_importance,
			@body_format = @v_body_format,
			@file_attachments = ''C:\releases\2010\July\01a_main_release_output.txt''', 
		@database_name=N'master', 
		@flags=0
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_update_job @job_id = @jobId, @start_step_id = 1
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_add_jobschedule @job_id=@jobId, @name=N'one time run (change and enable for each release)', 
		@enabled=0, 
		@freq_type=1, 
		@freq_interval=0, 
		@freq_subday_type=0, 
		@freq_subday_interval=0, 
		@freq_relative_interval=0, 
		@freq_recurrence_factor=0, 
		@active_start_date=20100718, 
		@active_end_date=99991231, 
		@active_start_time=10000, 
		@active_end_time=235959
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_add_jobserver @job_id = @jobId, @server_name = N'(local)'
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
COMMIT TRANSACTION
GOTO EndSave
QuitWithRollback:
    IF (@@TRANCOUNT > 0) ROLLBACK TRANSACTION
EndSave:

GO

