/*

SK: This script will turn on xp_cmdshell and then call sqlcmd to begin the execution of all of the DB scripts.

	*Update the -S switch of sqlcmd to point to your SQL Server
	This is the only script to be ran to do the deployment.

*/

--enable xpcmdshell

--check the status before turning option to 1
USE master;
GO

--turn advanced options on
EXEC sp_configure 'show advanced option', '1';
RECONFIGURE WITH OVERRIDE;

--create temp table to store status
CREATE TABLE #tmp_cmdShellStatus (name sysname, minimum int, maximum int, config_value int, run_value int);

--insert values into temp table
INSERT INTO #tmp_cmdShellStatus
EXEC sp_configure 'xp_cmdshell';
GO

--set status to 1 regardless of whether it is already on or not
EXEC master.dbo.sp_configure 'show advanced options', 1
RECONFIGURE WITH OVERRIDE;
GO

EXEC master.dbo.sp_configure 'xp_cmdshell', 1
RECONFIGURE WITH OVERRIDE;
GO



/***** Perform the deployment by calling the script that references each of the DB update scripts. *****/
EXEC xp_cmdshell   'SQLCMD -S"SQLServerA" -E -d"master" -i"C:\releases\2010\July\01a_main_release.sql" -o"C:\releases\2010\July\01a_main_release_output.txt"'




/******  Return xp_cmdshell to its previous state  ******/

--turn xp_cmdshell off if it was off before running the deployment script
If exists (SELECT run_value FROM #tmp_cmdShellStatus where run_value = 0)
BEGIN
	/* Disable xp_cmdshell following SSIS package deployment */
	/* Off is the default */
	EXEC master.dbo.sp_configure 'show advanced options', 1
	RECONFIGURE WITH OVERRIDE;

	EXEC master.dbo.sp_configure 'xp_cmdshell', 0
	RECONFIGURE WITH OVERRIDE;
END

DROP TABLE #tmp_cmdShellStatus;
GO
