/* 
 * Tables to support the cleansing of address data 
 * Packages:	paf_example.dtsx
 * Author:		John Tunnicliffe
 * Email:		dr.john.tunnicliffe@talk21.com
 * Date:		Oct 2007
 */

-- Input table containing dirty address data
IF OBJECT_ID (N'dbo.input_dirty_address_data', N'U') IS NOT NULL
	DROP TABLE dbo.input_dirty_address_data
GO
CREATE TABLE dbo.input_dirty_address_data(
	address_id int NOT NULL,
	-- whole address must contain comma-deliminated address data. 
	-- no carriage returns or line feed characters!!!
	whole_address varchar(500) NULL
) ON [PRIMARY]
GO

IF OBJECT_ID (N'dbo.output_clean_address_data', N'U') IS NOT NULL
	DROP TABLE dbo.output_clean_address_data
GO
CREATE TABLE dbo.output_clean_address_data(
	-- holds Postcode Anywhere address data
	address_id int NOT NULL,
	paf_id varchar(20) NULL,
	organisation_name varchar(50) NULL,
	address_line_1 varchar(50) NULL,
	address_line_2 varchar(50) NULL,
	address_line_3 varchar(50) NULL,
	address_line_4 varchar(50) NULL,
	address_line_5 varchar(50) NULL,
	posttown varchar(20) NULL,
	county varchar(20) NULL,
	postcode varchar(10) NULL
) ON [PRIMARY]
GO

-- Table to record errors encountered when cleansing address data
IF OBJECT_ID (N'dbo.output_addresses_with_errors', N'U') IS NOT NULL
	DROP TABLE dbo.output_addresses_with_errors
GO
CREATE TABLE dbo.output_addresses_with_errors(
	address_id int NULL,
	error_desc nvarchar(50) NULL
) ON [PRIMARY]
GO

IF OBJECT_ID (N'dbo.addresses_with_errors', N'V') IS NOT NULL
	DROP VIEW dbo.addresses_with_errors
GO
CREATE VIEW dbo.addresses_with_errors
AS
SELECT A.*, B.error_desc 
FROM input_dirty_address_data A
	INNER JOIN output_addresses_with_errors B ON
		A.address_id = B.address_id
GO
