/***************************************************************************************************************
*Routine Name: [dbo].[jb_mywho2]
*Purpose: Return SPID information from SQL Server
*Used by: Admins
*Inputs: @IsUserProcess (0,1),@CurrentSpid (0,Null)
*Returns:
*Test Code: EXEC jb_mywho2 
*Revision History
*Version		Date		Person		Description
*=========		=======		========	================
*1.0.0			03/31/2010	J Brimhall	Create Proc
*1.0.1			04/25/2010	J Brimhall	Fixed Null database name issue
*1.0.2			04/29/2010	J Brimhall	Report open transaction count
***************************************************************************************************************/


Alter Procedure jb_mywho2
	@IsUserProcess	TinyInt = 0
	,@CurrentSpid	TinyInt = 0
	
As
Begin
Set NoCount On

/*
Test Code
------------------------------------------
Declare @IsUserProcess	TinyInt
		,@CurrentSpid	TinyInt
	
Select @IsUserProcess = 0
		,@CurrentSpid = 0

*/

Select es.session_id as SPID
		,ROW_NUMBER() over (partition by es.session_id order by es.login_time) as SubProcessID
		,DB_NAME(Coalesce(er.database_id,tl1.resource_database_id,' - ')) as DBName
		,Coalesce(ot.task_state,es.status,' - ') as TaskStatus
		,es.login_name as LoginName
		,Coalesce(ec.client_net_address,' - ') as IPAddress
		,Coalesce((SELECT text AS [processing-instruction(definition)]
			FROM sys.dm_exec_sql_text(ec.most_recent_sql_handle)
			FOR XML PATH(''), TYPE
		),'') as QueryText
		,Coalesce(er.wait_type,wt.wait_type,er.last_wait_type,' - ') as WaitType
		,Coalesce(es.host_name,' - ') as HostName
		,Coalesce(tl.request_session_id,'') as BlockedBy
		,Coalesce((SELECT p.text
			FROM (SELECT MIN(sql_handle) AS sql_handle
					FROM sys.dm_exec_requests r2
					WHERE r2.session_id = tl.request_session_id
				) AS rb
			CROSS APPLY
				(SELECT text AS [processing-instruction(definition)]
					FROM sys.dm_exec_sql_text(rb.sql_handle)
					FOR XML PATH(''), TYPE
				) p (text)
		),'') AS BlockingText
		,Coalesce(es.program_name,' - ') as ProgramName
		,Coalesce(es.client_interface_name,' - ') as ClientInterface
		,Coalesce(es.host_process_id,' - ') as UserProcessID
		,es.login_time as LoginTime
		,es.last_request_start_time as LastBatch
		,es.total_elapsed_time *.001 as SessionElapsedTime
		,es.total_scheduled_time * .001 as CPUTime
		,es.memory_usage as Num8kPages
		,Coalesce(ec.num_reads,'') as NumReads
		,Coalesce(ec.num_writes,'') as NumWrites
		,Coalesce(er.open_transaction_count,st.TranCount,0) as OpenTranCount
		,Coalesce(dt.lockcount,0) as LockCount
	From sys.dm_exec_sessions es
		Left Outer Join sys.dm_exec_connections ec
			On ec.session_id = es.session_id
		Left Outer Join sys.dm_os_waiting_tasks wt
			On wt.session_id = es.session_id
		Left Outer Join sys.dm_os_tasks ot
			ON es.session_id = ot.session_id
		Left Outer Join sys.dm_tran_locks tl
			On wt.blocking_session_id = tl.request_session_id
		Left Outer Join sys.dm_tran_locks tl1
			On ec.session_id = tl1.request_session_id
		Left Outer Join sys.dm_exec_requests er
			On tl.request_session_id = er.session_id
		Left Outer Join (
			Select request_session_id,COUNT(request_session_id) as LockCount
				From sys.dm_tran_locks
				Group By request_session_id
			) dt
			On ec.session_id = dt.request_session_id
		Left Outer Join (
			Select session_id,COUNT(session_id) as TranCount
				From sys.dm_tran_session_transactions
				Group By session_id
			) st
			On ec.session_id = st.session_id
	Where es.is_user_process >= (case when @IsUserProcess = 0 Then 0 Else 1 End)
		And es.session_id <> (case when @CurrentSPID = 0 Then 0 Else @@SPID End)	--@@SPID if current Spid is to be excluded
		
		
End
