Use master
Go

Create Database TestLogGrowth
Go

--Verify Settings By opening Database properties

Use TestLogGrowth
go

Create Table DBFileSizeLog (
	LogID int identity primary key, DBName Varchar(25),DBSizeMB decimal(15,2),DataSizeMB decimal(15,2)
	,LogSizeMB decimal(15,2),LogUsedMB decimal(15,2),LogUsedPercent Decimal (9,2),LogGrowths Int,CheckDate datetime
	)
go

Create proc SpaceUsed_perfmon as 

Set nocount on

Begin

	Declare @instanceName	Varchar(25)

	Set @instanceName = 'TestLogGrowth'
	;
	WITH    LogData (database_name, measure, value) AS
	(
	SELECT  instance_name,
	CASE counter_name
	WHEN N'Data File(s) Size (KB)' THEN N'DSize'
	WHEN N'Log File(s) Size (KB)' THEN N'LSize'
	WHEN N'Log File(s) Used Size (KB)' THEN N'Used'
	WHEN N'Log Growths' THEN N'Grow'
	END,
	cntr_value
	FROM    sys.dm_os_performance_counters PC
	WHERE   counter_name IN (N'Data File(s) Size (KB)', N'Log File(s) Size (KB)'
		, N'Log File(s) Used Size (KB)', N'Log Growths')
	AND     instance_name = @InstanceName
	),
	LogUsage AS
	(
	SELECT  database_name,
		DataSizeMB = CONVERT(DEC(9,2), SUM(CASE WHEN measure = N'DSize' THEN value ELSE 0 END) / 1024.0),
		LogSizeMB = CONVERT(DEC(9,2), SUM(CASE WHEN measure = N'LSize' THEN value ELSE 0 END) / 1024.0),
		LogUsedMB = CONVERT(DEC(9,2), SUM(CASE WHEN measure = N'Used' THEN value ELSE 0 END) / 1024.0),
		LogGrowths = CONVERT(DEC(9,2), SUM(CASE WHEN measure = N'Grow' THEN value ELSE 0 END))
	FROM LogData
	GROUP BY database_name
	)
	Insert into DBFileSizeLog (DBName,DBSizeMB,DataSizeMB,LogSizeMB,LogUsedMB,LogUsedPercent,LogGrowths,CheckDate)
		SELECT  database_name,DataSizeMB+LogSizeMB,DataSizeMB,LogSizeMB,LogUsedMB
				,[LogUsedPercent] = CONVERT(DEC(9,2), ((LogUsedMB * 100.0) / LogSizeMB))
				,LogGrowths,convert(varchar(19),GETDATE(),120)
			FROM LogUsage
			ORDER BY database_name ASC;
End


/* method two */

CREATE TABLE [dbo].[AuditTSQL](
	[TSqlID] [int] IDENTITY(1,1) NOT NULL,
	[LoginName] [varchar](30) NULL,
	[Spid] [int] NULL,
	[DBName] [varchar](25) NULL,
	[ParentQuery] [varchar](max) NULL,
	[Wait] [varchar](50) NULL,
	[Program] [varchar](75) NULL,
	[Hostname] [varchar](25) NULL,
	[StartTime] [datetime] NULL,
	[InsertedTime] [datetime] NULL,
 CONSTRAINT [PK_AuditTSQL] PRIMARY KEY CLUSTERED 
(
	[TSqlID] ASC
))

go

Create Proc RunningSQLStatements
as
Begin
		Insert Into AuditTSQL (LoginName,SPID,DBName,ParentQuery,Wait,Program,HostName,StartTime,InsertedTime)
		SELECT sp.loginame as [UserName],sp.spid as SPID
			, DB_NAME(sp.dbid)
			,qt.text
			,wait_type
			,sp.program_name
			,Hostname
			,start_time
			,convert(varchar(19),GETDATE(),120)
			FROM sys.dm_exec_requests er
			INNER JOIN sys.sysprocesses sp 
				ON er.session_id = sp.spid
			Inner Join sys.dm_exec_sessions es
				On er.session_id = es.session_id
			CROSS APPLY sys.dm_exec_sql_text(er.sql_handle) as qt
			WHERE es.is_user_process = 1 -- Ignore system spids.
				AND er.session_Id NOT IN (@@SPID) -- Ignore this current statement.
			ORDER BY sp.dbid, sp.loginame
			
End

--Establish a baseline by running the spacemon_perfmon proc
Exec SpaceUsed_perfmon
