/************************************************
-- AUTHOR	Alan Jefferson
-- Date		5/11/2017
--
-- Purpose	Query to discover the current schedules defined in SQL Agent
-- Dependency   fn_IntToTimeString.sql
*************************************************/
DECLARE @daysOfWeek TABLE
	(
	[dayNumber]   TINYINT,
	[dayCode]     TINYINT,
	[dayName]		VARCHAR(11)
	)
 
INSERT INTO
	@daysOfWeek
	(
	[dayNumber],
	[dayCode],
	[dayName]
	)
VALUES
   (1,1, 'Sunday'),
   (2,2, 'Monday'),
   (3,4, 'Tuesday'),
   (4,8, 'Wednesday'),
   (5,16, 'Thursday'),
   (6,32, 'Friday'),
   (7,64, 'Saturday');

DECLARE @daysOfWeek_relative TABLE
	(
	[dayNumber] INT,
	[dayCode]   INT,
	[dayText]	VARCHAR(250)
	)
 
INSERT INTO
   @daysOfWeek_relative
   (
   [dayNumber],
   [dayCode],
   [dayText]
   )
VALUES
   (1,1, 'On the <<wk>> Sunday of every <<n>> Month(s)'),
   (2,2, 'On the <<wk>> Monday of every <<n>> Month(s)'),
   (3,3, 'On the <<wk>> Tuesday of every <<n>> Month(s)'),
   (4,4, 'On the <<wk>> Wednesday of every <<n>> Month(s)'),
   (5,5, 'On the <<wk>> Thursday of every <<n>> Month(s)'),
   (6,6, 'On the <<wk>> Friday of every <<n>> Month(s)'),
   (7,7, 'On the <<wk>> Saturday of every <<n>> Month(s)'),
   (8,8, 'Each Day of the <<wk>> week of every <<n>> Month(s)'),
   (9,9, 'Each Weekday of the <<wk>> week of every <<n>> Month(s)'),
   (10,10, 'Each Weekend Day of the <<wk>> week of every <<n>> Month(s)');

DECLARE @weeksOfMonth TABLE
	(
	[womNumber]   TINYINT,
	[womCode]     TINYINT,
	[womName]		VARCHAR(11)
	)
 
INSERT INTO
   @weeksOfMonth
   (
   [womNumber],
   [womCode],
   [womName]
   )
VALUES
	(1, 1, 'First'),
	(2, 2, 'Second'),
	(3, 4, 'Third'),
	(4, 8, 'Fourth'),
	(5, 16, 'Last');

DECLARE @Ordinal TABLE 
	(OrdinalID int,
	 OrdinalCode int,
	 OrdinalName varchar(20))
	 
insert into @Ordinal (OrdinalID, OrdinalCode, OrdinalName)
values
	(1,1,'1st'),
	(2,2,'2nd'),
	(3,3,'3rd'),
	(4,4,'4th'),
	(5,5,'5th'),
	(6,6,'6th'),
	(7,7,'7th'),
	(8,8,'8th'),
	(9,9,'9th'),
	(10,10,'10th'),
	(11,11,'11th'),
	(12,12,'12th'),
	(13,13,'13th'),
	(14,14,'14th'),
	(15,15,'15th'),
	(16,16,'16th'),
	(17,17,'17th'),
	(18,18,'18th'),
	(19,19,'19th'),
	(20,20,'20th'),
	(21,21,'21st'),
	(22,22,'22nd'),
	(23,23,'23rd'),
	(24,24,'24th'),
	(25,25,'25th'),
	(26,26,'26th'),
	(27,27,'27th'),
	(28,28,'28th'),
	(29,29,'29th'),
	(30,30,'30th'),
	(31,31,'31st');


WITH CTE_DOW
AS(
	select distinct schedule_id
	, Days_of_Week = convert(varchar(250),STUFF((select ', ' + DOW.[dayName] 
		from @daysOfWeek DOW WHERE ss.[freq_interval] & DOW.dayCode = DOW.dayCode
		for xml path('')),1,2,''))
	from msdb.dbo.sysschedules ss
), 
CTE_WOM
AS(
	select distinct schedule_id 
	, Weeks_of_Month = convert(varchar(250),STUFF((select ', ' + WOM.[womName] 
		from @WeeksOfMonth WOM WHERE ss.[freq_relative_interval] & WOM.womCode = WOM.womCode
		for xml path('')),1,2,''))
	from msdb.dbo.sysschedules ss
)
select @@ServerName as Server_Name, sj.name as Job_Name, sj.[Enabled] as Job_Enabled, ss.name as Schedule_Name, ss.[enabled] as Schedule_Enabled
	, Frequency = convert (varchar(500), CASE freq_Type 
			WHEN 1 then 'One Time Only'
			WHEN 4 then 'Every ' + CONVERT(varchar(3),ss.freq_interval) + ' Day(s)'
			WHEN 8 then 'Every ' + isnull(DOW.Days_of_Week,'') + ' of every ' + CONVERT(varchar(3),ss.freq_recurrence_factor) + ' Week(s).' 
			WHEN 16 then 'On the ' + ISNULL(od.OrdinalName,'') + ' day of every ' + CONVERT(varchar(3),ss.freq_recurrence_factor) + ' Month(s).'
			WHEN 32 then REPLACE(REPLACE(DOWR.[dayText], '<<wk>>', isnull(WOM.Weeks_of_Month,'')), '<<n>>', CONVERT(varchar(3),ss.freq_recurrence_factor)) 
			WHEN 64 then 'When SQL Server Starts'
			WHEN 128 then 'WHEN SQL Server is Idle'
			ELSE '' END)
	, Interday_Frequency = CONVERT(varchar(500), CASE when freq_Type NOT IN (64, 128) THEN CASE freq_subday_type
			WHEN 0 then ' at '
			WHEN 1 then 'Once at '
			WHEN 2 then 'Every ' + CONVERT(varchar(10), ss.freq_subday_interval) + ' Second(s) starting at '
			WHEN 4 then 'Every ' + CONVERT(varchar(10), ss.freq_subday_interval) + ' Minute(s) starting at '
			WHEN 8 then 'Every ' + CONVERT(varchar(10), ss.freq_subday_interval) + ' Hour(s) starting at '
			ELSE '' END  +  dbo.fn_IntToTimeString(active_start_time) 
			+ CASE WHEN ss.freq_subday_type IN (2,4,8) THEN ' Ending at '+ dbo.fn_IntToTimeString(active_end_time) ELSE '' END
			ELSE '' END) 
	, active_start_date = convert(datetime,CONVERT(varchar(8),ss.active_start_date,114))
	, active_start_time = dbo.fn_IntToTimeString(active_start_time)
	, active_end_date = convert(datetime,CONVERT(varchar(8),ss.active_end_date,114))
	, active_end_time = dbo.fn_IntToTimeString(active_end_time)
from msdb.dbo.sysjobs sj
join msdb.dbo.sysjobschedules sjs 
	on sj.job_id = sjs.job_id
join msdb.dbo.sysschedules ss 
	on sjs.schedule_id = ss.schedule_id
left join CTE_DOW DOW 
	on ss.Schedule_id = DOW.Schedule_id
left join CTE_WOM WOM 
	on ss.schedule_id = WOM.schedule_id
left join @Ordinal od 
	on ss.freq_interval = od.OrdinalCode
left join @Ordinal om 
	on ss.freq_recurrence_factor = om.OrdinalCode
left join @daysOfWeek_relative DOWR 
	ON ss.freq_interval = DOWR.dayCode
