/************************************************
-- AUTHOR	Alan Jefferson
-- Date		5/11/2017
--
-- Purpose	Stand alone query to discover the current jobs 
--              and job steps that exist on the SQL Agent.
*************************************************/

select ServerName = @@ServerName, sj.name, sj.enabled, sjs.step_id, sjs.step_name
	, sjs.database_name, sjs.subsystem, sjs.command, sjs.last_run_outcome
	, last_run = CASE WHEN len(sjs.last_Run_Date) = 8 
					then Convert(datetime, CONVERT(varchar(8),sjs.last_Run_Date) + '  ' 
					+ left(right('000000' + CONVERT(varchar(6),sjs.last_run_time),6),2) 
					+ ':' + SUBSTRING(right('000000' + CONVERT(varchar(6),sjs.last_run_time),6),3,2) 
					+ ':' + RIGHT('00' + CONVERT(varchar(6),sjs.last_run_time),2)) 
				ELSE NULL 
				END
from sysjobs sj
join sysjobsteps sjs ON sj.job_id = sjs.job_id
order by sj.name, sjs.step_id;