import os
import sys
import time
from datetime import datetime, timedelta
	
try:
	# Our backup types
	backupTypes = ( "DIFF", "FULL", "LOG" )

	# Get the folder to search and the report file name from the command line
	rootFolder = sys.argv[1]
	if("\\" in sys.argv[2]):
		filename = sys.argv[2]
	else:
		filename = rootFolder.rstrip("\\") + "\\" + sys.argv[2]

	# Open the report file for writing
	with open(filename,"w") as outfile:

		print("Creating report: %s" % filename)
		folderCount = 0

		# Write the CSV header row
		outfile.write("Server,Database,BackupType,FileCount,SizeGB,Latest,LatestAgeInDays,Oldest,OldestAgeInDays\n")

		# Start walking the backup folder path
		for root, dirs, files in os.walk(rootFolder):

			# Strip out any drive letter or UNC double-backslash from the front of the path
			path = root.replace(rootFolder,'').lstrip("\\")
			if(len(path) > 1 and path[1] == ':'):
				path = path[2:]

			# Now split the path into server\database\backup-type tokens
			tokens = path.split('\\')

			# Check to see if this is a backup folder
			if(len(tokens) == 3 and tokens[2].upper() in backupTypes):

				# Get stats on files
				folderCount += 1
				print("Server:%s / Database: %s / BackupType: %s" % (tokens[0], tokens[1], tokens[2]))
				size = 0
				oldestDate = None
				newestDate = None

				# For each file...
				for file in files:

					# Make the file path and get the stats
					filePath = "{}\\{}".format(root, file)
					stats = os.stat(filePath)

					# Calculate the size and newest/oldest file dates
					size += stats.st_size
					filedate = datetime.fromtimestamp(stats.st_ctime)
					if(newestDate is None or filedate > newestDate):
						newestDate = filedate
					if(oldestDate is None or filedate < oldestDate):
						oldestDate = filedate

				# Calculate oldest and newest file ages in days
				oldestAgeInDays = (datetime.now() - oldestDate).days
				newestAgeInDays = (datetime.now() - newestDate).days

				# Write the stats for this backup folder
				outfile.write("%s,%s,%s,%d,%.2f,%s,%d,%s,%d\n" % 
						(tokens[0],tokens[1],tokens[2], len(files), size/1073741824,newestDate.strftime("%m-%d-%Y %H:%M:%S"),newestAgeInDays,oldestDate.strftime("%m-%d-%Y %H:%M:%S"),oldestAgeInDays))

	# Done - print number of folders searched
	print("Done - searched [%d] folders" % folderCount)
except IndexError:
	print("Usage: %s <folder> <output-filename>" % sys.argv[0])
except IOError:
	print("Could not create file: \"%s\". Is the folder correct?" % filename)


