USE master
GO

IF EXISTS (SELECT DATABASE_ID FROM SYS.DATABASES WHERE NAME = 'FMR')
DROP DATABASE FMR
GO

PRINT '======= Drop FMR Database Complete ========'
PRINT ''

CREATE DATABASE [FMR] ON  PRIMARY 
( NAME = N'FMR_Primary', FILENAME = N'C:\Program Files\Microsoft SQL Server\MSSQL.1\MSSQL\DATA\FMR_Primary.mdf' , SIZE = 2048KB , FILEGROWTH = 1024KB ), 
 FILEGROUP [FMR_Data] 
( NAME = N'FMRG1F1_Data', FILENAME = N'C:\Program Files\Microsoft SQL Server\MSSQL.1\MSSQL\DATA\FMRG1F1_Data.ndf' , SIZE = 2048KB , FILEGROWTH = 1024KB ), 
 FILEGROUP [FMR_Index] 
( NAME = N'FMRG2F1_Data', FILENAME = N'C:\Program Files\Microsoft SQL Server\MSSQL.1\MSSQL\DATA\FMRG2F1_Data.ndf' , SIZE = 2048KB , FILEGROWTH = 1024KB )
 LOG ON 
( NAME = N'FMR_log', FILENAME = N'C:\Program Files\Microsoft SQL Server\MSSQL.1\MSSQL\DATA\FMR_Log.ldf' , SIZE = 1024KB , FILEGROWTH = 10%)
GO

EXEC dbo.sp_dbcmptlevel @dbname=N'FMR', @new_cmptlevel=90
GO

IF (1 = FULLTEXTSERVICEPROPERTY('IsFullTextInstalled'))
begin
EXEC [FMR].[dbo].[sp_fulltext_database] @action = 'disable'
end
GO

USE [FMR]
GO

IF NOT EXISTS (SELECT name FROM sys.filegroups WHERE is_default=1 AND name = N'FMR_Data') ALTER DATABASE [FMR] MODIFY FILEGROUP [FMR_Data] DEFAULT
GO

PRINT '======= Create FMR Database Complete ========'
PRINT ''

IF EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'UdtAge' AND ss.name = N'dbo')
DROP TYPE [dbo].[UdtAge]
GO

CREATE TYPE [dbo].[UdtAge] FROM [tinyint] NOT NULL
GO

IF EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'UdtAmount' AND ss.name = N'dbo')
DROP TYPE [dbo].[UdtAmount] 
GO

CREATE TYPE [dbo].[UdtAmount] FROM [decimal](28, 10) NOT NULL
GO

IF EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'UdtAttachment' AND ss.name = N'dbo')
DROP TYPE [dbo].[UdtAttachment]
GO

CREATE TYPE [dbo].[UdtAttachment] FROM [varchar](2000) NOT NULL
GO

IF EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'UdtChannel' AND ss.name = N'dbo')
DROP TYPE [dbo].[UdtChannel] 
GO

CREATE TYPE [dbo].[UdtChannel] FROM [varchar](25) NOT NULL
GO

IF EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'UdtChannelType' AND ss.name = N'dbo')
DROP TYPE [dbo].[UdtChannelType]
GO

CREATE TYPE [dbo].[UdtChannelType] FROM [varchar](15) NOT NULL
GO

IF EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'UdtCode' AND ss.name = N'dbo')
DROP TYPE [dbo].[UdtCode] 
GO

CREATE TYPE [dbo].[UdtCode] FROM [varchar](10) NOT NULL
GO

IF EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'UdtDateTime' AND ss.name = N'dbo')
DROP TYPE [dbo].[UdtDateTime]
GO

CREATE TYPE [dbo].[UdtDateTime] FROM [datetime] NOT NULL
GO

IF EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'UdtDesc' AND ss.name = N'dbo')
DROP TYPE [dbo].[UdtDesc] 
GO

CREATE TYPE [dbo].[UdtDesc] FROM [varchar](255) NOT NULL
GO

IF EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'UdtEffYrMon' AND ss.name = N'dbo')
DROP TYPE [dbo].[UdtEffYrMon] 
GO

CREATE TYPE [dbo].[UdtEffYrMon] FROM [int] NOT NULL
GO

IF EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'UdtEMailAddress' AND ss.name = N'dbo')
DROP TYPE [dbo].[UdtEMailAddress]
GO

CREATE TYPE [dbo].[UdtEMailAddress] FROM [varchar](8000) NOT NULL
GO

IF EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'UdtErrorArgument' AND ss.name = N'dbo')
DROP TYPE [dbo].[UdtErrorArgument]
GO

CREATE TYPE [dbo].[UdtErrorArgument] FROM [varchar](8000) NOT NULL
GO

IF EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'UdtErrorNumber' AND ss.name = N'dbo')
DROP TYPE [dbo].[UdtErrorNumber] 
GO

CREATE TYPE [dbo].[UdtErrorNumber] FROM [decimal](10, 0) NOT NULL
GO

IF EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'UdtFiscalYear' AND ss.name = N'dbo')
DROP TYPE [dbo].[UdtFiscalYear]
GO

CREATE TYPE [dbo].[UdtFiscalYear] FROM [char](2) NOT NULL
GO

IF EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'UdtForm' AND ss.name = N'dbo')
DROP TYPE [dbo].[UdtForm] 
GO

CREATE TYPE [dbo].[UdtForm] FROM [varchar](3) NOT NULL
GO


IF EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'UdtInteger' AND ss.name = N'dbo')
DROP TYPE [dbo].[UdtInteger] 
GO

CREATE TYPE [dbo].[UdtInteger] FROM [int] NOT NULL
GO

IF EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'UdtLine' AND ss.name = N'dbo')
DROP TYPE [dbo].[UdtLine]
GO

CREATE TYPE [dbo].[UdtLine] FROM [varchar](10) NOT NULL
GO

IF EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'UdtLocalMarket' AND ss.name = N'dbo')
DROP TYPE dbo.UdtLocalMarket
GO

CREATE TYPE [dbo].[UdtLocalMarket] FROM [varchar](255) NOT NULL
GO

IF EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'UdtLook' AND ss.name = N'dbo')
DROP TYPE [dbo].[UdtLook]
GO

CREATE TYPE [dbo].[UdtLook] FROM [varchar](6) NOT NULL
GO

IF EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'UdtMessage' AND ss.name = N'dbo')
DROP TYPE [dbo].[UdtMessage]
GO

CREATE TYPE [dbo].[UdtMessage] FROM [varchar](8000) NOT NULL
GO

IF EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'UdtMkt' AND ss.name = N'dbo')
DROP TYPE [dbo].[UdtMkt] 
GO

CREATE TYPE [dbo].[UdtMkt] FROM [varchar](2) NOT NULL
GO

IF EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'UdtMonthName' AND ss.name = N'dbo')
DROP TYPE [dbo].[UdtMonthName]
GO

CREATE TYPE [dbo].[UdtMonthName] FROM [varchar](10) NOT NULL
GO

IF EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'UdtName' AND ss.name = N'dbo')
DROP TYPE [dbo].[UdtName] 
GO

CREATE TYPE [dbo].[UdtName] FROM [varchar](255) NOT NULL
GO

IF EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'UdtNFInd' AND ss.name = N'dbo')
DROP TYPE [dbo].[UdtNFInd]
GO

CREATE TYPE [dbo].[UdtNFInd] FROM [varchar](10) NOT NULL
GO

IF EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'UdtNumber' AND ss.name = N'dbo')
DROP TYPE [dbo].[UdtNumber] 
GO

CREATE TYPE [dbo].[UdtNumber] FROM [decimal](38, 0) NOT NULL
GO

IF EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'UdtProduct' AND ss.name = N'dbo')
DROP TYPE [dbo].[UdtProduct] 
GO

CREATE TYPE [dbo].[UdtProduct] FROM [varchar](20) NOT NULL
GO

IF EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'UdtRatePlan' AND ss.name = N'dbo')
DROP TYPE [dbo].[UdtRatePlan]
GO

CREATE TYPE [dbo].[UdtRatePlan] FROM [varchar](15) NOT NULL
GO

IF EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'UdtRegion' AND ss.name = N'dbo')
DROP TYPE [dbo].[UdtRegion]
GO

CREATE TYPE [dbo].[UdtRegion] FROM [varchar](15) NOT NULL
GO

IF EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'UdtSegment' AND ss.name = N'dbo')
DROP TYPE [dbo].[UdtSegment] 
GO

CREATE TYPE [dbo].[UdtSegment] FROM [varchar](20) NOT NULL
GO

IF EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'UdtSeverity' AND ss.name = N'dbo')
DROP TYPE [dbo].[UdtSeverity]
GO

CREATE TYPE [dbo].[UdtSeverity] FROM [int] NOT NULL
GO

IF EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'UdtSource' AND ss.name = N'dbo')
DROP TYPE [dbo].[UdtSource]
GO

CREATE TYPE [dbo].[UdtSource] FROM [varchar](25) NOT NULL
GO

IF EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'UdtSpectrum' AND ss.name = N'dbo')
DROP TYPE [dbo].[UdtSpectrum]
GO

CREATE TYPE [dbo].[UdtSpectrum] FROM [varchar](3) NOT NULL
GO

IF EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'UdtStateCode' AND ss.name = N'dbo')
DROP TYPE [dbo].[UdtStateCode] 
GO

CREATE TYPE [dbo].[UdtStateCode] FROM [char](2) NOT NULL
GO

IF EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'UdtStatus' AND ss.name = N'dbo')
DROP TYPE [dbo].[UdtStatus]
GO

CREATE TYPE [dbo].[UdtStatus] FROM [varchar](50) NOT NULL
GO

IF EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'UdtStrategy' AND ss.name = N'dbo')
DROP TYPE [dbo].[UdtStrategy]
GO

CREATE TYPE [dbo].[UdtStrategy] FROM [varchar](10) NOT NULL
GO

IF EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'UdtSubChannel' AND ss.name = N'dbo')
DROP TYPE [dbo].[UdtSubChannel]
GO

CREATE TYPE [dbo].[UdtSubChannel] FROM [varchar](20) NOT NULL
GO

IF EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'UdtSubject' AND ss.name = N'dbo')
DROP TYPE [dbo].[UdtSubject]
GO

CREATE TYPE [dbo].[UdtSubject] FROM [varchar](255) NOT NULL
GO

IF EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'UdtSubMkt' AND ss.name = N'dbo')
DROP TYPE [dbo].[UdtSubMkt] 
GO

CREATE TYPE [dbo].[UdtSubMkt] FROM [varchar](5) NOT NULL
GO

IF EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'UdtTerm' AND ss.name = N'dbo')
DROP TYPE [dbo].[UdtTerm] 
GO

CREATE TYPE [dbo].[UdtTerm] FROM [tinyint] NOT NULL
GO

IF EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'UdtUserName' AND ss.name = N'dbo')
DROP TYPE [dbo].[UdtUserName] 
GO

CREATE TYPE [dbo].[UdtUserName] FROM [varchar](255) NOT NULL
GO

IF EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'UdtYearDescriptive' AND ss.name = N'dbo')
DROP TYPE dbo.UdtYearDescriptive
GO

CREATE TYPE [dbo].[UdtYearDescriptive] FROM [varchar](255) NOT NULL
GO

IF EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'UdtYesNo' AND ss.name = N'dbo')
DROP TYPE [dbo].[UdtYesNo]
GO

CREATE TYPE [dbo].[UdtYesNo] FROM [char](1) NOT NULL
GO

IF EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'UdtZipCode' AND ss.name = N'dbo')
DROP TYPE [dbo].[UdtZipCode] 
GO

CREATE TYPE [dbo].[UdtZipCode] FROM [varchar](5) NOT NULL
GO

IF EXISTS (SELECT * FROM sys.types st JOIN sys.schemas ss ON st.schema_id = ss.schema_id WHERE st.name = N'UdtSubProduct' AND ss.name = N'dbo')
DROP TYPE [dbo].[UdtSubProduct] 
GO

CREATE TYPE [dbo].[UdtSubProduct] FROM [varchar](15) NOT NULL
GO

PRINT '======= User Defined Data Type Complete ========'
PRINT ''

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARCHV_DTL_FIN_MGT_RPT]') AND type in (N'U'))
DROP TABLE [dbo].[ARCHV_DTL_FIN_MGT_RPT]
GO

CREATE TABLE [dbo].[ARCHV_DTL_FIN_MGT_RPT](
	ADFMR_PK_ID						[udtNumber] IDENTITY(1,1) NOT NULL,	
	ADFMR_SRC_NM						[udtSource] NOT NULL,	
	ADFMR_BPM_LN_OF_BUS				[udtLine] NOT NULL,
	ADFMR_BPM_SEG_NM					[udtSegment] NOT NULL,
	ADFMR_BPM_PRDCT_NM				[udtProduct] NOT NULL,	
	ADFMR_RT_PLN_GRP_NM				[udtRatePlan] NOT NULL,
	ADFMR_TRM							[udtTerm] NOT NULL,
	ADFMR_CHNL_GRP_NM					[udtChannel] NOT NULL,
	ADFMR_CHNL_NM						[udtChannelType] NOT NULL,
	ADFMR_SUB_CHNL					[udtSubChannel] NOT NULL,
	ADFMR_PM_RGN_NM					[udtRegion] NOT NULL,
	ADFMR_STRG						[udtStrategy] NOT NULL,
	ADFMR_ST_NM						[udtName] NOT NULL,
	ADFMR_ST_CD						[udtStateCode] NOT NULL,
	ADFMR_SPC						[udtSpectrum] NOT NULL,
	ADFMR_EFF_YR						[udtEffYrMon] NOT NULL,
	ADFMR_EFF_MO						[udtEffYrMon] NOT NULL,
	ADFMR_MO_NM						[udtMonthName] NOT NULL,
	ADFMR_EFF_YR_MO					[udtEffYrMon] NOT NULL,
	ADFMR_FISC_YR						[udtFiscalYear] NOT NULL,	
	ADFMR_RPT_YR_MO					[udtEffYrMon] NOT NULL,
	ADFMR_ARB_ULT_POL_CNT				[udtAmount] NOT NULL,
	ADFMR_ARB_POL_CNT					[udtAmount] NOT NULL,
	ADFMR_ARB_POL_CNT_FST_ON			[udtAmount] NOT NULL,
	ADFMR_ARB_POL_CNT_SEC_ON			[udtAmount] NOT NULL,
	ADFMR_ARB_POL_CNT_FST_OFF			[udtAmount] NOT NULL,
	ADFMR_ARB_ULT_POL_CNT_SEC_OFF		[udtAmount] NOT NULL,
	ADFMR_ARB_FC_CO					[udtAmount] NOT NULL,
	ADFMR_ARB_FC_AGT_NP_FST_ON			[udtAmount] NOT NULL,
	ADFMR_ARB_FC_AGT_NP_SEC_ON			[udtAmount] NOT NULL,
	ADFMR_ARB_FC_AGT_NP_ON				[udtAmount] NOT NULL,
	ADFMR_ARB_FC_AGT_NP_FST_OFF		[udtAmount] NOT NULL,
	ADFMR_ARB_FC_AGT_NP_SEC_OFF		[udtAmount] NOT NULL,
	ADFMR_ARB_FC_AGT_NP_OFF			[udtAmount] NOT NULL,
	ADFMR_ARB_ULT_FC_AGT_NP			[udtAmount] NOT NULL,
	ADFMR_ARB_MT						[udtAmount] NOT NULL,
	ADFMR_ARB_ULT_MT					[udtAmount] NOT NULL,
	ADFMR_ARB_RET						[udtAmount] NOT NULL,
	ADFMR_ARB_ULT_RET					[udtAmount] NOT NULL,
	ADFMR_ORA_POL_CNT					[udtAmount] NOT NULL,
	ADFMR_ORA_POL_CNT_FST_ON			[udtAmount] NOT NULL,
	ADFMR_ORA_POL_CNT_SEC_ON			[udtAmount] NOT NULL,
	ADFMR_ORA_POL_CNT_FST_OFF			[udtAmount] NOT NULL,
	ADFMR_ORA_POL_CNT_SEC_OFF			[udtAmount] NOT NULL,
	ADFMR_ORA_FC_CO					[udtAmount] NOT NULL,
	ADFMR_ORA_FC_AGT_NP_FST_ON			[udtAmount] NOT NULL,
	ADFMR_ORA_FC_AGT_NP_SEC_ON			[udtAmount] NOT NULL,
	ADFMR_ORA_FC_AGT_NP_ON				[udtAmount] NOT NULL,
	ADFMR_ORA_FC_AGT_NP_FST_OFF		[udtAmount] NOT NULL,
	ADFMR_ORA_FC_AGT_NP_SEC_OFF		[udtAmount] NOT NULL,
	ADFMR_ORA_FC_AGT_NP_OFF			[udtAmount] NOT NULL,
	ADFMR_ORA_ULT_FC_AGT_NP			[udtAmount] NOT NULL,
	ADFMR_ORA_MT						[udtAmount] NOT NULL,
	ADFMR_ORA_ULT_MT					[udtAmount] NOT NULL,
	ADFMR_ORA_REW						[udtAmount] NOT NULL,
	ADFMR_ORA_ULT_REW					[udtAmount] NOT NULL,
	ADFMR_ORA_RET						[udtAmount] NOT NULL,
	ADFMR_ORA_ULT_RET					[udtAmount] NOT NULL,
	ADFMR_BNB_POL_CNT					[udtAmount] NOT NULL,
	ADFMR_BNB_POL_CNT_FST_ON			[udtAmount] NOT NULL,
	ADFMR_BNB_POL_CNT_SEC_ON			[udtAmount] NOT NULL,
	ADFMR_BNB_POL_CNT_FST_OFF			[udtAmount] NOT NULL,
	ADFMR_BNB_POL_CNT_SEC_OFF			[udtAmount] NOT NULL,
	ADFMR_BNB_ULT_POL_CNT				[udtAmount] NOT NULL,
	ADFMR_BNB_FC_CO					[udtAmount] NOT NULL,
	ADFMR_BNB_FC_AGT_NP_FST_ON			[udtAmount] NOT NULL,
	ADFMR_BNB_FC_AGT_NP_SEC_ON			[udtAmount] NOT NULL,
	ADFMR_BNB_FC_AGT_NP_ON				[udtAmount] NOT NULL,
	ADFMR_BNB_FC_AGT_NP_FST_OFF		[udtAmount] NOT NULL,
	ADFMR_BNB_FC_AGT_NP_SEC_OFF		[udtAmount] NOT NULL,
	ADFMR_BNB_FC_AGT_NP_OFF			[udtAmount] NOT NULL,
	ADFMR_BNB_ULT_FC_AGT_NP			[udtAmount] NOT NULL,
	ADFMR_BNB_MT						[udtAmount] NOT NULL,
	ADFMR_BNB_ULT_MT					[udtAmount] NOT NULL,
	ADFMR_BNB_REW						[udtAmount] NOT NULL,
	ADFMR_BNB_ULT_REW					[udtAmount] NOT NULL,
	ADFMR_BNB_RET						[udtAmount] NOT NULL,
	ADFMR_BNB_ULT_RET					[udtAmount] NOT NULL,
	ADFMR_NB_CHG_EFF_DT					[udtAmount] NOT NULL,
	ADFMR_RRA_POL_CNT					[udtAmount] NOT NULL,
	ADFMR_RRA_POL_CNT_FST_ON			[udtAmount] NOT NULL,
	ADFMR_RRA_POL_CNT_SEC_ON			[udtAmount] NOT NULL,
	ADFMR_RRA_POL_CNT_FST_OFF			[udtAmount] NOT NULL,
	ADFMR_RRA_POL_CNT_SEC_OFF			[udtAmount] NOT NULL,
	ADFMR_RRA_FC_CO					[udtAmount] NOT NULL,
	ADFMR_RRA_FC_AGT_NP_FST_ON			[udtAmount] NOT NULL,
	ADFMR_RRA_FC_AGT_NP_SEC_ON			[udtAmount] NOT NULL,
	ADFMR_RRA_FC_AGT_NP_ON				[udtAmount] NOT NULL,
	ADFMR_RRA_FC_AGT_NP_FST_OFF		[udtAmount] NOT NULL,
	ADFMR_RRA_FC_AGT_NP_SEC_OFF		[udtAmount] NOT NULL,
	ADFMR_RRA_FC_AGT_NP_OFF			[udtAmount] NOT NULL,
	ADFMR_RRA_ULT_FC_AGT_NP			[udtAmount] NOT NULL,
	ADFMR_RRA_MT						[udtAmount] NOT NULL,
	ADFMR_RRA_ULT_MT					[udtAmount] NOT NULL,
	ADFMR_RRA_REW						[udtAmount] NOT NULL,
	ADFMR_RRA_ULT_REW					[udtAmount] NOT NULL,
	ADFMR_RRA_RET						[udtAmount] NOT NULL,
	ADFMR_RRA_ULT_RET					[udtAmount] NOT NULL,
	ADFMR_RPC_AMT_FST_ON				[udtAmount] NOT NULL,
	ADFMR_BAS_WRT_PRM_FST_ON			[udtAmount] NOT NULL,
	ADFMR_RPC_RT_AMT_FST_ON			[udtAmount] NOT NULL,
	ADFMR_RPC_AIL_AMT_FST_ON			[udtAmount] NOT NULL,
	ADFMR_RPC_EXPOS_AMT_FST_ON		[udtAmount] NOT NULL,
	ADFMR_RPC_AMT						[udtAmount] NOT NULL,
	ADFMR_BAS_WRT_PRM					[udtAmount] NOT NULL,
	ADFMR_RPC_RT_AMT					[udtAmount] NOT NULL,
	ADFMR_RPC_AIL_AMT					[udtAmount] NOT NULL,
	ADFMR_RPC_EXPOS_AMT				[udtAmount] NOT NULL,
	ADFMR_ANNL_WRT_PRM_AMT_RB			[udtAmount] NOT NULL,
	ADFMR_ANNL_WRT_PRM_AMT_BNB		[udtAmount] NOT NULL,
	ADFMR_ORG_WRT_PRM_AMT				[udtAmount] NOT NULL,
	ADFMR_ACQN_WRT_PRM_AMT			[udtAmount] NOT NULL,
	ADFMR_COMB_WRT_PRM_AMT			[udtAmount] NOT NULL,
	ADFMR_PRR_IN_FRC_AMT				[udtAmount] NOT NULL,
	ADFMR_YR_END_IN_FRC_AMT			[udtAmount] NOT NULL,
	ADFMR_CURR_IN_FRC_AMT				[udtAmount] NOT NULL,
	ADFMR_EARN_PRM_AMT				[udtAmount] NOT NULL,
	ADFMR_CTL_LS_AMT					[udtAmount] NOT NULL,
	ADFMR_PIF_AMT						[udtAmount] NOT NULL,
	ADFMR_LST_USER					[udtUserName] NOT NULL,
	ADFMR_LST_DT_TM					[udtDateTime] NOT NULL,
	ADFMR_CREAT_USER					[udtUserName] NOT NULL,
	ADFMR_CREAT_DT_TM					[udtDateTime] NOT NULL
) ON [FMR_Data]
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARCHV_IND_COMB_RTO]') AND type in (N'U'))
DROP TABLE [dbo].[ARCHV_IND_COMB_RTO]
GO

CREATE TABLE [dbo].[ARCHV_IND_COMB_RTO](
	[AICR_PK_ID]			[UdtNumber] IDENTITY(1,1) NOT NULL,
	[AICR_BPM_LN_OF_BUS]	[UdtLine] NOT NULL,
	[AICR_SHT_NM]			[UdtName] NOT NULL,
	[AICR_RPT_DESC]			[UdtName] NOT NULL,
	[AICR_ST_CD]			[UdtStateCode] NOT NULL,
	[AICR_ST_NM]			[UdtName] NOT NULL,
	[AICR_CHNL_GRP_NM]		[UdtChannel] NOT NULL,
	[AICR_RPT_MO]			[UdtEffYrMon] NOT NULL,
	[AICR_RPT_YR]			[UdtEffYrMon] NOT NULL,
	[AICR_RPT_YR_MO]		[UdtEffYrMon] NOT NULL,
	[AICR_TOT_PCT]			[UdtAmount] NOT NULL,
	AICR_LST_USER			[udtUserName] NOT NULL,
	AICR_LST_DT_TM			[udtDateTime] NOT NULL,
	AICR_CREAT_USER			[udtUserName] NOT NULL,
	AICR_CREAT_DT_TM			[udtDateTime] NOT NULL
) ON [FMR_Data]
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CNFG_DFLT_SYS_PREF]') AND type in (N'U'))
DROP TABLE [dbo].[CNFG_DFLT_SYS_PREF]
GO

CREATE TABLE [dbo].[CNFG_DFLT_SYS_PREF](
	[CDSP_PK_ID]		[udtInteger] NOT NULL,
	[CDSP_CD]			[udtCode] NOT NULL,
	[CDSP_NM]			[udtName] NOT NULL,
	[CDSP_VAL]			[udtName] NOT NULL,
	[CDSP_LST_USER]		[udtUserName] NOT NULL,
	[CDSP_LST_DT_TM]		[udtDateTime] NOT NULL,
	[CDSP_CREAT_USER]	[udtUserName] NOT NULL,
	[CDSP_CREAT_DT_TM]	[udtDateTime] NOT NULL
) ON [FMR_Data]
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CNFG_MSTR_CYC_NBR]') AND type in (N'U'))
DROP TABLE [dbo].[CNFG_MSTR_CYC_NBR]
GO

CREATE TABLE [dbo].[CNFG_MSTR_CYC_NBR](
	[CMCN_PK_ID] [udtInteger] IDENTITY(1,1) NOT NULL,
	[CMCN_TNJ_CURR] [udtInteger] NOT NULL,
	[CMCN_WRT_PRM_CURR] [udtInteger] NOT NULL,
	[CMCN_TNJ_YR_PRR] [udtInteger] NOT NULL,
	[CMCN_WRT_PRM_YR_PRR] [udtInteger] NOT NULL,
	[CMCN_TNJ_LT_YR_END] [udtInteger] NOT NULL,
	[CMCN_WRT_PRM_LT_YR_END] [udtInteger] NOT NULL,
	[CMCN_LST_USER] [udtUserName] NOT NULL,
	[CMCN_LST_DT_TM] [udtDateTime] NOT NULL,
	[CMCN_CREAT_USER] [udtUserName] NOT NULL,
	[CMCN_CREAT_DT_TM] [udtDateTime] NOT NULL
) ON [FMR_Data]

GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CNFG_MSTR_DVLP_FCT]') AND type in (N'U'))
DROP TABLE [dbo].[CNFG_MSTR_DVLP_FCT]
GO
CREATE TABLE [dbo].[CNFG_MSTR_DVLP_FCT](
	[CMDF_CHNL] [dbo].[UdtChannel] NOT NULL,
	[CMDF_CD] [dbo].[UdtProduct] NOT NULL,
	[CMDF_AGE] [dbo].[UdtInteger] NOT NULL,
	[CMDF_RBLI] [dbo].[UdtInteger] NOT NULL,
	[CMDF_RFA] [dbo].[UdtAmount] NOT NULL,
	[CMDF_RMC] [dbo].[UdtAmount] NOT NULL,
	[CMDF_NBLI] [dbo].[UdtAmount] NOT NULL,
	[CMDF_NFA] [dbo].[UdtAmount] NOT NULL,
	[CMDF_NMC] [dbo].[UdtAmount] NOT NULL
) ON [FMR_Data]
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CNFG_MSTR_FM_DECODE]') AND type in (N'U'))
DROP TABLE [dbo].[CNFG_MSTR_FM_DECODE]
GO

CREATE TABLE [dbo].[CNFG_MSTR_FM_DECODE](
	[CMFD_FM] [dbo].[udtForm] NOT NULL,
	[CMFD_CD] [dbo].[udtCode] NOT NULL,
	[CMFD_DESC] [dbo].[UdtDesc] NOT NULL,
	[CMFD_BPM_SEG_NM] [dbo].[udtSegment] NOT NULL,
	[CMFD_BPM_PRDCT_NM] [dbo].[udtProduct] NOT NULL
) ON [FMR_Data]
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CNFG_MSTR_MKT_DECODE]') AND type in (N'U'))
DROP TABLE [dbo].[CNFG_MSTR_MKT_DECODE]
GO

CREATE TABLE [dbo].[CNFG_MSTR_MKT_DECODE](
	[CMMD_MKT_CD] [dbo].[udtMkt] NOT NULL,
	[CMMD_SUB_MKT] [dbo].[udtSubMkt] NOT NULL,
	[CMMD_CHNL_NM] [dbo].[UdtChannelType] NOT NULL,
	[CMMD_SUB_MKT_DESC] [dbo].[UdtDesc] NOT NULL,
	[CMMD_CHNL_GRP_NM] [dbo].[UdtChannel] NOT NULL,
	[CMMD_MKT_USER_GRP] [dbo].[udtSubChannel] NOT NULL
) ON [FMR_Data]
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CNFG_MSTR_ST_NM]') AND type in (N'U'))
DROP TABLE [dbo].[CNFG_MSTR_ST_NM]
GO

CREATE TABLE [dbo].[CNFG_MSTR_ST_NM](
	[CMSN_ST_CD] [dbo].[udtStateCode] NOT NULL,
	[CMSN_ST_NM] [dbo].[udtName] NOT NULL,
	[CMSN_SPC] [dbo].[udtSpectrum] NOT NULL
) ON [FMR_Data]
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CNFG_MSTR_ZIPCD]') AND type in (N'U'))
DROP TABLE [dbo].[CNFG_MSTR_ZIPCD]
GO

CREATE TABLE [dbo].[CNFG_MSTR_ZIPCD](
	[CMZ_ST_CD] [udtStateCode] NOT NULL,
	[CMZ_ZIP_CD] [udtZipCode] NOT NULL,
	[CMZ_LCL_MKT_TR] [udtLocalMarket] NOT NULL,
	[CMZ_LCL_MKT_TR_PLN] [udtLocalMarket] NOT NULL
) ON [FMR_Data]
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CRIT_STS_XTRCT]') AND type in (N'U'))
DROP TABLE [dbo].[CRIT_STS_XTRCT]
GO

CREATE TABLE [dbo].[CRIT_STS_XTRCT](
	[CSX_PK_ID] [udtInteger] IDENTITY(1,1) NOT NULL,
	[CSX_YR_MO] [udtEffYrMon] NOT NULL,
	[CSX_CTL_IND] [udtYesNo] NOT NULL,
	[CSX_POL_IN_FRC_IND] [udtYesNo] NOT NULL,
	[CSX_TNJ_IND] [udtYesNo] NOT NULL,
	[CSX_FDB_IND] [udtYesNo] NOT NULL,
	[CSX_IND_COMB_RTO_IND] [udtYesNo] NOT NULL,
	[CSX_EARN_PRM_LS_RTO_IND] [udtYesNo] NOT NULL,
	[CSX_LST_USER] [udtUserName] NOT NULL,
	[CSX_LST_DT_TM] [udtDateTime] NOT NULL,
	[CSX_CREAT_USER] [udtUserName] NOT NULL,
	[CSX_CREAT_DT_TM] [udtDateTime] NOT NULL
) ON [FMR_Data]
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EMAIL_DTL_MSG]') AND type in (N'U'))
DROP TABLE [dbo].[EMAIL_DTL_MSG]
GO

CREATE TABLE [dbo].[EMAIL_DTL_MSG](
	[EDM_PK_ID] [dbo].[udtNumber] IDENTITY(1,1) NOT NULL,
	[EDM_SBJ] [dbo].[udtSubject] NOT NULL,
	[EDM_MSG] [dbo].[udtMessage] NOT NULL,
	[EDM_FROM] [dbo].[udtEMailAddress] NOT NULL,
	[EDM_ATTCH] [dbo].[udtAttachment] NOT NULL,
	[EDM_LST_USER] [dbo].[udtUserName] NOT NULL,
	[EDM_LST_DT_TM] [dbo].[udtDateTime] NOT NULL,
	[EDM_CREAT_USER] [dbo].[udtUserName] NOT NULL,
	[EDM_CREAT_DT_TM] [dbo].[udtDateTime] NOT NULL
) ON [FMR_Data]
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EMAIL_DTL_RCIP]') AND type in (N'U'))
DROP TABLE [dbo].[EMAIL_DTL_RCIP]
GO

CREATE TABLE [dbo].[EMAIL_DTL_RCIP](
	[EDR_PK_ID] [dbo].[udtNumber] IDENTITY(1,1) NOT NULL,
	[EDR_MSG_ID] [dbo].[udtNumber] NOT NULL,
	[EDR_EMAIL_ADR] [dbo].[udtEMailAddress] NOT NULL,
	[EDR_TYP] [dbo].[udtInteger] NOT NULL,
	[EDR_SND_IND] [dbo].[udtYesNo] NOT NULL,
	[EDR_SND_DT_TM] [dbo].[udtDateTime] NOT NULL,
	[EDR_LST_USER] [dbo].[udtUserName] NOT NULL,
	[EDR_LST_DT_TM] [dbo].[udtDateTime] NOT NULL,
	[EDR_CREAT_USER] [dbo].[udtUserName] NOT NULL,
	[EDR_CREAT_DT_TM] [dbo].[udtDateTime] NOT NULL
) ON [FMR_Data]
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EMAIL_MSTR_MSG_TMPLT]') AND type in (N'U'))
DROP TABLE [dbo].[EMAIL_MSTR_MSG_TMPLT]
GO

CREATE TABLE [dbo].[EMAIL_MSTR_MSG_TMPLT](
	[EMMT_PK_ID] [dbo].[udtInteger] NOT NULL,
	[EMMT_CD] [dbo].[udtCode] NOT NULL,
	[EMMT_SBJ] [dbo].[udtSubject] NOT NULL,
	[EMMT_MSG] [dbo].[udtMessage] NOT NULL,
	[EMMT_FROM] [dbo].[udtEMailAddress] NOT NULL,
	[EMMT_LST_USER] [dbo].[udtUserName] NOT NULL,
	[EMMT_LST_DT_TM] [dbo].[udtDateTime] NOT NULL,
	[EMMT_CREAT_USER] [dbo].[udtUserName] NOT NULL,
	[EMMT_CREAT_DT_TM] [dbo].[udtDateTime] NOT NULL
) ON [FMR_Data]
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EMAIL_MSTR_ADR_BK]') AND type in (N'U'))
DROP TABLE [dbo].[EMAIL_MSTR_ADR_BK]
GO

CREATE TABLE [dbo].[EMAIL_MSTR_ADR_BK](
	[EMAB_PK_ID] [dbo].[udtInteger] NOT NULL,
	[EMAB_MSG_TMPLT_ID] [dbo].[udtInteger] NOT NULL,
	[EMAB_TO] [dbo].[udtEMailAddress] NOT NULL,
	[EMAB_CC] [dbo].[udtEMailAddress] NOT NULL,
	[EMAB_BCC] [dbo].[udtEMailAddress] NOT NULL,
	[EMAB_LST_USER] [dbo].[udtUserName] NOT NULL,
	[EMAB_LST_DT_TM] [dbo].[udtDateTime] NOT NULL,
	[EMAB_CREAT_USER] [dbo].[udtUserName] NOT NULL,
	[EMAB_CREAT_DT_TM] [dbo].[udtDateTime] NOT NULL
) ON [FMR_Data]
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[LOG_ERR_FIN_MGT_RPT]') AND type in (N'U'))
DROP TABLE [dbo].[LOG_ERR_FIN_MGT_RPT]
GO

CREATE TABLE [dbo].[LOG_ERR_FIN_MGT_RPT](
	[LEFMR_PK_ID] [dbo].[udtNumber] IDENTITY(1,1) NOT NULL,
	[LEFMR_NBR] [dbo].[udtInteger] NOT NULL,
	[LEFMR_SEV] [dbo].[udtSeverity] NOT NULL,
	[LEFMR_MSG] [dbo].[udtMessage] NOT NULL,
	[LEFMR_TSK_NM] [dbo].[udtMessage] NOT NULL,
	[LEFMR_OBJ_NM] [dbo].[udtName] NOT NULL,
	[LEFMR_YR_MO] [dbo].[udtEffYrMon] NOT NULL,
	[LEFMR_LST_USER] [dbo].[udtUserName] NOT NULL,
	[LEFMR_LST_DT_TM] [dbo].[udtDateTime] NOT NULL,
	[LEFMR_CREAT_USER] [dbo].[udtUserName] NOT NULL,
	[LEFMR_CREAT_DT_TM] [dbo].[udtDateTime] NOT NULL
) ON [FMR_Data]
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FACT_CTL_RPT_VAR]') AND type in (N'U'))
DROP TABLE [dbo].[FACT_CTL_RPT_VAR]
GO

CREATE TABLE [dbo].[FACT_CTL_RPT_VAR](
	FCRV_PK_ID [udtInteger] IDENTITY(1,1) NOT NULL,
	FCRV_BPM_LN_OF_BUS [udtLine] NOT NULL,
	FCRV_ST_CD [udtStateCode] NOT NULL,
	FCRV_ST_NM [udtName] NOT NULL,
	FCRV_CURR_MO_ARB_ULT_POL_CNT [udtAmount] NOT NULL,
	FCRV_PREV_MO_ARB_ULT_POL_CNT [udtAmount] NOT NULL,
	FCRV_ARB_ULT_POL_CNT_VAR [udtAmount] NOT NULL,
	FCRV_CURR_MO_ARB_ULT_RET [udtAmount] NOT NULL,
	FCRV_PREV_MO_ARB_ULT_RET [udtAmount] NOT NULL,
	FCRV_ARB_ULT_RET_VAR [udtAmount] NOT NULL,
	FCRV_CURR_MO_ORA_ULT_RET [udtAmount] NOT NULL,
	FCRV_PREV_MO_ORA_ULT_RET [udtAmount] NOT NULL,
	FCRV_ORA_ULT_RET_VAR [udtAmount] NOT NULL,
	FCRV_CURR_MO_BNB_POL_CNT [udtAmount] NOT NULL,
	FCRV_PREV_MO_BNB_POL_CNT [udtAmount] NOT NULL,
	FCRV_BNB_POL_CNT_VAR [udtAmount] NOT NULL,
	FCRV_CURR_MO_BNB_ULT_RET [udtAmount] NOT NULL,
	FCRV_PREV_MO_BNB_ULT_RET [udtAmount] NOT NULL,
	FCRV_BNB_ULT_RET_VAR [udtAmount] NOT NULL,
	FCRV_CURR_MO_RRA_ULT_RET [udtAmount] NOT NULL,
	FCRV_PREV_MO_RRA_ULT_RET [udtAmount] NOT NULL,
	FCRV_RRA_ULT_RET_VAR [udtAmount] NOT NULL,
	FCRV_CURR_MO_RETN_WRT_PRM [udtAmount] NOT NULL,
	FCRV_PREV_MO_RETN_WRT_PRM [udtAmount] NOT NULL,
	FCRV_RETN_WRT_PRM_VAR [udtAmount] NOT NULL,
	FCRV_CURR_MO_RPC_AMT [udtAmount] NOT NULL,
	FCRV_PREV_MO_RPC_AMT [udtAmount] NOT NULL,
	FCRV_RPC_AMT_VAR [udtAmount] NOT NULL,
	FCRV_LST_USER [udtUserName] NOT NULL,
	FCRV_LST_DT_TM [udtDateTime] NOT NULL,
	FCRV_CREAT_USER [udtUserName] NOT NULL,
	FCRV_CREAT_DT_TM [udtDateTime] NOT NULL
) ON [FMR_Data]
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FACT_DTL_FIN_MGT_RPT]') AND type in (N'U'))
DROP TABLE [dbo].[FACT_DTL_FIN_MGT_RPT]
GO

CREATE TABLE [dbo].[FACT_DTL_FIN_MGT_RPT](
	FDFMR_PK_ID						[udtNumber] IDENTITY(1,1) NOT NULL,	
	FDFMR_SRC_NM						[udtSource] NOT NULL,	
	FDFMR_BPM_LN_OF_BUS				[udtLine] NOT NULL,
	FDFMR_BPM_SEG_NM					[udtSegment] NOT NULL,
	FDFMR_BPM_PRDCT_NM				[udtProduct] NOT NULL,	
	FDFMR_RT_PLN_GRP_NM				[udtRatePlan] NOT NULL,
	FDFMR_TRM							[udtTerm] NOT NULL,
	FDFMR_CHNL_GRP_NM					[udtChannel] NOT NULL,
	FDFMR_CHNL_NM						[udtChannelType] NOT NULL,
	FDFMR_SUB_CHNL					[udtSubChannel] NOT NULL,
	FDFMR_PM_RGN_NM					[udtRegion] NOT NULL,
	FDFMR_STRG						[udtStrategy] NOT NULL,
	FDFMR_ST_NM						[udtName] NOT NULL,
	FDFMR_ST_CD						[udtStateCode] NOT NULL,
	FDFMR_SPC						[udtSpectrum] NOT NULL,
	FDFMR_EFF_YR						[udtEffYrMon] NOT NULL,
	FDFMR_EFF_MO						[udtEffYrMon] NOT NULL,
	FDFMR_MO_NM						[udtMonthName] NOT NULL,
	FDFMR_EFF_YR_MO					[udtEffYrMon] NOT NULL,
	FDFMR_FISC_YR						[udtFiscalYear] NOT NULL,	
	FDFMR_ARB_ULT_POL_CNT				[udtAmount] NOT NULL,
	FDFMR_ARB_POL_CNT					[udtAmount] NOT NULL,
	FDFMR_ARB_POL_CNT_FST_ON			[udtAmount] NOT NULL,
	FDFMR_ARB_POL_CNT_SEC_ON			[udtAmount] NOT NULL,
	FDFMR_ARB_POL_CNT_FST_OFF			[udtAmount] NOT NULL,
	FDFMR_ARB_ULT_POL_CNT_SEC_OFF		[udtAmount] NOT NULL,
	FDFMR_ARB_FC_CO					[udtAmount] NOT NULL,
	FDFMR_ARB_FC_AGT_NP_FST_ON			[udtAmount] NOT NULL,
	FDFMR_ARB_FC_AGT_NP_SEC_ON			[udtAmount] NOT NULL,
	FDFMR_ARB_FC_AGT_NP_ON				[udtAmount] NOT NULL,
	FDFMR_ARB_FC_AGT_NP_FST_OFF		[udtAmount] NOT NULL,
	FDFMR_ARB_FC_AGT_NP_SEC_OFF		[udtAmount] NOT NULL,
	FDFMR_ARB_FC_AGT_NP_OFF			[udtAmount] NOT NULL,
	FDFMR_ARB_ULT_FC_AGT_NP			[udtAmount] NOT NULL,
	FDFMR_ARB_MT						[udtAmount] NOT NULL,
	FDFMR_ARB_ULT_MT					[udtAmount] NOT NULL,
	FDFMR_ARB_RET						[udtAmount] NOT NULL,
	FDFMR_ARB_ULT_RET					[udtAmount] NOT NULL,
	FDFMR_ORA_POL_CNT					[udtAmount] NOT NULL,
	FDFMR_ORA_POL_CNT_FST_ON			[udtAmount] NOT NULL,
	FDFMR_ORA_POL_CNT_SEC_ON			[udtAmount] NOT NULL,
	FDFMR_ORA_POL_CNT_FST_OFF			[udtAmount] NOT NULL,
	FDFMR_ORA_POL_CNT_SEC_OFF			[udtAmount] NOT NULL,
	FDFMR_ORA_FC_CO					[udtAmount] NOT NULL,
	FDFMR_ORA_FC_AGT_NP_FST_ON			[udtAmount] NOT NULL,
	FDFMR_ORA_FC_AGT_NP_SEC_ON			[udtAmount] NOT NULL,
	FDFMR_ORA_FC_AGT_NP_ON				[udtAmount] NOT NULL,
	FDFMR_ORA_FC_AGT_NP_FST_OFF		[udtAmount] NOT NULL,
	FDFMR_ORA_FC_AGT_NP_SEC_OFF		[udtAmount] NOT NULL,
	FDFMR_ORA_FC_AGT_NP_OFF			[udtAmount] NOT NULL,
	FDFMR_ORA_ULT_FC_AGT_NP			[udtAmount] NOT NULL,
	FDFMR_ORA_MT						[udtAmount] NOT NULL,
	FDFMR_ORA_ULT_MT					[udtAmount] NOT NULL,
	FDFMR_ORA_REW						[udtAmount] NOT NULL,
	FDFMR_ORA_ULT_REW					[udtAmount] NOT NULL,
	FDFMR_ORA_RET						[udtAmount] NOT NULL,
	FDFMR_ORA_ULT_RET					[udtAmount] NOT NULL,
	FDFMR_BNB_POL_CNT					[udtAmount] NOT NULL,
	FDFMR_BNB_POL_CNT_FST_ON			[udtAmount] NOT NULL,
	FDFMR_BNB_POL_CNT_SEC_ON			[udtAmount] NOT NULL,
	FDFMR_BNB_POL_CNT_FST_OFF			[udtAmount] NOT NULL,
	FDFMR_BNB_POL_CNT_SEC_OFF			[udtAmount] NOT NULL,
	FDFMR_BNB_ULT_POL_CNT				[udtAmount] NOT NULL,
	FDFMR_BNB_FC_CO					[udtAmount] NOT NULL,
	FDFMR_BNB_FC_AGT_NP_FST_ON			[udtAmount] NOT NULL,
	FDFMR_BNB_FC_AGT_NP_SEC_ON			[udtAmount] NOT NULL,
	FDFMR_BNB_FC_AGT_NP_ON				[udtAmount] NOT NULL,
	FDFMR_BNB_FC_AGT_NP_FST_OFF		[udtAmount] NOT NULL,
	FDFMR_BNB_FC_AGT_NP_SEC_OFF		[udtAmount] NOT NULL,
	FDFMR_BNB_FC_AGT_NP_OFF			[udtAmount] NOT NULL,
	FDFMR_BNB_ULT_FC_AGT_NP			[udtAmount] NOT NULL,
	FDFMR_BNB_MT						[udtAmount] NOT NULL,
	FDFMR_BNB_ULT_MT					[udtAmount] NOT NULL,
	FDFMR_BNB_REW						[udtAmount] NOT NULL,
	FDFMR_BNB_ULT_REW					[udtAmount] NOT NULL,
	FDFMR_BNB_RET						[udtAmount] NOT NULL,
	FDFMR_BNB_ULT_RET					[udtAmount] NOT NULL,
	FDFMR_NB_CHG_EFF_DT					[udtAmount] NOT NULL,
	FDFMR_RRA_POL_CNT					[udtAmount] NOT NULL,
	FDFMR_RRA_POL_CNT_FST_ON			[udtAmount] NOT NULL,
	FDFMR_RRA_POL_CNT_SEC_ON			[udtAmount] NOT NULL,
	FDFMR_RRA_POL_CNT_FST_OFF			[udtAmount] NOT NULL,
	FDFMR_RRA_POL_CNT_SEC_OFF			[udtAmount] NOT NULL,
	FDFMR_RRA_FC_CO					[udtAmount] NOT NULL,
	FDFMR_RRA_FC_AGT_NP_FST_ON			[udtAmount] NOT NULL,
	FDFMR_RRA_FC_AGT_NP_SEC_ON			[udtAmount] NOT NULL,
	FDFMR_RRA_FC_AGT_NP_ON				[udtAmount] NOT NULL,
	FDFMR_RRA_FC_AGT_NP_FST_OFF		[udtAmount] NOT NULL,
	FDFMR_RRA_FC_AGT_NP_SEC_OFF		[udtAmount] NOT NULL,
	FDFMR_RRA_FC_AGT_NP_OFF			[udtAmount] NOT NULL,
	FDFMR_RRA_ULT_FC_AGT_NP			[udtAmount] NOT NULL,
	FDFMR_RRA_MT						[udtAmount] NOT NULL,
	FDFMR_RRA_ULT_MT					[udtAmount] NOT NULL,
	FDFMR_RRA_REW						[udtAmount] NOT NULL,
	FDFMR_RRA_ULT_REW					[udtAmount] NOT NULL,
	FDFMR_RRA_RET						[udtAmount] NOT NULL,
	FDFMR_RRA_ULT_RET					[udtAmount] NOT NULL,
	FDFMR_RPC_AMT_FST_ON				[udtAmount] NOT NULL,
	FDFMR_BAS_WRT_PRM_FST_ON			[udtAmount] NOT NULL,
	FDFMR_RPC_RT_AMT_FST_ON			[udtAmount] NOT NULL,
	FDFMR_RPC_AIL_AMT_FST_ON			[udtAmount] NOT NULL,
	FDFMR_RPC_EXPOS_AMT_FST_ON		[udtAmount] NOT NULL,
	FDFMR_RPC_AMT						[udtAmount] NOT NULL,
	FDFMR_BAS_WRT_PRM					[udtAmount] NOT NULL,
	FDFMR_RPC_RT_AMT					[udtAmount] NOT NULL,
	FDFMR_RPC_AIL_AMT					[udtAmount] NOT NULL,
	FDFMR_RPC_EXPOS_AMT				[udtAmount] NOT NULL,
	FDFMR_ANNL_WRT_PRM_AMT_RB			[udtAmount] NOT NULL,
	FDFMR_ANNL_WRT_PRM_AMT_BNB		[udtAmount] NOT NULL,
	FDFMR_ORG_WRT_PRM_AMT				[udtAmount] NOT NULL,
	FDFMR_ACQN_WRT_PRM_AMT			[udtAmount] NOT NULL,
	FDFMR_COMB_WRT_PRM_AMT			[udtAmount] NOT NULL,
	FDFMR_PRR_IN_FRC_AMT				[udtAmount] NOT NULL,
	FDFMR_YR_END_IN_FRC_AMT			[udtAmount] NOT NULL,
	FDFMR_CURR_IN_FRC_AMT				[udtAmount] NOT NULL,
	FDFMR_EARN_PRM_AMT				[udtAmount] NOT NULL,
	FDFMR_CTL_LS_AMT					[udtAmount] NOT NULL,
	FDFMR_PIF_AMT						[udtAmount] NOT NULL,
	FDFMR_LST_USER					[udtUserName] NOT NULL,
	FDFMR_LST_DT_TM					[udtDateTime] NOT NULL,
	FDFMR_CREAT_USER					[udtUserName] NOT NULL,
	FDFMR_CREAT_DT_TM					[udtDateTime] NOT NULL
) ON [FMR_Data]
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FACT_IND_COMB_RTO]') AND type in (N'U'))
DROP TABLE [dbo].[FACT_IND_COMB_RTO]
GO

CREATE TABLE [dbo].[FACT_IND_COMB_RTO](
	[FICR_PK_ID] [dbo].[UdtNumber] IDENTITY(1,1) NOT NULL,
	[FICR_BPM_LN_OF_BUS] [dbo].[UdtLine] NOT NULL,
	[FICR_SHT_NM] [dbo].[UdtName] NOT NULL,
	[FICR_RPT_DESC] [dbo].[UdtName] NOT NULL,
	[FICR_ST_CD] [dbo].[UdtStateCode] NOT NULL,
	[FICR_ST_NM] [dbo].[UdtName] NOT NULL,
	[FICR_CHNL_GRP_NM] [dbo].[UdtChannel] NOT NULL,
	[FICR_RPT_MO] [dbo].[UdtEffYrMon] NOT NULL,
	[FICR_RPT_YR] [dbo].[UdtEffYrMon] NOT NULL,
	[FICR_RPT_YR_MO] [dbo].[UdtEffYrMon] NOT NULL,
	[FICR_TOT_PCT] [dbo].[UdtAmount] NOT NULL,
) ON [FMR_Data]

GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[XTRCT_POL_IN_FRC]') AND type in (N'U'))
DROP TABLE [dbo].[XTRCT_POL_IN_FRC]
GO

CREATE TABLE [dbo].[XTRCT_POL_IN_FRC](
	[XPIF_PK_ID]		[UdtNumber] IDENTITY(1,1) NOT NULL,
	[XPIF_BPM_LN_OF_BUS] [UdtLine] NOT NULL,
	[XPIF_DESC] [UdtName] NOT NULL,
	[XPIF_MO] [UdtEffYrMon] NOT NULL,
	[XPIF_YR] [UdtEffYrMon] NOT NULL,
	[XPIF_YR_MO] [UdtEffYrMon] NOT NULL,
	[XPIF_TOT_AMT] [UdtAmount] NOT NULL,
) ON [FMR_Data]

GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[LOG_MSG_FIN_MGT_RPT]') AND type in (N'U'))
DROP TABLE [dbo].[LOG_MSG_FIN_MGT_RPT]
GO

CREATE TABLE [dbo].[LOG_MSG_FIN_MGT_RPT](
	[LMFMR_PK_ID] [dbo].[udtNumber] IDENTITY(1,1) NOT NULL,
	[LMFMR_OBJ_NM] [dbo].[udtName] NOT NULL,
	[LMFMR_TSK_NM] [dbo].[udtMessage] NOT NULL,
	[LMFMR_STS] [dbo].[udtStatus] NOT NULL,
	[LMFMR_YR_MO] [dbo].[udtEffYrMon] NOT NULL,
	[LMFMR_LST_USER] [dbo].[udtUserName] NOT NULL,
	[LMFMR_LST_DT_TM] [dbo].[udtDateTime] NOT NULL,
	[LMFMR_CREAT_USER] [dbo].[udtUserName] NOT NULL,
	[LMFMR_CREAT_DT_TM] [dbo].[udtDateTime] NOT NULL
) ON [FMR_Data]
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'dbo.STG_TNJ_DATA') AND type in (N'U'))
DROP TABLE dbo.STG_TNJ_DATA
GO

CREATE TABLE dbo.STG_TNJ_DATA(
	STD_PK_ID				udtNumber IDENTITY(1,1) NOT NULL,
	STD_BPM_LN_OF_BUS		udtLine NOT NULL,
	STD_FM					udtForm NOT NULL,
	STD_BPM_SEG_NM			udtSegment NOT NULL,
	STD_BPM_PRDCT_NM		udtProduct NOT NULL,
	STD_CD					udtCode NOT NULL,
	STD_DESC				udtDesc NOT NULL,
	STD_MKT_CD				udtMkt NOT NULL,
	STD_SUB_MKT				udtSubMkt NOT NULL,
	STD_CHNL_GRP_NM			udtChannel NOT NULL,
	STD_SUB_CHNL			udtSubChannel NOT NULL,
	STD_CHNL_NM				udtChannelType NOT NULL,
	STD_ST_CD				udtStateCode NOT NULL,
	STD_ST_NM				udtName NOT NULL,
	STD_CURR_TRM			udtTerm NOT NULL,
	STD_PM_RGN_NM			udtRegion NOT NULL,
	STD_PREV_TRM			udtTerm NOT NULL,
	STD_STRG				udtStrategy NOT NULL,
	STD_AGE					udtAge NOT NULL,
	STD_LOOK				udtLook NOT NULL,
	STD_CYC					udtEffYrMon NOT NULL,
	STD_CURR_YR_DESC		udtYearDescriptive NOT NULL,
	STD_PRR_YR_DESC			udtYearDescriptive NOT NULL,
	STD_YR_END_DESC			udtYearDescriptive NOT NULL,
	STD_EFF_YR_MO			udtEffYrMon NOT NULL,
	STD_EFF_YR				udtEffYrMon NOT NULL,
	STD_EFF_MO				udtEffYrMon NOT NULL,
	STD_FISC_YR				udtFiscalYear NOT NULL,
	STD_ZIP_CD5				udtZipCode NOT NULL,
	STD_ZIP_CD4				udtZipCode NOT NULL,
	STD_LCL_MKT_NM			udtLocalMarket NOT NULL,
	STD_PLN_LCL_MKT_NM		udtLocalMarket NOT NULL,
	STD_RB_BAS udtAmount NOT NULL,
	STD_RB_FC_CO udtAmount NOT NULL,
	STD_RB_REW udtAmount NOT NULL,
	STD_RB_FC_AGT udtAmount NOT NULL,
	STD_RB_FC_NP udtAmount NOT NULL,
	STD_RB_FC_AGT_NP udtAmount NOT NULL,
	STD_RB_AGT_NP_UTL udtAmount NOT NULL,
	STD_RB_MT udtAmount NOT NULL,
	STD_RB_MT_UTL udtAmount NOT NULL,
	STD_RB_RET udtAmount NOT NULL,
	STD_RB_RET_UTL udtAmount NOT NULL,
	STD_NPH_BAS udtAmount NOT NULL,
	STD_NPH_FC_CO udtAmount NOT NULL,
	STD_NPH_REW udtAmount NOT NULL,
	STD_NPH_FC_AGT udtAmount NOT NULL,
	STD_NPH_FC_NP udtAmount NOT NULL,
	STD_NPH_FC_AGT_NP udtAmount NOT NULL,
	STD_NPH_AGT_NP_ULT udtAmount NOT NULL,
	STD_NPH_MT udtAmount NOT NULL,
	STD_NPH_MT_ULT udtAmount NOT NULL,
	STD_NPH_RET udtAmount NOT NULL,
	STD_NPH_RET_ULT udtAmount NOT NULL,
	STD_BNB udtAmount NOT NULL,
	STD_BNB_ULT udtAmount NOT NULL,
	STD_NB_FC_CO udtAmount NOT NULL,
	STD_NB_REW udtAmount NOT NULL,
	STD_NB_FC_AGT udtAmount NOT NULL,
	STD_NB_FC_NP udtAmount NOT NULL,
	STD_NB_FC_AGT_NP udtAmount NOT NULL,
	STD_NB_MT udtAmount NOT NULL,
	STD_NB_AGT_NP_ULT udtAmount NOT NULL,
	STD_NB_MT_ULT udtAmount NOT NULL,
	STD_NB_RET udtAmount NOT NULL,
	STD_NB_RET_ULT udtAmount NOT NULL,
	STD_NB_WRT_PRM udtAmount NOT NULL,
	STD_PRR_WRT_PRM udtAmount NOT NULL,
	STD_RETN_WRT_PRM udtAmount NOT NULL,
	STD_RPC_SEC_ON udtAmount NOT NULL,
	STD_RPC_AIL_SEC_ON udtAmount NOT NULL,
	STD_RPC_RT_SEC_ON udtAmount NOT NULL,
	STD_RPC_EXPOS_SEC_ON udtAmount NOT NULL,
	STD_ACTUL_WRT_PRM udtAmount NOT NULL,
	STD_ARB_POL_CNT udtAmount NOT NULL,
	STD_ARB_POL_CNT_FST_ON udtAmount NOT NULL,
	STD_ARB_POL_CNT_SEC_ON udtAmount NOT NULL,
	STD_ARB_POL_CNT_FST_OFF udtAmount NOT NULL,
	STD_ARB_ULT_POL_CNT_SEC_OFF udtAmount NOT NULL,
	STD_ARB_FC_CO udtAmount NOT NULL,
	STD_ARB_FC_AGT_NP_FST_ON udtAmount NOT NULL,
	STD_ARB_FC_AGT_NP_SEC_ON udtAmount NOT NULL,
	STD_ARB_FC_AGT_NP_ON udtAmount NOT NULL,
	STD_ARB_FC_AGT_NP_FST_OFF udtAmount NOT NULL,
	STD_ARB_FC_AGT_NP_SEC_OFF udtAmount NOT NULL,
	STD_ARB_FC_AGT_NP_OFF udtAmount NOT NULL,
	STD_ARB_ULT_FC_AGT_NP udtAmount NOT NULL,
	STD_ARB_MT udtAmount NOT NULL,
	STD_ARB_ULT_MT udtAmount NOT NULL,
	STD_ARB_RET udtAmount NOT NULL,
	STD_ARB_ULT_RET udtAmount NOT NULL,
	STD_ORA_POL_CNT_FST_ON udtAmount NOT NULL,
	STD_ORA_POL_CNT_SEC_ON udtAmount NOT NULL,
	STD_ORA_POL_CNT_FST_OFF udtAge NOT NULL,
	STD_ORA_POL_CNT_SEC_OFF udtAmount NOT NULL,
	STD_ORA_FC_CO udtAmount NOT NULL,
	STD_ORA_FC_AGT_NP_FST_ON udtAmount NOT NULL,
	STD_ORA_FC_AGT_NP_SEC_ON udtAmount NOT NULL,
	STD_ORA_FC_AGT_NP_ON udtAmount NOT NULL,
	STD_ORA_FC_AGT_NP_FST_OFF udtAmount NOT NULL,
	STD_ORA_FC_AGT_NP_SEC_OFF udtAmount NOT NULL,
	STD_ORA_FC_AGT_NP_OFF udtAmount NOT NULL,
	STD_ORA_ULT_FC_AGT_NP udtAmount NOT NULL,
	STD_ORA_MT udtAmount NOT NULL,
	STD_ORA_ULT_MT udtAmount NOT NULL,
	STD_ORA_REW udtAmount NOT NULL,
	STD_ORA_ULT_REW udtAmount NOT NULL,
	STD_ORA_RET udtAmount NOT NULL,
	STD_ORA_ULT_RET udtAmount NOT NULL,
	STD_BNB_POL_CNT udtAmount NOT NULL,
	STD_BNB_POL_CNT_FST_ON udtAmount NOT NULL,
	STD_BNB_POL_CNT_SEC_ON udtAmount NOT NULL,
	STD_BNB_POL_CNT_FST_OFF udtAmount NOT NULL,
	STD_BNB_POL_CNT_SEC_OFF udtAmount NOT NULL,
	STD_BNB_ULT_POL_CNT udtAmount NOT NULL,
	STD_BNB_FC_CO udtAmount NOT NULL,
	STD_BNB_FC_AGT_NP_FST_ON udtAmount NOT NULL,
	STD_BNB_FC_AGT_NP_SEC_ON udtAmount NOT NULL,
	STD_BNB_FC_AGT_NP_ON udtAmount NOT NULL,
	STD_BNB_FC_AGT_NP_FST_OFF udtAmount NOT NULL,
	STD_BNB_FC_AGT_NP_SEC_OFF udtAmount NOT NULL,
	STD_BNB_FC_AGT_NP_OFF udtAmount NOT NULL,
	STD_BNB_ULT_FC_AGT_NP udtAmount NOT NULL,
	STD_BNB_MT udtAmount NOT NULL,
	STD_BNB_ULT_MT udtAmount NOT NULL,
	STD_BNB_REW udtAmount NOT NULL,
	STD_BNB_ULT_REW udtAmount NOT NULL,
	STD_BNB_RET udtAmount NOT NULL,
	STD_BNB_ULT_RET udtAmount NOT NULL,
	STD_BNB_CH_EFF_DT udtAmount NOT NULL,
	STD_RRA_POL_CNT udtAmount NOT NULL,
	STD_RRA_POL_CNT_FST_ON udtAmount NOT NULL,
	STD_RRA_POL_CNT_SEC_ON udtAmount NOT NULL,
	STD_RRA_POL_CNT_FST_OFF udtAmount NOT NULL,
	STD_RRA_POL_CNT_SEC_OFF udtAmount NOT NULL,
	STD_RRA_FC_CO udtAmount NOT NULL,
	STD_RRA_FC_AGT_NP_FST_ON udtAmount NOT NULL,
	STD_RRA_FC_AGT_NP_SEC_ON udtAmount NOT NULL,
	STD_RRA_FC_AGT_NP_ON udtAmount NOT NULL,
	STD_RRA_FC_AGT_NP_FST_OFF udtAmount NOT NULL,
	STD_RRA_FC_AGT_NP_SEC_OFF udtAmount NOT NULL,
	STD_RRA_FC_AGT_NP_OFF udtAmount NOT NULL,
	STD_RRA_ULT_FC_AGT_NP udtAmount NOT NULL,
	STD_RRA_MT udtAmount NOT NULL,
	STD_RRA_ULT_MT udtAmount NOT NULL,
	STD_RRA_REW udtAmount NOT NULL,
	STD_RRA_ULT_REW udtAmount NOT NULL,
	STD_RRA_RET udtAmount NOT NULL,
	STD_RRA_ULT_RET udtAmount NOT NULL,
	STD_RPC_FST_ON udtAmount NOT NULL,
	STD_RET_FST_ON udtAmount NOT NULL,
	STD_RPC_RT_FST_ON udtAmount NOT NULL,
	STD_RPC_AIL_FST_ON udtAmount NOT NULL,
	STD_RPC_EXPOS_FST_ON udtAmount NOT NULL,
	STD_RPC udtAmount NOT NULL,
	STD_RET udtAmount NOT NULL,
	STD_RPC_RT udtAmount NOT NULL,
	STD_RPC_AIL udtAmount NOT NULL,
	STD_RPC_EXPOS udtAmount NOT NULL,
	STD_ANNL_WRT_PRM_RB udtAmount NOT NULL,
	STD_ANNL_WRT_PRM_BNB udtAmount NOT NULL,
	STD_ORG_WRT_PRM		udtAmount NOT NULL,
	STD_ACQN_WRT_PRM udtAmount NOT NULL,
	STD_COMB_WRT_PRM	udtAmount NOT NULL,
	STD_PRR_IN_FRC		udtAmount NOT NULL,
	STD_YR_END_IN_FRC	udtAmount NOT NULL,
	STD_LST_USER			udtUserName NOT NULL,
	STD_LST_DT_TM			udtDateTime NOT NULL,
	STD_CREAT_USER			udtUserName NOT NULL,
	STD_CREAT_DT_TM			udtDateTime NOT NULL
) ON FMR_Data
GO


IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[STG_WRT_PRDCT_MO_RPT]') AND type in (N'U'))
DROP TABLE [dbo].[STG_WRT_PRDCT_MO_RPT]
GO

CREATE TABLE [dbo].[STG_WRT_PRDCT_MO_RPT](
	SWPMR_PK_ID				[udtNumber] IDENTITY(1,1) NOT NULL,
	SWPMR_BPM_LN_OF_BUS		[udtLine] NOT NULL,
	SWPMR_BPM_SEG_NM			[udtSegment] NOT NULL,
	SWPMR_BPM_PRDCT_NM		[udtProduct] NOT NULL,
	SWPMR_RT_PLN_GRP_NM		[udtRatePlan] NOT NULL,
	SWPMR_TRM					[udtTerm] NOT NULL,
	SWPMR_CHNL_GRP_NM			[udtChannel] NOT NULL,
	SWPMR_CHNL_NM				[udtChannelType] NOT NULL,
	SWPMR_SUB_CHNL			[udtSubChannel] NOT NULL,
	SWPMR_PM_RGN_NM			[udtRegion] NOT NULL,
	SWPMR_ST_CD				[udtStateCode] NOT NULL,
	SWPMR_ST_NM				[udtName] NOT NULL,
	SWPMR_SPC				[udtSpectrum] NOT NULL,
	SWPMR_STRG				[udtStrategy] NOT NULL,
	SWPMR_EFF_YR				[udtEffYrMon] NOT NULL,
	SWPMR_EFF_MO				[udtEffYrMon] NOT NULL,
	SWPMR_EFF_YR_MO			[udtEffYrMon] NOT NULL,
	SWPMR_FISC_YR				[udtFiscalYear] NOT NULL,
	SWPMR_ARB_ULT_POL_CNT		[udtAmount] NOT NULL,
	SWPMR_ARB_POL_CNT			[udtAmount] NOT NULL,
	SWPMR_ARB_POL_CNT_FST_ON	[udtAmount] NOT NULL,
	SWPMR_ARB_POL_CNT_SEC_ON	[udtAmount] NOT NULL,
	SWPMR_ARB_POL_CNT_FST_OFF		[udtAmount] NOT NULL,
	SWPMR_ARB_ULT_POL_CNT_SEC_OFF [udtAmount] NOT NULL,
	SWPMR_ARB_FC_CO_FST_ON	[udtAmount] NOT NULL,
	SWPMR_ARB_FC_CO_SEC_ON	[udtAmount] NOT NULL,
	SWPMR_ARB_FC_CO_FST_OFF	[udtAmount] NOT NULL,
	SWPMR_ARB_FC_CO_SEC_OFF	[udtAmount] NOT NULL,
	SWPMR_ARB_FC_AGT_NP_FST_ON [udtAmount] NOT NULL,
	SWPMR_ARB_FC_AGT_NP_SEC_ON [udtAmount] NOT NULL,
	SWPMR_ARB_FC_AGT_NP_FST_OFF [udtAmount] NOT NULL,
	SWPMR_ARB_FC_AGT_NP_SEC_OFF [udtAmount] NOT NULL,
	SWPMR_ORA_POL_CNT_FST_ON	[udtAmount] NOT NULL,
	SWPMR_ORA_POL_CNT_SEC_ON	[udtAmount] NOT NULL,
	SWPMR_ORA_POL_CNT_FST_OFF [udtAmount] NOT NULL,
	SWPMR_ORA_POL_CNT_SEC_OFF [udtAmount] NOT NULL,
	SWPMR_ORA_FC_CO_FST_ON	[udtAmount] NOT NULL,
	SWPMR_ORA_FC_CO_SEC_ON	[udtAmount] NOT NULL,
	SWPMR_ORA_FC_CO_FST_OFF	[udtAmount] NOT NULL,
	SWPMR_ORA_FC_CO_SEC_OFF	[udtAmount] NOT NULL,
	SWPMR_ORA_FC_AGT_NP_FST_ON [udtAmount] NOT NULL,
	SWPMR_ORA_FC_AGT_NP_SEC_ON [udtAmount] NOT NULL,
	SWPMR_ORA_FC_AGT_NP_FST_OFF [udtAmount] NOT NULL,
	SWPMR_ORA_FC_AGT_NP_SEC_OFF [udtAmount] NOT NULL,
	SWPMR_BNB_POL_CNT_FST_ON	[udtAmount] NOT NULL,
	SWPMR_BNB_POL_CNT_SEC_ON	[udtAmount] NOT NULL,
	SWPMR_BNB_POL_CNT_FST_OFF [udtAmount] NOT NULL,
	SWPMR_BNB_POL_CNT_SEC_OFF [udtAmount] NOT NULL,
	SWPMR_BNB_FC_CO_FST_ON	[udtAmount] NOT NULL,
	SWPMR_BNB_FC_CO_SEC_ON	[udtAmount] NOT NULL,
	SWPMR_BNB_FC_CO_FST_OFF	[udtAmount] NOT NULL,
	SWPMR_BNB_FC_CO_SEC_OFF	[udtAmount] NOT NULL,
	SWPMR_BNB_FC_AGT_NP_FST_ON [udtAmount] NOT NULL,
	SWPMR_BNB_FC_AGT_NP_SEC_ON [udtAmount] NOT NULL,
	SWPMR_BNB_FC_AGT_NP_FST_OFF [udtAmount] NOT NULL,
	SWPMR_BNB_FC_AGT_NP_SEC_OFF [udtAmount] NOT NULL,
	SWPMR_RRA_POL_CNT_FST_ON	[udtAmount] NOT NULL,
	SWPMR_RRA_POL_CNT_SEC_ON	[udtAmount] NOT NULL,
	SWPMR_RRA_POL_CNT_FST_OFF [udtAmount] NOT NULL,
	SWPMR_RRA_POL_CNT_SEC_OFF [udtAmount] NOT NULL,
	SWPMR_RRA_FC_CO_FST_ON	[udtAmount] NOT NULL,
	SWPMR_RRA_FC_CO_SEC_ON	[udtAmount] NOT NULL,
	SWPMR_RRA_FC_CO_FST_OFF	[udtAmount] NOT NULL,
	SWPMR_RRA_FC_CO_SEC_OFF	[udtAmount] NOT NULL,
	SWPMR_RRA_FC_AGT_NP_FST_ON [udtAmount] NOT NULL,
	SWPMR_RRA_FC_AGT_NP_SEC_ON [udtAmount] NOT NULL,
	SWPMR_RRA_FC_AGT_NP_FST_OFF [udtAmount] NOT NULL,
	SWPMR_RRA_FC_AGT_NP_SEC_OFF [udtAmount] NOT NULL,
	SWPMR_BAS_WRT_PRM_FST_ON	[udtAmount] NOT NULL,
	SWPMR_RPC_AMT_FST_ON		[udtAmount] NOT NULL,
	SWPMR_RPC_RT_AMT_FST_ON	[udtAmount] NOT NULL,
	SWPMR_RPC_AIL_AMT_FST_ON	[udtAmount] NOT NULL,
	SWPMR_RPC_EXPOS_AMT_FST_ON [udtAmount] NOT NULL,
	SWPMR_ARB_FC_CO			[udtAmount] NOT NULL,
	SWPMR_ARB_ULT_FC_CO		[udtAmount] NOT NULL,
	SWPMR_ARB_FC_AGT_NP_ON		[udtAmount] NOT NULL,
	SWPMR_ARB_FC_AGT_NP_OFF	[udtAmount] NOT NULL,
	SWPMR_ARB_ULT_FC_AGT_NP	[udtAmount] NOT NULL,
	SWPMR_ARB_MT				[udtAmount] NOT NULL,
	SWPMR_ARB_ULT_MT			[udtAmount] NOT NULL,
	SWPMR_ARB_RET				[udtAmount] NOT NULL,
	SWPMR_ARB_ULT_RET			[udtAmount] NOT NULL,
	SWPMR_ORA_POL_CNT			[udtAmount] NOT NULL,
	SWPMR_ORA_ULT_POL_CNT		[udtAmount] NOT NULL,
	SWPMR_ORA_FC_CO			[udtAmount] NOT NULL,
	SWPMR_ORA_ULT_FC_CO		[udtAmount] NOT NULL,
	SWPMR_ORA_FC_AGT_NP_ON		[udtAmount] NOT NULL,
	SWPMR_ORA_FC_AGT_NP_OFF	[udtAmount] NOT NULL,
	SWPMR_ORA_ULT_FC_AGT_NP	[udtAmount] NOT NULL,
	SWPMR_ORA_MT				[udtAmount] NOT NULL,
	SWPMR_ORA_ULT_MT			[udtAmount] NOT NULL,
	SWPMR_ORA_REW				[udtAmount] NOT NULL,
	SWPMR_ORA_ULT_REW			[udtAmount] NOT NULL,
	SWPMR_ORA_RET				[udtAmount] NOT NULL,
	SWPMR_ORA_ULT_RET			[udtAmount] NOT NULL,
	SWPMR_BNB_POL_CNT			[udtAmount] NOT NULL,
	SWPMR_BNB_ULT_POL_CNT		[udtAmount] NOT NULL,
	SWPMR_BNB_FC_CO			[udtAmount] NOT NULL,
	SWPMR_BNB_ULT_FC_CO		[udtAmount] NOT NULL,
	SWPMR_BNB_FC_AGT_NP_ON		[udtAmount] NOT NULL,
	SWPMR_BNB_FC_AGT_NP_OFF	[udtAmount] NOT NULL,
	SWPMR_BNB_ULT_FC_AGT_NP	[udtAmount] NOT NULL,
	SWPMR_BNB_MT				[udtAmount] NOT NULL,
	SWPMR_BNB_ULT_MT			[udtAmount] NOT NULL,
	SWPMR_BNB_REW				[udtAmount] NOT NULL,
	SWPMR_BNB_ULT_REW			[udtAmount] NOT NULL,
	SWPMR_BNB_RET				[udtAmount] NOT NULL,
	SWPMR_BNB_ULT_RET			[udtAmount] NOT NULL,
	SWPMR_RRA_POL_CNT			[udtAmount] NOT NULL,
	SWPMR_RRA_ULT_POL_CNT		[udtAmount] NOT NULL,
	SWPMR_RRA_FC_CO			[udtAmount] NOT NULL,
	SWPMR_RRA_ULT_FC_CO		[udtAmount] NOT NULL,
	SWPMR_RRA_FC_AGT_NP_ON		[udtAmount] NOT NULL,
	SWPMR_RRA_FC_AGT_NP_OFF	[udtAmount] NOT NULL,
	SWPMR_RRA_MT				[udtAmount] NOT NULL,
	SWPMR_RRA_ULT_MT			[udtAmount] NOT NULL,
	SWPMR_RRA_REW				[udtAmount] NOT NULL,
	SWPMR_RRA_ULT_REW			[udtAmount] NOT NULL,
	SWPMR_RRA_RET				[udtAmount] NOT NULL,
	SWPMR_RRA_ULT_RET			[udtAmount] NOT NULL,
	SWPMR_RRA_ULT_FC_AGT_NP	[udtAmount] NOT NULL,
	SWPMR_BAS_WRT_PRM			[udtAmount] NOT NULL,
	SWPMR_RPC_AMT				[udtAmount] NOT NULL,
	SWPMR_RPC_RT_AMT			[udtAmount] NOT NULL,
	SWPMR_RPC_AIL_AMT			[udtAmount] NOT NULL,
	SWPMR_RPC_EXPOS_AMT		[udtAmount] NOT NULL,
	SWPMR_ANNL_WRT_PRM_AMT_RB [udtAmount] NOT NULL,
	SWPMR_ANNL_WRT_PRM_AMT_BNB [udtAmount] NOT NULL,
	SWPMR_ORG_WRT_PRM_AMT		[udtAmount] NOT NULL,
	SWPMR_ACQN_WRT_PRM_AMT	[udtAmount] NOT NULL,
	SWPMR_COMB_WRT_PRM_AMT	[udtAmount] NOT NULL,
	SWPMR_CURR_IN_FRC_AMT		[udtAmount] NOT NULL,
	SWPMR_PRR_IN_FRC_AMT		[udtAmount] NOT NULL,
	SWPMR_YR_END_IN_FRC_AMT	[udtAmount] NOT NULL,
	SWPMR_LST_USER			[udtUserName] NOT NULL,
	SWPMR_LST_DT_TM			[udtDateTime] NOT NULL,
	SWPMR_CREAT_USER			[udtUserName] NOT NULL,
	SWPMR_CREAT_DT_TM			[udtDateTime] NOT NULL
) ON [FMR_Data]
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[USER_MSTR_SESS]') AND type in (N'U'))
DROP TABLE [dbo].[USER_MSTR_SESS]
GO

CREATE TABLE [dbo].[USER_MSTR_SESS](
	[UMS_PK_ID] [dbo].[udtInteger] NOT NULL,
	[UMS_CD] [dbo].[udtCode] NOT NULL,
	[UMS_NM] [dbo].[udtName] NOT NULL,
	[UMS_DOM_NM] [dbo].[udtName] NOT NULL,
	[UMS_MACH_NM] [dbo].[udtName] NOT NULL,
	[UMS_ENAB_IND] [dbo].[udtYesNo] NOT NULL,
	[UMS_LST_USER] [dbo].[udtUserName] NOT NULL,
	[UMS_LST_DT_TM] [dbo].[udtDateTime] NOT NULL,
	[UMS_CREAT_USER] [dbo].[udtUserName] NOT NULL,
	[UMS_CREAT_DT_TM] [dbo].[udtDateTime] NOT NULL
) ON [FMR_Data]
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[XTRCT_CURR_MO_CTL_RPT]') AND type in (N'U'))
DROP TABLE [dbo].[XTRCT_CURR_MO_CTL_RPT]
GO

CREATE TABLE [dbo].[XTRCT_CURR_MO_CTL_RPT](
	XCMCR_EVAL_PERD_KEY [udtEffYrMon] NOT NULL,
	XCMCR_BPM_LN_OF_BUS [udtLine] NOT NULL,
	XCMCR_ST_CD [udtStateCode] NOT NULL,
	XCMCR_ARB_ULT_POL_CNT [udtAmount] NOT NULL,
	XCMCR_ARB_ULT_RET [udtAmount] NOT NULL,
	XCMCR_ORA_ULT_RET [udtAmount] NOT NULL,
	XCMCR_BNB_POL_CNT [udtAmount] NOT NULL,
	XCMCR_BNB_ULT_RET [udtAmount] NOT NULL,
	XCMCR_RRA_ULT_RET [udtAmount] NOT NULL,
	XCMCR_RETN_WRT_PRM [udtAmount] NOT NULL,
	XCMCR_RPC_AMT [udtAmount] NOT NULL
) ON [FMR_Data]
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[XTRCT_TNJ_CURR]') AND type in (N'U'))
DROP TABLE [dbo].[XTRCT_TNJ_CURR]
GO

CREATE TABLE [dbo].[XTRCT_TNJ_CURR](
	XTC_FM [udtForm] NULL,
	XTC_MKT_CD [udtMkt] NULL,
	XTC_SUB_MKT [udtSubMkt] NULL,
	XTC_ST_CD [udtStateCode] NULL,
	XTC_CURR_TRM [udtTerm] NULL,
	XTC_PREV_TRM [varchar](50) NULL,
	XTC_AGE [udtAge] NULL,
	XTC_CYC  [udtEffYrMon] NULL,
	XTC_EFF_YR_MO [udtEffYrMon] NULL,
	XTC_ZIP_CD5 [udtZipCode] NULL,
	XTC_ZIP_CD4 [udtZipCode] NULL,
	XTC_RB_BAS_AMT [udtAmount] NULL,
	XTC_RB_FC_CO_AMT [udtAmount] NULL,
	XTC_RB_REW_AMT [udtAmount] NULL,
	XTC_RB_FC_AGT_AMT [udtAmount] NULL,
	XTC_RB_FC_NP_AMT [udtAmount] NULL,
	XTC_RB_MT_AMT [udtAmount] NULL,
	XTC_NPH_BAS_AMT [udtAmount] NULL,
	XTC_NPH_FC_CO_AMT [udtAmount] NULL,
	XTC_NPH_REW_AMT [udtAmount] NULL,
	XTC_NPH_FC_AGT_AMT [udtAmount] NULL,
	XTC_NPH_FC_NP_AMT [udtAmount] NULL,
	XTC_NPH_MT_AMT [udtAmount] NULL,
	XTC_BNB_AMT [udtAmount] NULL,
	XTC_NB_FC_CO_AMT [udtAmount] NULL,
	XTC_NB_REW_AMT [udtAmount] NULL,
	XTC_NB_FC_AGT_AMT [udtAmount] NULL,
	XTC_NB_FC_NP_AMT [udtAmount] NULL,
	XTC_NB_MT_AMT [udtAmount] NULL,
	XTC_NB_WRT_PRM_AMT [udtAmount] NULL,
	XTC_PRR_WRT_PRM_AMT [udtAmount] NULL,
	XTC_RETN_WRT_PRM_AMT [udtAmount] NULL,
	XTC_RPC_AMT [udtAmount] NULL,
	XTC_RPC_AIL_AMT [udtAmount] NULL,
	XTC_RPC_RT_AMT [udtAmount] NULL,
	XTC_RPC_EXPOS_AMT [udtAmount] NULL,
	XTC_ACTUL_WRT_PRM_AMT [udtAmount] NULL
) ON [FMR_Data]

GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[XTRCT_TNJ_HS]') AND type in (N'U'))
DROP TABLE [dbo].[XTRCT_TNJ_HS]
GO

CREATE TABLE [dbo].[XTRCT_TNJ_HS](
	XTH_FM [udtForm] NULL,
	XTH_MKT_CD [udtMkt] NULL,
	XTH_SUB_MKT [udtSubMkt] NULL,
	XTH_ST_CD [udtStateCode] NULL,
	XTH_CURR_TRM [udtTerm] NULL,
	XTH_PREV_TRM [varchar](50) NULL,
	XTH_AGE [udtAge] NULL,
	XTH_CYC  [udtEffYrMon] NULL,
	XTH_EFF_YR_MO [udtEffYrMon] NULL,
	XTH_RB_BAS_AMT [udtAmount] NULL,
	XTH_RB_FC_CO_AMT [udtAmount] NULL,
	XTH_RB_REW_AMT [udtAmount] NULL,
	XTH_RB_FC_AGT_AMT [udtAmount] NULL,
	XTH_RB_FC_NP_AMT [udtAmount] NULL,
	XTH_RB_MT_AMT [udtAmount] NULL,
	XTH_NPH_BAS_AMT [udtAmount] NULL,
	XTH_NPH_FC_CO_AMT [udtAmount] NULL,
	XTH_NPH_REW_AMT [udtAmount] NULL,
	XTH_NPH_FC_AGT_AMT [udtAmount] NULL,
	XTH_NPH_FC_NP_AMT [udtAmount] NULL,
	XTH_NPH_MT_AMT [udtAmount] NULL,
	XTH_BNB_AMT [udtAmount] NULL,
	XTH_NB_FC_CO_AMT [udtAmount] NULL,
	XTH_NB_REW_AMT [udtAmount] NULL,
	XTH_NB_FC_AGT_AMT [udtAmount] NULL,
	XTH_NB_FC_NP_AMT [udtAmount] NULL,
	XTH_NB_MT_AMT [udtAmount] NULL,
	XTH_NB_WRT_PRM_AMT [udtAmount] NULL,
	XTH_PRR_WRT_PRM_AMT [udtAmount] NULL,
	XTH_RETN_WRT_PRM_AMT [udtAmount] NULL,
	XTH_RPC_AMT [udtAmount] NULL,
	XTH_RPC_AIL_AMT [udtAmount] NULL,
	XTH_RPC_RT_AMT [udtAmount] NULL,
	XTH_RPC_EXPOS_AMT [udtAmount] NULL,
	XTH_ACTUL_WRT_PRM_AMT [udtAmount] NULL
) ON [FMR_Data]
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[XTRCT_MKT_PRDCT_LCL_MKT_RGN]') AND type in (N'U'))
DROP TABLE [dbo].[XTRCT_MKT_PRDCT_LCL_MKT_RGN]
GO

CREATE TABLE [dbo].[XTRCT_MKT_PRDCT_LCL_MKT_RGN](
	XMPLMR_EVAL_PERD_KEY			[UdtNumber] NULL,
	XMPLMR_EFF_PERD_YR			[UdtEffYrMon] NULL,
	XMPLMR_RGN_NM				[UdtChannel] NULL,
	XMPLMR_SRC_CD				[UdtName]	NULL,
	XMPLMR_LOC_GRP_CD			[UdtCode]	NULL,
	XMPLMR_CHNL_GRP_NM			[UdtChannel] NULL,
	XMPLMR_CHNL_NM				[UdtChannelType] NULL,
	XMPLMR_RT_ST_CD				[UdtCode] NULL,
	XMPLMR_LCL_MKT_NM			[UdtLocalMarket] NULL,
	XMPLMR_BPM_LN_OF_BUS			[UdtLine] NULL,
	XMPLMR_BPM_SEG_NM			[UdtSegment] NULL,
	XMPLMR_BPM_PRDCT_NM			[UdtProduct] NULL,
	XMPLMR_BPM_SBPRDCT_NM		[UdtSubProduct] NULL,
	XMPLMR_RT_PLN_GRP_NM			[UdtRatePlan] NULL,
	XMPLMR_CTL_LS_AMT			[UdtAmount] NULL,
	XMPLMR_RSK_LOAD_AMT			[UdtAmount] NULL,
	XMPLMR_EARN_COMM_AMT			[UdtAmount] NULL,
	XMPLMR_CNTNGY_COMM_AMT		[UdtAmount] NULL,
	XMPLMR_COMM_OVRIDE_AMT		[UdtAmount] NULL,
	XMPLMR_ULAE_AMT				[UdtAmount] NULL,
	XMPLMR_PRM_TAX_AMT			[UdtAmount] NULL,
	XMPLMR_DIR_SALRY_BEN_AMT		[UdtAmount] NULL,
	XMPLMR_DIR_TRAV_RENT_AMT		[UdtAmount] NULL,
	XMPLMR_DIR_OTH_EXPN_AMT		[UdtAmount] NULL,
	XMPLMR_CCC_EXPN_AMT			[UdtAmount] NULL,
	XMPLMR_OIE_AMT				[UdtAmount] NULL,
	XMPLMR_DCS_WRIT_OFF_AMT		[UdtAmount] NULL,
	XMPLMR_FLOD_SRVC_FEE			[UdtAmount] NULL,
	XMPLMR_CCC_REV_AMT			[UdtAmount] NULL,
	XMPLMR_INSTL_FEE				[UdtAmount] NULL,
	XMPLMR_EARN_PRM_AMT			[UdtAmount] NULL
) ON [FMR_Data]
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[XTRCT_PREV_MO_CTL_RPT]') AND type in (N'U'))
DROP TABLE [dbo].[XTRCT_PREV_MO_CTL_RPT]
GO

CREATE TABLE [dbo].[XTRCT_PREV_MO_CTL_RPT](
	XPMCR_EVAL_PERD_KEY [udtEffYrMon] NOT NULL,
	XPMCR_BPM_LN_OF_BUS [udtLine] NOT NULL,
	XPMCR_ST_CD [udtStateCode] NOT NULL,
	XPMCR_ARB_ULT_POL_CNT [udtAmount] NOT NULL,
	XPMCR_ARB_ULT_RET [udtAmount] NOT NULL,
	XPMCR_ORA_ULT_RET [udtAmount] NOT NULL,
	XPMCR_BNB_POL_CNT [udtAmount] NOT NULL,
	XPMCR_BNB_ULT_RET [udtAmount] NOT NULL,
	XPMCR_RRA_ULT_RET [udtAmount] NOT NULL,
	XPMCR_RETN_WRT_PRM [udtAmount] NOT NULL,
	XPMCR_RPC_AMT [udtAmount] NOT NULL
) ON [FMR_Data]
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[XTRCT_WRT_PRDCT_MO_RPT]') AND type in (N'U'))
DROP TABLE [dbo].[XTRCT_WRT_PRDCT_MO_RPT]
GO

CREATE TABLE [dbo].[XTRCT_WRT_PRDCT_MO_RPT](
	XWPMR_EVAL_PERD_KEY [UdtNumber] NULL,
	XWPMR_BPM_LN_OF_BUS [UdtLine] NULL,
	XWPMR_BPM_SEG_NM [UdtSegment] NULL,
	XWPMR_BPM_PRDCT_NM [UdtProduct] NULL,
	XWPMR_RT_PLN_GRP_NM [UdtRatePlan] NULL,
	XWPMR_TRM [UdtTerm] NULL,
	XWPMR_CHNL_GRP_NM [UdtChannel] NULL,
	XWPMR_CHNL_NM [UdtChannelType] NULL,
	XWPMR_SUB_CHNL [UdtSubChannel] NULL,
	XWPMR_PM_RGN_NM [UdtRegion] NULL,
	XWPMR_ST_CD [UdtStateCode] NULL,
	XWPMR_ST_NM [UdtName] NULL,
	XWPMR_EFF_YR [UdtEffYrMon] NULL,
	XWPMR_EFF_MO [UdtEffYrMon] NULL,
	XWPMR_AGE	[UdtAge] NULL,
	XWPMR_YACHT_SPCL [nvarchar](50) NULL,
	XWPMR_ARB_POL_CNT [UdtAmount] NULL,
	XWPMR_ARB_FC_CO [UdtAmount] NULL,
	XWPMR_ARB_FC_CO_ON [UdtAmount] NULL,
	XWPMR_ARB_FC_CO_OFF [UdtAmount] NULL,
	XWPMR_ARB_FC_AGT [UdtAmount] NULL,
	XWPMR_ARB_FC_AGT_ON [UdtAmount] NULL,
	XWPMR_ARB_FC_AGT_OFF [UdtAmount] NULL,
	XWPMR_ARB_FC_NP [UdtAmount] NULL,
	XWPMR_ARB_FC_NP_ON [UdtAmount] NULL,
	XWPMR_ARB_FC_NP_OFF [UdtAmount] NULL,
	XWPMR_ARB_FC_AGT_NP [UdtAmount] NULL,
	XWPMR_ARB_FC_AGT_NP_ON [UdtAmount] NULL,
	XWPMR_ARB_FC_AGT_NP_OFF [UdtAmount] NULL,
	XWPMR_ARB_MT [UdtAmount] NULL,
	XWPMR_ARB_RET [UdtAmount] NULL,
	XWPMR_ARB_ULT_POL_CNT [UdtAmount] NULL,
	XWPMR_ARB_ULT_FC_CO [UdtAmount] NULL,
	XWPMR_ARB_ULT_FC_AGT_NP [UdtAmount] NULL,
	XWPMR_ARB_ULT_MT [UdtAmount] NULL,
	XWPMR_ARB_ULT_RET [UdtAmount] NULL,
	XWPMR_ORA_POL_CNT [UdtAmount] NULL,
	XWPMR_ORA_FC_CO [UdtAmount] NULL,
	XWPMR_ORA_FC_CO_ON [UdtAmount] NULL,
	XWPMR_ORA_FC_CO_OFF [UdtAmount] NULL,
	XWPMR_ORA_FC_AGT [UdtAmount] NULL,
	XWPMR_ORA_FC_AGT_ON [UdtAmount] NULL,
	XWPMR_ORA_FC_AGT_OFF [UdtAmount] NULL,
	XWPMR_ORA_FC_NP [UdtAmount] NULL,
	XWPMR_ORA_FC_NP_ON [UdtAmount] NULL,
	XWPMR_ORA_FC_NP_OFF [UdtAmount] NULL,
	XWPMR_ORA_FC_AGT_NP [UdtAmount] NULL,
	XWPMR_ORA_FC_AGT_NP_ON [UdtAmount] NULL,
	XWPMR_ORA_FC_AGT_NP_OFF [UdtAmount] NULL,
	XWPMR_ORA_MT [UdtAmount] NULL,
	XWPMR_ORA_MT_CO [UdtAmount] NULL,
	XWPMR_ORA_MT_AGT [UdtAmount] NULL,
	XWPMR_ORA_MT_NP [UdtAmount] NULL,
	XWPMR_ORA_REW [UdtAmount] NULL,
	XWPMR_ORA_REW_FLT [UdtAmount] NULL,
	XWPMR_ORA_REW_MT [UdtAmount] NULL,
	XWPMR_ORA_RET [UdtAmount] NULL,
	XWPMR_ORA_ULT_POL_CNT [UdtAmount] NULL,
	XWPMR_ORA_ULT_FC_CO [UdtAmount] NULL,
	XWPMR_ORA_ULT_FC_AGT_NP [UdtAmount] NULL,
	XWPMR_ORA_ULT_MT [UdtAmount] NULL,
	XWPMR_ORA_ULT_REW [UdtAmount] NULL,
	XWPMR_ORA_ULT_RET [UdtAmount] NULL,
	XWPMR_BNB_POL_CNT [UdtAmount] NULL,
	XWPMR_BNB_FC_CO [UdtAmount] NULL,
	XWPMR_BNB_FC_CO_ON [UdtAmount] NULL,
	XWPMR_BNB_FC_CO_OFF [UdtAmount] NULL,
	XWPMR_BNB_FC_AGT [UdtAmount] NULL,
	XWPMR_BNB_FC_AGT_ON [UdtAmount] NULL,
	XWPMR_BNB_FC_AGT_OFF [UdtAmount] NULL,
	XWPMR_BNB_FC_NP [UdtAmount] NULL,
	XWPMR_BNB_FC_NP_ON [UdtAmount] NULL,
	XWPMR_BNB_FC_NP_OFF [UdtAmount] NULL,
	XWPMR_BNB_FC_AGT_NP [UdtAmount] NULL,
	XWPMR_BNB_FC_AGT_NP_ON [UdtAmount] NULL,
	XWPMR_BNB_FC_AGT_NP_OFF [UdtAmount] NULL,
	XWPMR_BNB_MT [UdtAmount] NULL,
	XWPMR_BNB_MT_CO [UdtAmount] NULL,
	XWPMR_BNB_MT_AGT [UdtAmount] NULL,
	XWPMR_BNB_MT_NP [UdtAmount] NULL,
	XWPMR_BNB_REW [UdtAmount] NULL,
	XWPMR_BNB_REW_FLT [UdtAmount] NULL,
	XWPMR_BNB_REW_MT [UdtAmount] NULL,
	XWPMR_BNB_RET [UdtAmount] NULL,
	XWPMR_BNB_ULT_POL_CNT [UdtAmount] NULL,
	XWPMR_BNB_ULT_FC_CO [UdtAmount] NULL,
	XWPMR_BNB_ULT_FC_AGT_NP [UdtAmount] NULL,
	XWPMR_BNB_ULT_MT [UdtAmount] NULL,
	XWPMR_BNB_ULT_REW [UdtAmount] NULL,
	XWPMR_BNB_ULT_RET [UdtAmount] NULL,
	XWPMR_RRA_POL_CNT [UdtAmount] NULL,
	XWPMR_RRA_FC_CO [UdtAmount] NULL,
	XWPMR_RRA_FC_CO_ON [UdtAmount] NULL,
	XWPMR_RRA_FC_CO_OFF [UdtAmount] NULL,
	XWPMR_RRA_FC_AGT [UdtAmount] NULL,
	XWPMR_RRA_FC_AGT_ON [UdtAmount] NULL,
	XWPMR_RRA_FC_AGT_OFF [UdtAmount] NULL,
	XWPMR_RRA_FC_NP [UdtAmount] NULL,
	XWPMR_RRA_FC_NP_ON [UdtAmount] NULL,
	XWPMR_RRA_FC_NP_OFF [UdtAmount] NULL,
	XWPMR_RRA_FC_AGT_NP [UdtAmount] NULL,
	XWPMR_RRA_FC_AGT_NP_ON [UdtAmount] NULL,
	XWPMR_RRA_FC_AGT_NP_OFF [UdtAmount] NULL,
	XWPMR_RRA_MT [UdtAmount] NULL,
	XWPMR_RRA_MT_CO [UdtAmount] NULL,
	XWPMR_RRA_MT_AGT [UdtAmount] NULL,
	XWPMR_RRA_MT_NP [UdtAmount] NULL,
	XWPMR_RRA_REW [UdtAmount] NULL,
	XWPMR_RRA_REW_FLT [UdtAmount] NULL,
	XWPMR_RRA_REW_MT [UdtAmount] NULL,
	XWPMR_RRA_RET [UdtAmount] NULL,
	XWPMR_RRA_ULT_POL_CNT [UdtAmount] NULL,
	XWPMR_RRA_ULT_FC_CO [UdtAmount] NULL,
	XWPMR_RRA_ULT_FC_AGT_NP [UdtAmount] NULL,
	XWPMR_RRA_ULT_MT [UdtAmount] NULL,
	XWPMR_RRA_ULT_REW [UdtAmount] NULL,
	XWPMR_RRA_ULT_RET [UdtAmount] NULL,
	XWPMR_WRT_PRM_AMT [UdtAmount] NULL,
	XWPMR_ANNL_WRT_PRM_AMT_RB [UdtAmount] NULL,
	XWPMR_ANNL_WRT_PRM_AMT_BNB [UdtAmount] NULL,
	XWPMR_ANNL_WRT_PRM_AMT_RRA [UdtAmount] NULL,
	XWPMR_BAS_WRT_PRM [UdtAmount] NULL,
	XWPMR_RETN_WRT_PRM [UdtAmount] NULL,
	XWPMR_RPC_AMT [UdtAmount] NULL,
	XWPMR_RPC_AIL_AMT [UdtAmount] NULL,
	XWPMR_RPC_RT_AMT [UdtAmount] NULL,
	XWPMR_RPC_EXPOS_AMT [UdtAmount] NULL
) ON [FMR_Data]
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CNFG_MSTR_HOL]') AND type in (N'U'))
DROP TABLE [dbo].[CNFG_MSTR_HOL]
GO

CREATE TABLE [dbo].[CNFG_MSTR_HOL](
	[CMH_PK_ID]			[udtInteger]	NOT NULL,
	[CMH_DT]			[udtDateTime]	NOT NULL,
	[CMH_DESC]			[udtName]		NOT NULL,
	[CMH_LST_USER]		[udtUserName]	NOT NULL,
	[CMH_LST_DT_TM]		[udtDateTime]	NOT NULL,
	[CMH_CREAT_USER]		[udtUserName]	NOT NULL,
	[CMH_CREAT_DT_TM]		[udtDateTime]	NOT NULL
) ON [FMR_Data]
GO

PRINT '======= FMR User Table Creation Complete ========'
PRINT ''

IF EXISTS (SELECT * FROM sys.sysconstraints WHERE constid = OBJECT_ID(N'UNCPK_ARCHV_DTL_FIN_MGT_RPT') AND id = OBJECT_ID(N'[dbo].[ARCHV_DTL_FIN_MGT_RPT]'))
ALTER TABLE [dbo].[ARCHV_DTL_FIN_MGT_RPT] DROP CONSTRAINT UNCPK_ARCHV_DTL_FIN_MGT_RPT
GO

ALTER TABLE [dbo].[ARCHV_DTL_FIN_MGT_RPT]  ADD 
CONSTRAINT [UNCPK_ARCHV_DTL_FIN_MGT_RPT] PRIMARY KEY NONCLUSTERED 
(
	[ADFMR_PK_ID] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF, FILLFACTOR = 90) ON [FMR_Data]
GO

IF EXISTS (SELECT * FROM sys.sysconstraints WHERE constid = OBJECT_ID(N'UNCPK_ARCHV_IND_COMB_RTO') AND id = OBJECT_ID(N'[dbo].[ARCHV_IND_COMB_RTO]'))
ALTER TABLE [dbo].[ARCHV_IND_COMB_RTO] DROP CONSTRAINT UNCPK_ARCHV_IND_COMB_RTO
GO

ALTER TABLE [dbo].[ARCHV_IND_COMB_RTO]  ADD 
CONSTRAINT [UNCPK_ARCHV_IND_COMB_RTO] PRIMARY KEY NONCLUSTERED 
(
	[AICR_PK_ID] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF, FILLFACTOR = 90) ON [FMR_Data]
GO

IF EXISTS (SELECT * FROM sys.sysconstraints WHERE constid = OBJECT_ID(N'UNCPK_CNFG_DFLT_SYS_PREF') AND id = OBJECT_ID(N'[dbo].[CNFG_DFLT_SYS_PREF]'))
ALTER TABLE [dbo].[CNFG_DFLT_SYS_PREF] DROP CONSTRAINT UNCPK_CNFG_DFLT_SYS_PREF
GO

ALTER TABLE [dbo].[CNFG_DFLT_SYS_PREF]  ADD 
 CONSTRAINT [UNCPK_CNFG_DFLT_SYS_PREF] PRIMARY KEY NONCLUSTERED 
(
	[CDSP_PK_ID] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF, FILLFACTOR = 90) ON [FMR_Data]
GO

IF EXISTS (SELECT * FROM sys.sysconstraints WHERE constid = OBJECT_ID(N'UNCPK_CNFG_MSTR_CYC_NBR') AND id = OBJECT_ID(N'[dbo].[CNFG_MSTR_CYC_NBR]'))
ALTER TABLE [dbo].[CNFG_MSTR_CYC_NBR]  DROP CONSTRAINT UNCPK_CNFG_MSTR_CYC_NBR
GO

ALTER TABLE [dbo].[CNFG_MSTR_CYC_NBR]  ADD 
 CONSTRAINT [UNCPK_CNFG_MSTR_CYC_NBR] PRIMARY KEY NONCLUSTERED 
(
	[CMCN_PK_ID] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF, FILLFACTOR = 90) ON [FMR_Data]
GO

IF EXISTS (SELECT * FROM sys.sysconstraints WHERE constid = OBJECT_ID(N'UNCPK_CRIT_STS_XTRCT') AND id = OBJECT_ID(N'[dbo].[CRIT_STS_XTRCT]'))
ALTER TABLE [dbo].[CRIT_STS_XTRCT] DROP CONSTRAINT UNCPK_CRIT_STS_XTRCT
GO

ALTER TABLE [dbo].[CRIT_STS_XTRCT]  ADD 
CONSTRAINT [UNCPK_CRIT_STS_XTRCT] PRIMARY KEY NONCLUSTERED 
(
	[CSX_PK_ID] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF, FILLFACTOR = 90) ON [FMR_Data]
GO

IF EXISTS (SELECT * FROM sys.sysconstraints WHERE constid = OBJECT_ID(N'UNCPK_EMAIL_DTL_MSG') AND id = OBJECT_ID(N'[dbo].[EMAIL_DTL_MSG]'))
ALTER TABLE [dbo].[EMAIL_DTL_MSG] DROP CONSTRAINT UNCPK_EMAIL_DTL_MSG
GO

ALTER TABLE [dbo].[EMAIL_DTL_MSG]  ADD 
 CONSTRAINT [UNCPK_EMAIL_DTL_MSG] PRIMARY KEY NONCLUSTERED 
(
	[EDM_PK_ID] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF, FILLFACTOR = 90) ON [FMR_Data]
GO

IF EXISTS (SELECT * FROM sys.sysconstraints WHERE constid = OBJECT_ID(N'UNCPK_EMAIL_DTL_RCIP') AND id = OBJECT_ID(N'[dbo].[EMAIL_DTL_RCIP]'))
ALTER TABLE [dbo].[EMAIL_DTL_RCIP] DROP CONSTRAINT UNCPK_EMAIL_DTL_RCIP
GO

ALTER TABLE [dbo].[EMAIL_DTL_RCIP]  ADD 
 CONSTRAINT [UNCPK_EMAIL_DTL_RCIP] PRIMARY KEY NONCLUSTERED 
(
	[EDR_PK_ID] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF, FILLFACTOR = 90) ON [FMR_Data]
GO

IF EXISTS (SELECT * FROM sys.sysconstraints WHERE constid = OBJECT_ID(N'UNCPK_EMAIL_MSTR_ADR_BK') AND id = OBJECT_ID(N'[dbo].[EMAIL_MSTR_ADR_BK]'))
ALTER TABLE [dbo].[EMAIL_MSTR_ADR_BK] DROP CONSTRAINT UNCPK_EMAIL_MSTR_ADR_BK
GO

ALTER TABLE [dbo].[EMAIL_MSTR_ADR_BK]  ADD 
 CONSTRAINT [UNCPK_EMAIL_MSTR_ADR_BK] PRIMARY KEY NONCLUSTERED 
(
	[EMAB_PK_ID] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF, FILLFACTOR = 90) ON [FMR_Data]
GO

IF EXISTS (SELECT * FROM sys.sysconstraints WHERE constid = OBJECT_ID(N'UNCPK_EMAIL_MSTR_MSG_TMPLT') AND id = OBJECT_ID(N'[dbo].[EMAIL_MSTR_MSG_TMPLT]'))
ALTER TABLE [dbo].[EMAIL_MSTR_MSG_TMPLT] DROP CONSTRAINT UNCPK_EMAIL_MSTR_MSG_TMPLT
GO

ALTER TABLE [dbo].[EMAIL_MSTR_MSG_TMPLT]  ADD 
 CONSTRAINT [UNCPK_EMAIL_MSTR_MSG_TMPLT] PRIMARY KEY NONCLUSTERED 
(
	[EMMT_PK_ID] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF, FILLFACTOR = 90) ON [FMR_Data]
GO

IF EXISTS (SELECT * FROM sys.sysconstraints WHERE constid = OBJECT_ID(N'UNCPK_LOG_ERR_FIN_MGT_RPT') AND id = OBJECT_ID(N'[dbo].[LOG_ERR_FIN_MGT_RPT]'))
ALTER TABLE [dbo].[LOG_ERR_FIN_MGT_RPT] DROP CONSTRAINT UNCPK_LOG_ERR_FIN_MGT_RPT
GO

ALTER TABLE [dbo].[LOG_ERR_FIN_MGT_RPT]  ADD 
CONSTRAINT [UNCPK_LOG_ERR_FIN_MGT_RPT] PRIMARY KEY NONCLUSTERED 
(
	[LEFMR_PK_ID] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF, FILLFACTOR = 90) ON [FMR_Data]
GO

IF EXISTS (SELECT * FROM sys.sysconstraints WHERE constid = OBJECT_ID(N'UNCPK_FACT_CTL_RPT_VAR') AND id = OBJECT_ID(N'[dbo].[FACT_CTL_RPT_VAR]'))
ALTER TABLE [dbo].[FACT_CTL_RPT_VAR] DROP CONSTRAINT UNCPK_FACT_CTL_RPT_VAR
GO

ALTER TABLE [dbo].[FACT_CTL_RPT_VAR]  ADD 
 CONSTRAINT [UNCPK_FACT_CTL_RPT_VAR] PRIMARY KEY NONCLUSTERED 
(
	FCRV_PK_ID ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF, FILLFACTOR = 90) ON [FMR_Data]
GO

IF EXISTS (SELECT * FROM sys.sysconstraints WHERE constid = OBJECT_ID(N'UNCPK_FACT_DTL_FIN_MGT_RPT') AND id = OBJECT_ID(N'[dbo].[FACT_DTL_FIN_MGT_RPT]'))
ALTER TABLE [dbo].[FACT_DTL_FIN_MGT_RPT] DROP CONSTRAINT UNCPK_FACT_DTL_FIN_MGT_RPT
GO

ALTER TABLE [dbo].[FACT_DTL_FIN_MGT_RPT]  ADD 
CONSTRAINT [UNCPK_FACT_DTL_FIN_MGT_RPT] PRIMARY KEY NONCLUSTERED 
(
	[FDFMR_PK_ID] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF, FILLFACTOR = 90) ON [FMR_Data]
GO

IF EXISTS (SELECT * FROM sys.sysconstraints WHERE constid = OBJECT_ID(N'UNCPK_FACT_IND_COMB_RTO') AND id = OBJECT_ID(N'[dbo].[FACT_IND_COMB_RTO]'))
ALTER TABLE [dbo].[FACT_IND_COMB_RTO] DROP CONSTRAINT UNCPK_FACT_IND_COMB_RTO
GO

ALTER TABLE [dbo].[FACT_IND_COMB_RTO]  ADD 
CONSTRAINT [UNCPK_FACT_IND_COMB_RTO] PRIMARY KEY NONCLUSTERED 
(
	[FICR_PK_ID] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF, FILLFACTOR = 90) ON [FMR_Data]
GO

IF EXISTS (SELECT * FROM sys.sysconstraints WHERE constid = OBJECT_ID(N'UNCPK_XTRCT_POL_IN_FRC') AND id = OBJECT_ID(N'[dbo].[XTRCT_POL_IN_FRC]'))
ALTER TABLE [dbo].[XTRCT_POL_IN_FRC] DROP CONSTRAINT UNCPK_XTRCT_POL_IN_FRC
GO

ALTER TABLE [dbo].[XTRCT_POL_IN_FRC]  ADD 
CONSTRAINT [UNCPK_XTRCT_POL_IN_FRC] PRIMARY KEY NONCLUSTERED 
(
	[XPIF_PK_ID] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF, FILLFACTOR = 90) ON [FMR_Data]
GO

IF EXISTS (SELECT * FROM sys.sysconstraints WHERE constid = OBJECT_ID(N'UNCPK_LOG_MSG_FIN_MGT_RPT') AND id = OBJECT_ID(N'[dbo].[LOG_MSG_FIN_MGT_RPT]'))
ALTER TABLE [dbo].[LOG_MSG_FIN_MGT_RPT] DROP CONSTRAINT UNCPK_LOG_MSG_FIN_MGT_RPT
GO

ALTER TABLE [dbo].[LOG_MSG_FIN_MGT_RPT]  ADD 
CONSTRAINT [UNCPK_LOG_MSG_FIN_MGT_RPT] PRIMARY KEY NONCLUSTERED 
(
	[LMFMR_PK_ID] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF, FILLFACTOR = 90) ON [FMR_Data]
GO

IF EXISTS (SELECT * FROM sys.sysconstraints WHERE constid = OBJECT_ID(N'UNCPK_STG_TNJ_DATA') AND id = OBJECT_ID(N'[dbo].[STG_TNJ_DATA]'))
ALTER TABLE [dbo].[STG_TNJ_DATA] DROP CONSTRAINT UNCPK_STG_TNJ_DATA
GO

ALTER TABLE [dbo].[STG_TNJ_DATA]  ADD 
 CONSTRAINT [UNCPK_STG_TNJ_DATA] PRIMARY KEY NONCLUSTERED 
(
	[STD_PK_ID] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF, FILLFACTOR = 90) ON [FMR_Data]
GO

IF EXISTS (SELECT * FROM sys.sysconstraints WHERE constid = OBJECT_ID(N'UNCPK_STG_WRT_PRDCT_MO_RPT') AND id = OBJECT_ID(N'[dbo].[STG_WRT_PRDCT_MO_RPT]'))
ALTER TABLE [dbo].[STG_WRT_PRDCT_MO_RPT] DROP CONSTRAINT UNCPK_STG_WRT_PRDCT_MO_RPT
GO

ALTER TABLE [dbo].[STG_WRT_PRDCT_MO_RPT]  ADD 
 CONSTRAINT [UNCPK_STG_WRT_PRDCT_MO_RPT] PRIMARY KEY NONCLUSTERED 
(
	[SWPMR_PK_ID] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF, FILLFACTOR = 90) ON [FMR_Data]
GO

IF EXISTS (SELECT * FROM sys.sysconstraints WHERE constid = OBJECT_ID(N'UNCPK_USER_MSTR_SESS') AND id = OBJECT_ID(N'[dbo].[USER_MSTR_SESS]'))
ALTER TABLE [dbo].[USER_MSTR_SESS] DROP CONSTRAINT UNCPK_USER_MSTR_SESS
GO

ALTER TABLE [dbo].[USER_MSTR_SESS]  ADD 
 CONSTRAINT [UNCPK_USER_MSTR_SESS] PRIMARY KEY NONCLUSTERED 
(
	[UMS_PK_ID] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF, FILLFACTOR = 90) ON [FMR_Data]
GO

IF EXISTS (SELECT * FROM sys.sysconstraints WHERE constid = OBJECT_ID(N'UNCPK_CNFG_MSTR_HOL') AND id = OBJECT_ID(N'[dbo].[CNFG_MSTR_HOL]'))
ALTER TABLE [dbo].[CNFG_MSTR_HOL]  DROP CONSTRAINT UNCPK_CNFG_MSTR_HOL
GO

ALTER TABLE [dbo].[CNFG_MSTR_HOL]  ADD 
 CONSTRAINT [UNCPK_CNFG_MSTR_HOL] PRIMARY KEY NONCLUSTERED 
(
	[CMH_PK_ID] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF, FILLFACTOR = 90) ON [FMR_Data]
GO


PRINT '======= FMR Table Constraints Complete ========'
PRINT ''

IF EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_EMAIL_DTL_RCIP]') AND parent_object_id = OBJECT_ID(N'[dbo].[EMAIL_DTL_RCIP]'))
ALTER TABLE dbo.EMAIL_DTL_RCIP DROP CONSTRAINT FK_EMAIL_DTL_RCIP
GO

ALTER TABLE [dbo].[EMAIL_DTL_RCIP]  WITH CHECK ADD  CONSTRAINT [FK_EMAIL_DTL_RCIP] FOREIGN KEY([EDR_MSG_ID])
REFERENCES [dbo].[EMAIL_DTL_MSG] ([EDM_PK_ID])
GO

IF EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_EMAIL_MSTR_ADR_BK]') AND parent_object_id = OBJECT_ID(N'[dbo].[EMAIL_MSTR_ADR_BK]'))
ALTER TABLE [dbo].[EMAIL_MSTR_ADR_BK]  DROP CONSTRAINT [FK_EMAIL_MSTR_ADR_BK] 
GO

ALTER TABLE [dbo].[EMAIL_MSTR_ADR_BK]  WITH CHECK ADD  CONSTRAINT [FK_EMAIL_MSTR_ADR_BK] FOREIGN KEY(EMAB_MSG_TMPLT_ID)
REFERENCES [dbo].[EMAIL_MSTR_MSG_TMPLT] ([EMMT_PK_ID])
GO

PRINT '======= FMR Foreign Key Constraints Complete ========'
PRINT ''

IF EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ARCHV_DTL_FIN_MGT_RPT]') AND name = N'CI_ARCHV_DTL_FIN_MGT_RPT')
DROP INDEX ARCHV_DTL_FIN_MGT_RPT.CI_ARCHV_DTL_FIN_MGT_RPT
GO

CREATE CLUSTERED INDEX [CI_ARCHV_DTL_FIN_MGT_RPT] ON [dbo].[ARCHV_DTL_FIN_MGT_RPT] 
(
	ADFMR_BPM_LN_OF_BUS ASC,
	ADFMR_RPT_YR_MO ASC,
	ADFMR_EFF_YR ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF, FILLFACTOR = 70) ON [FMR_Index]
GO

IF EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ARCHV_IND_COMB_RTO]') AND name = N'CI_ARCHV_IND_COMB_RTO')
DROP INDEX ARCHV_IND_COMB_RTO.CI_ARCHV_IND_COMB_RTO
GO

CREATE CLUSTERED INDEX [CI_ARCHV_IND_COMB_RTO] ON [dbo].[ARCHV_IND_COMB_RTO] 
(
	[AICR_BPM_LN_OF_BUS] ASC,
	[AICR_RPT_YR_MO] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF, FILLFACTOR = 70) ON [FMR_Index]
GO

IF EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CNFG_DFLT_SYS_PREF]') AND name = N'UCI_CNFG_DFLT_SYS_PREF')
DROP INDEX CNFG_DFLT_SYS_PREF.UCI_CNFG_DFLT_SYS_PREF
GO

CREATE UNIQUE CLUSTERED INDEX [UCI_CNFG_DFLT_SYS_PREF] ON [dbo].[CNFG_DFLT_SYS_PREF] 
(
	[CDSP_CD] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF, FILLFACTOR = 70) ON [FMR_Index]
GO

IF EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CNFG_MSTR_ZIPCD]') AND name = N'CI_CNFG_MSTR_ZIPCD')
DROP INDEX CNFG_MSTR_ZIPCD.CI_CNFG_MSTR_ZIPCD
GO

CREATE CLUSTERED INDEX [CI_CNFG_MSTR_ZIPCD] ON [dbo].[CNFG_MSTR_ZIPCD] 
(
	[CMZ_ST_CD] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF, FILLFACTOR = 70) ON [FMR_Index]
GO

IF EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CNFG_MSTR_ZIPCD]') AND name = N'UNCI_CNFG_MSTR_ZIPCD')
DROP INDEX CNFG_MSTR_ZIPCD.UNCI_CNFG_MSTR_ZIPCD
GO

CREATE UNIQUE NONCLUSTERED INDEX [UNCI_CNFG_MSTR_ZIPCD] ON [dbo].[CNFG_MSTR_ZIPCD] 
(
	[CMZ_ZIP_CD] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF, FILLFACTOR = 70) ON [FMR_Index]
GO

IF EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[FACT_DTL_FIN_MGT_RPT]') AND name = N'CI_FACT_DTL_FIN_MGT_RPT')
DROP INDEX FACT_DTL_FIN_MGT_RPT.CI_FACT_DTL_FIN_MGT_RPT
GO

CREATE CLUSTERED INDEX [CI_FACT_DTL_FIN_MGT_RPT] ON [dbo].[FACT_DTL_FIN_MGT_RPT] 
(
	FDFMR_BPM_LN_OF_BUS ASC,
	FDFMR_EFF_YR ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF, FILLFACTOR = 70) ON [FMR_Index]
GO

IF EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[STG_TNJ_DATA]') AND name = N'CI_STG_TNJ_DATA')
DROP INDEX STG_TNJ_DATA.CI_STG_TNJ_DATA
GO

CREATE CLUSTERED INDEX [CI_STG_TNJ_DATA] ON [dbo].[STG_TNJ_DATA] 
(
	STD_FM ASC,
	STD_MKT_CD ASC,
	STD_SUB_MKT ASC,
	STD_ZIP_CD5 ASC,
	STD_AGE ASC,
	STD_EFF_YR ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF, FILLFACTOR = 70) ON [FMR_Index]
GO

IF EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[STG_WRT_PRDCT_MO_RPT]') AND name = N'CI_STG_WRT_PRDCT_MO_RPT')
DROP INDEX STG_WRT_PRDCT_MO_RPT.CI_STG_WRT_PRDCT_MO_RPT
GO

CREATE CLUSTERED INDEX [CI_STG_WRT_PRDCT_MO_RPT] ON [dbo].[STG_WRT_PRDCT_MO_RPT] 
(
	SWPMR_BPM_LN_OF_BUS ASC,
	SWPMR_EFF_YR ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF, FILLFACTOR = 70) ON [FMR_Index]
GO

IF EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[USER_MSTR_SESS]') AND name = N'UCI_USER_MSTR_SESS')
DROP INDEX USER_MSTR_SESS.UCI_USER_MSTR_SESS
GO

CREATE UNIQUE CLUSTERED INDEX [UCI_USER_MSTR_SESS] ON [dbo].[USER_MSTR_SESS] 
(
	[UMS_CD] ASC,
	[UMS_NM] ASC,
	[UMS_DOM_NM] ASC,
	[UMS_MACH_NM] ASC,
	[UMS_ENAB_IND] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF, FILLFACTOR = 70) ON [FMR_Index]
GO

IF EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CNFG_MSTR_HOL]') AND name = N'UNCI_CNFG_MSTR_HOL')
DROP INDEX CNFG_MSTR_HOL.UNCI_CNFG_MSTR_HOL
GO

CREATE UNIQUE NONCLUSTERED INDEX [UNCI_CNFG_MSTR_HOL] ON [dbo].[CNFG_MSTR_HOL] 
(
	[CMH_DT] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF, FILLFACTOR = 70) ON [FMR_Index]
GO

PRINT '======= FMR Table Index Complete ========'
PRINT ''

INSERT INTO USER_MSTR_SESS
(UMS_PK_ID, UMS_CD, UMS_NM, UMS_DOM_NM, UMS_MACH_NM, UMS_ENAB_IND, 
UMS_LST_USER, UMS_LST_DT_TM, UMS_CREAT_USER, UMS_CREAT_DT_TM)

SELECT 1, '001', 'dtsuser1', 'prod.travp.net', 'PHO9XW9I8FW', 'Y',
'SYSTEM BUILD', CURRENT_TIMESTAMP, 'SYSTEM BUILD', CURRENT_TIMESTAMP

UNION ALL 
SELECT 2, '002', 'dtsuser2', 'prod.travp.net', 'PHO9XW9I8FW', 'Y',
'SYSTEM BUILD', CURRENT_TIMESTAMP, 'SYSTEM BUILD', CURRENT_TIMESTAMP

UNION ALL 
SELECT 3, '003', 'dtsuser3', 'prod.travp.net', 'PHO9XW9I8FW', 'Y',
'SYSTEM BUILD', CURRENT_TIMESTAMP, 'SYSTEM BUILD', CURRENT_TIMESTAMP

UNION ALL 
SELECT 4, '004', 'dtsuser4', 'prod.travp.net', 'PHO9XW9I8FW', 'Y',
'SYSTEM BUILD', CURRENT_TIMESTAMP, 'SYSTEM BUILD', CURRENT_TIMESTAMP

UNION ALL 
SELECT 5, '005', 'dtsuser5', 'prod.travp.net', 'PHO9XW9I8FW', 'Y',
'SYSTEM BUILD', CURRENT_TIMESTAMP, 'SYSTEM BUILD', CURRENT_TIMESTAMP

INSERT INTO EMAIL_MSTR_MSG_TMPLT (EMMT_PK_ID, EMMT_CD, EMMT_SBJ, EMMT_MSG, EMMT_FROM, EMMT_LST_USER, 
EMMT_LST_DT_TM, EMMT_CREAT_USER, EMMT_CREAT_DT_TM)

SELECT 1, 'CRP', 'Control Report Process', 'Dear Administrator,


<MonthName> <Year Name> Control Report process has been completed.

Company Name', 'Administrator', 'SYSTEM BUILD', CURRENT_TIMESTAMP, 'SYSTEM BUILD', CURRENT_TIMESTAMP

UNION ALL SELECT 2, 'PIF', 'PIF Data Process', 'Dear Administrator,


<MonthName> <Year Name> PIF data process has been completed.

Company Name', 'Administrator', 'SYSTEM BUILD', CURRENT_TIMESTAMP, 'SYSTEM BUILD', CURRENT_TIMESTAMP

UNION ALL SELECT 3, 'RP', 'Retention Process', 'Dear Administrator,


<MonthName> <Year Name> Retention process has been completed.

Company Name', 'Administrator', 'SYSTEM BUILD', CURRENT_TIMESTAMP, 'SYSTEM BUILD', CURRENT_TIMESTAMP

UNION ALL SELECT 4, 'DWP', 'Direct Written Premium Process', 'Dear Administrator,


<MonthName> <Year Name> Direct Written Premium process has been completed.

Company Name', 'Administrator', 'SYSTEM BUILD', CURRENT_TIMESTAMP, 'SYSTEM BUILD', CURRENT_TIMESTAMP

UNION ALL SELECT 5, 'EO', 'Error Occured', 'An Error has occured,

please check the error log table for current year & month row(s) for more information.

Company Name', 'Administrator', 'SYSTEM BUILD', CURRENT_TIMESTAMP, 'SYSTEM BUILD', CURRENT_TIMESTAMP

UNION ALL SELECT 6, 'ICR', 'ICR Data Process', 'Dear Administrator,


<MonthName> <Year Name> ICR data process has been completed.

Company Name', 'Administrator', 'SYSTEM BUILD', CURRENT_TIMESTAMP, 'SYSTEM BUILD', CURRENT_TIMESTAMP

UNION ALL SELECT 7, 'EPLR', 'Earned Premium and Loss Ratio', 'Dear Administrator,


<MonthName> <Year Name> Earned Premium and Loss Ratio process has been completed.

Company Name', 'Administrator', 'SYSTEM BUILD', CURRENT_TIMESTAMP, 'SYSTEM BUILD', CURRENT_TIMESTAMP

INSERT INTO EMAIL_MSTR_ADR_BK (EMAB_PK_ID, EMAB_MSG_TMPLT_ID, EMAB_To, EMAB_Cc, EMAB_Bcc,
EMAB_LST_USER, EMAB_LST_DT_TM, EMAB_CREAT_USER, EMAB_CREAT_DT_TM)

SELECT 1, 1, 'VGULAPPA@EMAIL.COM', '', '', 'SYSTEM BUILD', CURRENT_TIMESTAMP, 'SYSTEM BUILD', CURRENT_TIMESTAMP

UNION ALL SELECT 2, 2, 'VGULAPPA@EMAIL.COM', '', '', 'SYSTEM BUILD', CURRENT_TIMESTAMP, 'SYSTEM BUILD', CURRENT_TIMESTAMP
UNION ALL SELECT 3, 3, 'VGULAPPA@EMAIL.COM', '', '', 'SYSTEM BUILD', CURRENT_TIMESTAMP, 'SYSTEM BUILD', CURRENT_TIMESTAMP
UNION ALL SELECT 4, 4, 'VGULAPPA@EMAIL.COM', '', '', 'SYSTEM BUILD', CURRENT_TIMESTAMP, 'SYSTEM BUILD', CURRENT_TIMESTAMP
UNION ALL SELECT 5, 5, 'VGULAPPA@EMAIL.COM', '', '', 'SYSTEM BUILD', CURRENT_TIMESTAMP, 'SYSTEM BUILD', CURRENT_TIMESTAMP
UNION ALL SELECT 6, 6, 'VGULAPPA@EMAIL.COM', '', '', 'SYSTEM BUILD', CURRENT_TIMESTAMP, 'SYSTEM BUILD', CURRENT_TIMESTAMP
UNION ALL SELECT 7, 7, 'VGULAPPA@EMAIL.COM', '', '', 'SYSTEM BUILD', CURRENT_TIMESTAMP, 'SYSTEM BUILD', CURRENT_TIMESTAMP

INSERT INTO CNFG_DFLT_SYS_PREF
(CDSP_PK_ID, CDSP_CD, CDSP_NM, CDSP_VAL, 
CDSP_LST_USER, CDSP_LST_DT_TM, CDSP_CREAT_USER, CDSP_CREAT_DT_TM)

SELECT 1, 'RSY', 'Report Start Year', '2004', 
'SYSTEM BUILD', CURRENT_TIMESTAMP, 'SYSTEM BUILD', CURRENT_TIMESTAMP

UNION ALL
SELECT 2, 'RPY', 'Report Previous Year', '2006', 
'SYSTEM BUILD', CURRENT_TIMESTAMP, 'SYSTEM BUILD', CURRENT_TIMESTAMP

UNION ALL
SELECT 3, 'RCY', 'Report Current Year', '2007', 
'SYSTEM BUILD', CURRENT_TIMESTAMP, 'SYSTEM BUILD', CURRENT_TIMESTAMP

INSERT INTO XTRCT_POL_IN_FRC
(XPIF_BPM_LN_OF_BUS, XPIF_DESC, XPIF_MO, XPIF_YR, XPIF_YR_MO, XPIF_TOT_AMT)

SELECT 'Property', 'Mendota Specialty', 01, 2006, 200602, 22655
UNION ALL SELECT 'Auto', 'Mendota NSA', 01, 2006, 200602, 100896 
UNION ALL SELECT 'Auto', 'NSA', 01, 2006, 200602, 62 
UNION ALL SELECT 'Auto', 'AIP', 01, 2006, 200602, 19393 
UNION ALL SELECT 'Property', 'Flood', 01, 2006, 200602, 199397 
UNION ALL SELECT 'Auto', 'Mass Auto', 01, 2006, 200602, 221468 

UNION ALL SELECT 'Property', 'Mendota Specialty', 02, 2006, 200603, 22288 
UNION ALL SELECT 'Auto', 'Mendota NSA', 02, 2006, 200603, 110120 
UNION ALL SELECT 'Auto', 'NSA', 02, 2006, 200603, 33 
UNION ALL SELECT 'Auto', 'AIP', 02, 2006, 200603, 18790 
UNION ALL SELECT 'Property', 'Flood', 02, 2006, 200603, 198184 
UNION ALL SELECT 'Auto', 'Mass Auto', 02, 2006, 200603, 221392 

UNION ALL SELECT 'Property', 'Mendota Specialty', 03, 2006, 200604,  21908 
UNION ALL SELECT 'Auto', 'Mendota NSA', 03, 2006, 200604, 119420 
UNION ALL SELECT 'Auto', 'NSA', 03, 2006, 200604, 1 
UNION ALL SELECT 'Auto', 'AIP', 03, 2006, 200604, 18570 
UNION ALL SELECT 'Property', 'Flood', 03, 2006, 200604, 200230 
UNION ALL SELECT 'Auto', 'Mass Auto', 03, 2006, 200604, 221927  

UNION ALL SELECT 'Property', 'Mendota Specialty', 04, 2006, 200605, 21445 
UNION ALL SELECT 'Auto', 'Mendota NSA', 04, 2006, 200605, 124419 
UNION ALL SELECT 'Auto', 'NSA', 04, 2006, 200605, 0 
UNION ALL SELECT 'Auto', 'AIP', 04, 2006, 200605, 18229 
UNION ALL SELECT 'Property', 'Flood', 04, 2006, 200605, 202298 
UNION ALL SELECT 'Auto', 'Mass Auto', 04, 2006, 200605, 222857   

UNION ALL SELECT 'Property', 'Mendota Specialty', 05, 2006, 200606,  21053 
UNION ALL SELECT 'Auto', 'Mendota NSA', 05, 2006, 200606,  128398 
UNION ALL SELECT 'Auto', 'NSA', 05, 2006, 200606, 0 
UNION ALL SELECT 'Auto', 'AIP', 05, 2006, 200606,  18438 
UNION ALL SELECT 'Property', 'Flood', 05, 2006, 200606,  206002 
UNION ALL SELECT 'Auto', 'Mass Auto', 05, 2006, 200606,  221863 

UNION ALL SELECT 'Property', 'Mendota Specialty', 06, 2006, 200607, 20627 
UNION ALL SELECT 'Auto', 'Mendota NSA', 06, 2006, 200607, 131721 
UNION ALL SELECT 'Auto', 'NSA', 06, 2006, 200607, 0 
UNION ALL SELECT 'Auto', 'AIP', 06, 2006, 200607, 18071 
UNION ALL SELECT 'Property', 'Flood', 06, 2006, 200607, 209641 
UNION ALL SELECT 'Auto', 'Mass Auto', 06, 2006, 200607, 221400  

UNION ALL SELECT 'Property', 'Mendota Specialty', 07, 2006, 200608, 20278
UNION ALL SELECT 'Auto', 'Mendota NSA', 07, 2006, 200608, 133504 
UNION ALL SELECT 'Auto', 'NSA', 07, 2006, 200608, 0 
UNION ALL SELECT 'Auto', 'AIP', 07, 2006, 200608, 17536 
UNION ALL SELECT 'Property', 'Flood', 07, 2006, 200608, 214146 
UNION ALL SELECT 'Auto', 'Mass Auto', 07, 2006, 200608, 220559   

UNION ALL SELECT 'Property', 'Mendota Specialty', 08, 2006, 200609, 19842 
UNION ALL SELECT 'Auto', 'Mendota NSA', 08, 2006, 200609, 136509 
UNION ALL SELECT 'Auto', 'NSA', 08, 2006, 200609, 0 
UNION ALL SELECT 'Auto', 'AIP', 08, 2006, 200609, 17216 
UNION ALL SELECT 'Property', 'Flood', 08, 2006, 200609, 217377 
UNION ALL SELECT 'Auto', 'Mass Auto', 08, 2006, 200609, 219839    

UNION ALL SELECT 'Property', 'Mendota Specialty', 09, 2006, 200610, 19397 
UNION ALL SELECT 'Auto', 'Mendota NSA', 09, 2006, 200610, 135701 
UNION ALL SELECT 'Auto', 'NSA', 09, 2006, 200610, 0 
UNION ALL SELECT 'Auto', 'AIP', 09, 2006, 200610, 17045 
UNION ALL SELECT 'Property', 'Flood', 09, 2006, 200610, 219635 
UNION ALL SELECT 'Auto', 'Mass Auto', 09, 2006, 200610, 219248    

UNION ALL SELECT 'Property', 'Mendota Specialty', 10, 2006, 200611, 18914 
UNION ALL SELECT 'Auto', 'Mendota NSA', 10, 2006, 200611, 137037 
UNION ALL SELECT 'Auto', 'NSA', 10, 2006, 200611, 0 
UNION ALL SELECT 'Auto', 'AIP', 10, 2006, 200611, 16813 
UNION ALL SELECT 'Property', 'Flood', 10, 2006, 200611, 220754 
UNION ALL SELECT 'Auto', 'Mass Auto', 10, 2006, 200611, 218098     

UNION ALL SELECT 'Property', 'Mendota Specialty', 11, 2006, 200612, 18476 
UNION ALL SELECT 'Auto', 'Mendota NSA', 11, 2006, 200612, 135871 
UNION ALL SELECT 'Auto', 'NSA', 11, 2006, 200612, 0 
UNION ALL SELECT 'Auto', 'AIP', 11, 2006, 200612, 16561 
UNION ALL SELECT 'Property', 'Flood', 11, 2006, 200612, 221175 
UNION ALL SELECT 'Auto', 'Mass Auto', 11, 2006, 200612, 217425     

UNION ALL SELECT 'Property', 'Mendota Specialty', 12, 2006, 200701, 18143
UNION ALL SELECT 'Auto', 'Mendota NSA', 12, 2006, 200701, 134251
UNION ALL SELECT 'Auto', 'NSA', 12, 2006, 200701, 0
UNION ALL SELECT 'Auto', 'AIP', 12, 2006, 200701, 16103
UNION ALL SELECT 'Property', 'Flood', 12, 2006, 200701, 221325
UNION ALL SELECT 'Auto', 'Mass Auto', 12, 2006, 200701, 216529

UNION ALL SELECT 'Property', 'Mendota Specialty', 01, 2007, 200702, 17329 
UNION ALL SELECT 'Auto', 'Mendota NSA', 01, 2007, 200702, 134338 
UNION ALL SELECT 'Auto', 'NSA', 01, 2007, 200702, 0 
UNION ALL SELECT 'Auto', 'AIP', 01, 2007, 200702, 15598 
UNION ALL SELECT 'Property', 'Flood', 01, 2007, 200702, 221847 
UNION ALL SELECT 'Auto', 'Mass Auto', 01, 2007, 200702, 215282 

UNION ALL SELECT 'Property', 'Mendota Specialty', 02, 2007, 200703, 15803 
UNION ALL SELECT 'Auto', 'Mendota NSA', 02, 2007, 200703,  136512 
UNION ALL SELECT 'Auto', 'NSA', 02, 2007, 200703, 0 
UNION ALL SELECT 'Auto', 'AIP', 02, 2007, 200703, 15180 
UNION ALL SELECT 'Property', 'Flood', 02, 2007, 200703, 221821 
UNION ALL SELECT 'Auto', 'Mass Auto', 02, 2007, 200703, 215046  

UNION ALL SELECT 'Property', 'Mendota Specialty', 03, 2007, 200704, 13982 
UNION ALL SELECT 'Auto', 'Mendota NSA', 03, 2007, 200704, 138830 
UNION ALL SELECT 'Auto', 'NSA', 03, 2007, 200704, 0 
UNION ALL SELECT 'Auto', 'AIP', 03, 2007, 200704, 14766 
UNION ALL SELECT 'Property', 'Flood', 03, 2007, 200704, 222437 
UNION ALL SELECT 'Auto', 'Mass Auto', 03, 2007, 200704, 214467  

UNION ALL SELECT 'Property', 'Mendota Specialty', 04, 2007, 200705, 0 
UNION ALL SELECT 'Auto', 'Mendota NSA', 04, 2007, 200705, 0 
UNION ALL SELECT 'Auto', 'NSA', 04, 2007, 200705, 0 
UNION ALL SELECT 'Auto', 'AIP', 04, 2007, 200705,  14386 
UNION ALL SELECT 'Property', 'Flood', 04, 2007, 200705, 222740 
UNION ALL SELECT 'Auto', 'Mass Auto', 04, 2007, 200705, 214298    

UNION ALL SELECT 'Property', 'Mendota Specialty', 05, 2007, 200706, 0 
UNION ALL SELECT 'Auto', 'Mendota NSA', 05, 2007, 200706, 0 
UNION ALL SELECT 'Auto', 'NSA', 05, 2007, 200706, 0 
UNION ALL SELECT 'Auto', 'AIP', 05, 2007, 200706, 14566 
UNION ALL SELECT 'Property', 'Flood', 05, 2007, 200706, 223011 
UNION ALL SELECT 'Auto', 'Mass Auto', 05, 2007, 200706, 213870  

UNION ALL SELECT 'Property', 'Mendota Specialty', 06, 2007, 200707, 0 
UNION ALL SELECT 'Auto', 'Mendota NSA', 06, 2007, 200707, 0 
UNION ALL SELECT 'Auto', 'NSA', 06, 2007, 200707, 0 
UNION ALL SELECT 'Auto', 'AIP', 06, 2007, 200707, 14248 
UNION ALL SELECT 'Property', 'Flood', 06, 2007, 200707, 222900 
UNION ALL SELECT 'Auto', 'Mass Auto', 06, 2007, 200707, 213223   

INSERT INTO CNFG_MSTR_HOL( CMH_PK_ID, CMH_DT, CMH_DESC, CMH_LST_USER, CMH_LST_DT_TM, CMH_CREAT_USER, CMH_CREAT_DT_TM)
SELECT  1, '2007-01-01 00:00:00', 'New Year Day', 'SYSTEM BUILD', CURRENT_TIMESTAMP, 'SYSTEM BUILD', CURRENT_TIMESTAMP
UNION ALL SELECT  2, '2007-05-28 00:00:00', 'Memorial Day', 'SYSTEM BUILD', CURRENT_TIMESTAMP, 'SYSTEM BUILD', CURRENT_TIMESTAMP
UNION ALL SELECT  3, '2007-07-04 00:00:00', 'Indenpendence Day', 'SYSTEM BUILD', CURRENT_TIMESTAMP, 'SYSTEM BUILD', CURRENT_TIMESTAMP
UNION ALL SELECT  4, '2007-09-03 00:00:00', 'Labor Day', 'SYSTEM BUILD', CURRENT_TIMESTAMP, 'SYSTEM BUILD', CURRENT_TIMESTAMP
UNION ALL SELECT  5, '2007-11-22 00:00:00', 'Thanksgiving Day', 'SYSTEM BUILD', CURRENT_TIMESTAMP, 'SYSTEM BUILD', CURRENT_TIMESTAMP
UNION ALL SELECT  6, '2007-11-23 00:00:00', 'Day after Thanksgiving', 'SYSTEM BUILD', CURRENT_TIMESTAMP, 'SYSTEM BUILD', CURRENT_TIMESTAMP
UNION ALL SELECT  7, '2007-12-24 00:00:00', 'Christmas Eve', 'SYSTEM BUILD', CURRENT_TIMESTAMP, 'SYSTEM BUILD', CURRENT_TIMESTAMP
UNION ALL SELECT  8, '2007-12-25 00:00:00', 'Christmas Day', 'SYSTEM BUILD', CURRENT_TIMESTAMP, 'SYSTEM BUILD', CURRENT_TIMESTAMP

INSERT INTO CNFG_MSTR_DVLP_FCT
(CMDF_CHNL, CMDF_CD, CMDF_AGE, CMDF_RBLI, CMDF_RFA, CMDF_RMC, CMDF_NBLI, CMDF_NFA, CMDF_NMC)
SELECT 'Affinity', 'COND', 1, 1, 4.9000000000, 15.0000000000, 1.5160000000, 3.1000000000, 9.6000000000
UNION ALL SELECT 'Affinity', 'COND', 2, 1, 0.4000000000, 14.7000000000, 1.0000000000, 1.7000000000, 8.9000000000
UNION ALL SELECT 'Affinity', 'COND', 3, 1, 0.0000000000, 13.7000000000, 1.0000000000, 1.7000000000, 8.0000000000
UNION ALL SELECT 'Affinity', 'COND', 4, 1, 0.0000000000, 12.3000000000, 1.0000000000, 0.0000000000, 7.1000000000
UNION ALL SELECT 'Affinity', 'COND', 5, 1, 0.0000000000, 10.8000000000, 1.0000000000, 0.0000000000, 7.1000000000
UNION ALL SELECT 'Affinity', 'COND', 6, 1, 0.0000000000, 9.4000000000, 1.0000000000, 0.0000000000, 6.7000000000
UNION ALL SELECT 'Affinity', 'COND', 7, 1, 0.0000000000, 8.7000000000, 1.0000000000, 0.0000000000, 6.1000000000
UNION ALL SELECT 'Affinity', 'COND', 8, 1, 0.0000000000, 7.0000000000, 1.0000000000, 0.0000000000, 5.5000000000
UNION ALL SELECT 'Affinity', 'COND', 9, 1, 0.0000000000, 6.4000000000, 1.0000000000, 0.0000000000, 4.3000000000
UNION ALL SELECT 'Affinity', 'COND', 10, 1, 0.0000000000, 4.0000000000, 1.0000000000, 0.0000000000, 3.1000000000
UNION ALL SELECT 'Affinity', 'COND', 11, 1, 0.0000000000, 1.4000000000, 1.0000000000, 0.0000000000, 2.5000000000
UNION ALL SELECT 'Affinity', 'COND', 12, 1, 0.0000000000, 0.4000000000, 1.0000000000, 0.0000000000, 2.0000000000
UNION ALL SELECT 'Affinity', 'COND', 13, 1, 0.0000000000, 0.0000000000, 1.0000000000, 0.0000000000, 0.0000000000
UNION ALL SELECT 'Retail', 'COND', 1, 1, 7.7000000000, 8.5000000000, 2.3550000000, 1.2000000000, 9.4000000000
UNION ALL SELECT 'Retail', 'COND', 2, 1, 1.2000000000, 8.4000000000, 1.0730000000, 1.2000000000, 9.1000000000
UNION ALL SELECT 'Retail', 'COND', 3, 1, 0.0000000000, 7.8000000000, 1.0090000000, 0.5000000000, 7.2000000000
UNION ALL SELECT 'Retail', 'COND', 4, 1, 0.0000000000, 6.9000000000, 1.0000000000, 0.0000000000, 6.0000000000
UNION ALL SELECT 'Retail', 'COND', 5, 1, 0.0000000000, 6.0000000000, 1.0000000000, 0.0000000000, 5.4000000000
UNION ALL SELECT 'Retail', 'COND', 6, 1, 0.0000000000, 5.1000000000, 1.0000000000, 0.0000000000, 5.0000000000
UNION ALL SELECT 'Retail', 'COND', 7, 1, 0.0000000000, 4.5000000000, 1.0000000000, 0.0000000000, 4.3000000000
UNION ALL SELECT 'Retail', 'COND', 8, 1, 0.0000000000, 3.7000000000, 1.0000000000, 0.0000000000, 3.6000000000
UNION ALL SELECT 'Retail', 'COND', 9, 1, 0.0000000000, 2.9000000000, 1.0000000000, 0.0000000000, 2.9000000000
UNION ALL SELECT 'Retail', 'COND', 10, 1, 0.0000000000, 2.2000000000, 1.0000000000, 0.0000000000, 2.1000000000
UNION ALL SELECT 'Retail', 'COND', 11, 1, 0.0000000000, 1.6000000000, 1.0000000000, 0.0000000000, 1.4000000000
UNION ALL SELECT 'Retail', 'COND', 12, 1, 0.0000000000, 0.8000000000, 1.0000000000, 0.0000000000, 0.5000000000
UNION ALL SELECT 'Retail', 'COND', 13, 1, 0.0000000000, 0.0000000000, 1.0000000000, 0.0000000000, 0.0000000000
UNION ALL SELECT 'Affinity', 'DWEL', 1, 1, 3.5000000000, 4.3000000000, 1.3220000000, 1.9000000000, 9.3000000000
UNION ALL SELECT 'Affinity', 'DWEL', 2, 1, 0.6000000000, 4.3000000000, 1.0120000000, 0.9000000000, 7.7000000000
UNION ALL SELECT 'Affinity', 'DWEL', 3, 1, 0.0000000000, 3.9000000000, 1.0080000000, 0.4000000000, 5.9000000000
UNION ALL SELECT 'Affinity', 'DWEL', 4, 1, 0.0000000000, 3.7000000000, 1.0000000000, 0.0000000000, 6.3000000000
UNION ALL SELECT 'Affinity', 'DWEL', 5, 1, 0.0000000000, 3.3000000000, 1.0000000000, 0.0000000000, 4.5000000000
UNION ALL SELECT 'Affinity', 'DWEL', 6, 1, 0.0000000000, 2.5000000000, 1.0000000000, 0.0000000000, 4.5000000000
UNION ALL SELECT 'Affinity', 'DWEL', 7, 1, 0.0000000000, 2.3000000000, 1.0000000000, 0.0000000000, 3.5000000000
UNION ALL SELECT 'Affinity', 'DWEL', 8, 1, 0.0000000000, 1.8000000000, 1.0000000000, 0.0000000000, 3.1000000000
UNION ALL SELECT 'Affinity', 'DWEL', 9, 1, 0.0000000000, 1.4000000000, 1.0000000000, 0.0000000000, 1.9000000000
UNION ALL SELECT 'Affinity', 'DWEL', 10, 1, 0.0000000000, 0.9000000000, 1.0000000000, 0.0000000000, 2.2000000000
UNION ALL SELECT 'Affinity', 'DWEL', 11, 1, 0.0000000000, 0.6000000000, 1.0000000000, 0.0000000000, 1.0000000000
UNION ALL SELECT 'Affinity', 'DWEL', 12, 1, 0.0000000000, 0.1000000000, 1.0000000000, 0.0000000000, 0.0000000000
UNION ALL SELECT 'Affinity', 'DWEL', 13, 1, 0.0000000000, 0.0000000000, 1.0000000000, 0.0000000000, 0.0000000000
UNION ALL SELECT 'Retail', 'DWEL', 1, 1, 4.3000000000, 4.6000000000, 3.3080000000, 1.0000000000, 8.6000000000
UNION ALL SELECT 'Retail', 'DWEL', 2, 1, 0.8000000000, 4.6000000000, 1.1070000000, 1.0000000000, 8.0000000000
UNION ALL SELECT 'Retail', 'DWEL', 3, 1, 0.0000000000, 4.3000000000, 1.0090000000, 0.4000000000, 6.1000000000
UNION ALL SELECT 'Retail', 'DWEL', 4, 1, 0.0000000000, 3.8000000000, 1.0000000000, 0.0000000000, 4.0000000000
UNION ALL SELECT 'Retail', 'DWEL', 5, 1, 0.0000000000, 3.4000000000, 1.0000000000, 0.0000000000, 3.8000000000
UNION ALL SELECT 'Retail', 'DWEL', 6, 1, 0.0000000000, 2.9000000000, 1.0000000000, 0.0000000000, 3.3000000000
UNION ALL SELECT 'Retail', 'DWEL', 7, 1, 0.0000000000, 2.5000000000, 1.0000000000, 0.0000000000, 2.9000000000
UNION ALL SELECT 'Retail', 'DWEL', 8, 1, 0.0000000000, 2.1000000000, 1.0000000000, 0.0000000000, 2.5000000000
UNION ALL SELECT 'Retail', 'DWEL', 9, 1, 0.0000000000, 1.7000000000, 1.0000000000, 0.0000000000, 2.0000000000
UNION ALL SELECT 'Retail', 'DWEL', 10, 1, 0.0000000000, 1.3000000000, 1.0000000000, 0.0000000000, 1.6000000000
UNION ALL SELECT 'Retail', 'DWEL', 11, 1, 0.0000000000, 0.9000000000, 1.0000000000, 0.0000000000, 1.0000000000
UNION ALL SELECT 'Retail', 'DWEL', 12, 1, 0.0000000000, 0.5000000000, 1.0000000000, 0.0000000000, 0.4000000000
UNION ALL SELECT 'Retail', 'DWEL', 13, 1, 0.0000000000, 0.0000000000, 1.0000000000, 0.0000000000, 0.0000000000
UNION ALL SELECT 'Affinity', 'HSDF', 1, 1, 0.0000000000, 7.2000000000, 1.4180000000, 0.0000000000, 0.0000000000
UNION ALL SELECT 'Affinity', 'HSDF', 2, 1, 0.0000000000, 7.2000000000, 1.0420000000, 0.0000000000, 0.0000000000
UNION ALL SELECT 'Affinity', 'HSDF', 3, 1, 0.0000000000, 7.2000000000, 1.0000000000, 0.0000000000, 0.0000000000
UNION ALL SELECT 'Affinity', 'HSDF', 4, 1, 0.0000000000, 6.0000000000, 1.0000000000, 0.0000000000, 0.0000000000
UNION ALL SELECT 'Affinity', 'HSDF', 5, 1, 0.0000000000, 6.0000000000, 1.0000000000, 0.0000000000, 0.0000000000
UNION ALL SELECT 'Affinity', 'HSDF', 6, 1, 0.0000000000, 6.0000000000, 1.0000000000, 0.0000000000, 0.0000000000
UNION ALL SELECT 'Affinity', 'HSDF', 7, 1, 0.0000000000, 5.0000000000, 1.0000000000, 0.0000000000, 0.0000000000
UNION ALL SELECT 'Affinity', 'HSDF', 8, 1, 0.0000000000, 5.0000000000, 1.0000000000, 0.0000000000, 0.0000000000
UNION ALL SELECT 'Affinity', 'HSDF', 9, 1, 0.0000000000, 0.0000000000, 1.0000000000, 0.0000000000, 0.0000000000
UNION ALL SELECT 'Affinity', 'HSDF', 10, 1, 0.0000000000, 0.0000000000, 1.0000000000, 0.0000000000, 0.0000000000
UNION ALL SELECT 'Affinity', 'HSDF', 11, 1, 0.0000000000, 0.0000000000, 1.0000000000, 0.0000000000, 0.0000000000
UNION ALL SELECT 'Affinity', 'HSDF', 12, 1, 0.0000000000, 0.0000000000, 1.0000000000, 0.0000000000, 0.0000000000
UNION ALL SELECT 'Affinity', 'HSDF', 13, 1, 0.0000000000, 0.0000000000, 1.0000000000, 0.0000000000, 0.0000000000
UNION ALL SELECT 'Retail', 'HSDF', 1, 1, 5.6000000000, 7.3000000000, 3.6390000000, 1.4000000000, 23.1000000000
UNION ALL SELECT 'Retail', 'HSDF', 2, 1, 0.7000000000, 7.3000000000, 1.1340000000, 1.4000000000, 23.0000000000
UNION ALL SELECT 'Retail', 'HSDF', 3, 1, 0.0000000000, 6.9000000000, 1.0220000000, 0.4000000000, 18.0000000000
UNION ALL SELECT 'Retail', 'HSDF', 4, 1, 0.0000000000, 6.2000000000, 1.0000000000, 0.1000000000, 11.0000000000
UNION ALL SELECT 'Retail', 'HSDF', 5, 1, 0.0000000000, 5.5000000000, 1.0000000000, 0.1000000000, 10.7000000000
UNION ALL SELECT 'Retail', 'HSDF', 6, 1, 0.0000000000, 4.9000000000, 1.0000000000, 0.1000000000, 9.8000000000
UNION ALL SELECT 'Retail', 'HSDF', 7, 1, 0.0000000000, 4.5000000000, 1.0000000000, 0.0000000000, 8.2000000000
UNION ALL SELECT 'Retail', 'HSDF', 8, 1, 0.0000000000, 3.8000000000, 1.0000000000, 0.0000000000, 7.6000000000
UNION ALL SELECT 'Retail', 'HSDF', 9, 1, 0.0000000000, 3.0000000000, 1.0000000000, 0.0000000000, 5.4000000000
UNION ALL SELECT 'Retail', 'HSDF', 10, 1, 0.0000000000, 2.3000000000, 1.0000000000, 0.0000000000, 4.2000000000
UNION ALL SELECT 'Retail', 'HSDF', 11, 1, 0.0000000000, 1.6000000000, 1.0000000000, 0.0000000000, 3.0000000000
UNION ALL SELECT 'Retail', 'HSDF', 12, 1, 0.0000000000, 0.8000000000, 1.0000000000, 0.0000000000, 1.3000000000
UNION ALL SELECT 'Retail', 'HSDF', 13, 1, 0.0000000000, 0.0000000000, 1.0000000000, 0.0000000000, 0.0000000000
UNION ALL SELECT 'Affinity', 'PAF', 1, 1, 0.0000000000, 0.0000000000, 1.0000000000, 0.0000000000, 0.0000000000
UNION ALL SELECT 'Affinity', 'PAF', 2, 1, 0.0000000000, 0.0000000000, 1.0000000000, 0.0000000000, 0.0000000000
UNION ALL SELECT 'Affinity', 'PAF', 3, 1, 0.0000000000, 0.0000000000, 1.0000000000, 0.0000000000, 0.0000000000
UNION ALL SELECT 'Affinity', 'PAF', 4, 1, 0.0000000000, 0.0000000000, 1.0000000000, 0.0000000000, 0.0000000000
UNION ALL SELECT 'Affinity', 'PAF', 5, 1, 0.0000000000, 0.0000000000, 1.0000000000, 0.0000000000, 0.0000000000
UNION ALL SELECT 'Affinity', 'PAF', 6, 1, 0.0000000000, 0.0000000000, 1.0000000000, 0.0000000000, 0.0000000000
UNION ALL SELECT 'Affinity', 'PAF', 7, 1, 0.0000000000, 0.0000000000, 1.0000000000, 0.0000000000, 0.0000000000
UNION ALL SELECT 'Affinity', 'PAF', 8, 1, 0.0000000000, 0.0000000000, 1.0000000000, 0.0000000000, 0.0000000000
UNION ALL SELECT 'Affinity', 'PAF', 9, 1, 0.0000000000, 0.0000000000, 1.0000000000, 0.0000000000, 0.0000000000
UNION ALL SELECT 'Affinity', 'PAF', 10, 1, 0.0000000000, 0.0000000000, 1.0000000000, 0.0000000000, 0.0000000000
UNION ALL SELECT 'Affinity', 'PAF', 11, 1, 0.0000000000, 0.0000000000, 1.0000000000, 0.0000000000, 0.0000000000
UNION ALL SELECT 'Affinity', 'PAF', 12, 1, 0.0000000000, 0.0000000000, 1.0000000000, 0.0000000000, 0.0000000000
UNION ALL SELECT 'Affinity', 'PAF', 13, 1, 0.0000000000, 0.0000000000, 1.0000000000, 0.0000000000, 0.0000000000
UNION ALL SELECT 'Retail', 'PAF', 1, 1, 5.3000000000, 1.9000000000, 2.6500000000, 0.0000000000, 14.8000000000
UNION ALL SELECT 'Retail', 'PAF', 2, 1, 0.7000000000, 1.9000000000, 2.2710000000, 0.0000000000, 14.8000000000
UNION ALL SELECT 'Retail', 'PAF', 3, 1, 0.0000000000, 1.8000000000, 1.3080000000, 0.0000000000, 12.0000000000
UNION ALL SELECT 'Retail', 'PAF', 4, 1, 0.0000000000, 1.6000000000, 1.0000000000, 0.0000000000, 6.3000000000
UNION ALL SELECT 'Retail', 'PAF', 5, 1, 0.0000000000, 1.3000000000, 1.0000000000, 0.0000000000, 4.6000000000
UNION ALL SELECT 'Retail', 'PAF', 6, 1, 0.0000000000, 1.1000000000, 1.0000000000, 0.0000000000, 0.9000000000
UNION ALL SELECT 'Retail', 'PAF', 7, 1, 0.0000000000, 0.9000000000, 1.0000000000, 0.0000000000, 0.9000000000
UNION ALL SELECT 'Retail', 'PAF', 8, 1, 0.0000000000, 0.8000000000, 1.0000000000, 0.0000000000, 0.9000000000
UNION ALL SELECT 'Retail', 'PAF', 9, 1, 0.0000000000, 0.7000000000, 1.0000000000, 0.0000000000, 0.9000000000
UNION ALL SELECT 'Retail', 'PAF', 10, 1, 0.0000000000, 0.6000000000, 1.0000000000, 0.0000000000, 0.9000000000
UNION ALL SELECT 'Retail', 'PAF', 11, 1, 0.0000000000, 0.6000000000, 1.0000000000, 0.0000000000, 0.0000000000
UNION ALL SELECT 'Retail', 'PAF', 12, 1, 0.0000000000, 0.4000000000, 1.0000000000, 0.0000000000, 0.0000000000
UNION ALL SELECT 'Retail', 'PAF', 13, 1, 0.0000000000, 0.0000000000, 1.0000000000, 0.0000000000, 0.0000000000
UNION ALL SELECT 'Affinity', 'PLUS', 1, 1, 1.7000000000, 3.7000000000, 1.5820000000, 0.0000000000, 3.1000000000
UNION ALL SELECT 'Affinity', 'PLUS', 2, 1, 0.0000000000, 2.9000000000, 1.1280000000, 0.0000000000, 3.1000000000
UNION ALL SELECT 'Affinity', 'PLUS', 3, 1, 0.0000000000, 2.9000000000, 1.0000000000, 0.0000000000, 3.1000000000
UNION ALL SELECT 'Affinity', 'PLUS', 4, 1, 0.0000000000, 2.2000000000, 1.0000000000, 0.0000000000, 3.1000000000
UNION ALL SELECT 'Affinity', 'PLUS', 5, 1, 0.0000000000, 2.2000000000, 1.0000000000, 0.0000000000, 3.1000000000
UNION ALL SELECT 'Affinity', 'PLUS', 6, 1, 0.0000000000, 0.9000000000, 1.0000000000, 0.0000000000, 3.1000000000
UNION ALL SELECT 'Affinity', 'PLUS', 7, 1, 0.0000000000, 0.9000000000, 1.0000000000, 0.0000000000, 1.9000000000
UNION ALL SELECT 'Affinity', 'PLUS', 8, 1, 0.0000000000, 0.0000000000, 1.0000000000, 0.0000000000, 1.4000000000
UNION ALL SELECT 'Affinity', 'PLUS', 9, 1, 0.0000000000, 0.0000000000, 1.0000000000, 0.0000000000, 1.4000000000
UNION ALL SELECT 'Affinity', 'PLUS', 10, 1, 0.0000000000, 0.0000000000, 1.0000000000, 0.0000000000, 0.5000000000
UNION ALL SELECT 'Affinity', 'PLUS', 11, 1, 0.0000000000, 0.0000000000, 1.0000000000, 0.0000000000, 0.0000000000
UNION ALL SELECT 'Affinity', 'PLUS', 12, 1, 0.0000000000, 0.0000000000, 1.0000000000, 0.0000000000, 0.0000000000
UNION ALL SELECT 'Affinity', 'PLUS', 13, 1, 0.0000000000, 0.0000000000, 1.0000000000, 0.0000000000, 0.0000000000
UNION ALL SELECT 'Retail', 'PLUS', 1, 1, 2.1000000000, 3.2000000000, 3.6470000000, 0.1000000000, 4.8000000000
UNION ALL SELECT 'Retail', 'PLUS', 2, 1, 0.2000000000, 2.6000000000, 1.1790000000, 0.1000000000, 4.8000000000
UNION ALL SELECT 'Retail', 'PLUS', 3, 1, 0.0000000000, 2.3000000000, 1.0160000000, 0.1000000000, 3.6000000000
UNION ALL SELECT 'Retail', 'PLUS', 4, 1, 0.0000000000, 2.1000000000, 1.0000000000, 0.0000000000, 2.5000000000
UNION ALL SELECT 'Retail', 'PLUS', 5, 1, 0.0000000000, 1.9000000000, 1.0000000000, 0.0000000000, 2.6000000000
UNION ALL SELECT 'Retail', 'PLUS', 6, 1, 0.0000000000, 1.7000000000, 1.0000000000, 0.0000000000, 2.5000000000
UNION ALL SELECT 'Retail', 'PLUS', 7, 1, 0.0000000000, 1.4000000000, 1.0000000000, 0.0000000000, 2.5000000000
UNION ALL SELECT 'Retail', 'PLUS', 8, 1, 0.0000000000, 1.2000000000, 1.0000000000, 0.0000000000, 2.4000000000
UNION ALL SELECT 'Retail', 'PLUS', 9, 1, 0.0000000000, 1.1000000000, 1.0000000000, 0.0000000000, 2.1000000000
UNION ALL SELECT 'Retail', 'PLUS', 10, 1, 0.0000000000, 0.8000000000, 1.0000000000, 0.0000000000, 1.6000000000
UNION ALL SELECT 'Retail', 'PLUS', 11, 1, 0.0000000000, 0.6000000000, 1.0000000000, 0.0000000000, 0.5000000000
UNION ALL SELECT 'Retail', 'PLUS', 12, 1, 0.0000000000, 0.3000000000, 1.0000000000, 0.0000000000, 0.1000000000
UNION ALL SELECT 'Retail', 'PLUS', 13, 1, 0.0000000000, 0.0000000000, 1.0000000000, 0.0000000000, 0.0000000000
UNION ALL SELECT 'Affinity', 'TNNT', 1, 1, 11.2000000000, 13.5000000000, 1.6840000000, 0.0000000000, 22.1000000000
UNION ALL SELECT 'Affinity', 'TNNT', 2, 1, 0.0000000000, 13.5000000000, 1.0400000000, 0.0000000000, 22.1000000000
UNION ALL SELECT 'Affinity', 'TNNT', 3, 1, 0.0000000000, 12.1000000000, 1.0000000000, 0.0000000000, 20.6000000000
UNION ALL SELECT 'Affinity', 'TNNT', 4, 1, 0.0000000000, 11.6000000000, 1.0000000000, 0.0000000000, 18.1000000000
UNION ALL SELECT 'Affinity', 'TNNT', 5, 1, 0.0000000000, 10.3000000000, 1.0000000000, 0.0000000000, 17.8000000000
UNION ALL SELECT 'Affinity', 'TNNT', 6, 1, 0.0000000000, 7.0000000000, 1.0000000000, 0.0000000000, 16.3000000000
UNION ALL SELECT 'Affinity', 'TNNT', 7, 1, 0.0000000000, 6.1000000000, 1.0000000000, 0.0000000000, 13.8000000000
UNION ALL SELECT 'Affinity', 'TNNT', 8, 1, 0.0000000000, 6.1000000000, 1.0000000000, 0.0000000000, 12.0000000000
UNION ALL SELECT 'Affinity', 'TNNT', 9, 1, 0.0000000000, 5.2000000000, 1.0000000000, 0.0000000000, 11.9000000000
UNION ALL SELECT 'Affinity', 'TNNT', 10, 1, 0.0000000000, 4.0000000000, 1.0000000000, 0.0000000000, 9.1000000000
UNION ALL SELECT 'Affinity', 'TNNT', 11, 1, 0.0000000000, 3.6000000000, 1.0000000000, 0.0000000000, 5.7000000000
UNION ALL SELECT 'Affinity', 'TNNT', 12, 1, 0.0000000000, 1.4000000000, 1.0000000000, 0.0000000000, 2.4000000000
UNION ALL SELECT 'Affinity', 'TNNT', 13, 1, 0.0000000000, 0.0000000000, 1.0000000000, 0.0000000000, 0.0000000000
UNION ALL SELECT 'Retail', 'TNNT', 1, 1, 13.8000000000, 9.4000000000, 2.5720000000, 1.3000000000, 22.5000000000
UNION ALL SELECT 'Retail', 'TNNT', 2, 1, 1.8000000000, 9.3000000000, 1.0600000000, 0.8000000000, 21.8000000000
UNION ALL SELECT 'Retail', 'TNNT', 3, 1, 0.1000000000, 8.5000000000, 1.0060000000, 0.0000000000, 18.1000000000
UNION ALL SELECT 'Retail', 'TNNT', 4, 1, 0.0000000000, 7.7000000000, 1.0000000000, 0.0000000000, 14.8000000000
UNION ALL SELECT 'Retail', 'TNNT', 5, 1, 0.0000000000, 6.9000000000, 1.0000000000, 0.0000000000, 12.9000000000
UNION ALL SELECT 'Retail', 'TNNT', 6, 1, 0.0000000000, 6.0000000000, 1.0000000000, 0.0000000000, 10.9000000000
UNION ALL SELECT 'Retail', 'TNNT', 7, 1, 0.0000000000, 4.9000000000, 1.0000000000, 0.0000000000, 9.6000000000
UNION ALL SELECT 'Retail', 'TNNT', 8, 1, 0.0000000000, 4.0000000000, 1.0000000000, 0.0000000000, 7.4000000000
UNION ALL SELECT 'Retail', 'TNNT', 9, 1, 0.0000000000, 3.2000000000, 1.0000000000, 0.0000000000, 5.9000000000
UNION ALL SELECT 'Retail', 'TNNT', 10, 1, 0.0000000000, 2.4000000000, 1.0000000000, 0.0000000000, 4.1000000000
UNION ALL SELECT 'Retail', 'TNNT', 11, 1, 0.0000000000, 1.7000000000, 1.0000000000, 0.0000000000, 2.4000000000
UNION ALL SELECT 'Retail', 'TNNT', 12, 1, 0.0000000000, 0.8000000000, 1.0000000000, 0.0000000000, 1.4000000000
UNION ALL SELECT 'Retail', 'TNNT', 13, 1, 0.0000000000, 0.0000000000, 1.0000000000, 0.0000000000, 0.0000000000
UNION ALL SELECT 'Affinity', 'VOL', 1, 1, 3.6000000000, 9.6000000000, 1.7370000000, 0.4000000000, 15.5000000000
UNION ALL SELECT 'Affinity', 'VOL', 2, 1, 0.4000000000, 8.7000000000, 1.0350000000, 0.4000000000, 15.5000000000
UNION ALL SELECT 'Affinity', 'VOL', 3, 1, 0.0000000000, 7.6000000000, 1.0100000000, 0.0000000000, 15.1000000000
UNION ALL SELECT 'Affinity', 'VOL', 4, 1, 0.0000000000, 6.6000000000, 1.0000000000, 0.0000000000, 14.1000000000
UNION ALL SELECT 'Affinity', 'VOL', 5, 1, 0.0000000000, 5.7000000000, 1.0000000000, 0.0000000000, 14.4000000000
UNION ALL SELECT 'Affinity', 'VOL', 6, 1, 0.0000000000, 5.5000000000, 1.0000000000, 0.0000000000, 12.6000000000
UNION ALL SELECT 'Affinity', 'VOL', 7, 1, 0.0000000000, 4.4000000000, 1.0000000000, 0.0000000000, 11.0000000000
UNION ALL SELECT 'Affinity', 'VOL', 8, 1, 0.0000000000, 3.9000000000, 1.0000000000, 0.0000000000, 9.9000000000
UNION ALL SELECT 'Affinity', 'VOL', 9, 1, 0.0000000000, 3.0000000000, 1.0000000000, 0.0000000000, 8.1000000000
UNION ALL SELECT 'Affinity', 'VOL', 10, 1, 0.0000000000, 2.1000000000, 1.0000000000, 0.0000000000, 5.5000000000
UNION ALL SELECT 'Affinity', 'VOL', 11, 1, 0.0000000000, 0.9000000000, 1.0000000000, 0.0000000000, 3.5000000000
UNION ALL SELECT 'Affinity', 'VOL', 12, 1, 0.0000000000, 0.0000000000, 1.0000000000, 0.0000000000, 1.0000000000
UNION ALL SELECT 'Affinity', 'VOL', 13, 1, 0.0000000000, 0.0000000000, 1.0000000000, 0.0000000000, 0.0000000000
UNION ALL SELECT 'Retail', 'VOL', 1, 1, 6.1000000000, 10.5000000000, 2.1400000000, 3.1000000000, 20.5000000000
UNION ALL SELECT 'Retail', 'VOL', 2, 1, 0.9000000000, 9.2000000000, 1.0130000000, 1.4000000000, 20.3000000000
UNION ALL SELECT 'Retail', 'VOL', 3, 1, 0.1000000000, 8.6000000000, 1.0030000000, 0.2000000000, 18.5000000000
UNION ALL SELECT 'Retail', 'VOL', 4, 1, 0.0000000000, 7.9000000000, 1.0000000000, 0.0000000000, 16.5000000000
UNION ALL SELECT 'Retail', 'VOL', 5, 1, 0.0000000000, 7.1000000000, 1.0000000000, 0.0000000000, 14.8000000000
UNION ALL SELECT 'Retail', 'VOL', 6, 1, 0.0000000000, 6.4000000000, 1.0000000000, 0.0000000000, 13.6000000000
UNION ALL SELECT 'Retail', 'VOL', 7, 1, 0.0000000000, 5.6000000000, 1.0000000000, 0.0000000000, 12.2000000000
UNION ALL SELECT 'Retail', 'VOL', 8, 1, 0.0000000000, 4.8000000000, 1.0000000000, 0.0000000000, 10.5000000000
UNION ALL SELECT 'Retail', 'VOL', 9, 1, 0.0000000000, 4.0000000000, 1.0000000000, 0.0000000000, 8.8000000000
UNION ALL SELECT 'Retail', 'VOL', 10, 1, 0.0000000000, 3.2000000000, 1.0000000000, 0.0000000000, 7.1000000000
UNION ALL SELECT 'Retail', 'VOL', 11, 1, 0.0000000000, 2.2000000000, 1.0000000000, 0.0000000000, 4.7000000000
UNION ALL SELECT 'Retail', 'VOL', 12, 1, 0.0000000000, 1.4000000000, 1.0000000000, 0.0000000000, 2.9000000000
UNION ALL SELECT 'Retail', 'VOL', 13, 1, 0.0000000000, 0.0000000000, 1.0000000000, 0.0000000000, 0.0000000000

INSERT INTO CNFG_MSTR_FM_DECODE
(CMFD_FM, CMFD_CD, CMFD_DESC, CMFD_BPM_SEG_NM, CMFD_BPM_PRDCT_NM)
SELECT '101', 'VOL', 'Voluntary Auto', 'Auto', 'Standard'
UNION ALL SELECT '202', 'VOL', 'Voluntary Auto - Basic Policies', 'Auto', 'Basic'
UNION ALL SELECT '311', 'PLUS', 'Umbrella Liability', 'Other', 'PLUS'
UNION ALL SELECT '501', 'HSDF', 'Dwelling Fire', 'Other', 'Dwelling/Fire'
UNION ALL SELECT '502', 'HSDF', 'Dwelling Fire', 'Other', 'Dwelling/Fire'
UNION ALL SELECT '503', 'HSDF', 'Dwelling Fire', 'Other', 'Dwelling/Fire'
UNION ALL SELECT '632', 'DWEL', 'Homeowners - Broad', 'Homeowners', 'Dwelling'
UNION ALL SELECT '633', 'DWEL', 'Homeowners - Special', 'Homeowners', 'Dwelling'
UNION ALL SELECT '636', 'COND', 'Condominium Owner', 'Homeowners', 'Condo'
UNION ALL SELECT '661', 'HSDF', 'Homesaver - Homeowners', 'Other', 'Homesavers'
UNION ALL SELECT '662', 'HSDF', 'Homesaver - Condominium Owner', 'Other', 'Homesavers'
UNION ALL SELECT '663', 'HSDF', 'Homesaver - Renters/Tenant - Dwelling', 'Other', 'Homesavers'
UNION ALL SELECT '664', 'HSDF', 'Homesaver - Rental Condominium', 'Other', 'Homesavers'
UNION ALL SELECT '665', 'HSDF', 'Homesaver - Renters/Tenant - Apt', 'Other', 'Homesavers'
UNION ALL SELECT '700', 'PAF', 'Personal Articles Floater', 'Other', 'PAF'
UNION ALL SELECT '634', 'TNNT', 'Renters/Tenant - Dwel', 'Homeowners', 'Tenants'

INSERT INTO CNFG_MSTR_MKT_DECODE
(CMMD_MKT_CD, CMMD_SUB_MKT, CMMD_CHNL_NM, CMMD_SUB_MKT_DESC, CMMD_CHNL_GRP_NM, CMMD_MKT_USER_GRP)
SELECT 'AF', 'AGT', 'Affinity', 'Affinity Agency', 'Affinity', 'Voluntary'
UNION ALL SELECT 'RT', 'NAS', 'Retail', 'NAS/ESP Small Group', 'Retail', 'Voluntary'
UNION ALL SELECT 'IV', 'AR', 'Involuntary', 'Assigned Risk', 'AIP', 'Involuntary'
UNION ALL SELECT 'DI', 'CC', 'Direct Business', 'Commercial Credit X Sell', 'Runoff', 'Voluntary'
UNION ALL SELECT 'OM', 'OM', 'Ocean Marine', 'Ocean Marine', 'Other', 'Voluntary'
UNION ALL SELECT 'CB', 'CCD', 'Citibank', 'Credit Cards', 'Runoff', 'Voluntary'
UNION ALL SELECT 'AF', 'FAGT', 'Affinity', 'Affinity Facility Agency', 'Affinity', 'Exclude'
UNION ALL SELECT 'AF', 'DI', 'Affinity', 'Affinity Direct', 'Affinity', 'Voluntary'
UNION ALL SELECT 'AF', 'FDI', 'Affinity', 'Affinity Facility Direct', 'Affinity', 'Exclude'
UNION ALL SELECT 'AF', 'COS', 'Affinity', 'Affinity CostCo', 'Runoff', 'Voluntary'
UNION ALL SELECT 'AF', 'FCOS', 'Affinity', 'Affinity Facility CostCo', 'Runoff', 'Exclude'
UNION ALL SELECT 'AF', 'TEI', 'Affinity', 'Affinity TEIS', 'Affinity', 'Voluntary'
UNION ALL SELECT 'AF', 'FTEI', 'Affinity', 'Affinity TEIS Facility', 'Affinity', 'Exclude'
UNION ALL SELECT 'AF', 'FLD', 'Affinity', 'Affinity Field Office', 'Affinity', 'Voluntary'
UNION ALL SELECT 'AF', 'FFLD', 'Affinity', 'Affinity Field Office Facility', 'Affinity', 'Exclude'
UNION ALL SELECT 'AF', 'AAA', 'Affinity', 'Affinity Triple A', 'Affinity', 'Voluntary'
UNION ALL SELECT 'AF', 'FAAA', 'Affinity', 'Affinity Triple A Facility', 'Affinity', 'Exclude'
UNION ALL SELECT 'AF', 'LEN', 'Affinity', 'Affinity Lender Marketing', 'Affinity', 'Voluntary'
UNION ALL SELECT 'AF', 'FLEN', 'Affinity', 'Affinity Lender Marketing Facility', 'Affinity', 'Exclude'
UNION ALL SELECT 'IV', 'FAC', 'Involuntary', 'Facility', 'AIP', 'Exclude'
UNION ALL SELECT 'IV', 'JUA', 'Involuntary', 'Joint Underwriting Association', 'AIP', 'Involuntary'
UNION ALL SELECT 'IV', 'PJUA', 'Involuntary', 'Participating JUA', 'AIP', 'Involuntary'
UNION ALL SELECT 'IV', 'FNAS', 'Involuntary', 'NAS/ESP Facility', 'AIP', 'Exclude'
UNION ALL SELECT 'DI', 'FCC', 'Direct Business', 'Commercial Credit X Sell Facility', 'Runoff', 'Exclude'
UNION ALL SELECT 'DI', 'PCC', 'Direct Business', 'Commercial Credit PFS X Sell', 'Runoff', 'Voluntary'
UNION ALL SELECT 'DI', 'PFS', 'Direct Business', 'Primerica Financial Services X Sell', 'Runoff', 'Voluntary'
UNION ALL SELECT 'DI', 'FPFS', 'Direct Business', 'Primerica Financial Services X Sell Facility', 'Runoff', 'Exclude'
UNION ALL SELECT 'DI', 'WEB', 'Direct Business', 'Internet Business', 'Affinity', 'Voluntary'
UNION ALL SELECT 'RT', 'RT', 'Retail', 'Retail', 'Retail', 'Voluntary'
UNION ALL SELECT 'RT', 'JUA', 'Retail', 'Florida Domestic', 'Retail', 'Voluntary'
UNION ALL SELECT 'RT', 'FSG', 'Retail', 'Small Group Facility', 'Retail', 'Exclude'
UNION ALL SELECT 'RT', 'BKS', 'Retail', 'Bankers & Shippers', 'Retail', 'Voluntary'
UNION ALL SELECT 'RT', 'GEICO', 'GEICO', 'GEICO (o/t Florida)', 'GEICO', 'Voluntary'
UNION ALL SELECT 'RT', 'SG', 'Retail', 'Small Group', 'Retail', 'Voluntary'
UNION ALL SELECT 'CB', 'FCCD', 'Citibank', 'Credit Cards Facility', 'Runoff', 'Exclude'
UNION ALL SELECT 'OM', 'GEICO', 'GEICO', 'GEICO', 'GEICO', 'Voluntary'
UNION ALL SELECT 'AF', 'JUA', 'Affinity', 'Affinity JUA', 'AIP', 'Involuntary'

INSERT INTO CNFG_MSTR_ST_NM
(CMSN_ST_CD, CMSN_ST_NM, CMSN_SPC)
SELECT 'AK', 'Alaska', 'No'
UNION ALL SELECT 'AL', 'Alabama', 'Yes'
UNION ALL SELECT 'AR', 'Arkansas', 'Yes'
UNION ALL SELECT 'AZ', 'Arizona', 'Yes'
UNION ALL SELECT 'CA', 'California', 'No'
UNION ALL SELECT 'CO', 'Colorado', 'Yes'
UNION ALL SELECT 'CT', 'Connecticut', 'Yes'
UNION ALL SELECT 'DC', 'District of Columbia', 'Yes'
UNION ALL SELECT 'DE', 'Delaware', 'No'
UNION ALL SELECT 'GA', 'Georgia', 'Yes'
UNION ALL SELECT 'HI', 'Hawaii', 'No'
UNION ALL SELECT 'IA', 'Iowa', 'No'
UNION ALL SELECT 'ID', 'Idaho', 'Yes'
UNION ALL SELECT 'IL', 'Illinois', 'Yes'
UNION ALL SELECT 'IN', 'Indiana', 'Yes'
UNION ALL SELECT 'KS', 'Kansas', 'Yes'
UNION ALL SELECT 'KY', 'Kentucky', 'Yes'
UNION ALL SELECT 'LA', 'Louisiana', 'No'
UNION ALL SELECT 'MA', 'Massachusetts', 'No'
UNION ALL SELECT 'MD', 'Maryland', 'Yes'
UNION ALL SELECT 'ME', 'Maine', 'Yes'
UNION ALL SELECT 'MI', 'Michigan', 'No'
UNION ALL SELECT 'MN', 'Minnesota', 'Yes'
UNION ALL SELECT 'MO', 'Missouri', 'Yes'
UNION ALL SELECT 'MS', 'Mississippi', 'Yes'
UNION ALL SELECT 'MT', 'Montana', 'Yes'
UNION ALL SELECT 'NC', 'North Carolina', 'Yes'
UNION ALL SELECT 'ND', 'North Dakota', 'No'
UNION ALL SELECT 'NE', 'Nebraska', 'No'
UNION ALL SELECT 'NH', 'New Hampshire', 'Yes'
UNION ALL SELECT 'NM', 'New Mexico', 'Yes'
UNION ALL SELECT 'NV', 'Nevada', 'Yes'
UNION ALL SELECT 'NY', 'New York', 'Yes'
UNION ALL SELECT 'OH', 'Ohio', 'Yes'
UNION ALL SELECT 'OK', 'Oklahoma', 'Yes'
UNION ALL SELECT 'OR', 'Oregon', 'Yes'
UNION ALL SELECT 'PA', 'Pennsylvania', 'Yes'
UNION ALL SELECT 'RI', 'Rhode Island', 'Yes'
UNION ALL SELECT 'SC', 'South Carolina', 'Yes'
UNION ALL SELECT 'SD', 'South Dakota', 'No'
UNION ALL SELECT 'TN', 'Tennessee', 'Yes'
UNION ALL SELECT 'TX', 'Texas', 'Yes'
UNION ALL SELECT 'UT', 'Utah', 'Yes'
UNION ALL SELECT 'VA', 'Virginia', 'Yes'
UNION ALL SELECT 'VT', 'Vermont', 'No'
UNION ALL SELECT 'WA', 'Washington', 'No'
UNION ALL SELECT 'WI', 'Wisconsin', 'Yes'
UNION ALL SELECT 'WV', 'West Virginia', 'No'
UNION ALL SELECT 'WY', 'Wyoming', 'No'
UNION ALL SELECT 'FL', 'Florida', 'Yes'
UNION ALL SELECT 'NJ', 'New Jersey', 'No'
UNION ALL SELECT 'XX', 'All Other', 'No'

INSERT INTO CNFG_MSTR_ZIPCD
(CMZ_ST_CD, CMZ_ZIP_CD, CMZ_LCL_MKT_TR, CMZ_LCL_MKT_TR_PLN)
SELECT 'NJ', '08824', 'North', 'North'
UNION ALL SELECT 'NJ', '08828', 'North', 'North'
UNION ALL SELECT 'NJ', '08830', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '08831', 'North', 'North'
UNION ALL SELECT 'NJ', '08832', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '08837', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '08840', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '08846', 'North', 'North'
UNION ALL SELECT 'NJ', '08850', 'North', 'North'
UNION ALL SELECT 'NJ', '08852', 'North', 'North'
UNION ALL SELECT 'NJ', '08854', 'North', 'North'
UNION ALL SELECT 'NJ', '08855', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '08857', 'North', 'Coast F'
UNION ALL SELECT 'NJ', '08859', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '08861', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '08862', 'Coast', 'Unsupported'
UNION ALL SELECT 'NJ', '08863', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '08871', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '08872', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '08878', 'Coast', 'Unsupported'
UNION ALL SELECT 'NJ', '08879', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '08882', 'North', 'Coast F'
UNION ALL SELECT 'NJ', '08884', 'North', 'North'
UNION ALL SELECT 'NJ', '08899', 'North', 'North'
UNION ALL SELECT 'NJ', '08901', 'North', 'North'
UNION ALL SELECT 'NJ', '08902', 'North', 'North'
UNION ALL SELECT 'NJ', '08903', 'North', 'North'
UNION ALL SELECT 'NJ', '08904', 'North', 'North'
UNION ALL SELECT 'NJ', '08905', 'North', 'North'
UNION ALL SELECT 'NJ', '08906', 'North', 'North'
UNION ALL SELECT 'NJ', '08922', 'North', 'North'
UNION ALL SELECT 'NJ', '08933', 'North', 'North'
UNION ALL SELECT 'NJ', '08988', 'North', 'North'
UNION ALL SELECT 'NJ', '08989', 'North', 'North'
UNION ALL SELECT 'NJ', '07701', 'Coast', 'Coast C'
UNION ALL SELECT 'NJ', '07702', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '07703', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '07704', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '07709', 'Coast', 'Coast C'
UNION ALL SELECT 'NJ', '07710', 'North Metro', 'Coast C'
UNION ALL SELECT 'NJ', '07711', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '07712', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '07715', 'Coast', 'Coast C'
UNION ALL SELECT 'NJ', '07716', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '07717', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '07718', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '07719', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '07720', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '07721', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '07722', 'North', 'Coast CF'
UNION ALL SELECT 'NJ', '07723', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '07724', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '07726', 'North', 'Coast CF'
UNION ALL SELECT 'NJ', '07727', 'North', 'Coast CF'
UNION ALL SELECT 'NJ', '07728', 'North', 'Coast CF'
UNION ALL SELECT 'NJ', '07730', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '07731', 'North', 'Coast CF'
UNION ALL SELECT 'NJ', '07732', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '07733', 'North', 'Coast CF'
UNION ALL SELECT 'NJ', '07734', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '07735', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '07737', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '07738', 'North', 'Coast CF'
UNION ALL SELECT 'NJ', '07739', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '07740', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '07746', 'North', 'Coast CF'
UNION ALL SELECT 'NJ', '07747', 'North', 'Coast CF'
UNION ALL SELECT 'NJ', '07748', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '07750', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '07751', 'North', 'Coast CF'
UNION ALL SELECT 'NJ', '07752', 'South', 'Coast C'
UNION ALL SELECT 'NJ', '07753', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '07754', 'South', 'Coast C'
UNION ALL SELECT 'NJ', '07755', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '07756', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '07757', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '07758', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '07760', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '07762', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '07763', 'North Metro', 'Coast C'
UNION ALL SELECT 'NJ', '07764', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '07765', 'North', 'Coast C'
UNION ALL SELECT 'NJ', '07777', 'North', 'Coast C'
UNION ALL SELECT 'NJ', '07799', 'North Metro', 'Coast C'
UNION ALL SELECT 'NJ', '08501', 'South', 'Coast C'
UNION ALL SELECT 'NJ', '08510', 'North', 'Coast CF'
UNION ALL SELECT 'NJ', '08514', 'South', 'Coast CF'
UNION ALL SELECT 'NJ', '08526', 'South', 'Coast CF'
UNION ALL SELECT 'NJ', '08535', 'North', 'Coast C'
UNION ALL SELECT 'NJ', '08555', 'North Metro', 'Coast C'
UNION ALL SELECT 'NJ', '08720', 'North Metro', 'Coast C'
UNION ALL SELECT 'NJ', '08730', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08736', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08750', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '07005', 'North', 'North'
UNION ALL SELECT 'NJ', '07034', 'North', 'North'
UNION ALL SELECT 'NJ', '07035', 'North', 'North'
UNION ALL SELECT 'NJ', '07045', 'North', 'North'
UNION ALL SELECT 'NJ', '07046', 'North', 'North'
UNION ALL SELECT 'NJ', '07054', 'North', 'North'
UNION ALL SELECT 'NJ', '07058', 'North', 'North'
UNION ALL SELECT 'NJ', '07082', 'North', 'North'
UNION ALL SELECT 'NJ', '07405', 'North', 'North'
UNION ALL SELECT 'NJ', '07440', 'North', 'North'
UNION ALL SELECT 'NJ', '07444', 'North', 'North'
UNION ALL SELECT 'NJ', '07457', 'North', 'North'
UNION ALL SELECT 'NJ', '07801', 'North', 'North'
UNION ALL SELECT 'NJ', '07802', 'North', 'North'
UNION ALL SELECT 'NJ', '07803', 'North', 'North'
UNION ALL SELECT 'NJ', '07806', 'North', 'North'
UNION ALL SELECT 'NJ', '07828', 'North', 'North'
UNION ALL SELECT 'NJ', '07834', 'North', 'North'
UNION ALL SELECT 'NJ', '07836', 'North', 'North'
UNION ALL SELECT 'NJ', '07842', 'North', 'North'
UNION ALL SELECT 'NJ', '07845', 'North', 'North'
UNION ALL SELECT 'NJ', '07847', 'North', 'North'
UNION ALL SELECT 'NJ', '07849', 'North', 'North'
UNION ALL SELECT 'NJ', '07850', 'North', 'North'
UNION ALL SELECT 'NJ', '07852', 'North', 'North'
UNION ALL SELECT 'NJ', '07853', 'North', 'North'
UNION ALL SELECT 'NJ', '07856', 'North', 'North'
UNION ALL SELECT 'NJ', '07857', 'North', 'North'
UNION ALL SELECT 'NJ', '07866', 'North', 'North'
UNION ALL SELECT 'NJ', '07869', 'North', 'North'
UNION ALL SELECT 'NJ', '07870', 'North', 'North'
UNION ALL SELECT 'NJ', '07876', 'North', 'North'
UNION ALL SELECT 'NJ', '07878', 'North', 'North'
UNION ALL SELECT 'NJ', '07885', 'North', 'North'
UNION ALL SELECT 'NJ', '07926', 'North', 'North'
UNION ALL SELECT 'NJ', '07927', 'North', 'North'
UNION ALL SELECT 'NJ', '07928', 'North', 'North'
UNION ALL SELECT 'NJ', '07930', 'North', 'North'
UNION ALL SELECT 'NJ', '07932', 'North', 'North'
UNION ALL SELECT 'NJ', '07933', 'North', 'North'
UNION ALL SELECT 'NJ', '07935', 'North', 'North'
UNION ALL SELECT 'NJ', '07936', 'North', 'North'
UNION ALL SELECT 'NJ', '07940', 'North', 'North'
UNION ALL SELECT 'NJ', '07945', 'North', 'North'
UNION ALL SELECT 'NJ', '07946', 'North', 'North'
UNION ALL SELECT 'NJ', '07950', 'North', 'North'
UNION ALL SELECT 'NJ', '07960', 'North', 'North'
UNION ALL SELECT 'NJ', '07961', 'North', 'North'
UNION ALL SELECT 'NJ', '07962', 'North', 'North'
UNION ALL SELECT 'NJ', '07963', 'North', 'North'
UNION ALL SELECT 'NJ', '07970', 'North', 'North'
UNION ALL SELECT 'NJ', '07976', 'North', 'North'
UNION ALL SELECT 'NJ', '07980', 'North', 'North'
UNION ALL SELECT 'NJ', '07981', 'North', 'North'
UNION ALL SELECT 'NJ', '07983', 'North', 'North'
UNION ALL SELECT 'NJ', '07999', 'North', 'North'
UNION ALL SELECT 'NJ', '08005', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08006', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08008', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08050', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08087', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08092', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08527', 'South', 'Coast CF'
UNION ALL SELECT 'NJ', '08533', 'South', 'Coast CF'
UNION ALL SELECT 'NJ', '08701', 'South', 'Coast CF'
UNION ALL SELECT 'NJ', '08721', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08722', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08723', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08724', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08731', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08732', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08733', 'South', 'Coast CF'
UNION ALL SELECT 'NJ', '08734', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08735', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08738', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08739', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08740', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08741', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08742', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08751', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08752', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08753', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08754', 'Coast', 'Coast C'
UNION ALL SELECT 'NJ', '08755', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08756', 'Coast', 'Coast C'
UNION ALL SELECT 'NJ', '08757', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08758', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08759', 'South', 'Coast CF'
UNION ALL SELECT 'NJ', '07011', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07012', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07013', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07014', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07015', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07055', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07403', 'North', 'North'
UNION ALL SELECT 'NJ', '07420', 'North', 'North'
UNION ALL SELECT 'NJ', '07421', 'North', 'North'
UNION ALL SELECT 'NJ', '07424', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07435', 'North', 'North'
UNION ALL SELECT 'NJ', '07438', 'North', 'North'
UNION ALL SELECT 'NJ', '07442', 'North', 'North'
UNION ALL SELECT 'NJ', '07456', 'North', 'North'
UNION ALL SELECT 'NJ', '07465', 'North', 'North'
UNION ALL SELECT 'NJ', '07470', 'North', 'North'
UNION ALL SELECT 'NJ', '07474', 'North', 'North'
UNION ALL SELECT 'NJ', '07477', 'North', 'North'
UNION ALL SELECT 'NJ', '07480', 'North', 'North'
UNION ALL SELECT 'NJ', '07501', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07502', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07503', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07504', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07505', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07506', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07507', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07508', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07509', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07510', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07511', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07512', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07513', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07514', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07522', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07524', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07533', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07538', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07543', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07544', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '08001', 'South', 'South'
UNION ALL SELECT 'NJ', '08023', 'South', 'South'
UNION ALL SELECT 'NJ', '08038', 'South', 'South'
UNION ALL SELECT 'NJ', '08067', 'South', 'Coast F'
UNION ALL SELECT 'NJ', '08069', 'South', 'Coast F'
UNION ALL SELECT 'NJ', '08070', 'South', 'Coast F'
UNION ALL SELECT 'NJ', '08072', 'South', 'South'
UNION ALL SELECT 'NJ', '08079', 'South', 'Coast F'
UNION ALL SELECT 'NJ', '08098', 'South', 'South'
UNION ALL SELECT 'NJ', '08318', 'South', 'South'
UNION ALL SELECT 'NJ', '08343', 'South', 'South'
UNION ALL SELECT 'NJ', '08347', 'South', 'South'
UNION ALL SELECT 'NJ', '07059', 'North', 'North'
UNION ALL SELECT 'NJ', '07060', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07920', 'North', 'North'
UNION ALL SELECT 'NJ', '07921', 'North', 'North'
UNION ALL SELECT 'NJ', '07924', 'North', 'North'
UNION ALL SELECT 'NJ', '07931', 'North', 'North'
UNION ALL SELECT 'NJ', '07934', 'North', 'North'
UNION ALL SELECT 'NJ', '07938', 'North', 'North'
UNION ALL SELECT 'NJ', '07939', 'North', 'North'
UNION ALL SELECT 'NJ', '07977', 'North', 'North'
UNION ALL SELECT 'NJ', '07978', 'North', 'North'
UNION ALL SELECT 'NJ', '08502', 'North', 'North'
UNION ALL SELECT 'NJ', '08504', 'North', 'North'
UNION ALL SELECT 'NJ', '08528', 'North', 'North'
UNION ALL SELECT 'NJ', '08553', 'North', 'North'
UNION ALL SELECT 'NJ', '08558', 'North', 'North'
UNION ALL SELECT 'NJ', '08805', 'North', 'North'
UNION ALL SELECT 'NJ', '08807', 'North', 'North'
UNION ALL SELECT 'NJ', '08821', 'North', 'North'
UNION ALL SELECT 'NJ', '08823', 'North', 'North'
UNION ALL SELECT 'NJ', '08835', 'North', 'North'
UNION ALL SELECT 'NJ', '08836', 'North', 'North'
UNION ALL SELECT 'NJ', '08853', 'North', 'North'
UNION ALL SELECT 'NJ', '08869', 'North', 'North'
UNION ALL SELECT 'NJ', '08873', 'North', 'North'
UNION ALL SELECT 'NJ', '08875', 'North', 'North'
UNION ALL SELECT 'NJ', '08876', 'North', 'North'
UNION ALL SELECT 'NJ', '08877', 'North', 'North'
UNION ALL SELECT 'NJ', '08880', 'North', 'North'
UNION ALL SELECT 'NJ', '08890', 'North', 'North'
UNION ALL SELECT 'NJ', '07416', 'North', 'North'
UNION ALL SELECT 'NJ', '07418', 'North', 'North'
UNION ALL SELECT 'NJ', '07419', 'North', 'North'
UNION ALL SELECT 'NJ', '07422', 'North', 'North'
UNION ALL SELECT 'NJ', '07428', 'North', 'North'
UNION ALL SELECT 'NJ', '07439', 'North', 'North'
UNION ALL SELECT 'NJ', '07460', 'North', 'North'
UNION ALL SELECT 'NJ', '07461', 'North', 'North'
UNION ALL SELECT 'NJ', '07462', 'North', 'North'
UNION ALL SELECT 'NJ', '07821', 'North', 'North'
UNION ALL SELECT 'NJ', '07822', 'North', 'North'
UNION ALL SELECT 'NJ', '07826', 'North', 'North'
UNION ALL SELECT 'NJ', '07827', 'North', 'North'
UNION ALL SELECT 'NJ', '07837', 'North', 'North'
UNION ALL SELECT 'NJ', '07839', 'North', 'North'
UNION ALL SELECT 'NJ', '07843', 'North', 'North'
UNION ALL SELECT 'NJ', '07848', 'North', 'North'
UNION ALL SELECT 'NJ', '07851', 'North', 'North'
UNION ALL SELECT 'NJ', '07855', 'North', 'North'
UNION ALL SELECT 'NJ', '07860', 'North', 'North'
UNION ALL SELECT 'NJ', '07871', 'North', 'North'
UNION ALL SELECT 'NJ', '07874', 'North', 'North'
UNION ALL SELECT 'NJ', '07875', 'North', 'North'
UNION ALL SELECT 'NJ', '07877', 'North', 'North'
UNION ALL SELECT 'NJ', '07879', 'North', 'North'
UNION ALL SELECT 'NJ', '07881', 'North', 'North'
UNION ALL SELECT 'NJ', '07890', 'North', 'North'
UNION ALL SELECT 'NJ', '07016', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07023', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07027', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07033', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07036', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '07061', 'North', 'North'
UNION ALL SELECT 'NJ', '07062', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07063', 'North', 'North'
UNION ALL SELECT 'NJ', '07065', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '07066', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '07076', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07081', 'North', 'North'
UNION ALL SELECT 'NJ', '07083', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07088', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07090', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07091', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07092', 'North', 'North'
UNION ALL SELECT 'NJ', '07201', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '07202', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '07203', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '07204', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07205', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07206', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '07207', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07208', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '07901', 'North', 'North'
UNION ALL SELECT 'NJ', '07902', 'North', 'North'
UNION ALL SELECT 'NJ', '07922', 'North', 'North'
UNION ALL SELECT 'NJ', '07974', 'North', 'North'
UNION ALL SELECT 'NJ', '07820', 'North', 'North'
UNION ALL SELECT 'NJ', '07823', 'North', 'North'
UNION ALL SELECT 'NJ', '07825', 'North', 'North'
UNION ALL SELECT 'NJ', '07829', 'North', 'North'
UNION ALL SELECT 'NJ', '07831', 'North', 'North'
UNION ALL SELECT 'NJ', '07832', 'North', 'North'
UNION ALL SELECT 'NJ', '07833', 'North', 'North'
UNION ALL SELECT 'NJ', '07838', 'North', 'North'
UNION ALL SELECT 'NJ', '07840', 'North', 'North'
UNION ALL SELECT 'NJ', '07844', 'North', 'North'
UNION ALL SELECT 'NJ', '07846', 'North', 'North'
UNION ALL SELECT 'NJ', '07863', 'North', 'North'
UNION ALL SELECT 'NJ', '07865', 'North', 'North'
UNION ALL SELECT 'NJ', '07880', 'North', 'North'
UNION ALL SELECT 'NJ', '07882', 'North', 'North'
UNION ALL SELECT 'NJ', '08802', 'North', 'North'
UNION ALL SELECT 'NJ', '08808', 'North', 'North'
UNION ALL SELECT 'NJ', '08865', 'North', 'North'
UNION ALL SELECT 'NJ', '08886', 'North', 'North'
UNION ALL SELECT 'NJ', '08405', 'Coast', 'Coast C'
UNION ALL SELECT 'NJ', '07677', 'North', 'North'
UNION ALL SELECT 'NJ', '07676', 'North', 'North'
UNION ALL SELECT 'NJ', '08205', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08844', 'North', 'North'
UNION ALL SELECT 'NJ', '07069', 'North', 'North'
UNION ALL SELECT 'NJ', '07086', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '08037', 'South', 'Coast CF'
UNION ALL SELECT 'NJ', '08201', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08203', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08213', 'South', 'Coast C'
UNION ALL SELECT 'NJ', '08215', 'South', 'Coast CF'
UNION ALL SELECT 'NJ', '08217', 'South', 'Coast C'
UNION ALL SELECT 'NJ', '08220', 'Coast', 'Coast C'
UNION ALL SELECT 'NJ', '08221', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08225', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08231', 'South', 'Coast C'
UNION ALL SELECT 'NJ', '08232', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08234', 'South', 'Coast CF'
UNION ALL SELECT 'NJ', '08240', 'South', 'Coast C'
UNION ALL SELECT 'NJ', '08241', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08244', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08310', 'South', 'Coast CF'
UNION ALL SELECT 'NJ', '08317', 'South', 'Coast CF'
UNION ALL SELECT 'NJ', '08319', 'South', 'Coast CF'
UNION ALL SELECT 'NJ', '08326', 'South', 'Coast CF'
UNION ALL SELECT 'NJ', '08330', 'South', 'Coast CF'
UNION ALL SELECT 'NJ', '08340', 'South', 'Coast CF'
UNION ALL SELECT 'NJ', '08341', 'South', 'Coast CF'
UNION ALL SELECT 'NJ', '08342', 'South', 'Coast C'
UNION ALL SELECT 'NJ', '08346', 'South', 'Coast CF'
UNION ALL SELECT 'NJ', '08350', 'South', 'Coast CF'
UNION ALL SELECT 'NJ', '08360', 'South', 'Coast C'
UNION ALL SELECT 'NJ', '08401', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08402', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08403', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08404', 'Coast', 'Coast C'
UNION ALL SELECT 'NJ', '08406', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '07010', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '07020', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '07022', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '07024', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '07026', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07031', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07057', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07070', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07071', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07072', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07073', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07074', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07075', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07401', 'North', 'North'
UNION ALL SELECT 'NJ', '07407', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07410', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07417', 'North', 'North'
UNION ALL SELECT 'NJ', '07423', 'North', 'North'
UNION ALL SELECT 'NJ', '07430', 'North', 'North'
UNION ALL SELECT 'NJ', '07432', 'North', 'North'
UNION ALL SELECT 'NJ', '07436', 'North', 'North'
UNION ALL SELECT 'NJ', '07446', 'North', 'North'
UNION ALL SELECT 'NJ', '07450', 'North', 'North'
UNION ALL SELECT 'NJ', '07451', 'North', 'North'
UNION ALL SELECT 'NJ', '07452', 'North', 'North'
UNION ALL SELECT 'NJ', '07458', 'North', 'North'
UNION ALL SELECT 'NJ', '07463', 'North', 'North'
UNION ALL SELECT 'NJ', '07481', 'North', 'North'
UNION ALL SELECT 'NJ', '07495', 'North', 'North'
UNION ALL SELECT 'NJ', '07498', 'North', 'North'
UNION ALL SELECT 'NJ', '07601', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07602', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07603', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07604', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07605', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '07606', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07607', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07608', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07620', 'North', 'Coast F'
UNION ALL SELECT 'NJ', '07621', 'North', 'North'
UNION ALL SELECT 'NJ', '07624', 'North', 'Coast F'
UNION ALL SELECT 'NJ', '07626', 'North', 'Coast F'
UNION ALL SELECT 'NJ', '07627', 'North', 'Coast F'
UNION ALL SELECT 'NJ', '07628', 'North', 'North'
UNION ALL SELECT 'NJ', '07630', 'North', 'North'
UNION ALL SELECT 'NJ', '07631', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '07632', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '07640', 'North', 'North'
UNION ALL SELECT 'NJ', '07641', 'North', 'North'
UNION ALL SELECT 'NJ', '07642', 'North', 'North'
UNION ALL SELECT 'NJ', '07643', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07644', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07645', 'North', 'North'
UNION ALL SELECT 'NJ', '07646', 'North', 'North'
UNION ALL SELECT 'NJ', '07647', 'North', 'North'
UNION ALL SELECT 'NJ', '07648', 'North', 'North'
UNION ALL SELECT 'NJ', '07649', 'North', 'North'
UNION ALL SELECT 'NJ', '07650', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '07652', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07653', 'North', 'North'
UNION ALL SELECT 'NJ', '07656', 'North', 'North'
UNION ALL SELECT 'NJ', '07657', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '07660', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07661', 'North', 'North'
UNION ALL SELECT 'NJ', '07662', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07663', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07666', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07670', 'North', 'Coast F'
UNION ALL SELECT 'NJ', '07675', 'North', 'North'
UNION ALL SELECT 'NJ', '08010', 'South Metro', 'Coast C'
UNION ALL SELECT 'NJ', '08011', 'South', 'Coast C'
UNION ALL SELECT 'NJ', '08015', 'South', 'Coast CF'
UNION ALL SELECT 'NJ', '08016', 'South Metro', 'Coast C'
UNION ALL SELECT 'NJ', '08019', 'South', 'Coast CF'
UNION ALL SELECT 'NJ', '08022', 'South', 'Coast C'
UNION ALL SELECT 'NJ', '08036', 'South', 'Coast C'
UNION ALL SELECT 'NJ', '08041', 'South', 'Coast C'
UNION ALL SELECT 'NJ', '08042', 'South', 'Coast C'
UNION ALL SELECT 'NJ', '08046', 'South Metro', 'Coast C'
UNION ALL SELECT 'NJ', '08048', 'South', 'Coast C'
UNION ALL SELECT 'NJ', '08052', 'South Metro', 'Coast C'
UNION ALL SELECT 'NJ', '08053', 'South Metro', 'Coast C'
UNION ALL SELECT 'NJ', '08054', 'South Metro', 'Coast C'
UNION ALL SELECT 'NJ', '08055', 'South', 'Coast C'
UNION ALL SELECT 'NJ', '08057', 'South Metro', 'Coast C'
UNION ALL SELECT 'NJ', '08060', 'South', 'Coast C'
UNION ALL SELECT 'NJ', '08064', 'South', 'Coast C'
UNION ALL SELECT 'NJ', '08065', 'South Metro', 'Coast C'
UNION ALL SELECT 'NJ', '08068', 'South', 'Coast C'
UNION ALL SELECT 'NJ', '08073', 'South', 'Coast C'
UNION ALL SELECT 'NJ', '08075', 'South Metro', 'Coast C'
UNION ALL SELECT 'NJ', '08076', 'South', 'Coast C'
UNION ALL SELECT 'NJ', '08077', 'South Metro', 'Coast C'
UNION ALL SELECT 'NJ', '08088', 'South', 'Coast CF'
UNION ALL SELECT 'NJ', '08224', 'South', 'Coast C'
UNION ALL SELECT 'NJ', '08505', 'Capital', 'Coast C'
UNION ALL SELECT 'NJ', '08511', 'South', 'Coast CF'
UNION ALL SELECT 'NJ', '08515', 'South', 'Coast C'
UNION ALL SELECT 'NJ', '08518', 'Capital', 'Coast C'
UNION ALL SELECT 'NJ', '08554', 'Capital', 'Coast C'
UNION ALL SELECT 'NJ', '08562', 'South', 'Coast C'
UNION ALL SELECT 'NJ', '08640', 'South', 'Coast C'
UNION ALL SELECT 'NJ', '08641', 'South', 'Coast C'
UNION ALL SELECT 'NJ', '08002', 'South Metro', 'South Metro'
UNION ALL SELECT 'NJ', '08003', 'South Metro', 'South Metro'
UNION ALL SELECT 'NJ', '08004', 'South', 'South'
UNION ALL SELECT 'NJ', '08007', 'South Metro', 'South Metro'
UNION ALL SELECT 'NJ', '08009', 'South', 'South'
UNION ALL SELECT 'NJ', '08012', 'South Metro', 'South Metro'
UNION ALL SELECT 'NJ', '08018', 'South', 'South'
UNION ALL SELECT 'NJ', '08021', 'South Metro', 'South Metro'
UNION ALL SELECT 'NJ', '08026', 'South Metro', 'South Metro'
UNION ALL SELECT 'NJ', '08029', 'South Metro', 'South Metro'
UNION ALL SELECT 'NJ', '08030', 'South Metro', 'South Metro'
UNION ALL SELECT 'NJ', '08031', 'South Metro', 'South Metro'
UNION ALL SELECT 'NJ', '08033', 'South Metro', 'South Metro'
UNION ALL SELECT 'NJ', '08034', 'South Metro', 'South Metro'
UNION ALL SELECT 'NJ', '08035', 'South Metro', 'South Metro'
UNION ALL SELECT 'NJ', '08043', 'South Metro', 'South Metro'
UNION ALL SELECT 'NJ', '08045', 'South Metro', 'South Metro'
UNION ALL SELECT 'NJ', '08049', 'South Metro', 'South Metro'
UNION ALL SELECT 'NJ', '08059', 'South Metro', 'South Metro'
UNION ALL SELECT 'NJ', '08078', 'South Metro', 'South Metro'
UNION ALL SELECT 'NJ', '08081', 'South', 'South'
UNION ALL SELECT 'NJ', '08083', 'South Metro', 'South Metro'
UNION ALL SELECT 'NJ', '08084', 'South Metro', 'South Metro'
UNION ALL SELECT 'NJ', '08089', 'South', 'South'
UNION ALL SELECT 'NJ', '08091', 'South', 'South'
UNION ALL SELECT 'NJ', '08095', 'South', 'South'
UNION ALL SELECT 'NJ', '08099', 'South', 'South'
UNION ALL SELECT 'NJ', '08101', 'South Metro', 'South Metro'
UNION ALL SELECT 'NJ', '08102', 'South Metro', 'South Metro'
UNION ALL SELECT 'NJ', '08103', 'South Metro', 'South Metro'
UNION ALL SELECT 'NJ', '08104', 'South Metro', 'South Metro'
UNION ALL SELECT 'NJ', '08105', 'South Metro', 'South Metro'
UNION ALL SELECT 'NJ', '08106', 'South Metro', 'South Metro'
UNION ALL SELECT 'NJ', '08107', 'South Metro', 'South Metro'
UNION ALL SELECT 'NJ', '08108', 'South Metro', 'South Metro'
UNION ALL SELECT 'NJ', '08109', 'South Metro', 'South Metro'
UNION ALL SELECT 'NJ', '08110', 'South Metro', 'South Metro'
UNION ALL SELECT 'NJ', '08202', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08204', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08210', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08212', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08214', 'South', 'Coast C'
UNION ALL SELECT 'NJ', '08218', 'Coast', 'Coast C'
UNION ALL SELECT 'NJ', '08219', 'South', 'Coast C'
UNION ALL SELECT 'NJ', '08223', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08226', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08230', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08242', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08243', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08245', 'South', 'Coast C'
UNION ALL SELECT 'NJ', '08246', 'South', 'Coast C'
UNION ALL SELECT 'NJ', '08247', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08248', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08250', 'South', 'Coast C'
UNION ALL SELECT 'NJ', '08251', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08252', 'South', 'Coast C'
UNION ALL SELECT 'NJ', '08260', 'Coast', 'Coast CF'
UNION ALL SELECT 'NJ', '08270', 'South', 'Coast CF'
UNION ALL SELECT 'NJ', '08302', 'South', 'Coast CF'
UNION ALL SELECT 'NJ', '08311', 'South', 'Coast CF'
UNION ALL SELECT 'NJ', '08313', 'South', 'Coast C'
UNION ALL SELECT 'NJ', '08314', 'South', 'Coast CF'
UNION ALL SELECT 'NJ', '08315', 'South', 'Coast C'
UNION ALL SELECT 'NJ', '08316', 'South', 'Coast C'
UNION ALL SELECT 'NJ', '08320', 'South', 'Coast C'
UNION ALL SELECT 'NJ', '08321', 'South', 'Coast C'
UNION ALL SELECT 'NJ', '08323', 'South', 'Coast CF'
UNION ALL SELECT 'NJ', '08324', 'South', 'Coast CF'
UNION ALL SELECT 'NJ', '08327', 'South', 'Coast CF'
UNION ALL SELECT 'NJ', '08329', 'South', 'Coast C'
UNION ALL SELECT 'NJ', '08332', 'South', 'Coast CF'
UNION ALL SELECT 'NJ', '08345', 'South', 'Coast CF'
UNION ALL SELECT 'NJ', '08348', 'South', 'Coast C'
UNION ALL SELECT 'NJ', '08349', 'South', 'Coast CF'
UNION ALL SELECT 'NJ', '08352', 'South', 'Coast C'
UNION ALL SELECT 'NJ', '08353', 'South', 'Coast CF'
UNION ALL SELECT 'NJ', '08361', 'South', 'Coast CF'
UNION ALL SELECT 'NJ', '07003', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07004', 'North', 'North'
UNION ALL SELECT 'NJ', '07006', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07007', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07009', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07017', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07018', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07019', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07021', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07028', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07039', 'North', 'North'
UNION ALL SELECT 'NJ', '07040', 'North', 'North'
UNION ALL SELECT 'NJ', '07041', 'North', 'North'
UNION ALL SELECT 'NJ', '07042', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07043', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07044', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07050', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07051', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07052', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07068', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07078', 'North', 'North'
UNION ALL SELECT 'NJ', '07079', 'North', 'North'
UNION ALL SELECT 'NJ', '07101', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07102', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07103', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07104', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07105', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '07106', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07107', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07108', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07109', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07110', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07111', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07112', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07114', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '07175', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07184', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07188', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07189', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07191', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07192', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07193', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07194', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07195', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07197', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07198', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07199', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '08014', 'South', 'South'
UNION ALL SELECT 'NJ', '08020', 'South', 'South'
UNION ALL SELECT 'NJ', '08025', 'South', 'South'
UNION ALL SELECT 'NJ', '08027', 'South Metro', 'South Metro'
UNION ALL SELECT 'NJ', '08028', 'South', 'South'
UNION ALL SELECT 'NJ', '08032', 'South', 'South'
UNION ALL SELECT 'NJ', '08039', 'South', 'South'
UNION ALL SELECT 'NJ', '08051', 'South', 'South'
UNION ALL SELECT 'NJ', '08056', 'South', 'South'
UNION ALL SELECT 'NJ', '08061', 'South', 'South'
UNION ALL SELECT 'NJ', '08062', 'South', 'South'
UNION ALL SELECT 'NJ', '08063', 'South Metro', 'South Metro'
UNION ALL SELECT 'NJ', '08066', 'South Metro', 'South Metro'
UNION ALL SELECT 'NJ', '08071', 'South', 'South'
UNION ALL SELECT 'NJ', '08074', 'South', 'South'
UNION ALL SELECT 'NJ', '08080', 'South', 'South'
UNION ALL SELECT 'NJ', '08085', 'South', 'South'
UNION ALL SELECT 'NJ', '08086', 'South Metro', 'South Metro'
UNION ALL SELECT 'NJ', '08090', 'South', 'South'
UNION ALL SELECT 'NJ', '08093', 'South Metro', 'South Metro'
UNION ALL SELECT 'NJ', '08094', 'South', 'South'
UNION ALL SELECT 'NJ', '08096', 'South Metro', 'South Metro'
UNION ALL SELECT 'NJ', '08097', 'South', 'South'
UNION ALL SELECT 'NJ', '08312', 'South', 'South'
UNION ALL SELECT 'NJ', '08322', 'South', 'South'
UNION ALL SELECT 'NJ', '08328', 'South', 'South'
UNION ALL SELECT 'NJ', '08344', 'South', 'South'
UNION ALL SELECT 'NJ', '07002', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '07029', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07030', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '07032', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07047', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '07087', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '07093', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '07094', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '07096', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07097', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07099', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07302', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '07303', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07304', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '07305', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '07306', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '07307', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '07308', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07309', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07310', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '07311', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07399', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07830', 'North', 'North'
UNION ALL SELECT 'NJ', '07979', 'North', 'North'
UNION ALL SELECT 'NJ', '08530', 'North', 'North'
UNION ALL SELECT 'NJ', '08551', 'North', 'North'
UNION ALL SELECT 'NJ', '08556', 'North', 'North'
UNION ALL SELECT 'NJ', '08557', 'North', 'North'
UNION ALL SELECT 'NJ', '08559', 'North', 'North'
UNION ALL SELECT 'NJ', '08801', 'North', 'North'
UNION ALL SELECT 'NJ', '08803', 'North', 'North'
UNION ALL SELECT 'NJ', '08804', 'North', 'North'
UNION ALL SELECT 'NJ', '08809', 'North', 'North'
UNION ALL SELECT 'NJ', '08822', 'North', 'North'
UNION ALL SELECT 'NJ', '08825', 'North', 'North'
UNION ALL SELECT 'NJ', '08826', 'North', 'North'
UNION ALL SELECT 'NJ', '08827', 'North', 'North'
UNION ALL SELECT 'NJ', '08829', 'North', 'North'
UNION ALL SELECT 'NJ', '08833', 'North', 'North'
UNION ALL SELECT 'NJ', '08834', 'North', 'North'
UNION ALL SELECT 'NJ', '08848', 'North', 'North'
UNION ALL SELECT 'NJ', '08858', 'North', 'North'
UNION ALL SELECT 'NJ', '08867', 'North', 'North'
UNION ALL SELECT 'NJ', '08868', 'North', 'North'
UNION ALL SELECT 'NJ', '08870', 'North', 'North'
UNION ALL SELECT 'NJ', '08885', 'North', 'North'
UNION ALL SELECT 'NJ', '08887', 'North', 'North'
UNION ALL SELECT 'NJ', '08888', 'North', 'North'
UNION ALL SELECT 'NJ', '08889', 'North', 'North'
UNION ALL SELECT 'NJ', '08520', 'North', 'North'
UNION ALL SELECT 'NJ', '08525', 'North', 'North'
UNION ALL SELECT 'NJ', '08534', 'North', 'North'
UNION ALL SELECT 'NJ', '08540', 'North', 'North'
UNION ALL SELECT 'NJ', '08541', 'South', 'South'
UNION ALL SELECT 'NJ', '08542', 'North', 'North'
UNION ALL SELECT 'NJ', '08543', 'South', 'South'
UNION ALL SELECT 'NJ', '08544', 'North', 'North'
UNION ALL SELECT 'NJ', '08550', 'North', 'North'
UNION ALL SELECT 'NJ', '08560', 'North', 'North'
UNION ALL SELECT 'NJ', '08561', 'North', 'North'
UNION ALL SELECT 'NJ', '08601', 'South Metro', 'South Metro'
UNION ALL SELECT 'NJ', '08602', 'South Metro', 'South Metro'
UNION ALL SELECT 'NJ', '08603', 'South Metro', 'South Metro'
UNION ALL SELECT 'NJ', '08604', 'South Metro', 'South Metro'
UNION ALL SELECT 'NJ', '08605', 'South Metro', 'South Metro'
UNION ALL SELECT 'NJ', '08606', 'South Metro', 'South Metro'
UNION ALL SELECT 'NJ', '08607', 'South Metro', 'South Metro'
UNION ALL SELECT 'NJ', '08608', 'Capital', 'Capital'
UNION ALL SELECT 'NJ', '08609', 'Capital', 'Capital'
UNION ALL SELECT 'NJ', '08610', 'Capital', 'Capital'
UNION ALL SELECT 'NJ', '08611', 'Capital', 'Capital'
UNION ALL SELECT 'NJ', '08618', 'Capital', 'Capital'
UNION ALL SELECT 'NJ', '08619', 'Capital', 'Capital'
UNION ALL SELECT 'NJ', '08620', 'Capital', 'Capital'
UNION ALL SELECT 'NJ', '08625', 'Capital', 'Capital'
UNION ALL SELECT 'NJ', '08628', 'Capital', 'Capital'
UNION ALL SELECT 'NJ', '08629', 'Capital', 'Capital'
UNION ALL SELECT 'NJ', '08638', 'Capital', 'Capital'
UNION ALL SELECT 'NJ', '08645', 'Capital', 'Capital'
UNION ALL SELECT 'NJ', '08646', 'Capital', 'Capital'
UNION ALL SELECT 'NJ', '08647', 'Capital', 'Capital'
UNION ALL SELECT 'NJ', '08648', 'Capital', 'Capital'
UNION ALL SELECT 'NJ', '08650', 'South Metro', 'South Metro'
UNION ALL SELECT 'NJ', '08666', 'Capital', 'Capital'
UNION ALL SELECT 'NJ', '08677', 'Capital', 'Capital'
UNION ALL SELECT 'NJ', '08690', 'Capital', 'Capital'
UNION ALL SELECT 'NJ', '08691', 'North', 'North'
UNION ALL SELECT 'NJ', '08695', 'Capital', 'Capital'
UNION ALL SELECT 'NJ', '07001', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '07008', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '07064', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '07067', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '07077', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '07080', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '07095', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '08512', 'North', 'North'
UNION ALL SELECT 'NJ', '08536', 'North', 'North'
UNION ALL SELECT 'NJ', '08570', 'North', 'North'
UNION ALL SELECT 'NJ', '08810', 'North', 'North'
UNION ALL SELECT 'NJ', '08812', 'North', 'North'
UNION ALL SELECT 'NJ', '08816', 'North', 'Coast F'
UNION ALL SELECT 'NJ', '08817', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '08818', 'North Metro', 'North Metro'
UNION ALL SELECT 'NJ', '08820', 'North Metro', 'Coast F'
UNION ALL SELECT 'NJ', '08362', 'Other', 'Coast C'
UNION ALL SELECT 'NJ', '07182', 'Other', 'North Metro'
UNION ALL SELECT 'NJ', '07390', 'Other', 'North Metro'
UNION ALL SELECT 'NJ', '07395', 'Other', 'North Metro'
UNION ALL SELECT 'NJ', '07699', 'Other', 'North Metro'
UNION ALL SELECT 'NJ', '08896', 'Other', 'North'

PRINT '======= FMR Base Data Complete ========'
PRINT ''

--------------------------------------------------------------------------------------------------------------------------------------------
-- Drop Procedure
--------------------------------------------------------------------------------------------------------------------------------------------
if exists (select * from sys.sysobjects where id = object_id(N'[dbo].[ArcCurrentFMRDataExcludeICR]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ArcCurrentFMRDataExcludeICR]
GO

--------------------------------------------------------------------------------------------------------------------------------------------
-- Create procedure
--------------------------------------------------------------------------------------------------------------------------------------------
CREATE PROCEDURE ArcCurrentFMRDataExcludeICR
(	@SessionId		[udtNumber],
	@FunctionName	[udtName],
	@UserName	udtName
)
AS 
--------------------------------------------------------------------------------------------------------------------------------------------
-- OBJECT NAME:    ArcCurrentFMRDataExcludeICR
--------------------------------------------------------------------------------------------------------------------------------------------
-- AUTHOR:         Vijaya Kumar Gulappa
--------------------------------------------------------------------------------------------------------------------------------------------
-- CREATED:        Aug-06-2007
--------------------------------------------------------------------------------------------------------------------------------------------
-- DESCRIPTION:    Archive Current FMR Data from FACT_DTL_FIN_MGT_RPT in to ARCHV_DTL_FIN_MGT_RPT table exclude ICR
--------------------------------------------------------------------------------------------------------------------------------------------
-- PARAMETERS:
--------------------------------------------------------------------------------------------------------------------------------------------
-- RETURNS:        0  -  success
--                 returns from SQL Server
--------------------------------------------------------------------------------------------------------------------------------------------

-- VERSION: $Revision: 3 $  UPDATED: $Modtime: 8/08/07 1:44p $
--------------------------------------------------------------------------------------------------------------------------------------------

declare	@ret int,
		@Value	udtName,
		@RPT_YRMO	udtEffYrMon
set nocount on
Set @FunctionName = OBJECT_NAME(@@PROCID)
SET @RPT_YRMO = CAST(DATEPART (YYYY, GETDATE()) AS VARCHAR(4)) + (CASE WHEN LEN(DATEPART(M, GETDATE())) = 1 THEN '0' ELSE '' END) + CAST(DATEPART(M, GETDATE()) AS VARCHAR(2))
SET @ret = 0

  BEGIN

	INSERT INTO [dbo].ARCHV_DTL_FIN_MGT_RPT
	( 
	ADFMR_SRC_NM, ADFMR_BPM_LN_OF_BUS, ADFMR_BPM_SEG_NM, ADFMR_BPM_PRDCT_NM, ADFMR_RT_PLN_GRP_NM, ADFMR_TRM, ADFMR_CHNL_GRP_NM, 
	ADFMR_CHNL_NM, ADFMR_SUB_CHNL, ADFMR_PM_RGN_NM, ADFMR_STRG, ADFMR_ST_NM, ADFMR_ST_CD, ADFMR_SPC, ADFMR_EFF_YR, ADFMR_EFF_MO, 
	ADFMR_MO_NM, ADFMR_EFF_YR_MO, ADFMR_FISC_YR, ADFMR_RPT_YR_MO,
	ADFMR_ARB_ULT_POL_CNT, ADFMR_ARB_POL_CNT, ADFMR_ARB_POL_CNT_FST_ON, ADFMR_ARB_POL_CNT_SEC_ON, ADFMR_ARB_POL_CNT_FST_OFF, 
	ADFMR_ARB_ULT_POL_CNT_SEC_OFF, ADFMR_ARB_FC_CO, ADFMR_ARB_FC_AGT_NP_FST_ON, ADFMR_ARB_FC_AGT_NP_SEC_ON, ADFMR_ARB_FC_AGT_NP_ON, 
	ADFMR_ARB_FC_AGT_NP_FST_OFF, ADFMR_ARB_FC_AGT_NP_SEC_OFF, ADFMR_ARB_FC_AGT_NP_OFF, ADFMR_ARB_ULT_FC_AGT_NP, ADFMR_ARB_MT, ADFMR_ARB_ULT_MT, ADFMR_ARB_RET,
	ADFMR_ARB_ULT_RET, ADFMR_ORA_POL_CNT, ADFMR_ORA_POL_CNT_FST_ON, ADFMR_ORA_POL_CNT_SEC_ON, ADFMR_ORA_POL_CNT_FST_OFF,
	ADFMR_ORA_POL_CNT_SEC_OFF, ADFMR_ORA_FC_CO, ADFMR_ORA_FC_AGT_NP_FST_ON, ADFMR_ORA_FC_AGT_NP_SEC_ON, ADFMR_ORA_FC_AGT_NP_ON,
	ADFMR_ORA_FC_AGT_NP_FST_OFF, ADFMR_ORA_FC_AGT_NP_SEC_OFF, ADFMR_ORA_FC_AGT_NP_OFF, ADFMR_ORA_ULT_FC_AGT_NP, ADFMR_ORA_MT, ADFMR_ORA_ULT_MT,
	ADFMR_ORA_REW, ADFMR_ORA_ULT_REW, ADFMR_ORA_RET, ADFMR_ORA_ULT_RET, ADFMR_BNB_POL_CNT, ADFMR_BNB_POL_CNT_FST_ON, ADFMR_BNB_POL_CNT_SEC_ON,
	ADFMR_BNB_POL_CNT_FST_OFF, ADFMR_BNB_POL_CNT_SEC_OFF, ADFMR_BNB_ULT_POL_CNT, ADFMR_BNB_FC_CO, ADFMR_BNB_FC_AGT_NP_FST_ON, ADFMR_BNB_FC_AGT_NP_SEC_ON, 
	ADFMR_BNB_FC_AGT_NP_ON, ADFMR_BNB_FC_AGT_NP_FST_OFF, ADFMR_BNB_FC_AGT_NP_SEC_OFF, ADFMR_BNB_FC_AGT_NP_OFF, ADFMR_BNB_ULT_FC_AGT_NP, ADFMR_BNB_MT,
	ADFMR_BNB_ULT_MT, ADFMR_BNB_REW, ADFMR_BNB_ULT_REW, ADFMR_BNB_RET, ADFMR_BNB_ULT_RET, ADFMR_NB_CHG_EFF_DT,
	ADFMR_RRA_POL_CNT, ADFMR_RRA_POL_CNT_FST_ON, ADFMR_RRA_POL_CNT_SEC_ON, ADFMR_RRA_POL_CNT_FST_OFF, ADFMR_RRA_POL_CNT_SEC_OFF,
	ADFMR_RRA_FC_CO, ADFMR_RRA_FC_AGT_NP_FST_ON, ADFMR_RRA_FC_AGT_NP_SEC_ON, ADFMR_RRA_FC_AGT_NP_ON, ADFMR_RRA_FC_AGT_NP_FST_OFF, ADFMR_RRA_FC_AGT_NP_SEC_OFF,
	ADFMR_RRA_FC_AGT_NP_OFF, ADFMR_RRA_ULT_FC_AGT_NP, ADFMR_RRA_MT, ADFMR_RRA_ULT_MT, ADFMR_RRA_REW, ADFMR_RRA_ULT_REW,
	ADFMR_RRA_RET, ADFMR_RRA_ULT_RET, ADFMR_RPC_AMT_FST_ON, ADFMR_BAS_WRT_PRM_FST_ON, ADFMR_RPC_RT_AMT_FST_ON, ADFMR_RPC_AIL_AMT_FST_ON, ADFMR_RPC_EXPOS_AMT_FST_ON,
	ADFMR_RPC_AMT, ADFMR_BAS_WRT_PRM, ADFMR_RPC_RT_AMT, ADFMR_RPC_AIL_AMT, ADFMR_RPC_EXPOS_AMT, ADFMR_ANNL_WRT_PRM_AMT_RB,
	ADFMR_ANNL_WRT_PRM_AMT_BNB, ADFMR_ORG_WRT_PRM_AMT, ADFMR_ACQN_WRT_PRM_AMT, ADFMR_COMB_WRT_PRM_AMT, ADFMR_PRR_IN_FRC_AMT, ADFMR_YR_END_IN_FRC_AMT,
	ADFMR_CURR_IN_FRC_AMT, ADFMR_CTL_LS_AMT, ADFMR_EARN_PRM_AMT, ADFMR_PIF_AMT, ADFMR_LST_USER, ADFMR_LST_DT_TM, ADFMR_CREAT_USER, ADFMR_CREAT_DT_TM
	)
	SELECT 
	FDFMR_SRC_NM, FDFMR_BPM_LN_OF_BUS, FDFMR_BPM_SEG_NM, FDFMR_BPM_PRDCT_NM, FDFMR_RT_PLN_GRP_NM, FDFMR_TRM, FDFMR_CHNL_GRP_NM, 
	FDFMR_CHNL_NM, FDFMR_SUB_CHNL, FDFMR_PM_RGN_NM, FDFMR_STRG, FDFMR_ST_NM, FDFMR_ST_CD,
	FDFMR_SPC, FDFMR_EFF_YR, FDFMR_EFF_MO, FDFMR_MO_NM, FDFMR_EFF_YR_MO, FDFMR_FISC_YR, @RPT_YRMO,
	FDFMR_ARB_ULT_POL_CNT, FDFMR_ARB_POL_CNT, FDFMR_ARB_POL_CNT_FST_ON, FDFMR_ARB_POL_CNT_SEC_ON, FDFMR_ARB_POL_CNT_FST_OFF, 
	FDFMR_ARB_ULT_POL_CNT_SEC_OFF, FDFMR_ARB_FC_CO, FDFMR_ARB_FC_AGT_NP_FST_ON, FDFMR_ARB_FC_AGT_NP_SEC_ON, FDFMR_ARB_FC_AGT_NP_ON, 
	FDFMR_ARB_FC_AGT_NP_FST_OFF, FDFMR_ARB_FC_AGT_NP_SEC_OFF, FDFMR_ARB_FC_AGT_NP_OFF, FDFMR_ARB_ULT_FC_AGT_NP, FDFMR_ARB_MT, FDFMR_ARB_ULT_MT, FDFMR_ARB_RET,
	FDFMR_ARB_ULT_RET, FDFMR_ORA_POL_CNT, FDFMR_ORA_POL_CNT_FST_ON, FDFMR_ORA_POL_CNT_SEC_ON, FDFMR_ORA_POL_CNT_FST_OFF,
	FDFMR_ORA_POL_CNT_SEC_OFF, FDFMR_ORA_FC_CO, FDFMR_ORA_FC_AGT_NP_FST_ON, FDFMR_ORA_FC_AGT_NP_SEC_ON, FDFMR_ORA_FC_AGT_NP_ON,
	FDFMR_ORA_FC_AGT_NP_FST_OFF, FDFMR_ORA_FC_AGT_NP_SEC_OFF, FDFMR_ORA_FC_AGT_NP_OFF, FDFMR_ORA_ULT_FC_AGT_NP, FDFMR_ORA_MT, FDFMR_ORA_ULT_MT,
	FDFMR_ORA_REW, FDFMR_ORA_ULT_REW, FDFMR_ORA_RET, FDFMR_ORA_ULT_RET, FDFMR_BNB_POL_CNT, FDFMR_BNB_POL_CNT_FST_ON, FDFMR_BNB_POL_CNT_SEC_ON,
	FDFMR_BNB_POL_CNT_FST_OFF, FDFMR_BNB_POL_CNT_SEC_OFF, FDFMR_BNB_ULT_POL_CNT, FDFMR_BNB_FC_CO, FDFMR_BNB_FC_AGT_NP_FST_ON, FDFMR_BNB_FC_AGT_NP_SEC_ON, 
	FDFMR_BNB_FC_AGT_NP_ON, FDFMR_BNB_FC_AGT_NP_FST_OFF, FDFMR_BNB_FC_AGT_NP_SEC_OFF, FDFMR_BNB_FC_AGT_NP_OFF, FDFMR_BNB_ULT_FC_AGT_NP, FDFMR_BNB_MT,
	FDFMR_BNB_ULT_MT, FDFMR_BNB_REW, FDFMR_BNB_ULT_REW, FDFMR_BNB_RET, FDFMR_BNB_ULT_RET, FDFMR_NB_CHG_EFF_DT,
	FDFMR_RRA_POL_CNT, FDFMR_RRA_POL_CNT_FST_ON, FDFMR_RRA_POL_CNT_SEC_ON, FDFMR_RRA_POL_CNT_FST_OFF, FDFMR_RRA_POL_CNT_SEC_OFF,
	FDFMR_RRA_FC_CO, FDFMR_RRA_FC_AGT_NP_FST_ON, FDFMR_RRA_FC_AGT_NP_SEC_ON, FDFMR_RRA_FC_AGT_NP_ON, FDFMR_RRA_FC_AGT_NP_FST_OFF, FDFMR_RRA_FC_AGT_NP_SEC_OFF,
	FDFMR_RRA_FC_AGT_NP_OFF, FDFMR_RRA_ULT_FC_AGT_NP, FDFMR_RRA_MT, FDFMR_RRA_ULT_MT, FDFMR_RRA_REW, FDFMR_RRA_ULT_REW,
	FDFMR_RRA_RET, FDFMR_RRA_ULT_RET, FDFMR_RPC_AMT_FST_ON, FDFMR_BAS_WRT_PRM_FST_ON, FDFMR_RPC_RT_AMT_FST_ON, FDFMR_RPC_AIL_AMT_FST_ON, FDFMR_RPC_EXPOS_AMT_FST_ON,
	FDFMR_RPC_AMT, FDFMR_BAS_WRT_PRM, FDFMR_RPC_RT_AMT, FDFMR_RPC_AIL_AMT, FDFMR_RPC_EXPOS_AMT, FDFMR_ANNL_WRT_PRM_AMT_RB,
	FDFMR_ANNL_WRT_PRM_AMT_BNB, FDFMR_ORG_WRT_PRM_AMT, FDFMR_ACQN_WRT_PRM_AMT, FDFMR_COMB_WRT_PRM_AMT, FDFMR_PRR_IN_FRC_AMT, FDFMR_YR_END_IN_FRC_AMT,
	FDFMR_CURR_IN_FRC_AMT, FDFMR_CTL_LS_AMT, FDFMR_EARN_PRM_AMT, FDFMR_PIF_AMT,
	FDFMR_LST_USER, FDFMR_LST_DT_TM, FDFMR_CREAT_USER, FDFMR_CREAT_DT_TM
	FROM FACT_DTL_FIN_MGT_RPT
	WHERE FDFMR_BPM_LN_OF_BUS IN ('Auto', 'Property')

	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 52100, 11, 'ARCHV_DTL_FIN_MGT_RPT table: insert statement from FACT_DTL_FIN_MGT_RPT table did not succeed'
		return 52100
	  END

    exec @ret = OthInsUserMessage
                @SessionId, 
                @FunctionName = @FunctionName, 
                @Task_Name = 'Insert Statement: ARCHV_DTL_FIN_MGT_RPT <-- From FACT_DTL_FIN_MGT_RPT table',
                @Status = 'Complete',
				@UserName = @UserName

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing insert ARCHV_DTL_FIN_MGT_RPT from FACT_DTL_FIN_MGT_RPT table complete statement'
		return 50200
	  END
	
  END

set nocount off

RETURN 0

GO

--------------------------------------------------------------------------------------------------------------------------------------------
-- Drop Procedure
--------------------------------------------------------------------------------------------------------------------------------------------
if exists (select * from sys.sysobjects where id = object_id(N'[dbo].[ArcCurrentICRFMRData]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ArcCurrentICRFMRData]
GO

--------------------------------------------------------------------------------------------------------------------------------------------
-- Create procedure
--------------------------------------------------------------------------------------------------------------------------------------------
CREATE PROCEDURE ArcCurrentICRFMRData
(	@SessionId		[udtNumber],
	@FunctionName	[udtName],
	@UserName	udtName
)
AS 
--------------------------------------------------------------------------------------------------------------------------------------------
-- OBJECT NAME:    ArcCurrentICRFMRData
--------------------------------------------------------------------------------------------------------------------------------------------
-- AUTHOR:         Vijaya Kumar Gulappa
--------------------------------------------------------------------------------------------------------------------------------------------
-- CREATED:        Aug-06-2007
--------------------------------------------------------------------------------------------------------------------------------------------
-- DESCRIPTION:    Archive Current ICR FMR Data from FACT_IND_COMB_RTO in to ARCHV_IND_COMB_RTO table
--------------------------------------------------------------------------------------------------------------------------------------------
-- PARAMETERS:
--------------------------------------------------------------------------------------------------------------------------------------------
-- RETURNS:        0  -  success
--                 returns from SQL Server
--------------------------------------------------------------------------------------------------------------------------------------------

-- VERSION: $Revision: 2 $  UPDATED: $Modtime: 8/08/07 1:46p $
--------------------------------------------------------------------------------------------------------------------------------------------

declare	@ret int

set nocount on
Set @FunctionName = OBJECT_NAME(@@PROCID)
SET @ret = 0

  BEGIN

	INSERT INTO [dbo].ARCHV_IND_COMB_RTO 
	(
	AICR_BPM_LN_OF_BUS, AICR_SHT_NM, AICR_RPT_DESC, AICR_ST_CD, AICR_ST_NM, AICR_CHNL_GRP_NM, AICR_RPT_MO, AICR_RPT_YR, 
	AICR_RPT_YR_MO, AICR_TOT_PCT, AICR_LST_USER, AICR_LST_DT_TM, AICR_CREAT_USER, AICR_CREAT_DT_TM
	)
	SELECT
	FICR_BPM_LN_OF_BUS, FICR_SHT_NM, FICR_RPT_DESC, FICR_ST_CD, FICR_ST_NM, FICR_CHNL_GRP_NM, FICR_RPT_MO, FICR_RPT_YR, 
	FICR_RPT_YR_MO, FICR_TOT_PCT, @UserName, GetDate(), @UserName, GetDate()
	FROM FACT_IND_COMB_RTO

	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 51821, 11, 'ARCHV_IND_COMB_RTO table: Insert statement from FACT_IND_COMB_RTO table did not succeed'
		return 51821
	  END

    exec @ret = OthInsUserMessage
                @SessionId, 
                @FunctionName = @FunctionName, 
                @Task_Name = 'Insert Statement: ARCHV_IND_COMB_RTO <-- from FACT_IND_COMB_RTO table',
                @Status = 'Complete',
				@UserName = @UserName

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing insert ARCHV_IND_COMB_RTO from FACT_IND_COMB_RTO table complete statement'
		return 50200
	  END

  END

set nocount off

RETURN 0

GO

--------------------------------------------------------------------------------------------------------------------------------------------
-- Drop Procedure
--------------------------------------------------------------------------------------------------------------------------------------------
if exists (select * from sys.sysobjects where id = object_id(N'[dbo].[ConGetSystemPreferenceValue]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ConGetSystemPreferenceValue]
GO

CREATE PROCEDURE ConGetSystemPreferenceValue
(	@FunctionName	[udtName],
	@Code			[udtCode],
	@Value			[udtName] output
)
AS
--------------------------------------------------------------------------------------------------------------------------------------------
-- OBJECT NAME:    ConGetSystemPreferenceValue
--------------------------------------------------------------------------------------------------------------------------------------------
-- AUTHOR:			VIJAYA KUMAR GULAPPA
--------------------------------------------------------------------------------------------------------------------------------------------
-- CREATED:			JUNE 06 2007
--------------------------------------------------------------------------------------------------------------------------------------------
-- DESCRIPTION:		Get FMR system related data
--------------------------------------------------------------------------------------------------------------------------------------------
-- PARAMETERS:     <To be inserted>
--------------------------------------------------------------------------------------------------------------------------------------------
-- RETURNS:        0                -  success
--                 <To be inserted>
--                 returns from SQL Server
--------------------------------------------------------------------------------------------------------------------------------------------

-- VERSION: $Revision: 3 $  UPDATED: $Modtime: 8/08/07 1:47p $
--------------------------------------------------------------------------------------------------------------------------------------------

Set	@Value = NULL

SELECT	@Value = CDSP_VAL
FROM	CNFG_DFLT_SYS_PREF
WHERE	CDSP_CD = @Code

IF @@error != 0
BEGIN
	exec OthInsErrorMessage null, @FunctionName, 51503, 11, 'System Preference: select statement failed', @Code
	return 51503
END

IF @Value = NULL
BEGIN
	exec OthInsErrorMessage null, @FunctionName, 51504, 11, 'System Preference: select statement failed', @Code
	return 51504
END

RETURN 0

GO
--------------------------------------------------------------------------------------------------------------------------------------------
-- Drop Procedure
--------------------------------------------------------------------------------------------------------------------------------------------
if exists (select * from sys.sysobjects where id = object_id(N'[dbo].[CriInsExtractStatus]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[CriInsExtractStatus]
GO

CREATE PROCEDURE CriInsExtractStatus
(	@SessionId		udtInteger,
	@FunctionName	udtname,
	@UserName		udtname = null,
	@YearMonth		udtEffYrMon,
	@Control		udtYesNo,
	@PIF			udtYesNo,
	@Trenton		udtYesNo,
	@Findb			udtYesNo,
	@ICR			udtYesNo,
	@EPLR			udtYesNo
)
AS
--------------------------------------------------------------------------------------------------------------------------------------------
-- OBJECT NAME:    CriInsExtractStatus
--------------------------------------------------------------------------------------------------------------------------------------------
-- AUTHOR:			VIJAYA KUMAR GULAPPA
--------------------------------------------------------------------------------------------------------------------------------------------
-- CREATED:			MAY 22 2007
--------------------------------------------------------------------------------------------------------------------------------------------
-- DESCRIPTION:    TRACK EXTRACT FILE STATUS FOR IMPORT STATMENT
--------------------------------------------------------------------------------------------------------------------------------------------
-- PARAMETERS:     <To be inserted>
--------------------------------------------------------------------------------------------------------------------------------------------
-- RETURNS:        0                -  success
--                 <To be inserted>
--                 returns from SQL Server
--------------------------------------------------------------------------------------------------------------------------------------------

-- VERSION: $Revision: 4 $  UPDATED: $Modtime: 8/02/07 2:24p $
--------------------------------------------------------------------------------------------------------------------------------------------


declare	@ret		int

set nocount on
Set @FunctionName = OBJECT_NAME(@@PROCID)

If @UserName is null or len(@UserName) = 0
Begin

	exec @ret = UsrGetSessionInfo @SessionId = @SessionId,
								@FunctionName = @FunctionName,
								@UMS_AT_Name = @UserName Output

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50103, 11, 'Get Session Information: Exec UsrGetSessionInfo failed'
		return 50103
	  END
End

If @UserName is null or len(@UserName) = 0 Set @UserName = suser_sname()

INSERT INTO CRIT_STS_XTRCT
	(CSX_YR_MO, CSX_CTL_IND, CSX_POL_IN_FRC_IND, CSX_TNJ_IND, CSX_FDB_IND, CSX_IND_COMB_RTO_IND, 
		CSX_EARN_PRM_LS_RTO_IND, CSX_LST_USER, CSX_LST_DT_TM, CSX_CREAT_USER, CSX_CREAT_DT_TM)
VALUES(@YearMonth, @Control, @PIF, @Trenton, @Findb, @ICR, @EPLR, @UserName, GETDATE(), @UserName, GETDATE())


IF  @@error != 0 
BEGIN 
	exec OthInsErrorMessage @SessionId, @FunctionName, 50800, 11, 'Extract Status table: insert statement did not succeed'
	return 50800
END

set nocount off
return 0

GO
--------------------------------------------------------------------------------------------------------------------------------------------
-- Drop Procedure
--------------------------------------------------------------------------------------------------------------------------------------------
if exists (select * from sys.sysobjects where id = object_id(N'[dbo].[CtlReconcile]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[CtlReconcile]
GO

--------------------------------------------------------------------------------------------------------------------------------------------
-- Create procedure
--------------------------------------------------------------------------------------------------------------------------------------------
CREATE PROCEDURE CtlReconcile
(	@SessionId		[udtNumber],
	@FunctionName	[udtName]
)
AS 
--------------------------------------------------------------------------------------------------------------------------------------------
-- OBJECT NAME:    CtlReconcile
--------------------------------------------------------------------------------------------------------------------------------------------
-- AUTHOR:         Vijaya Kumar Gulappa
--------------------------------------------------------------------------------------------------------------------------------------------
-- CREATED:        May-21-2007
--------------------------------------------------------------------------------------------------------------------------------------------
-- DESCRIPTION:    Insert Control Report Month Variance data to the FACT_CTL_RPT_VAR table.
--------------------------------------------------------------------------------------------------------------------------------------------
-- PARAMETERS:
--------------------------------------------------------------------------------------------------------------------------------------------
-- RETURNS:        0  -  success
--                 returns from SQL Server
--------------------------------------------------------------------------------------------------------------------------------------------

-- VERSION: $Revision: 14 $  UPDATED: $Modtime: 8/08/07 1:54p $
--------------------------------------------------------------------------------------------------------------------------------------------

declare	@ret int,
		@UserName	udtName,
		@YearMonth	udtEffYrMon,
		@FromDate	udtDateTime

set nocount on
Set @FunctionName = OBJECT_NAME(@@PROCID)
SET @YearMonth = CAST(DATEPART (YYYY, GETDATE()) AS VARCHAR(4)) + (CASE WHEN LEN(DATEPART(M, GETDATE())) = 1 THEN '0' ELSE '' END) + CAST(DATEPART(M, GETDATE()) AS VARCHAR(2))

SET @ret = 0
SET @FromDate = CONVERT(VARCHAR(10), GETDATE(), 120)

  BEGIN
     
	Exec @ret = UsrGetSessionInfo @SessionId = @SessionId,
								@FunctionName = @FunctionName,
								@UMS_AT_Name = @UserName Output

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50103, 11, 'Get Session Information: Exec UsrGetSessionInfo failed'
		return 50103
	  END

	IF NOT EXISTS (SELECT CSX_YR_MO FROM CRIT_STS_XTRCT WHERE CSX_YR_MO = @YearMonth)
	BEGIN
		Exec @ret = CriInsExtractStatus @SessionId = @SessionId,
									@FunctionName = @FunctionName,
									@UserName = @UserName,
									@YearMonth = @YearMonth,
									@Control = 'N',
									@PIF = 'N',
									@Trenton = 'N',
									@Findb = 'N',
									@ICR = 'N',
									@EPLR = 'N'

		IF  @ret != 0 
		  BEGIN 
			exec OthInsErrorMessage @SessionId, @FunctionName, 50800, 11, 'Extract Status: insert statement did not succeed'
			return 50800
		  END
	END

	TRUNCATE TABLE [dbo].FACT_CTL_RPT_VAR 
	
	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50724, 11, 'Control Variance: truncation did not succeed'
		return 50724
	  END

    exec @ret = OthInsUserMessage
                @SessionId, 
                @FunctionName = @FunctionName, 
                @Task_Name = 'Truncate Table : Control Report Data',
                @Status = 'Complete',
				@UserName = @UserName

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing truncate control report data table complete statement'
		return 50200
	  END

	INSERT INTO [dbo].FACT_CTL_RPT_VAR
	(
		FCRV_BPM_LN_OF_BUS, FCRV_ST_CD, FCRV_ST_NM, FCRV_CURR_MO_ARB_ULT_POL_CNT, FCRV_PREV_MO_ARB_ULT_POL_CNT, 
		FCRV_ARB_ULT_POL_CNT_VAR, FCRV_CURR_MO_ARB_ULT_RET, FCRV_PREV_MO_ARB_ULT_RET, FCRV_ARB_ULT_RET_VAR,
		FCRV_CURR_MO_ORA_ULT_RET, FCRV_PREV_MO_ORA_ULT_RET, FCRV_ORA_ULT_RET_VAR, FCRV_CURR_MO_BNB_POL_CNT, 
		FCRV_PREV_MO_BNB_POL_CNT, FCRV_BNB_POL_CNT_VAR, FCRV_CURR_MO_BNB_ULT_RET, FCRV_PREV_MO_BNB_ULT_RET, 
		FCRV_BNB_ULT_RET_VAR, FCRV_CURR_MO_RRA_ULT_RET, FCRV_PREV_MO_RRA_ULT_RET, FCRV_RRA_ULT_RET_VAR,
		FCRV_CURR_MO_RETN_WRT_PRM, FCRV_PREV_MO_RETN_WRT_PRM, FCRV_RETN_WRT_PRM_VAR, FCRV_CURR_MO_RPC_AMT, 
		FCRV_PREV_MO_RPC_AMT, FCRV_RPC_AMT_VAR, FCRV_LST_USER, FCRV_LST_DT_TM, FCRV_CREAT_USER, FCRV_CREAT_DT_TM
	)
	SELECT 
		CM.XCMCR_BPM_LN_OF_BUS, CM.XCMCR_ST_CD, SN.CMSN_ST_NM, 
		CM.XCMCR_ARB_ULT_POL_CNT, PM.XPMCR_ARB_ULT_POL_CNT, 
		(CASE WHEN PM.XPMCR_ARB_ULT_POL_CNT = 0 THEN 0 ELSE (CM.XCMCR_ARB_ULT_POL_CNT / PM.XPMCR_ARB_ULT_POL_CNT) - 1 END), 
		CM.XCMCR_ARB_ULT_RET, PM.XPMCR_ARB_ULT_RET, 
		(CASE WHEN PM.XPMCR_ARB_ULT_RET = 0 THEN 0 ELSE (CM.XCMCR_ARB_ULT_RET / PM.XPMCR_ARB_ULT_RET) - 1 END), 
		CM.XCMCR_ORA_ULT_RET, PM.XPMCR_ORA_ULT_RET, 
		(CASE WHEN PM.XPMCR_ORA_ULT_RET = 0 THEN 0 ELSE (CM.XCMCR_ORA_ULT_RET / PM.XPMCR_ORA_ULT_RET) - 1 END), 
		CM.XCMCR_BNB_POL_CNT, PM.XPMCR_BNB_POL_CNT, 
		(CASE WHEN PM.XPMCR_BNB_POL_CNT = 0 THEN 0 ELSE (CM.XCMCR_BNB_POL_CNT / PM.XPMCR_BNB_POL_CNT) - 1 END), 
		CM.XCMCR_BNB_ULT_RET, PM.XPMCR_BNB_ULT_RET, 
		(CASE WHEN PM.XPMCR_BNB_ULT_RET = 0 THEN 0 ELSE (CM.XCMCR_BNB_ULT_RET / PM.XPMCR_BNB_ULT_RET) - 1 END), 
		CM.XCMCR_RRA_ULT_RET, PM.XPMCR_RRA_ULT_RET, 
		(CASE WHEN PM.XPMCR_RRA_ULT_RET = 0 THEN 0 ELSE (CM.XCMCR_RRA_ULT_RET / PM.XPMCR_RRA_ULT_RET) - 1 END),
		(CM.XCMCR_RETN_WRT_PRM) / 1000, (PM.XPMCR_RETN_WRT_PRM) / 1000, 
		(CASE WHEN PM.XPMCR_RETN_WRT_PRM = 0 THEN 0 ELSE (CM.XCMCR_RETN_WRT_PRM / PM.XPMCR_RETN_WRT_PRM) - 1 END),
		CM.XCMCR_RPC_AMT / 1000, (PM.XPMCR_RPC_AMT) / 1000, 
		(CASE WHEN PM.XPMCR_RPC_AMT = 0 THEN 0 ELSE (CM.XCMCR_RPC_AMT / PM.XPMCR_RPC_AMT) - 1 END),
		@UserName, GETDATE(), @UserName, GETDATE()
	FROM 
	XTRCT_CURR_MO_CTL_RPT CM LEFT JOIN XTRCT_PREV_MO_CTL_RPT PM
	ON (CM.XCMCR_BPM_LN_OF_BUS = PM.XPMCR_BPM_LN_OF_BUS) AND (CM.XCMCR_ST_CD = PM.XPMCR_ST_CD)
	INNER JOIN [CNFG_MSTR_ST_NM] SN ON CM.XCMCR_ST_CD = SN.CMSN_ST_CD

	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50721, 11, 'Control Report Data table: insert statement from previous & current month and statename did not succeed'
		return 50721
	  END


    exec @ret = OthInsUserMessage
                @SessionId, 
                @FunctionName = @FunctionName, 
                @Task_Name = 'Insert Statement: Control Report Data <-- From Previous & Current month and StateNames',
                @Status = 'Complete',
				@UserName = @UserName

   	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing insert previous & current month and stateNames table complete statement'
		return 50200
	  END

	exec @ret = OthSetCurrentAndNextSSIS
				@SessionId, 
				@FunctionName = @FunctionName, 
				@UserName = @UserName,
				@Curr_Package_Name = 'Control Report',
				@Next_Package_Name = 'Retention'
	
	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 100011, 11, 'MSDB Job: update statement did not succeed'
		return 100011
	  END

--EXTRACT STATUS: CONTROL COLUMN UPDATE STATEMENT START HERE

	UPDATE CRIT_STS_XTRCT SET CSX_CTL_IND = 'Y', CSX_LST_USER = @UserName, CSX_LST_DT_TM = GETDATE()
	WHERE CSX_YR_MO = @YearMonth

	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50801, 11, 'Extract Status table: control column update statement did not succeed'
		return 50801
	  END

--EXTRACT STATUS: CONTROL COLUMN UPDATE STATEMENT END HERE

  END

set nocount off

RETURN 0

GO

--------------------------------------------------------------------------------------------------------------------------------------------
-- Drop Procedure
--------------------------------------------------------------------------------------------------------------------------------------------

IF EXISTS (SELECT * FROM SYS.SYSOBJECTS WHERE ID = OBJECT_ID(N'[dbo].[EmlGetAddressBook]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
  DROP PROCEDURE [dbo].[EmlGetAddressBook]
GO

CREATE PROC EmlGetAddressBook
(	@MessageTemplateId	udtInteger,
	@Id					udtInteger = null output,
	@EMA_AT_To			udtEMailAddress = null output,
	@EMA_AT_Cc			udtEMailAddress = null output,
	@EMA_AT_Bcc			udtEMailAddress = null output,
	@LastUser			udtUserName = null output,
	@LastDateTime		udtDateTime = null output,
	@CreateUser			udtUserName = null output,
	@CreateDateTime		udtDateTime = null output
)

AS

--------------------------------------------------------------------------------------------------------------------------------------------
-- OBJECT NAME:    EmlGetAddressBook
--------------------------------------------------------------------------------------------------------------------------------------------
-- AUTHOR:			VIJAYA KUMAR GULAPPA
--------------------------------------------------------------------------------------------------------------------------------------------
-- CREATED:			MAY 22 2007
--------------------------------------------------------------------------------------------------------------------------------------------
-- DESCRIPTION:    	Get a record from address book table for a message template
--------------------------------------------------------------------------------------------------------------------------------------------
-- PARAMETERS:     <To be inserted>
--------------------------------------------------------------------------------------------------------------------------------------------
-- RETURNS:        0                -  success
--                 <To be inserted>
--                 returns from SQL Server
--------------------------------------------------------------------------------------------------------------------------------------------

-- VERSION: $Revision: 3 $  UPDATED: $Modtime: 8/02/07 3:16p $
--------------------------------------------------------------------------------------------------------------------------------------------

declare	@err	int,
		@rows	int,
		@FunctionName	[udtName]

set nocount on
Set @FunctionName = OBJECT_NAME(@@PROCID)

SELECT	@Id = EMAB_PK_ID, @EMA_AT_To = EMAB_To, @EMA_AT_Cc = EMAB_Cc, @EMA_AT_Bcc = EMAB_Bcc,
	@LastUser = EMAB_LST_USER, @LastDateTime = EMAB_LST_DT_TM,
	@CreateUser = EMAB_CREAT_USER, @CreateDateTime = EMAB_CREAT_DT_TM
FROM	EMAIL_MSTR_ADR_BK
WHERE	EMAB_MSG_TMPLT_ID = @MessageTemplateId

Select @rows = @@rowcount, @err = @@error

if @err != 0
BEGIN 
	exec OthInsErrorMessage null, @FunctionName, 51203, 11, 'Address Book: select statement failed'
	return 51203
END

if @rows = 0
BEGIN 
	exec OthInsErrorMessage null, @FunctionName, 51204, 11, 'Row Count: Zero'
	return 51204
END

set nocount off
return 0
GO
--------------------------------------------------------------------------------------------------------------------------------------------
-- Drop Procedure
--------------------------------------------------------------------------------------------------------------------------------------------

IF EXISTS (SELECT * FROM SYS.SYSOBJECTS WHERE ID = OBJECT_ID(N'[dbo].[EmlGetMessageTemplateForCode]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
  DROP PROCEDURE [dbo].[EmlGetMessageTemplateForCode]
GO

CREATE PROC EmlGetMessageTemplateForCode
(	@Code			udtCode,
	@Id				udtInteger = null output,
	@Subject		udtSubject = null output,
	@Message		udtMessage = null output,
	@From			udtEMailAddress = null output,
	@LastUser		udtUserName = null output,
	@LastDateTime	udtDateTime = null output,
	@CreateUser		udtUserName = null output,
	@CreateDateTime	udtDateTime = null output
)

AS

--------------------------------------------------------------------------------------------------------------------------------------------
-- OBJECT NAME:    EmlGetMessageTemplateForCode
--------------------------------------------------------------------------------------------------------------------------------------------
-- AUTHOR:			VIJAYA KUMAR GULAPPA
--------------------------------------------------------------------------------------------------------------------------------------------
-- CREATED:			MAY 22 2007
--------------------------------------------------------------------------------------------------------------------------------------------
-- DESCRIPTION:    	Get a record from message template table
--------------------------------------------------------------------------------------------------------------------------------------------
-- PARAMETERS:     <To be inserted>
--------------------------------------------------------------------------------------------------------------------------------------------
-- RETURNS:        0                -  success
--                 <To be inserted>
--                 returns from SQL Server
--------------------------------------------------------------------------------------------------------------------------------------------

-- VERSION: $Revision: 6 $  UPDATED: $Modtime: 8/08/07 1:57p $
--------------------------------------------------------------------------------------------------------------------------------------------

declare	@err	int,
		@rows	int,
		@FunctionName	[udtName]

set nocount on
Set @FunctionName = OBJECT_NAME(@@PROCID)

SELECT	@Id = EMMT_PK_ID, @Subject = EMMT_SBJ, @Message = EMMT_MSG, @From = EMMT_FROM,
	@LastUser = EMMT_LST_USER, @LastDateTime = EMMT_LST_DT_TM,
	@CreateUser = EMMT_CREAT_USER, @CreateDateTime = EMMT_CREAT_DT_TM
FROM	EMAIL_MSTR_MSG_TMPLT
WHERE	EMMT_CD = @Code

Select @rows = @@rowcount, @err = @@error

if @err != 0
BEGIN 
	exec OthInsErrorMessage null, @FunctionName, 51003, 11, 'Message Template: select statement failed', @Code
	return 51003
END

if @rows = 0
BEGIN 
	exec OthInsErrorMessage null, @FunctionName, 51004, 11, 'Row Count: Zero', @Code
	return 51004
END
set nocount off

return 0

GO

--------------------------------------------------------------------------------------------------------------------------------------------
-- Drop Procedure
--------------------------------------------------------------------------------------------------------------------------------------------

if exists (select * from sys.sysobjects where id = object_id(N'[dbo].[EmlInsMessage]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[EmlInsMessage]
GO


CREATE proc EmlInsMessage
(	@UserName		udtName,
	@Subject		udtSubject,
	@Message		udtMessage,
	@From			udtEMailAddress,
	@Attachments	udtAttachment = null,
	@Id				udtNumber = null output
)

AS

--------------------------------------------------------------------------------------------------------------------------------------------
-- OBJECT NAME:    EmlInsMessage
--------------------------------------------------------------------------------------------------------------------------------------------
-- AUTHOR:			VIJAYA KUMAR GULAPPA
--------------------------------------------------------------------------------------------------------------------------------------------
-- CREATED:			MAY 22 2007
--------------------------------------------------------------------------------------------------------------------------------------------
-- DESCRIPTION:    	Add a record in to message table
--------------------------------------------------------------------------------------------------------------------------------------------
-- PARAMETERS:     <To be inserted>
--------------------------------------------------------------------------------------------------------------------------------------------
-- RETURNS:        0                -  success
--                 <To be inserted>
--                 returns from SQL Server
--------------------------------------------------------------------------------------------------------------------------------------------

-- VERSION: $Revision: 3 $  UPDATED: $Modtime: 8/02/07 2:50p $
--------------------------------------------------------------------------------------------------------------------------------------------

declare @FunctionName	[udtName]

set nocount on
Set @FunctionName = OBJECT_NAME(@@PROCID)

If @Attachments is null or Len(@Attachments) = 0 Set @Attachments = ''

INSERT INTO	EMAIL_DTL_MSG
	(EDM_SBJ, EDM_MSG, EDM_FROM, EDM_ATTCH, 
		EDM_LST_USER, EDM_LST_DT_TM, EDM_CREAT_USER, EDM_CREAT_DT_TM)
VALUES
	(@Subject, @Message, @From, @Attachments, @UserName, Getdate(), @UserName, Getdate())

if @@error != 0
BEGIN 
	exec OthInsErrorMessage null, @FunctionName, 50900, 11, 'Message Table: insert statement did not succeed'
	return 50900
END

SELECT @Id = IDENT_CURRENT('EMAIL_DTL_MSG')

set nocount off

return 0

GO
--------------------------------------------------------------------------------------------------------------------------------------------
-- Drop Procedure
--------------------------------------------------------------------------------------------------------------------------------------------

IF EXISTS (SELECT * FROM SYS.SYSOBJECTS WHERE ID = OBJECT_ID(N'[dbo].[EmlInsRecipient]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
  DROP PROCEDURE [dbo].[EmlInsRecipient]
GO

CREATE PROC EmlInsRecipient
(	@UserName		udtName,
	@MessageId		udtNumber,
	@EMailAddress	udtEMailAddress,
	@Type			udtInteger = 1
)

AS

--------------------------------------------------------------------------------------------------------------------------------------------
-- OBJECT NAME:    EmlInsRecipient
--------------------------------------------------------------------------------------------------------------------------------------------
-- AUTHOR:			VIJAYA KUMAR GULAPPA
--------------------------------------------------------------------------------------------------------------------------------------------
-- CREATED:			MAY 22 2007
--------------------------------------------------------------------------------------------------------------------------------------------
-- DESCRIPTION:    	Add a record in to recipient table
--------------------------------------------------------------------------------------------------------------------------------------------
-- PARAMETERS:     <To be inserted>
--------------------------------------------------------------------------------------------------------------------------------------------
-- RETURNS:        0                -  success
--                 <To be inserted>
--                 returns from SQL Server
--------------------------------------------------------------------------------------------------------------------------------------------

-- VERSION: $Revision: 3 $  UPDATED: $Modtime: 8/02/07 3:00p $
--------------------------------------------------------------------------------------------------------------------------------------------

declare @FunctionName	[udtName]

set nocount on
Set @FunctionName = OBJECT_NAME(@@PROCID)


INSERT INTO EMAIL_DTL_RCIP
	(EDR_MSG_ID, EDR_EMAIL_ADR, EDR_TYP, EDR_SND_IND, EDR_SND_DT_TM,
		EDR_LST_USER, EDR_LST_DT_TM, EDR_CREAT_USER, EDR_CREAT_DT_TM)
VALUES
	(@MessageId, @EMailAddress, @Type, 'N', Getdate(), @UserName, Getdate(), @UserName, Getdate())

if @@error != 0
BEGIN 
	exec OthInsErrorMessage null, @FunctionName, 51100, 11, 'Recipient Table: insert statement did not succeed'
	return 51100
END

set nocount off

return 0

GO
-- 
--------------------------------------------------------------------------------------------------------------------------------------------
-- Drop Procedure
--------------------------------------------------------------------------------------------------------------------------------------------
if exists (select * from sys.sysobjects where id = object_id(N'[dbo].[EmlReconcile]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[EmlReconcile]
GO

--------------------------------------------------------------------------------------------------------------------------------------------
-- Create procedure
--------------------------------------------------------------------------------------------------------------------------------------------
CREATE PROCEDURE EmlReconcile
(	@SessionId		udtNumber,
	@FunctionName	udtName,
	@Code			udtCode
)
AS 
--------------------------------------------------------------------------------------------------------------------------------------------
-- OBJECT NAME:    EmlReconcile
--------------------------------------------------------------------------------------------------------------------------------------------
-- AUTHOR:         Vijaya Kumar Gulappa
--------------------------------------------------------------------------------------------------------------------------------------------
-- CREATED:        May 22 2007
--------------------------------------------------------------------------------------------------------------------------------------------
-- DESCRIPTION:    Get Message Template & Address Book record and add a row in message and recipient tables
--------------------------------------------------------------------------------------------------------------------------------------------
-- PARAMETERS:
--------------------------------------------------------------------------------------------------------------------------------------------
-- RETURNS:        0  -  success
--                 returns from SQL Server
--------------------------------------------------------------------------------------------------------------------------------------------
-- VERSION: $Revision: 4 $  UPDATED: $Modtime: 6/06/07 1:40p $
--------------------------------------------------------------------------------------------------------------------------------------------

declare	@ret int,
		@UserName			udtName,
		@Message			udtMessage,
		@Subject			udtSubject,
		@From				udtEMailAddress,
		@MessageTemplateId	udtInteger,
		@MessageId			udtNumber,
		@EMA_AT_To			udtEMailAddress,
		@EMA_AT_Cc			udtEMailAddress,
		@EMA_AT_Bcc			udtEMailAddress

set nocount on
Set @FunctionName = OBJECT_NAME(@@PROCID)

SET @ret = 0

  BEGIN

	Exec @ret = UsrGetSessionInfo @SessionId = @SessionId,
								@FunctionName = @FunctionName,
								@UMS_AT_Name = @UserName Output

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50103, 11, 'Get Session Information: Exec UsrGetSessionInfo failed'
		return 50103
	  END

	If @UserName is null or len(@UserName) = 0 Set @UserName = suser_sname()

	exec @ret = EmlGetMessageTemplateForCode
				@Code = @Code, 
				@Subject = @Subject Output, 
				@Message = @Message Output, 
				@From = @From Output,
				@Id = @MessageTemplateId Output
	
	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage null, @FunctionName, 51003, 11, 'Message Template: select statement failed'
		return 51003
	  END

	exec @ret = OthInsUserMessage
				@SessionId, 
				@FunctionName = @FunctionName, 
				@Task_Name = 'Select Statement: From Message Template',
				@Status = 'Complete'

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing select message template table complete statement'
		return 50200
	  END


	exec @ret = EmlGetAddressBook
				@MessageTemplateId = @MessageTemplateId, 
				@EMA_AT_To = @EMA_AT_To Output,
				@EMA_AT_Cc = @EMA_AT_Cc Output,
				@EMA_AT_Bcc = @EMA_AT_Bcc Output
	
	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage null, @FunctionName, 51203, 11, 'Address Book: select statement failed'
		return 51203
	  END

	exec @ret = OthInsUserMessage
				@SessionId, 
				@FunctionName = @FunctionName, 
				@Task_Name = 'Select Statement: From Address Book',
				@Status = 'Complete'

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing select address book table complete statement'
		return 50200
	  END

	Set @Subject = @Subject + ' @ ' + @@SERVERNAME
	Set @Message = Replace(@Message, '<MonthName>', DATENAME(MM, GETDATE()))
	Set @Message = Replace(@Message, '<Year Name>', DATEPART(yyyy, GETDATE()))

	exec @ret = EmlInsMessage
				@UserName = @UserName, 
				@Subject = @Subject, 
				@Message = @Message,
				@From = @From,
				@Id = @MessageId Output
	
	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage null, @FunctionName, 50900, 11, 'Message Table: insert statement failed'
		return 50900
	  END

	exec @ret = OthInsUserMessage
				@SessionId, 
				@FunctionName = @FunctionName, 
				@Task_Name = 'Insert Statement: Message',
				@Status = 'Complete'

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing insert message table complete statement'
		return 50200
	  END
    
	exec @ret = EmlInsRecipient
				@UserName = @UserName, 
				@MessageId = @MessageId, 
				@EMailAddress = @EMA_AT_To
	
	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 51100, 11, 'Recipient Table: insert statement failed'
		return 51100
	  END

	exec @ret = OthInsUserMessage
				@SessionId, 
				@FunctionName = @FunctionName, 
				@Task_Name = 'Insert Statement: Recipient',
				@Status = 'Complete'

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing insert recipient table complete statement'
		return 50200
	  END
    
  END

set nocount off

RETURN @ret
-- 
--------------------------------------------------------------------------------------------------------------------------------------------
-- Drop Procedure
--------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM SYS.SYSOBJECTS WHERE ID = OBJECT_ID(N'[dbo].[EmlSendEMail]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
  DROP PROCEDURE [dbo].[EmlSendEMail]
GO

--------------------------------------------------------------------------------------------------------------------------------------------
-- Create procedure
--------------------------------------------------------------------------------------------------------------------------------------------
CREATE proc EmlSendEMail
(	@FunctionName	[udtName]
)

AS

--------------------------------------------------------------------------------------------------------------------------------------------
-- OBJECT NAME:    EmlSendEMail
--------------------------------------------------------------------------------------------------------------------------------------------
-- AUTHOR:         VIJAYA KUMAR GULAPPA
--------------------------------------------------------------------------------------------------------------------------------------------
-- CREATED:        MAY 22 2007
--------------------------------------------------------------------------------------------------------------------------------------------
-- DESCRIPTION:    This proc sends an email to a fmr users using MSSQL sp_send_dbmail stored procedure
--------------------------------------------------------------------------------------------------------------------------------------------
-- PARAMETERS:      @FunctionName [dtname]           - (INPUT) function name
--------------------------------------------------------------------------------------------------------------------------------------------
-- RETURNS:        0                -  success
--                 <To be inserted>
--                 returns from SQL Server
--------------------------------------------------------------------------------------------------------------------------------------------

-- VERSION: $Revision: 4 $  UPDATED: $Modtime: 8/02/07 3:02p $
--------------------------------------------------------------------------------------------------------------------------------------------

declare	@ret	int
declare	@rows	int

declare	@MessageId		udtNumber,
		@Subject		udtSubject,
		@Message		udtMessage,
		@From			udtEMailAddress,
		@LastFrom		udtEMailAddress,
		@RecipientId	udtNumber,
		@Recipient		udtEMailAddress,
		@RecipientType	udtInteger,
		@Attachments	udtAttachment

set nocount on

DECLARE csrMessage CURSOR
LOCAL
FORWARD_ONLY
STATIC
FOR
SELECT 
	M.EDM_PK_ID, M.EDM_SBJ, M.EDM_MSG, M.EDM_FROM, M.EDM_ATTCH, R.EDR_PK_ID, 
	R.EDR_EMAIL_ADR, R.EDR_TYP
FROM
	EMAIL_DTL_MSG M, EMAIL_DTL_RCIP R
WHERE
	M.EDM_PK_ID = R.EDR_MSG_ID AND
	R.EDR_SND_IND = 'N' --AND
	--R.EDR_AT_EMailAddress <> 'UNKNOWN'
ORDER BY M.EDM_FROM

if @@error != 0
begin
	exec OthInsErrorMessage null, @FunctionName, 100001, 11, 'Message & Recipient: select statement failed', 'csrMessage'
	return 100001
end

OPEN csrMessage
if @@error != 0
begin
	exec OthInsErrorMessage null, @FunctionName, 100002, 11, 'Message & Recipient: select statement executed however opening cursor failure', 'csrMessage'
	return 100002
end

SELECT @rows = @@cursor_rows

IF @rows < 1 
BEGIN
	exec OthInsErrorMessage null, @FunctionName, 100006, 11, 'Message & Recipient: No rows', 'csrMessage'
	GOTO ExitSuccess
END

FETCH NEXT FROM csrMessage
INTO	@MessageId, @Subject, @Message, @From, @Attachments, @RecipientId, @Recipient, @RecipientType

IF @@error != 0
BEGIN
	exec OthInsErrorMessage null, @FunctionName, 100005, 11, 'Message & Recipient: fetch next row failed', 'csrMessage'
	Goto ExitError
END

Set	@LastFrom = ''
WHILE @@FETCH_STATUS = 0
BEGIN
	
	-- send each email
	--if @Attachments is null
	begin	
		exec @ret = msdb.dbo.sp_send_dbmail	@subject = @subject,
							@body = @message,
							@recipients = @recipient,
							@exclude_query_output = 'true'
	end
	/*else
	begin
		exec @ret = msdb.dbo.sp_send_dbmail	@subject = @subject,
							@message = @message,
							@recipients = @recipient,
							@Attachments = @Attachments,
							@no_output = 'true',
							@set_user = @from
	end*/
	if @@error != 0 or @ret != 0
	begin
		GOTO NextEMail
	end

	-- set the sent flag and date/time for the message
	UPDATE	EMAIL_DTL_RCIP
	SET	EDR_SND_IND = 'Y',
		EDR_SND_DT_TM = getdate()
	WHERE	EDR_PK_ID = @RecipientId
	if @@error != 0
	begin
		GOTO NextEMail
	end
	
NextEMail:
	FETCH NEXT FROM csrMessage
	INTO	@MessageId, @Subject, @Message, @From, @Attachments, @RecipientId, @Recipient, @RecipientType
	IF @@error != 0
	BEGIN
		exec OthInsErrorMessage null, @FunctionName, 100005, 11, 'Message & Recipient: fetch next row failed', 'csrMessage'
		Goto ExitError
	END
END

ExitSuccess:

CLOSE csrMessage
if @@error != 0
begin
	exec OthInsErrorMessage null, @FunctionName, 100003, 11, 'Message & Recipient: close cursor failed', 'csrMessage'
	return 100003
end 

DEALLOCATE csrMessage
if @@error != 0
begin
	exec OthInsErrorMessage null, @FunctionName, 100004, 11, 'Message & Recipient: memory clean-up failed', 'csrMessage'
	return 100004
end 

set nocount off

return 0

ExitError:

CLOSE csrMessage
if @@error != 0
begin
	exec OthInsErrorMessage null, @FunctionName, 100003, 11, 'Message & Recipient: close cursor failed', 'csrMessage'
	return 100003
end 

DEALLOCATE csrMessage
if @@error != 0
begin
	exec OthInsErrorMessage null, @FunctionName, 100004, 11, 'Message & Recipient: memory clean-up failed', 'csrMessage'
	return 100004
end 

set nocount off

return 1

GO
--------------------------------------------------------------------------------------------------------------------------------------------
-- Drop Procedure
--------------------------------------------------------------------------------------------------------------------------------------------
if exists (select * from sysobjects where id = object_id(N'[dbo].[OthCalculateNextDate]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[OthCalculateNextDate]
GO

CREATE PROCEDURE OthCalculateNextDate
(	
	@SessionId		[udtNumber],
	@FunctionName	[udtName],
	@UserName		udtName,
	@FromDate	[udtDateTime] Output
)
AS
--------------------------------------------------------------------------------------------------------------------------------------------
-- OBJECT NAME:    OthCalculateNextDate
--------------------------------------------------------------------------------------------------------------------------------------------
-- AUTHOR:			VIJAYA KUMAR GULAPPA
--------------------------------------------------------------------------------------------------------------------------------------------
-- CREATED:			01 AUG 2007
--------------------------------------------------------------------------------------------------------------------------------------------
-- DESCRIPTION:    Calculate job next date for execution.  
--------------------------------------------------------------------------------------------------------------------------------------------
-- PARAMETERS:     <To be inserted>
--------------------------------------------------------------------------------------------------------------------------------------------
-- RETURNS:        0                -  success
--                 <To be inserted>
--                 returns from SQL Server
--------------------------------------------------------------------------------------------------------------------------------------------

-- VERSION: $Revision: 5 $  UPDATED: $Modtime: 8/15/07 9:12a $
--------------------------------------------------------------------------------------------------------------------------------------------


declare	
		@ret		int,
		@DateFirst	int,
		@intDay		int,
		@found		bit,
		@IsHoliday	int,
		@NextDate	[udtDateTime]

set nocount on

-- take the definition of the first day of the week
set	@DateFirst = @@DATEFIRST
set @found = 0
set @IsHoliday = 0
set @ret = 0
-- set the first day of the week to Sunday
set DATEFIRST 7

begin
	set	@NextDate = dateadd(month, 1, @FromDate)
--While loop make sure "NextDate" should be on a week date instead of weekend.  
--SSIS Package should not run on weekends and holidays.
	while (@found = 0)
	begin
		set	@intDay = datepart(weekday, @NextDate)
		if @intDay in (2, 3, 4, 5, 6)
		begin
			exec @ret = ConCheckHoliday
						@SessionId, 
						@FunctionName = @FunctionName, 
						@UserName = @UserName,
						@Hol_Date = @NextDate,
						@IsHoliday = @IsHoliday Output
			IF  @ret != 0 
			  BEGIN 
				exec OthInsErrorMessage @SessionId, @FunctionName, 52203, 11, 'Holiday table: select statement did not succeed'
				return 52203
			  END
			IF @IsHoliday = 0 break
		end
		set	@NextDate = dateadd(day, 1, @NextDate)
	end

	set @FromDate = @NextDate
end

set nocount off

set DATEFIRST @DateFirst

return	0

GO

-- 
-- 
--------------------------------------------------------------------------------------------------------------------------------------------
-- Drop Procedure
--------------------------------------------------------------------------------------------------------------------------------------------
if exists (select * from sys.sysobjects where id = object_id(N'[dbo].[OthInsErrorMessage]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[OthInsErrorMessage]
GO

CREATE PROCEDURE OthInsErrorMessage
(	@SessionId		udtNumber,
	@FunctionName	udtName,
	@Err_Number		udtInteger,
	@Severity		udtSeverity,
	@Task_Name 		udtMessage,
	@Arg2			udtErrorArgument = '',
	@Arg3			udtErrorArgument = '',
	@Arg4			udtErrorArgument = '',
	@Arg5			udtErrorArgument = '',
	@Arg6			udtErrorArgument = '',
	@Arg7			udtErrorArgument = '',
	@Arg8			udtErrorArgument = '',
	@Arg9			udtErrorArgument = '',
	@Arg10			udtErrorArgument = '',
	@Arg11			udtErrorArgument = '',
	@Arg12			udtErrorArgument = '',
	@Arg13			udtErrorArgument = '',
	@Arg14			udtErrorArgument = '',
	@Arg15			udtErrorArgument = '',
	@Arg16			udtErrorArgument = '',
	@Arg17			udtErrorArgument = '',
	@Arg18			udtErrorArgument = '',
	@Arg19			udtErrorArgument = ''
)

AS 
--------------------------------------------------------------------------------------------------------------------------------------------
-- OBJECT NAME:    OthInsErrorMessage
--------------------------------------------------------------------------------------------------------------------------------------------
-- AUTHOR:			VIJAYA KUMAR GULAPPA
--------------------------------------------------------------------------------------------------------------------------------------------
-- CREATED:			MAY 08 2007
--------------------------------------------------------------------------------------------------------------------------------------------
-- DESCRIPTION:    	Adds a record to the Error Log table
--------------------------------------------------------------------------------------------------------------------------------------------
-- PARAMETERS:     <To be inserted>
--------------------------------------------------------------------------------------------------------------------------------------------
-- RETURNS:        0                -  success
--                 <To be inserted>
--                 returns from SQL Server
--------------------------------------------------------------------------------------------------------------------------------------------

-- VERSION: $Revision: 15 $  UPDATED: $Modtime: 8/08/07 3:15p $
--------------------------------------------------------------------------------------------------------------------------------------------

declare @ret int
declare	@msg udtName,
		@Err_Message	udtMessage,
		@YearMonth	udtEffYrMon

SET @YearMonth = CAST(DATEPART(YYYY, GETDATE()) AS VARCHAR(4)) + (CASE WHEN LEN(DATEPART(M, GETDATE())) = 1 THEN '0' ELSE '' END) + CAST(DATEPART(M, GETDATE()) AS VARCHAR(2))

/*
Due to FMR automation: File Exists and Zero Bytes File Size Validation have been ignored using below if condition 
however we can remove the if condition when we need to enable those validation!
*/
IF @Err_Number NOT IN (50002, 50003, 50012, 50013, 50022, 50023, 50701, 50702, 50712, 50713, 51301, 51302, 51801, 
			51802, 51902, 51903, 51912, 51913, 51922, 51923)
BEGIN
	if exists(select 1 from master..sysmessages where error = @Err_Number)
	Begin
		SELECT	@Err_Message = description	
		FROM master..sysmessages
		WHERE error = @Err_Number
		
		if @@error != 0
		begin
			select	@msg = 'OthInsErrorMessage: FATAL ERROR\nMessage number ' + convert(varchar(255), @Err_Number) + ' does not exist!'
			raiserror(@msg, 11, 2) with seterror
			return	1
		end

		SELECT	@Err_Message = FormatMessage(CAST(@Err_Number AS INT), @Arg2, @Arg3, @Arg4, @Arg5, @Arg6, @Arg7, 
					@Arg8, @Arg9, @Arg10, @Arg11, @Arg12, @Arg13, @Arg14, @Arg15, @Arg16, @Arg17, @Arg18, @Arg19) 

		INSERT INTO fmr.dbo.LOG_ERR_FIN_MGT_RPT 
			 (LEFMR_NBR, LEFMR_SEV, LEFMR_MSG, LEFMR_TSK_NM, LEFMR_OBJ_NM,
				LEFMR_YR_MO, LEFMR_LST_USER, LEFMR_LST_DT_TM, LEFMR_CREAT_USER, LEFMR_CREAT_DT_TM) 
		VALUES 
			(@Err_Number, @Severity, @Err_Message, @Task_Name, @FunctionName, @YearMonth, suser_sname(), getdate(), suser_sname(), getdate())

		if @@error != 0
		begin
			raiserror('OthInsErrorMessage: FATAL ERROR\nError inserting event message!', 11, 2) with seterror
			return	1
		end
	End
	else
	Begin
		Set	@Err_Message = 'OthInsErrorMessage: FATAL ERROR\nMessage number ' + convert(varchar(255), @Err_Number) + ' does not exist!'
		raiserror(@Err_Message, 11, 2) with seterror
		return	1
	End
	if	@@error != 0
	begin
		select	@Err_Message = 'OthInsErrorMessage: FATAL ERROR\nError finding message '+ convert(varchar(255), @Err_Number) + ' in sysmessages!'
		raiserror(@Err_Message, 11, 2) with seterror
		return	1	
	end

	IF @Arg3 = 'Y'
	BEGIN
		exec @ret = EmlReconcile
					@SessionId, 
					@FunctionName = @FunctionName, 
					@Code = 'EO'
	END
END

RAISERROR(@Err_Number, @Severity, 2, @Arg2, @Arg3, @Arg4, @Arg5, @Arg6, @Arg7, @Arg8, @Arg9, @Arg10, @Arg11, @Arg12, @Arg13, @Arg14, @Arg15, @Arg16, @Arg17, @Arg18, @Arg19) with seterror

return 0

GO

-- 
--------------------------------------------------------------------------------------------------------------------------------------------
-- Drop Procedure
--------------------------------------------------------------------------------------------------------------------------------------------
if exists (select * from sys.sysobjects where id = object_id(N'[dbo].[OthInsUserMessage]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[OthInsUserMessage]
GO

CREATE PROCEDURE OthInsUserMessage
(	@SessionId		[udtNumber],
	@FunctionName	[udtName],
	@Task_Name 		[udtMessage],
	@Status 		[udtStatus],
	@UserName		udtName = null
)

AS 
--------------------------------------------------------------------------------------------------------------------------------------------
-- OBJECT NAME:    OthInsUserMessage
--------------------------------------------------------------------------------------------------------------------------------------------
-- AUTHOR:			VIJAYA KUMAR GULAPPA
--------------------------------------------------------------------------------------------------------------------------------------------
-- CREATED:			MAY 08 2007
--------------------------------------------------------------------------------------------------------------------------------------------
-- DESCRIPTION:    	Adds a record to the Message Log table
--------------------------------------------------------------------------------------------------------------------------------------------
-- PARAMETERS:     <To be inserted>
--------------------------------------------------------------------------------------------------------------------------------------------
-- RETURNS:        0                -  success
--                 <To be inserted>
--                 returns from SQL Server
--------------------------------------------------------------------------------------------------------------------------------------------

-- VERSION: $Revision: 10 $  UPDATED: $Modtime: 8/03/07 9:58a $
--------------------------------------------------------------------------------------------------------------------------------------------
--suser_sname() should be replace with username/session id parameter

declare @ret int,
		@YearMonth	udtEffYrMon
		
set nocount on

SET @YearMonth = CAST(DATEPART(YYYY, GETDATE()) AS VARCHAR(4)) + (CASE WHEN LEN(DATEPART(M, GETDATE())) = 1 THEN '0' ELSE '' END) + CAST(DATEPART(M, GETDATE()) AS VARCHAR(2))

If @UserName is null or len(@UserName) = 0
Begin

	exec @ret = UsrGetSessionInfo @SessionId = @SessionId,
								@FunctionName = @FunctionName,
								@UMS_AT_Name = @UserName Output

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50103, 11, 'Get Session Information: Exec UsrGetSessionInfo failed'
		return 50103
	  END
End

If @UserName is null or len(@UserName) = 0 Set @UserName = suser_sname()

INSERT INTO [dbo].[LOG_MSG_FIN_MGT_RPT] 
	 (LMFMR_OBJ_NM, LMFMR_TSK_NM, LMFMR_STS, LMFMR_YR_MO, LMFMR_LST_USER, LMFMR_LST_DT_TM, LMFMR_CREAT_USER, LMFMR_CREAT_DT_TM) 
VALUES 
	(@FunctionName, @Task_Name, @Status, @YearMonth, @UserName, getdate(), @UserName, getdate())

IF  @@error != 0 
  BEGIN 
    exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Message Log table: insert statement did not succeed'
	return 50200
  END

set nocount off
return 0
GO

--------------------------------------------------------------------------------------------------------------------------------------------
-- Drop Procedure
--------------------------------------------------------------------------------------------------------------------------------------------
if exists (select * from sysobjects where id = object_id(N'[dbo].[OthSetCurrentAndNextSSIS]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[OthSetCurrentAndNextSSIS]
GO

CREATE PROCEDURE OthSetCurrentAndNextSSIS
(	
	@SessionId			[udtNumber],
	@FunctionName		[udtName],
	@UserName			udtName,
	@Curr_Package_Name	udtName,
	@Next_Package_Name	udtName
)
AS
--------------------------------------------------------------------------------------------------------------------------------------------
-- OBJECT NAME:    OthSetCurrentAndNextSSIS
--------------------------------------------------------------------------------------------------------------------------------------------
-- AUTHOR:			VIJAYA KUMAR GULAPPA
--------------------------------------------------------------------------------------------------------------------------------------------
-- CREATED:			01 AYG 2007
--------------------------------------------------------------------------------------------------------------------------------------------
-- DESCRIPTION:    Disable & Enable SSIS package and set execution date for enabled package
--------------------------------------------------------------------------------------------------------------------------------------------
-- PARAMETERS:     <To be inserted>
--------------------------------------------------------------------------------------------------------------------------------------------
-- RETURNS:        0                -  success
--                 <To be inserted>
--                 returns from SQL Server
--------------------------------------------------------------------------------------------------------------------------------------------

-- VERSION: $Revision: 6 $  UPDATED: $Modtime: 8/10/07 3:12p $
--------------------------------------------------------------------------------------------------------------------------------------------


declare	
		@ret		int,
		@StartDate  UDTEFFYRMON,
		@FromDate	udtDateTime,
		@NewPackage_Name	udtName

set nocount on

Set @FunctionName = OBJECT_NAME(@@PROCID)
SET @ret = 0
SET @FromDate = CONVERT(VARCHAR(10), GETDATE(), 120)

Begin

	exec @ret = OthCalculateNextDate @SessionId = @SessionId,
								@FunctionName = @FunctionName,
								@UserName = @UserName,
								@FromDate = @FromDate Output

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 51501, 11, 'Calculate Next Date Information: Exec OthCalculateNextDate failed'
		return 51501
	  END

	SET @StartDate = REPLACE(CONVERT(VARCHAR(10), @FromDate, 120), '-', '')

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 51503, 11, 'Get System Preference: Exec ConGetSystemPreferenceValue failed'
		return 51503
	  END

    exec @ret = OthInsUserMessage
                @SessionId = @SessionId, 
                @FunctionName = @FunctionName, 
                @Task_Name = 'Select Statement: System Preference',
                @Status = 'Complete',
				@UserName = @UserName

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing select system preference data table complete statement'
		return 50200
	  END

--SET CURRENT & NEXT SSIS PACKAGE UPDATE STATEMENT START HERE
	SET @NewPackage_Name = ''
	SET @NewPackage_Name = @Curr_Package_Name + ' -- Disabled'

	EXEC @ret = msdb.dbo.sp_update_job
		@job_name = @Curr_Package_Name,
		@new_name = @NewPackage_Name,
		@enabled = 0 ;

	IF  @ret != 0  
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 100009, 11, 'msdb.dbo.sp_update_job: Disable current job update Statement failed', @Curr_Package_Name
		return 100009
	  END

    exec @ret = OthInsUserMessage
                @SessionId, 
                @FunctionName = @FunctionName, 
                @Task_Name = 'Disable current job update Statement: msdb.dbo.sp_update_job ',
                @Status = 'Complete',
				@UserName = @UserName

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing disable current job update statement msdb.dbo.sp_update_job complete statement'
		return 50200
	  END

	EXEC @ret = msdb.dbo.sp_update_schedule
		@name = @Curr_Package_Name,
		@new_name = @NewPackage_Name,
		@enabled = 0,
		@active_start_date = @StartDate

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 100009, 11, 'msdb.dbo.sp_update_schedule: Disable current job update Statement failed', @Curr_Package_Name
		return 100009
	  END

    exec @ret = OthInsUserMessage
                @SessionId, 
                @FunctionName = @FunctionName, 
                @Task_Name = 'Disable current job update Statement: msdb.dbo.sp_update_schedule ',
                @Status = 'Complete',
				@UserName = @UserName

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing disable current job update statement msdb.dbo.sp_update_schedule complete statement'
		return 50200
	  END

--	UPDATE msdb.dbo.sysjobs SET ENABLED = 1 WHERE NAME = @Next_Package_Name

	SET @NewPackage_Name = ''
	SET @NewPackage_Name = @Next_Package_Name	
	SET @Next_Package_Name = @Next_Package_Name + ' -- Disabled'

	EXEC msdb.dbo.sp_update_job
		@job_name = @Next_Package_Name,
		@new_name = @NewPackage_Name,
		@enabled = 1 ;

	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 100009, 11, 'msdb.dbo.sp_update_job: Enable next job update Statement failed', @Next_Package_Name
		return 100009
	  END

    exec @ret = OthInsUserMessage
                @SessionId, 
                @FunctionName = @FunctionName, 
                @Task_Name = 'Enable Next job update Statement: msdb.dbo.sp_update_job ',
                @Status = 'Complete',
				@UserName = @UserName

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing enable next job update statement msdb.dbo.sp_update_job complete statement'
		return 50200
	  END

	--UPDATE msdb.dbo.sysschedules SET ENABLED = 1 WHERE NAME = @Next_Package_Name

	EXEC @ret = msdb.dbo.sp_update_schedule
		@name = @Next_Package_Name,
		@new_name = @NewPackage_Name,
		@enabled = 1	

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 100010, 11, 'msdb.dbo.sp_update_schedule: Enable next job update Statement failed', @Next_Package_Name
		return 100010
	  END

    exec @ret = OthInsUserMessage
                @SessionId, 
                @FunctionName = @FunctionName, 
                @Task_Name = 'Enable next job update Statement: msdb.dbo.sp_update_schedule ',
                @Status = 'Complete',
				@UserName = @UserName

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing enable next job update statement msdb.dbo.sp_update_schedule complete statement'
		return 50200
	  END

--SET CURRENT & NEXT SSIS PACKAGE UPDATE STATEMENT END HERE

End

set nocount off

return	0

GO

--------------------------------------------------------------------------------------------------------------------------------------------
-- Drop Procedure
--------------------------------------------------------------------------------------------------------------------------------------------
if exists (select * from sys.sysobjects where id = object_id(N'[dbo].[OthSetPermissions]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[OthSetPermissions]
GO



--------------------------------------------------------------------------------------------------------------------------------------------
-- Create procedure
--------------------------------------------------------------------------------------------------------------------------------------------
CREATE PROCEDURE OthSetPermissions
AS
--------------------------------------------------------------------------------------------------------------------------------------------
-- OBJECT NAME:    dbo.OthSetPermissions.PRC
--------------------------------------------------------------------------------------------------------------------------------------------
-- AUTHOR:         VIJAYA KUMAR GULAPPA
--------------------------------------------------------------------------------------------------------------------------------------------
-- CREATED:        JUNE 07 2007
--------------------------------------------------------------------------------------------------------------------------------------------
-- DESCRIPTION:    Set permission for fmr database objects
--------------------------------------------------------------------------------------------------------------------------------------------
-- PARAMETERS:     
--                 
--------------------------------------------------------------------------------------------------------------------------------------------
-- RETURNS:        0  -  Success
--                 returns from SQL Server
--------------------------------------------------------------------------------------------------------------------------------------------

-- VERSION: $Revision: 3 $  UPDATED: $Modtime: 6/15/07 9:56a $
--------------------------------------------------------------------------------------------------------------------------------------------


  ------------------------------------------------------------------------------------------------------------------------------------------
  -- Initialise procedure
  ------------------------------------------------------------------------------------------------------------------------------------------
  SET NOCOUNT ON
  DECLARE @ret int
        , @Allocated tinyint
        , @Open tinyint
        , @Name varchar(255)
        , @xtype varchar(16)
        , @SQL varchar(1024)

  SELECT  @ret = 0
        , @Allocated = 0
        , @Open = 0

  DENY CREATE DEFAULT, CREATE PROCEDURE, CREATE RULE, CREATE TABLE, CREATE VIEW, BACKUP DATABASE, BACKUP LOG TO FmrDevelopers, FmrStaff, [public]
  GRANT CREATE DEFAULT, CREATE PROCEDURE, CREATE RULE, CREATE TABLE, CREATE VIEW, BACKUP DATABASE, BACKUP LOG TO FmrAdministrators

  --DECLARE csrObjects CURSOR LOCAL FORWARD_ONLY STATIC FOR SELECT [name], xtype FROM SYS.SYSOBJECTS WHERE xtype IN ('s', 'u', 'p')
  DECLARE csrObjects CURSOR LOCAL FORWARD_ONLY STATIC FOR SELECT [name], xtype FROM SYS.SYSOBJECTS WHERE xtype IN ('u', 'p', 'v')
  IF @@ERROR != 0
   BEGIN
     SET @SQL = 'Could not allocate cursor for ' + DB_NAME() + ' objects!'
     RAISERROR (@SQL, 16, 1)
     SET @ret = -1
   END

  IF @ret = 0
    BEGIN
      SET @Allocated = 1

      --------------------------------------------------------------------------------------------------------------------------------------
      -- Open cursor
      --------------------------------------------------------------------------------------------------------------------------------------
      OPEN csrObjects
      IF @@ERROR != 0
        BEGIN
          RAISERROR ('Error opening fmr objects cursor', 16, 1)
          SET @ret = -1
        END
    END

  IF @ret = 0
    BEGIN
      SET @Open = 1

      ----------------------------------------------------------------------------------------------------------------------------------------
      -- Check we've got some data
      ----------------------------------------------------------------------------------------------------------------------------------------
      IF @@CURSOR_ROWS < 1
        BEGIN
          SET @ret = 1
        END
    END

  IF @ret = 0
    BEGIN
      --------------------------------------------------------------------------------------------------------------------------------------
      -- Get the 1st row
      --------------------------------------------------------------------------------------------------------------------------------------
      FETCH NEXT FROM csrObjects INTO @Name, @xtype
      IF @@ERROR != 0
        BEGIN
          RAISERROR ('Error getting first record', 16, 1)
          SET @ret = -1
        END
    END

  WHILE (@@FETCH_STATUS = 0) AND (@ret = 0)
    BEGIN
      PRINT ''
      PRINT '@Name: ' + @Name

      SET @SQL = 'DENY ALL ON [' + DB_NAME() + '].[dbo].[' + RTRIM(@Name) + '] TO [FmrAdministrators], [FmrDevelopers], [FmrStaff], [public]'
      PRINT '@SQL:  ' + @SQL
      EXECUTE (@SQL)

      SET @SQL = 'GRANT ALL ON [' + DB_NAME() + '].[dbo].[' + RTRIM(@Name) + '] to [FmrAdministrators]'
      PRINT '@SQL:  ' + @SQL
      EXECUTE (@SQL)

      /*IF @xtype = 's'
        BEGIN
          SET @SQL = 'GRANT SELECT ON [' + DB_NAME() + '].[dbo].[' + RTRIM(@Name) + '] to [FmrDevelopers], [FmrStaff]'
          PRINT '@SQL:  ' + @SQL
          EXECUTE (@SQL)
        END
		*/
      IF @xtype = 'p'
        BEGIN
          SET @SQL = 'GRANT EXEC ON [' + DB_NAME() + '].[dbo].[' + RTRIM(@Name) + '] to [FmrDevelopers], [FmrStaff]'
          PRINT '@SQL:  ' + @SQL
          EXECUTE (@SQL)
        END

      IF @xtype in ('u', 'v')
        BEGIN
          SET @SQL = 'GRANT SELECT ON [' + DB_NAME() + '].[dbo].[' + RTRIM(@Name) + '] to [FmrDevelopers]'
          PRINT '@SQL:  ' + @SQL
          EXECUTE (@SQL)
        END

      SET @SQL = 'REVOKE ALL ON [' + DB_NAME() + '].[dbo].[' + RTRIM(@Name) + '] to [public]'
      PRINT '@SQL:  ' + @SQL
      EXECUTE (@SQL)

      ----------------------------------------------------------------------------------------------------------------------------------------
      -- Get the next row
      ----------------------------------------------------------------------------------------------------------------------------------------
      FETCH NEXT FROM csrObjects INTO @Name, @xtype
      IF @@ERROR != 0
        BEGIN
          RAISERROR ('Error getting next record', 16, 1)
          SET @ret = -1
        END
    END

  IF @Open = 1
    BEGIN
      CLOSE csrObjects
    END

  IF @Allocated = 1
    BEGIN
      DEALLOCATE csrObjects
    END

  RETURN @ret
GO

--------------------------------------------------------------------------------------------------------------------------------------------
-- Drop Procedure
--------------------------------------------------------------------------------------------------------------------------------------------
if exists (select * from sys.sysobjects where id = object_id(N'[dbo].[RptInsEarnPremiumAndLossRatio]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[RptInsEarnPremiumAndLossRatio]
GO

--------------------------------------------------------------------------------------------------------------------------------------------
-- Create procedure
--------------------------------------------------------------------------------------------------------------------------------------------
CREATE PROCEDURE RptInsEarnPremiumAndLossRatio
(	@SessionId		[udtNumber],
	@FunctionName	[udtName]
)
AS 
--------------------------------------------------------------------------------------------------------------------------------------------
-- OBJECT NAME:    RptInsEarnPremiumAndLossRatio
--------------------------------------------------------------------------------------------------------------------------------------------
-- AUTHOR:         Vijaya Kumar Gulappa
--------------------------------------------------------------------------------------------------------------------------------------------
-- CREATED:        May-10-2007
--------------------------------------------------------------------------------------------------------------------------------------------
-- DESCRIPTION:    Combine MARKET & PRODUCT REGION Previous & Current Year data into FACT_DTL_FIN_MGT_RPT table.
--------------------------------------------------------------------------------------------------------------------------------------------
-- PARAMETERS:
--------------------------------------------------------------------------------------------------------------------------------------------
-- RETURNS:        0  -  success
--                 returns from SQL Server
--------------------------------------------------------------------------------------------------------------------------------------------

-- VERSION: $Revision: 16 $  UPDATED: $Modtime: 8/08/07 2:15p $
--------------------------------------------------------------------------------------------------------------------------------------------

declare	@ret int,
		@PREV_YEAR_TERM			UdtTerm,
		@PREV_YEAR_EFF_MONTH	UdtEffYrMon,
		@PREV_YEAR_MONTHNAME	UdtMonthName,
		@PREV_YEAR_YEARMONTH	UdtEffYrMon,
		@PREV_YEAR_FISCAL_YEAR	UdtFiscalYear,
		@CURR_YEAR_TERM			UdtTerm,
		@CURR_YEAR_EFF_MONTH	UdtEffYrMon,
		@CURR_YEAR_MONTHNAME	UdtMonthName,
		@CURR_YEAR_YEARMONTH	UdtEffYrMon,
		@CURR_YEAR_FISCAL_YEAR	UdtFiscalYear,
		@RPT_PREV_YEAR			UdtEffYrMon,
		@RPT_CURR_YEAR			UdtEffYrMon,
		@PRMIN_XMPLMR_EVAL_PERD_KEY	UdtNumber,
		@PRMAX_XMPLMR_EVAL_PERD_KEY	UdtNumber,
		@MRMIN_XMPLMR_EVAL_PERD_KEY	UdtNumber,
		@MRMAX_XMPLMR_EVAL_PERD_KEY	UdtNumber,
		@UserName				udtName,
		@YearMonth				udtEffYrMon

set nocount on
Set @FunctionName = OBJECT_NAME(@@PROCID)
SET @YearMonth = CAST(DATEPART (YYYY, GETDATE()) AS VARCHAR(4)) + (CASE WHEN LEN(DATEPART(M, GETDATE())) = 1 THEN '0' ELSE '' END) + CAST(DATEPART(M, GETDATE()) AS VARCHAR(2))
SET @ret = 0

  BEGIN

	Exec @ret = ConGetSystemPreferenceValue	@FunctionName = @FunctionName,
									@Code = 'RPY',
									@Value = @RPT_PREV_YEAR Output

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 51503, 11, 'Get System Preference: Exec ConGetSystemPreferenceValue failed'
		return 51503
	  END

	Exec @ret = ConGetSystemPreferenceValue	@FunctionName = @FunctionName,
									@Code = 'RCY',
									@Value = @RPT_CURR_YEAR Output

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 51503, 11, 'Get System Preference: Exec ConGetSystemPreferenceValue failed'
		return 51503
	  END

	Exec @ret = UsrGetSessionInfo @SessionId = @SessionId,
								@FunctionName = @FunctionName,
								@UMS_AT_Name = @UserName Output

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50103, 11, 'Get Session Information: Exec UsrGetSessionInfo failed'
		return 50103
	  END

	SELECT
	@PREV_YEAR_TERM = MAX(FDFMR_TRM), @PREV_YEAR_EFF_MONTH = MAX(FDFMR_EFF_MO),
	@PREV_YEAR_FISCAL_YEAR = (CASE WHEN MAX(FDFMR_EFF_MO) < 4 THEN 'Q1' WHEN MAX(FDFMR_EFF_MO) < 7 THEN 'Q2' WHEN MAX(FDFMR_EFF_MO) < 10 THEN 'Q3' ELSE 'Q4' END),
	@PREV_YEAR_MONTHNAME = DATENAME(MONTH, CAST(MAX(FDFMR_EFF_YR) AS VARCHAR(4)) +  '-' + CAST(MAX(FDFMR_EFF_MO) AS VARCHAR(2)) + '-01'),
	@PREV_YEAR_YEARMONTH = CAST(MAX(FDFMR_EFF_YR) AS VARCHAR(4)) + (CASE WHEN LEN(MAX(FDFMR_EFF_MO)) = 1 THEN '0' ELSE '' END) + CAST(MAX(FDFMR_EFF_MO) AS VARCHAR(2))
	FROM FACT_DTL_FIN_MGT_RPT WHERE FDFMR_EFF_YR = @RPT_PREV_YEAR

	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50604, 11, 'FACT_DTL_FIN_MGT_RPT table: select statement did not succeed'
		return 50604
	  END

	SELECT
	@CURR_YEAR_TERM = MAX(FDFMR_TRM), @CURR_YEAR_EFF_MONTH = MAX(FDFMR_EFF_MO),
	@CURR_YEAR_FISCAL_YEAR = (CASE WHEN MAX(FDFMR_EFF_MO) < 4 THEN 'Q1' WHEN MAX(FDFMR_EFF_MO) < 7 THEN 'Q2' WHEN MAX(FDFMR_EFF_MO) < 10 THEN 'Q3' ELSE 'Q4' END),
	@CURR_YEAR_MONTHNAME = DATENAME(MONTH, CAST(MAX(FDFMR_EFF_YR) AS VARCHAR(4)) +  '-' + CAST(MAX(FDFMR_EFF_MO) AS VARCHAR(2)) + '-01'),
	@CURR_YEAR_YEARMONTH = CAST(MAX(FDFMR_EFF_YR) AS VARCHAR(4)) + (CASE WHEN LEN(MAX(FDFMR_EFF_MO)) = 1 THEN '0' ELSE '' END) + CAST(MAX(FDFMR_EFF_MO) AS VARCHAR(2))
	FROM FACT_DTL_FIN_MGT_RPT WHERE FDFMR_EFF_YR = @RPT_CURR_YEAR

	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50604, 11, 'FACT_DTL_FIN_MGT_RPT table: select statement did not succeed'
		return 50604
	  END

	UPDATE XTRCT_MKT_PRDCT_LCL_MKT_RGN SET 
	XMPLMR_RGN_NM = REPLACE(XMPLMR_RGN_NM, '"',''),
	XMPLMR_LOC_GRP_CD = REPLACE(XMPLMR_LOC_GRP_CD, '"', ''),
	XMPLMR_CHNL_GRP_NM = REPLACE(XMPLMR_CHNL_GRP_NM, '"', ''),
	XMPLMR_CHNL_NM = REPLACE(XMPLMR_CHNL_NM, '"', ''),
	XMPLMR_RT_ST_CD = REPLACE(XMPLMR_RT_ST_CD, '"', ''),
	XMPLMR_LCL_MKT_NM = REPLACE(XMPLMR_LCL_MKT_NM, '"', ''),
	XMPLMR_BPM_LN_OF_BUS = REPLACE(XMPLMR_BPM_LN_OF_BUS, '"', ''),
	XMPLMR_BPM_SEG_NM = REPLACE(XMPLMR_BPM_SEG_NM, '"', ''),
	XMPLMR_BPM_PRDCT_NM = REPLACE(XMPLMR_BPM_PRDCT_NM, '"', ''),
	XMPLMR_BPM_SBPRDCT_NM = REPLACE(XMPLMR_BPM_SBPRDCT_NM, '"', ''),
	XMPLMR_RT_PLN_GRP_NM = REPLACE(XMPLMR_RT_PLN_GRP_NM, '"', '')

	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 52001, 11, 'XTRCT_MKT_PRDCT_LCL_MKT_RGN table: update statement (remove double quotes) did not succeed'
		return 52001
	  END

	UPDATE XTRCT_MKT_PRDCT_LCL_MKT_RGN SET XMPLMR_SRC_CD = 'MARKET REGION' 
	WHERE XMPLMR_SRC_CD IS NULL AND XMPLMR_LOC_GRP_CD IS NULL AND XMPLMR_LCL_MKT_NM IS NULL

	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 52001, 11, 'XTRCT_MKT_PRDCT_LCL_MKT_RGN table: update statement (market region source code) did not succeed'
		return 52001
	  END

	UPDATE XTRCT_MKT_PRDCT_LCL_MKT_RGN SET XMPLMR_SRC_CD = 'PRODUCT REGION' 
	WHERE XMPLMR_SRC_CD IS NULL AND XMPLMR_RT_ST_CD IS NULL AND XMPLMR_LCL_MKT_NM IS NULL

	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 52001, 11, 'XTRCT_MKT_PRDCT_LCL_MKT_RGN table: update statement (product region source code) did not succeed'
		return 52001
	  END

	UPDATE XTRCT_MKT_PRDCT_LCL_MKT_RGN SET XMPLMR_SRC_CD = 'LOCAL MARKET' 
	WHERE XMPLMR_SRC_CD IS NULL AND XMPLMR_LOC_GRP_CD IS NULL

	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 52001, 11, 'XTRCT_MKT_PRDCT_LCL_MKT_RGN table: update statement (local market region source code) did not succeed'
		return 52001
	  END

	UPDATE XTRCT_MKT_PRDCT_LCL_MKT_RGN SET XMPLMR_BPM_SEG_NM = 'Other Personal Lines' WHERE XMPLMR_BPM_SEG_NM = 'Other Personal Line'

	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 52001, 11, 'XTRCT_MKT_PRDCT_LCL_MKT_RGN table: update statement (other personal lines) did not succeed'
		return 52001
	  END

	UPDATE XTRCT_MKT_PRDCT_LCL_MKT_RGN SET XMPLMR_BPM_PRDCT_NM = 'OPL (excl Specialty)' WHERE XMPLMR_BPM_PRDCT_NM = 'OPL (excl Specialty'

	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 52001, 11, 'XTRCT_MKT_PRDCT_LCL_MKT_RGN table: update statement (OPL (excl Specialty)) did not succeed'
		return 52001
	  END

	SELECT @PRMIN_XMPLMR_EVAL_PERD_KEY = MIN(XMPLMR_EVAL_PERD_KEY), @PRMAX_XMPLMR_EVAL_PERD_KEY = MAX(XMPLMR_EVAL_PERD_KEY) 
	FROM XTRCT_MKT_PRDCT_LCL_MKT_RGN WHERE XMPLMR_SRC_CD = 'PRODUCT REGION' AND XMPLMR_EFF_PERD_YR = @RPT_PREV_YEAR

	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 52004, 11, 'XTRCT_MKT_PRDCT_LCL_MKT_RGN table: select statement (product region: max & min eval period key) did not succeed'
		return 52004
	  END

	SELECT @MRMIN_XMPLMR_EVAL_PERD_KEY = MIN(XMPLMR_EVAL_PERD_KEY), @MRMAX_XMPLMR_EVAL_PERD_KEY = MAX(XMPLMR_EVAL_PERD_KEY) 
	FROM XTRCT_MKT_PRDCT_LCL_MKT_RGN WHERE XMPLMR_SRC_CD = 'MARKET REGION' AND XMPLMR_EFF_PERD_YR = @RPT_PREV_YEAR

	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 52004, 11, 'XTRCT_MKT_PRDCT_LCL_MKT_RGN table: select statement (market region: max & min eval period key) did not succeed'
		return 52004
	  END

	IF EXISTS(SELECT FDFMR_PK_ID FROM FACT_DTL_FIN_MGT_RPT WHERE FDFMR_SRC_NM 
		IN ('MARKET REGION', 'PRODUCT REGION', 'LOCAL MARKET'))
	BEGIN
		DELETE FROM FACT_DTL_FIN_MGT_RPT WHERE FDFMR_SRC_NM IN ('MARKET REGION', 'PRODUCT REGION', 'LOCAL MARKET')		
		IF  @@error != 0 
		  BEGIN 
			exec OthInsErrorMessage @SessionId, @FunctionName, 50602, 11, 'FACT_DTL_FIN_MGT_RPT table: market & product region and local market delete statement did not succeed'
			return 50602
		  END
	END
--PRODUCT REGION INSERT STATEMENT START HERE--

--AUTO & PROPERTY PRODUCT REGION CURRENT YEAR INSERT STATEMENT START HERE--
	INSERT INTO [dbo].FACT_DTL_FIN_MGT_RPT
	( 
	FDFMR_SRC_NM, FDFMR_BPM_LN_OF_BUS, FDFMR_BPM_SEG_NM, FDFMR_BPM_PRDCT_NM, FDFMR_RT_PLN_GRP_NM, FDFMR_TRM, FDFMR_CHNL_GRP_NM, 
	FDFMR_CHNL_NM, FDFMR_SUB_CHNL, FDFMR_PM_RGN_NM, FDFMR_STRG, FDFMR_ST_NM, FDFMR_ST_CD,
	FDFMR_SPC, FDFMR_EFF_YR, FDFMR_EFF_MO, FDFMR_MO_NM, FDFMR_EFF_YR_MO, FDFMR_FISC_YR, 
	FDFMR_ARB_ULT_POL_CNT, FDFMR_ARB_POL_CNT, FDFMR_ARB_POL_CNT_FST_ON, FDFMR_ARB_POL_CNT_SEC_ON, FDFMR_ARB_POL_CNT_FST_OFF, 
	FDFMR_ARB_ULT_POL_CNT_SEC_OFF, FDFMR_ARB_FC_CO, FDFMR_ARB_FC_AGT_NP_FST_ON, FDFMR_ARB_FC_AGT_NP_SEC_ON, FDFMR_ARB_FC_AGT_NP_ON, 
	FDFMR_ARB_FC_AGT_NP_FST_OFF, FDFMR_ARB_FC_AGT_NP_SEC_OFF, FDFMR_ARB_FC_AGT_NP_OFF, FDFMR_ARB_ULT_FC_AGT_NP, FDFMR_ARB_MT, FDFMR_ARB_ULT_MT, FDFMR_ARB_RET,
	FDFMR_ARB_ULT_RET, FDFMR_ORA_POL_CNT, FDFMR_ORA_POL_CNT_FST_ON, FDFMR_ORA_POL_CNT_SEC_ON, FDFMR_ORA_POL_CNT_FST_OFF,
	FDFMR_ORA_POL_CNT_SEC_OFF, FDFMR_ORA_FC_CO, FDFMR_ORA_FC_AGT_NP_FST_ON, FDFMR_ORA_FC_AGT_NP_SEC_ON, FDFMR_ORA_FC_AGT_NP_ON,
	FDFMR_ORA_FC_AGT_NP_FST_OFF, FDFMR_ORA_FC_AGT_NP_SEC_OFF, FDFMR_ORA_FC_AGT_NP_OFF, FDFMR_ORA_ULT_FC_AGT_NP, FDFMR_ORA_MT, FDFMR_ORA_ULT_MT,
	FDFMR_ORA_REW, FDFMR_ORA_ULT_REW, FDFMR_ORA_RET, FDFMR_ORA_ULT_RET, FDFMR_BNB_POL_CNT, FDFMR_BNB_POL_CNT_FST_ON, FDFMR_BNB_POL_CNT_SEC_ON,
	FDFMR_BNB_POL_CNT_FST_OFF, FDFMR_BNB_POL_CNT_SEC_OFF, FDFMR_BNB_ULT_POL_CNT, FDFMR_BNB_FC_CO, FDFMR_BNB_FC_AGT_NP_FST_ON, FDFMR_BNB_FC_AGT_NP_SEC_ON, 
	FDFMR_BNB_FC_AGT_NP_ON, FDFMR_BNB_FC_AGT_NP_FST_OFF, FDFMR_BNB_FC_AGT_NP_SEC_OFF, FDFMR_BNB_FC_AGT_NP_OFF, FDFMR_BNB_ULT_FC_AGT_NP, FDFMR_BNB_MT,
	FDFMR_BNB_ULT_MT, FDFMR_BNB_REW, FDFMR_BNB_ULT_REW, FDFMR_BNB_RET, FDFMR_BNB_ULT_RET, FDFMR_NB_CHG_EFF_DT,
	FDFMR_RRA_POL_CNT, FDFMR_RRA_POL_CNT_FST_ON, FDFMR_RRA_POL_CNT_SEC_ON, FDFMR_RRA_POL_CNT_FST_OFF, FDFMR_RRA_POL_CNT_SEC_OFF,
	FDFMR_RRA_FC_CO, FDFMR_RRA_FC_AGT_NP_FST_ON, FDFMR_RRA_FC_AGT_NP_SEC_ON, FDFMR_RRA_FC_AGT_NP_ON, FDFMR_RRA_FC_AGT_NP_FST_OFF, FDFMR_RRA_FC_AGT_NP_SEC_OFF,
	FDFMR_RRA_FC_AGT_NP_OFF, FDFMR_RRA_ULT_FC_AGT_NP, FDFMR_RRA_MT, FDFMR_RRA_ULT_MT, FDFMR_RRA_REW, FDFMR_RRA_ULT_REW,
	FDFMR_RRA_RET, FDFMR_RRA_ULT_RET, FDFMR_RPC_AMT_FST_ON, FDFMR_BAS_WRT_PRM_FST_ON, FDFMR_RPC_RT_AMT_FST_ON, FDFMR_RPC_AIL_AMT_FST_ON, FDFMR_RPC_EXPOS_AMT_FST_ON,
	FDFMR_RPC_AMT, FDFMR_BAS_WRT_PRM, FDFMR_RPC_RT_AMT, FDFMR_RPC_AIL_AMT, FDFMR_RPC_EXPOS_AMT, FDFMR_ANNL_WRT_PRM_AMT_RB,
	FDFMR_ANNL_WRT_PRM_AMT_BNB, FDFMR_ORG_WRT_PRM_AMT, FDFMR_ACQN_WRT_PRM_AMT, FDFMR_COMB_WRT_PRM_AMT, FDFMR_PRR_IN_FRC_AMT, FDFMR_YR_END_IN_FRC_AMT,
	FDFMR_CURR_IN_FRC_AMT, FDFMR_CTL_LS_AMT, FDFMR_EARN_PRM_AMT, FDFMR_PIF_AMT,
	FDFMR_LST_USER, FDFMR_LST_DT_TM, FDFMR_CREAT_USER, FDFMR_CREAT_DT_TM
	)
	SELECT 
	XMPLMR_SRC_CD, XMPLMR_BPM_LN_OF_BUS, XMPLMR_BPM_SEG_NM, XMPLMR_BPM_PRDCT_NM, XMPLMR_RT_PLN_GRP_NM, @CURR_YEAR_TERM, XMPLMR_CHNL_GRP_NM, XMPLMR_CHNL_NM, 
	'Other', XMPLMR_RGN_NM, '', SN.CMSN_ST_NM, SN.CMSN_ST_CD, 'No', XMPLMR_EFF_PERD_YR, 
	@CURR_YEAR_EFF_MONTH, @CURR_YEAR_MONTHNAME, @CURR_YEAR_YEARMONTH, @CURR_YEAR_FISCAL_YEAR, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, XMPLMR_CTL_LS_AMT, XMPLMR_EARN_PRM_AMT, 0,
	@UserName, GETDATE(), @UserName, GETDATE()
	FROM XTRCT_MKT_PRDCT_LCL_MKT_RGN, CNFG_MSTR_ST_NM SN
	WHERE XMPLMR_SRC_CD = 'PRODUCT REGION' AND SN.CMSN_ST_CD = LEFT(XMPLMR_LOC_GRP_CD, 2) AND
	XMPLMR_EFF_PERD_YR = @RPT_CURR_YEAR
	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50600, 11, 'FACT_DTL_FIN_MGT_RPT table: insert statement from XTRCT_MKT_PRDCT_LCL_MKT_RGN (Auto & Property Product Region) Current Year data did not succeed'
		return 50600
	  END

    exec @ret = OthInsUserMessage
                @SessionId, 
                @FunctionName = @FunctionName, 
                @Task_Name = 'Insert Statement: FACT_DTL_FIN_MGT_RPT <-- From XTRCT_MKT_PRDCT_LCL_MKT_RGN (Auto & Property Product Region) Current Year data',
                @Status = 'Complete',
				@UserName = @UserName

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing insert FACT_DTL_FIN_MGT_RPT from XTRCT_MKT_PRDCT_LCL_MKT_RGN (Auto & Property Product Region) Current Year data table complete statement'
		return 50200
	  END
--AUTO & PROPERTY PRODUCT REGION CURRENT YEAR INSERT STATEMENT END HERE--
--AUTO & PROPERTY PRODUCT REGION PREVIOUS YEAR INSERT STATEMENT START HERE--
	INSERT INTO [dbo].FACT_DTL_FIN_MGT_RPT
	( 
	FDFMR_SRC_NM, FDFMR_BPM_LN_OF_BUS, FDFMR_BPM_SEG_NM, FDFMR_BPM_PRDCT_NM, FDFMR_RT_PLN_GRP_NM, FDFMR_TRM, FDFMR_CHNL_GRP_NM, 
	FDFMR_CHNL_NM, FDFMR_SUB_CHNL, FDFMR_PM_RGN_NM, FDFMR_STRG, FDFMR_ST_NM, FDFMR_ST_CD,
	FDFMR_SPC, FDFMR_EFF_YR, FDFMR_EFF_MO, FDFMR_MO_NM, FDFMR_EFF_YR_MO, FDFMR_FISC_YR, 
	FDFMR_ARB_ULT_POL_CNT, FDFMR_ARB_POL_CNT, FDFMR_ARB_POL_CNT_FST_ON, FDFMR_ARB_POL_CNT_SEC_ON, FDFMR_ARB_POL_CNT_FST_OFF, 
	FDFMR_ARB_ULT_POL_CNT_SEC_OFF, FDFMR_ARB_FC_CO, FDFMR_ARB_FC_AGT_NP_FST_ON, FDFMR_ARB_FC_AGT_NP_SEC_ON, FDFMR_ARB_FC_AGT_NP_ON, 
	FDFMR_ARB_FC_AGT_NP_FST_OFF, FDFMR_ARB_FC_AGT_NP_SEC_OFF, FDFMR_ARB_FC_AGT_NP_OFF, FDFMR_ARB_ULT_FC_AGT_NP, FDFMR_ARB_MT, FDFMR_ARB_ULT_MT, FDFMR_ARB_RET,
	FDFMR_ARB_ULT_RET, FDFMR_ORA_POL_CNT, FDFMR_ORA_POL_CNT_FST_ON, FDFMR_ORA_POL_CNT_SEC_ON, FDFMR_ORA_POL_CNT_FST_OFF,
	FDFMR_ORA_POL_CNT_SEC_OFF, FDFMR_ORA_FC_CO, FDFMR_ORA_FC_AGT_NP_FST_ON, FDFMR_ORA_FC_AGT_NP_SEC_ON, FDFMR_ORA_FC_AGT_NP_ON,
	FDFMR_ORA_FC_AGT_NP_FST_OFF, FDFMR_ORA_FC_AGT_NP_SEC_OFF, FDFMR_ORA_FC_AGT_NP_OFF, FDFMR_ORA_ULT_FC_AGT_NP, FDFMR_ORA_MT, FDFMR_ORA_ULT_MT,
	FDFMR_ORA_REW, FDFMR_ORA_ULT_REW, FDFMR_ORA_RET, FDFMR_ORA_ULT_RET, FDFMR_BNB_POL_CNT, FDFMR_BNB_POL_CNT_FST_ON, FDFMR_BNB_POL_CNT_SEC_ON,
	FDFMR_BNB_POL_CNT_FST_OFF, FDFMR_BNB_POL_CNT_SEC_OFF, FDFMR_BNB_ULT_POL_CNT, FDFMR_BNB_FC_CO, FDFMR_BNB_FC_AGT_NP_FST_ON, FDFMR_BNB_FC_AGT_NP_SEC_ON, 
	FDFMR_BNB_FC_AGT_NP_ON, FDFMR_BNB_FC_AGT_NP_FST_OFF, FDFMR_BNB_FC_AGT_NP_SEC_OFF, FDFMR_BNB_FC_AGT_NP_OFF, FDFMR_BNB_ULT_FC_AGT_NP, FDFMR_BNB_MT,
	FDFMR_BNB_ULT_MT, FDFMR_BNB_REW, FDFMR_BNB_ULT_REW, FDFMR_BNB_RET, FDFMR_BNB_ULT_RET, FDFMR_NB_CHG_EFF_DT,
	FDFMR_RRA_POL_CNT, FDFMR_RRA_POL_CNT_FST_ON, FDFMR_RRA_POL_CNT_SEC_ON, FDFMR_RRA_POL_CNT_FST_OFF, FDFMR_RRA_POL_CNT_SEC_OFF,
	FDFMR_RRA_FC_CO, FDFMR_RRA_FC_AGT_NP_FST_ON, FDFMR_RRA_FC_AGT_NP_SEC_ON, FDFMR_RRA_FC_AGT_NP_ON, FDFMR_RRA_FC_AGT_NP_FST_OFF, FDFMR_RRA_FC_AGT_NP_SEC_OFF,
	FDFMR_RRA_FC_AGT_NP_OFF, FDFMR_RRA_ULT_FC_AGT_NP, FDFMR_RRA_MT, FDFMR_RRA_ULT_MT, FDFMR_RRA_REW, FDFMR_RRA_ULT_REW,
	FDFMR_RRA_RET, FDFMR_RRA_ULT_RET, FDFMR_RPC_AMT_FST_ON, FDFMR_BAS_WRT_PRM_FST_ON, FDFMR_RPC_RT_AMT_FST_ON, FDFMR_RPC_AIL_AMT_FST_ON, FDFMR_RPC_EXPOS_AMT_FST_ON,
	FDFMR_RPC_AMT, FDFMR_BAS_WRT_PRM, FDFMR_RPC_RT_AMT, FDFMR_RPC_AIL_AMT, FDFMR_RPC_EXPOS_AMT, FDFMR_ANNL_WRT_PRM_AMT_RB,
	FDFMR_ANNL_WRT_PRM_AMT_BNB, FDFMR_ORG_WRT_PRM_AMT, FDFMR_ACQN_WRT_PRM_AMT, FDFMR_COMB_WRT_PRM_AMT, FDFMR_PRR_IN_FRC_AMT, FDFMR_YR_END_IN_FRC_AMT,
	FDFMR_CURR_IN_FRC_AMT, FDFMR_CTL_LS_AMT, FDFMR_EARN_PRM_AMT, FDFMR_PIF_AMT,
	FDFMR_LST_USER, FDFMR_LST_DT_TM, FDFMR_CREAT_USER, FDFMR_CREAT_DT_TM
	)
	SELECT 
	EP.XMPLMR_SRC_CD, EP.XMPLMR_BPM_LN_OF_BUS, EP.XMPLMR_BPM_SEG_NM, EP.XMPLMR_BPM_PRDCT_NM, EP.XMPLMR_RT_PLN_GRP_NM, @PREV_YEAR_TERM, EP.XMPLMR_CHNL_GRP_NM, 
	EP.XMPLMR_CHNL_NM, 'Other', EP.XMPLMR_RGN_NM, '', SN.CMSN_ST_NM, SN.CMSN_ST_CD, 'No', EP.XMPLMR_EFF_PERD_YR, 
	@PREV_YEAR_EFF_MONTH,	@PREV_YEAR_MONTHNAME, @PREV_YEAR_YEARMONTH, @PREV_YEAR_FISCAL_YEAR, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, L.XMPLMR_CTL_LS_AMT, L.XMPLMR_EARN_PRM_AMT, 0, 
	@UserName, GETDATE(), @UserName, GETDATE()
	FROM CNFG_MSTR_ST_NM SN, 
	(SELECT XMPLMR_SRC_CD, XMPLMR_EVAL_PERD_KEY, XMPLMR_EFF_PERD_YR, XMPLMR_RGN_NM, XMPLMR_LOC_GRP_CD, XMPLMR_CHNL_GRP_NM, XMPLMR_CHNL_NM, XMPLMR_BPM_LN_OF_BUS, XMPLMR_BPM_SEG_NM, 
	XMPLMR_BPM_PRDCT_NM, XMPLMR_RT_PLN_GRP_NM
	FROM XTRCT_MKT_PRDCT_LCL_MKT_RGN 
	WHERE XMPLMR_SRC_CD = 'PRODUCT REGION' AND XMPLMR_EVAL_PERD_KEY = @PRMIN_XMPLMR_EVAL_PERD_KEY AND XMPLMR_EFF_PERD_YR = @RPT_PREV_YEAR
	GROUP BY
	XMPLMR_SRC_CD, XMPLMR_EVAL_PERD_KEY, XMPLMR_EFF_PERD_YR, XMPLMR_RGN_NM, XMPLMR_LOC_GRP_CD, XMPLMR_CHNL_GRP_NM, XMPLMR_CHNL_NM, XMPLMR_BPM_LN_OF_BUS, XMPLMR_BPM_SEG_NM, XMPLMR_BPM_PRDCT_NM, XMPLMR_RT_PLN_GRP_NM
	) AS EP INNER JOIN 
	(SELECT XMPLMR_EVAL_PERD_KEY, XMPLMR_EFF_PERD_YR, XMPLMR_RGN_NM, XMPLMR_LOC_GRP_CD, XMPLMR_CHNL_GRP_NM, XMPLMR_CHNL_NM, XMPLMR_BPM_LN_OF_BUS, XMPLMR_BPM_SEG_NM, 
	XMPLMR_BPM_PRDCT_NM, XMPLMR_RT_PLN_GRP_NM, SUM(XMPLMR_CTL_LS_AMT) AS XMPLMR_CTL_LS_AMT, SUM(XMPLMR_EARN_PRM_AMT) AS XMPLMR_EARN_PRM_AMT
	FROM XTRCT_MKT_PRDCT_LCL_MKT_RGN 
	WHERE XMPLMR_SRC_CD = 'PRODUCT REGION' AND XMPLMR_EVAL_PERD_KEY = @PRMAX_XMPLMR_EVAL_PERD_KEY AND XMPLMR_EFF_PERD_YR = @RPT_PREV_YEAR
	GROUP BY
	XMPLMR_EVAL_PERD_KEY, XMPLMR_EFF_PERD_YR, XMPLMR_RGN_NM, XMPLMR_LOC_GRP_CD, XMPLMR_CHNL_GRP_NM, XMPLMR_CHNL_NM, XMPLMR_BPM_LN_OF_BUS, XMPLMR_BPM_SEG_NM, XMPLMR_BPM_PRDCT_NM, XMPLMR_RT_PLN_GRP_NM
	) AS L 
	ON
	L.XMPLMR_BPM_PRDCT_NM = EP.XMPLMR_BPM_PRDCT_NM AND L.XMPLMR_BPM_SEG_NM = EP.XMPLMR_BPM_SEG_NM AND L.XMPLMR_BPM_LN_OF_BUS = EP.XMPLMR_BPM_LN_OF_BUS AND 
	L.XMPLMR_CHNL_NM = EP.XMPLMR_CHNL_NM AND L.XMPLMR_CHNL_GRP_NM = EP.XMPLMR_CHNL_GRP_NM AND L.XMPLMR_LOC_GRP_CD = EP.XMPLMR_LOC_GRP_CD AND
	L.XMPLMR_RGN_NM = EP.XMPLMR_RGN_NM AND L.XMPLMR_EFF_PERD_YR = EP.XMPLMR_EFF_PERD_YR AND
	L.XMPLMR_RT_PLN_GRP_NM = (CASE WHEN L.XMPLMR_BPM_LN_OF_BUS = 'Auto' THEN L.XMPLMR_RT_PLN_GRP_NM ELSE EP.XMPLMR_RT_PLN_GRP_NM END)
	WHERE 
	SN.CMSN_ST_CD = LEFT(EP.XMPLMR_LOC_GRP_CD, 2)
	ORDER BY 
	EP.XMPLMR_SRC_CD, EP.XMPLMR_EFF_PERD_YR, EP.XMPLMR_RGN_NM, EP.XMPLMR_LOC_GRP_CD, SN.CMSN_ST_NM, SN.CMSN_ST_CD, 
	EP.XMPLMR_CHNL_NM, EP.XMPLMR_CHNL_GRP_NM, EP.XMPLMR_BPM_LN_OF_BUS, EP.XMPLMR_BPM_SEG_NM, EP.XMPLMR_BPM_PRDCT_NM, EP.XMPLMR_RT_PLN_GRP_NM

	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50600, 11, 'FACT_DTL_FIN_MGT_RPT table: insert statement from XTRCT_MKT_PRDCT_LCL_MKT_RGN (Auto & Property Product Region) Previous Year data did not succeed'
		return 50600
	  END

    exec @ret = OthInsUserMessage
                @SessionId, 
                @FunctionName = @FunctionName, 
                @Task_Name = 'Insert Statement: FACT_DTL_FIN_MGT_RPT <-- From XTRCT_MKT_PRDCT_LCL_MKT_RGN (Auto & Property Product Region) Previous Year Data',
                @Status = 'Complete',
				@UserName = @UserName

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing insert FACT_DTL_FIN_MGT_RPT from XTRCT_MKT_PRDCT_LCL_MKT_RGN (Auto & Property Product Region) Previous Year data table complete statement'
		return 50200
	  END
--AUTO & PROPERTY PRODUCT REGION PREVIOUS YEAR INSERT STATEMENT END HERE--
--PRODUCT REGION INSERT STATEMENT END HERE--
--MARKET REGION INSERT STATEMENT START HERE--
--AUTO & PROPERTY MARKET REGION CURRENT YEAR INSERT STATEMENT START HERE--
	INSERT INTO [dbo].FACT_DTL_FIN_MGT_RPT
	( 
	FDFMR_SRC_NM, FDFMR_BPM_LN_OF_BUS, FDFMR_BPM_SEG_NM, FDFMR_BPM_PRDCT_NM, FDFMR_RT_PLN_GRP_NM, FDFMR_TRM, FDFMR_CHNL_GRP_NM, 
	FDFMR_CHNL_NM, FDFMR_SUB_CHNL, FDFMR_PM_RGN_NM, FDFMR_STRG, FDFMR_ST_NM, FDFMR_ST_CD,
	FDFMR_SPC, FDFMR_EFF_YR, FDFMR_EFF_MO, FDFMR_MO_NM, FDFMR_EFF_YR_MO, FDFMR_FISC_YR, 
	FDFMR_ARB_ULT_POL_CNT, FDFMR_ARB_POL_CNT, FDFMR_ARB_POL_CNT_FST_ON, FDFMR_ARB_POL_CNT_SEC_ON, FDFMR_ARB_POL_CNT_FST_OFF, 
	FDFMR_ARB_ULT_POL_CNT_SEC_OFF, FDFMR_ARB_FC_CO, FDFMR_ARB_FC_AGT_NP_FST_ON, FDFMR_ARB_FC_AGT_NP_SEC_ON, FDFMR_ARB_FC_AGT_NP_ON, 
	FDFMR_ARB_FC_AGT_NP_FST_OFF, FDFMR_ARB_FC_AGT_NP_SEC_OFF, FDFMR_ARB_FC_AGT_NP_OFF, FDFMR_ARB_ULT_FC_AGT_NP, FDFMR_ARB_MT, FDFMR_ARB_ULT_MT, FDFMR_ARB_RET,
	FDFMR_ARB_ULT_RET, FDFMR_ORA_POL_CNT, FDFMR_ORA_POL_CNT_FST_ON, FDFMR_ORA_POL_CNT_SEC_ON, FDFMR_ORA_POL_CNT_FST_OFF,
	FDFMR_ORA_POL_CNT_SEC_OFF, FDFMR_ORA_FC_CO, FDFMR_ORA_FC_AGT_NP_FST_ON, FDFMR_ORA_FC_AGT_NP_SEC_ON, FDFMR_ORA_FC_AGT_NP_ON,
	FDFMR_ORA_FC_AGT_NP_FST_OFF, FDFMR_ORA_FC_AGT_NP_SEC_OFF, FDFMR_ORA_FC_AGT_NP_OFF, FDFMR_ORA_ULT_FC_AGT_NP, FDFMR_ORA_MT, FDFMR_ORA_ULT_MT,
	FDFMR_ORA_REW, FDFMR_ORA_ULT_REW, FDFMR_ORA_RET, FDFMR_ORA_ULT_RET, FDFMR_BNB_POL_CNT, FDFMR_BNB_POL_CNT_FST_ON, FDFMR_BNB_POL_CNT_SEC_ON,
	FDFMR_BNB_POL_CNT_FST_OFF, FDFMR_BNB_POL_CNT_SEC_OFF, FDFMR_BNB_ULT_POL_CNT, FDFMR_BNB_FC_CO, FDFMR_BNB_FC_AGT_NP_FST_ON, FDFMR_BNB_FC_AGT_NP_SEC_ON, 
	FDFMR_BNB_FC_AGT_NP_ON, FDFMR_BNB_FC_AGT_NP_FST_OFF, FDFMR_BNB_FC_AGT_NP_SEC_OFF, FDFMR_BNB_FC_AGT_NP_OFF, FDFMR_BNB_ULT_FC_AGT_NP, FDFMR_BNB_MT,
	FDFMR_BNB_ULT_MT, FDFMR_BNB_REW, FDFMR_BNB_ULT_REW, FDFMR_BNB_RET, FDFMR_BNB_ULT_RET, FDFMR_NB_CHG_EFF_DT,
	FDFMR_RRA_POL_CNT, FDFMR_RRA_POL_CNT_FST_ON, FDFMR_RRA_POL_CNT_SEC_ON, FDFMR_RRA_POL_CNT_FST_OFF, FDFMR_RRA_POL_CNT_SEC_OFF,
	FDFMR_RRA_FC_CO, FDFMR_RRA_FC_AGT_NP_FST_ON, FDFMR_RRA_FC_AGT_NP_SEC_ON, FDFMR_RRA_FC_AGT_NP_ON, FDFMR_RRA_FC_AGT_NP_FST_OFF, FDFMR_RRA_FC_AGT_NP_SEC_OFF,
	FDFMR_RRA_FC_AGT_NP_OFF, FDFMR_RRA_ULT_FC_AGT_NP, FDFMR_RRA_MT, FDFMR_RRA_ULT_MT, FDFMR_RRA_REW, FDFMR_RRA_ULT_REW,
	FDFMR_RRA_RET, FDFMR_RRA_ULT_RET, FDFMR_RPC_AMT_FST_ON, FDFMR_BAS_WRT_PRM_FST_ON, FDFMR_RPC_RT_AMT_FST_ON, FDFMR_RPC_AIL_AMT_FST_ON, FDFMR_RPC_EXPOS_AMT_FST_ON,
	FDFMR_RPC_AMT, FDFMR_BAS_WRT_PRM, FDFMR_RPC_RT_AMT, FDFMR_RPC_AIL_AMT, FDFMR_RPC_EXPOS_AMT, FDFMR_ANNL_WRT_PRM_AMT_RB,
	FDFMR_ANNL_WRT_PRM_AMT_BNB, FDFMR_ORG_WRT_PRM_AMT, FDFMR_ACQN_WRT_PRM_AMT, FDFMR_COMB_WRT_PRM_AMT, FDFMR_PRR_IN_FRC_AMT, FDFMR_YR_END_IN_FRC_AMT,
	FDFMR_CURR_IN_FRC_AMT, FDFMR_CTL_LS_AMT, FDFMR_EARN_PRM_AMT, FDFMR_PIF_AMT,
	FDFMR_LST_USER, FDFMR_LST_DT_TM, FDFMR_CREAT_USER, FDFMR_CREAT_DT_TM
	)
	SELECT 
	XMPLMR_SRC_CD, L.XMPLMR_BPM_LN_OF_BUS, L.XMPLMR_BPM_SEG_NM, 
	(CASE WHEN XMPLMR_BPM_PRDCT_NM IN ('Legacy', 'Quantum', 'Trav Auto Pgm') THEN 'Standard Auto' 
	WHEN XMPLMR_BPM_PRDCT_NM IN ('Specialty', 'OPL (excl Specialty)') THEN XMPLMR_BPM_SBPRDCT_NM ELSE XMPLMR_BPM_PRDCT_NM END), 
	L.XMPLMR_RT_PLN_GRP_NM, @CURR_YEAR_TERM, L.XMPLMR_CHNL_GRP_NM, L.XMPLMR_CHNL_NM, 
	(CASE WHEN XMPLMR_RGN_NM = 'Affn - Agent Sold' THEN 'Agent' WHEN XMPLMR_RGN_NM = 'Affn - Trav Sold' THEN 'Trav Sold' ELSE XMPLMR_RGN_NM END),
	'Other', '', SN.CMSN_ST_NM, SN.CMSN_ST_CD, 'No', L.XMPLMR_EFF_PERD_YR, @CURR_YEAR_EFF_MONTH,
	@CURR_YEAR_MONTHNAME, @CURR_YEAR_YEARMONTH, @CURR_YEAR_FISCAL_YEAR, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, L.XMPLMR_CTL_LS_AMT, L.XMPLMR_EARN_PRM_AMT, 0, 
	@UserName, GETDATE(), @UserName, GETDATE()
	FROM XTRCT_MKT_PRDCT_LCL_MKT_RGN L, CNFG_MSTR_ST_NM SN
	WHERE 
	L.XMPLMR_EFF_PERD_YR = @RPT_CURR_YEAR AND L.XMPLMR_SRC_CD = 'MARKET REGION' 
	AND SN.CMSN_ST_CD = L.XMPLMR_RT_ST_CD
	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50600, 11, 'FACT_DTL_FIN_MGT_RPT table: insert statement from XTRCT_MKT_PRDCT_LCL_MKT_RGN (Auto & Property Market Region) Current Year data did not succeed'
		return 50600
	  END

    exec @ret = OthInsUserMessage
                @SessionId, 
                @FunctionName = @FunctionName, 
                @Task_Name = 'Insert Statement: FACT_DTL_FIN_MGT_RPT <-- From XTRCT_MKT_PRDCT_LCL_MKT_RGN (Auto & Property Market Region) Current Year data',
                @Status = 'Complete',
				@UserName = @UserName

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing insert FACT_DTL_FIN_MGT_RPT from XTRCT_MKT_PRDCT_LCL_MKT_RGN (Auto & Property Market Region) Current Year data table complete statement'
		return 50200
	  END
--AUTO & PROPERTY MARKET REGION CURRENT YEAR INSERT STATEMENT END HERE--
--AUTO & PROPERTY MARKET REGION PREVIOUS YEAR INSERT STATEMENT START HERE--
	INSERT INTO [dbo].FACT_DTL_FIN_MGT_RPT
	( 
	FDFMR_SRC_NM, FDFMR_BPM_LN_OF_BUS, FDFMR_BPM_SEG_NM, FDFMR_BPM_PRDCT_NM, FDFMR_RT_PLN_GRP_NM, FDFMR_TRM, FDFMR_CHNL_GRP_NM, 
	FDFMR_CHNL_NM, FDFMR_SUB_CHNL, FDFMR_PM_RGN_NM, FDFMR_STRG, FDFMR_ST_NM, FDFMR_ST_CD,
	FDFMR_SPC, FDFMR_EFF_YR, FDFMR_EFF_MO, FDFMR_MO_NM, FDFMR_EFF_YR_MO, FDFMR_FISC_YR, 
	FDFMR_ARB_ULT_POL_CNT, FDFMR_ARB_POL_CNT, FDFMR_ARB_POL_CNT_FST_ON, FDFMR_ARB_POL_CNT_SEC_ON, FDFMR_ARB_POL_CNT_FST_OFF, 
	FDFMR_ARB_ULT_POL_CNT_SEC_OFF, FDFMR_ARB_FC_CO, FDFMR_ARB_FC_AGT_NP_FST_ON, FDFMR_ARB_FC_AGT_NP_SEC_ON, FDFMR_ARB_FC_AGT_NP_ON, FDFMR_ARB_FC_AGT_NP_FST_OFF, 
	FDFMR_ARB_FC_AGT_NP_SEC_OFF, FDFMR_ARB_FC_AGT_NP_OFF, FDFMR_ARB_ULT_FC_AGT_NP, FDFMR_ARB_MT, FDFMR_ARB_ULT_MT, FDFMR_ARB_RET, FDFMR_ARB_ULT_RET, 
	FDFMR_ORA_POL_CNT, FDFMR_ORA_POL_CNT_FST_ON, FDFMR_ORA_POL_CNT_SEC_ON, FDFMR_ORA_POL_CNT_FST_OFF, FDFMR_ORA_POL_CNT_SEC_OFF, FDFMR_ORA_FC_CO, 
	FDFMR_ORA_FC_AGT_NP_FST_ON, FDFMR_ORA_FC_AGT_NP_SEC_ON, FDFMR_ORA_FC_AGT_NP_ON, FDFMR_ORA_FC_AGT_NP_FST_OFF, FDFMR_ORA_FC_AGT_NP_SEC_OFF, FDFMR_ORA_FC_AGT_NP_OFF, 
	FDFMR_ORA_ULT_FC_AGT_NP, FDFMR_ORA_MT, FDFMR_ORA_ULT_MT, FDFMR_ORA_REW, FDFMR_ORA_ULT_REW, FDFMR_ORA_RET, FDFMR_ORA_ULT_RET, 
	FDFMR_BNB_POL_CNT, FDFMR_BNB_POL_CNT_FST_ON, FDFMR_BNB_POL_CNT_SEC_ON, FDFMR_BNB_POL_CNT_FST_OFF, FDFMR_BNB_POL_CNT_SEC_OFF, FDFMR_BNB_ULT_POL_CNT, FDFMR_BNB_FC_CO, 
	FDFMR_BNB_FC_AGT_NP_FST_ON, FDFMR_BNB_FC_AGT_NP_SEC_ON, FDFMR_BNB_FC_AGT_NP_ON, FDFMR_BNB_FC_AGT_NP_FST_OFF, FDFMR_BNB_FC_AGT_NP_SEC_OFF, FDFMR_BNB_FC_AGT_NP_OFF, 
	FDFMR_BNB_ULT_FC_AGT_NP, FDFMR_BNB_MT, FDFMR_BNB_ULT_MT, FDFMR_BNB_REW, FDFMR_BNB_ULT_REW, FDFMR_BNB_RET, FDFMR_BNB_ULT_RET, 
	FDFMR_NB_CHG_EFF_DT,	FDFMR_RRA_POL_CNT, FDFMR_RRA_POL_CNT_FST_ON, FDFMR_RRA_POL_CNT_SEC_ON, FDFMR_RRA_POL_CNT_FST_OFF, 
	FDFMR_RRA_POL_CNT_SEC_OFF, FDFMR_RRA_FC_CO, FDFMR_RRA_FC_AGT_NP_FST_ON, FDFMR_RRA_FC_AGT_NP_SEC_ON, FDFMR_RRA_FC_AGT_NP_ON, FDFMR_RRA_FC_AGT_NP_FST_OFF, 
	FDFMR_RRA_FC_AGT_NP_SEC_OFF,	FDFMR_RRA_FC_AGT_NP_OFF, FDFMR_RRA_ULT_FC_AGT_NP, FDFMR_RRA_MT, FDFMR_RRA_ULT_MT, FDFMR_RRA_REW, 
	FDFMR_RRA_ULT_REW, FDFMR_RRA_RET, FDFMR_RRA_ULT_RET, FDFMR_RPC_AMT_FST_ON, FDFMR_BAS_WRT_PRM_FST_ON, FDFMR_RPC_RT_AMT_FST_ON, FDFMR_RPC_AIL_AMT_FST_ON, 
	FDFMR_RPC_EXPOS_AMT_FST_ON, FDFMR_RPC_AMT, FDFMR_BAS_WRT_PRM, FDFMR_RPC_RT_AMT, FDFMR_RPC_AIL_AMT, FDFMR_RPC_EXPOS_AMT, FDFMR_ANNL_WRT_PRM_AMT_RB,
	FDFMR_ANNL_WRT_PRM_AMT_BNB, FDFMR_ORG_WRT_PRM_AMT, FDFMR_ACQN_WRT_PRM_AMT, FDFMR_COMB_WRT_PRM_AMT, FDFMR_PRR_IN_FRC_AMT, FDFMR_YR_END_IN_FRC_AMT,
	FDFMR_CURR_IN_FRC_AMT, FDFMR_CTL_LS_AMT, FDFMR_EARN_PRM_AMT, FDFMR_PIF_AMT,
	FDFMR_LST_USER, FDFMR_LST_DT_TM, FDFMR_CREAT_USER, FDFMR_CREAT_DT_TM
	)
	SELECT 
	EP.XMPLMR_SRC_CD, EP.XMPLMR_BPM_LN_OF_BUS, EP.XMPLMR_BPM_SEG_NM, 
	(CASE WHEN EP.XMPLMR_BPM_PRDCT_NM IN ('Legacy', 'Quantum', 'Trav Auto Pgm') THEN 'Standard Auto' 
	WHEN EP.XMPLMR_BPM_PRDCT_NM IN ('Specialty', 'OPL (excl Specialty)') THEN EP.XMPLMR_BPM_SBPRDCT_NM ELSE EP.XMPLMR_BPM_PRDCT_NM END), 
	(CASE WHEN EP.XMPLMR_BPM_PRDCT_NM IN ('Legacy', 'Quantum', 'Trav Auto Pgm') THEN EP.XMPLMR_BPM_PRDCT_NM ELSE 'Other' END), 
	@PREV_YEAR_TERM, EP.XMPLMR_CHNL_GRP_NM, EP.XMPLMR_CHNL_NM, 
	(CASE WHEN EP.XMPLMR_RGN_NM = 'Affn - Agent Sold' THEN 'Agent' WHEN EP.XMPLMR_RGN_NM = 'Affn - Trav Sold' THEN 'Trav Sold' ELSE EP.XMPLMR_RGN_NM END),  
	'Other', '', SN.CMSN_ST_NM, SN.CMSN_ST_CD, 'No', EP.XMPLMR_EFF_PERD_YR, @PREV_YEAR_EFF_MONTH,	
	@PREV_YEAR_MONTHNAME, @PREV_YEAR_YEARMONTH, @PREV_YEAR_FISCAL_YEAR, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, SUM(L.XMPLMR_CTL_LS_AMT) , SUM(L.XMPLMR_EARN_PRM_AMT), 0, 
	@UserName, GETDATE(), @UserName, GETDATE()
	FROM CNFG_MSTR_ST_NM SN, 
	(
	SELECT 
	EP.XMPLMR_SRC_CD, EP.XMPLMR_EVAL_PERD_KEY, EP.XMPLMR_EFF_PERD_YR, EP.XMPLMR_RT_ST_CD, EP.XMPLMR_CHNL_NM, EP.XMPLMR_CHNL_GRP_NM, EP.XMPLMR_RGN_NM, EP.XMPLMR_BPM_LN_OF_BUS, 
	EP.XMPLMR_BPM_SEG_NM, EP.XMPLMR_BPM_PRDCT_NM, EP.XMPLMR_BPM_SBPRDCT_NM, SUM(EP.XMPLMR_CTL_LS_AMT) AS XMPLMR_CTL_LS_AMT, SUM(EP.XMPLMR_EARN_PRM_AMT) AS XMPLMR_EARN_PRM_AMT
	FROM XTRCT_MKT_PRDCT_LCL_MKT_RGN EP
	WHERE 
	EP.XMPLMR_SRC_CD = 'MARKET REGION' AND EP.XMPLMR_EVAL_PERD_KEY = @MRMIN_XMPLMR_EVAL_PERD_KEY AND EP.XMPLMR_EFF_PERD_YR = @RPT_PREV_YEAR
	GROUP BY 
	EP.XMPLMR_SRC_CD, EP.XMPLMR_EVAL_PERD_KEY, EP.XMPLMR_EFF_PERD_YR, EP.XMPLMR_RT_ST_CD, EP.XMPLMR_CHNL_NM, EP.XMPLMR_CHNL_GRP_NM, EP.XMPLMR_RGN_NM, EP.XMPLMR_BPM_LN_OF_BUS, 
	EP.XMPLMR_BPM_SEG_NM, EP.XMPLMR_BPM_PRDCT_NM, EP.XMPLMR_BPM_SBPRDCT_NM
	) AS EP, 
	(SELECT 
	L.XMPLMR_EVAL_PERD_KEY, L.XMPLMR_EFF_PERD_YR, L.XMPLMR_RT_ST_CD, L.XMPLMR_CHNL_NM, L.XMPLMR_CHNL_GRP_NM, L.XMPLMR_RGN_NM, L.XMPLMR_BPM_LN_OF_BUS, L.XMPLMR_BPM_SEG_NM, 
	L.XMPLMR_BPM_PRDCT_NM, L.XMPLMR_BPM_SBPRDCT_NM, SUM(L.XMPLMR_CTL_LS_AMT) AS XMPLMR_CTL_LS_AMT, SUM(L.XMPLMR_EARN_PRM_AMT) AS XMPLMR_EARN_PRM_AMT
	FROM XTRCT_MKT_PRDCT_LCL_MKT_RGN L
	WHERE 
	L.XMPLMR_SRC_CD = 'MARKET REGION' AND L.XMPLMR_EVAL_PERD_KEY = @MRMAX_XMPLMR_EVAL_PERD_KEY AND L.XMPLMR_EFF_PERD_YR = @RPT_PREV_YEAR 
	GROUP BY 
	L.XMPLMR_EVAL_PERD_KEY, L.XMPLMR_EFF_PERD_YR, L.XMPLMR_RT_ST_CD, L.XMPLMR_CHNL_NM, L.XMPLMR_CHNL_GRP_NM, L.XMPLMR_RGN_NM, L.XMPLMR_BPM_LN_OF_BUS, L.XMPLMR_BPM_SEG_NM, 
	L.XMPLMR_BPM_PRDCT_NM, L.XMPLMR_BPM_SBPRDCT_NM) AS L
	WHERE 
	EP.XMPLMR_BPM_SBPRDCT_NM = L.XMPLMR_BPM_SBPRDCT_NM AND EP.XMPLMR_BPM_PRDCT_NM = L.XMPLMR_BPM_PRDCT_NM AND EP.XMPLMR_BPM_SEG_NM = L.XMPLMR_BPM_SEG_NM AND
	EP.XMPLMR_BPM_LN_OF_BUS = L.XMPLMR_BPM_LN_OF_BUS AND EP.XMPLMR_RGN_NM = L.XMPLMR_RGN_NM AND EP.XMPLMR_CHNL_NM = L.XMPLMR_CHNL_NM AND 
	EP.XMPLMR_CHNL_GRP_NM = L.XMPLMR_CHNL_GRP_NM AND EP.XMPLMR_EFF_PERD_YR = L.XMPLMR_EFF_PERD_YR AND EP.XMPLMR_RT_ST_CD = L.XMPLMR_RT_ST_CD AND
	EP.XMPLMR_RT_ST_CD = SN.CMSN_ST_CD
	GROUP BY
	EP.XMPLMR_SRC_CD, EP.XMPLMR_EFF_PERD_YR, SN.CMSN_ST_NM, SN.CMSN_ST_CD, EP.XMPLMR_CHNL_NM, EP.XMPLMR_CHNL_GRP_NM, EP.XMPLMR_RGN_NM, 
	EP.XMPLMR_BPM_LN_OF_BUS, EP.XMPLMR_BPM_SEG_NM, EP.XMPLMR_BPM_PRDCT_NM, EP.XMPLMR_BPM_SBPRDCT_NM
	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50600, 11, 'FACT_DTL_FIN_MGT_RPT table: insert statement from XTRCT_MKT_PRDCT_LCL_MKT_RGN (Auto & Property Market Region) Previous Year data did not succeed'
		return 50600
	  END

    exec @ret = OthInsUserMessage
                @SessionId, 
                @FunctionName = @FunctionName, 
                @Task_Name = 'Insert Statement: FACT_DTL_FIN_MGT_RPT <-- From XTRCT_MKT_PRDCT_LCL_MKT_RGN (Auto & Property Market Region) Previous Year data',
                @Status = 'Complete',
				@UserName = @UserName

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing insert FACT_DTL_FIN_MGT_RPT from XTRCT_MKT_PRDCT_LCL_MKT_RGN (Auto & Property Market Region) Previous Year data table complete statement'
		return 50200
	  END
--AUTO & PROPERTY MARKET REGION PREVIOUS YEAR INSERT STATEMENT END HERE--
--MARKET REGION INSERT STATEMENT END HERE--
--EXTRACT STATUS: EPLR COLUMN UPDATE STATEMENT START HERE

	UPDATE CRIT_STS_XTRCT SET CSX_EARN_PRM_LS_RTO_IND = 'Y', CSX_LST_USER = @UserName, CSX_LST_DT_TM = GETDATE()
	WHERE CSX_YR_MO = @YearMonth

	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50801, 11, 'Extract Status table: Earned Premium & Loss Ratio column update statement did not succeed'
		return 50801
	  END

--EXTRACT STATUS: EPLR COLUMN UPDATE STATEMENT END HERE
--SET CURRENT AND NEXT SSIS PACKAGE START HERE--
	exec @ret = OthSetCurrentAndNextSSIS
				@SessionId, 
				@FunctionName = @FunctionName, 
				@UserName = @UserName,
				@Curr_Package_Name = 'Earned Premium And Loss Ratio',
				@Next_Package_Name = 'Indicated Combined Ratio'
	
	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 100011, 11, 'MSDB Job: update statement did not succeed'
		return 100011
	  END
  END
--SET CURRENT AND NEXT SSIS PACKAGE START HERE--
set nocount off

RETURN 0

GO
--------------------------------------------------------------------------------------------------------------------------------------------
-- Drop Procedure
--------------------------------------------------------------------------------------------------------------------------------------------
if exists (select * from sys.sysobjects where id = object_id(N'[dbo].[RptInsICRdata]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[RptInsICRdata]
GO

--------------------------------------------------------------------------------------------------------------------------------------------
-- Create procedure
--------------------------------------------------------------------------------------------------------------------------------------------
CREATE PROCEDURE RptInsICRdata
(	@SessionId			udtNumber,
	@FunctionName		udtName,
	@FICR_RPT_DESC		UdtName,
	@Arg1				UdtAmount = 0.00,
	@Arg2				UdtAmount = 0.00,
	@Arg3				UdtAmount = 0.00,
	@Arg4				UdtAmount = 0.00,
	@Arg5				UdtAmount = 0.00,
	@Arg6				UdtAmount = 0.00
)
AS 
--------------------------------------------------------------------------------------------------------------------------------------------
-- OBJECT NAME:    RptInsICRdata
--------------------------------------------------------------------------------------------------------------------------------------------
-- AUTHOR:         Vijaya Kumar Gulappa
--------------------------------------------------------------------------------------------------------------------------------------------
-- CREATED:        31 Jul 2007
--------------------------------------------------------------------------------------------------------------------------------------------
-- DESCRIPTION:    Insert Current year ICR data table.
--------------------------------------------------------------------------------------------------------------------------------------------
-- PARAMETERS:
--------------------------------------------------------------------------------------------------------------------------------------------
-- RETURNS:        0  -  success
--                 returns from SQL Server
--------------------------------------------------------------------------------------------------------------------------------------------

-- VERSION: $Revision: 10 $  UPDATED: $Modtime: 8/08/07 2:19p $
--------------------------------------------------------------------------------------------------------------------------------------------

declare	@ret int,
		@UserName			udtName,
		@FICR_RPT_MO		UdtEffYrMon,
		@FICR_RPT_YR			UdtEffYrMon,
		@FICR_RPT_YR_MO		UdtEffYrMon,
		@FICR_ST_CD			UdtStateCode,
		@FICR_ST_NM			udtName,
		@FICR_SHT_NM			udtName,
		@FICR_CHNL_GRP_NM	UdtChannel

set nocount on
Set @FunctionName = OBJECT_NAME(@@PROCID)
SET @ret = 0

SET @FICR_RPT_MO = (CASE WHEN LEN(DATEPART(M, GETDATE()) - 1) = 1 THEN '0' ELSE '' END) + CAST(DATEPART(M, GETDATE()) - 1 AS VARCHAR(2))
SET @FICR_RPT_YR = (CASE WHEN DATEPART(M, GETDATE()) = 12 THEN DATEPART(YYYY, GETDATE()) - 1 ELSE DATEPART(YYYY, GETDATE()) END)
SET @FICR_RPT_YR_MO = CAST(DATEPART(YYYY, GETDATE()) AS VARCHAR(4)) + (CASE WHEN LEN(DATEPART(M, GETDATE())) = 1 THEN '0' ELSE '' END) + CAST(DATEPART(M, GETDATE()) AS VARCHAR(2))
SET @FICR_SHT_NM = @FICR_RPT_DESC

  BEGIN

	Exec @ret = UsrGetSessionInfo @SessionId = @SessionId,
								@FunctionName = @FunctionName,
								@UMS_AT_Name = @UserName Output

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50103, 11, 'Get Session Information: Exec UsrGetSessionInfo failed'
		return 50103
	  END

--ARCHIVE ICR DATA: STATEMENT START HERE
	IF @FICR_RPT_DESC = 'TOTAL_AUTO' 
	BEGIN
		exec @ret = ArcCurrentICRFMRData
					@SessionId, 
					@FunctionName = @FunctionName, 
					@UserName = @UserName
		
		IF  @ret != 0 
		  BEGIN 
			exec OthInsErrorMessage @SessionId, @FunctionName, 51822, 11, 'Archive ICR Data: insert statement did not succeed'
			return 51822
		  END

		exec @ret = OthInsUserMessage
					@SessionId, 
					@FunctionName = @FunctionName, 
					@Task_Name = 'Insert Statement: Archive ICR Data',
					@Status = 'Complete'

		IF  @ret != 0 
		  BEGIN 
			exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing insert archive icr data complete statement'
			return 50200
		  END
	END
--ARCHIVE ICR DATA: STATEMENT END HERE

	IF EXISTS(SELECT FICR_PK_ID FROM FACT_IND_COMB_RTO WHERE FICR_RPT_YR_MO = @FICR_RPT_YR_MO AND FICR_SHT_NM = @FICR_SHT_NM)
	BEGIN
		DELETE FROM FACT_IND_COMB_RTO WHERE FICR_RPT_YR_MO = @FICR_RPT_YR_MO AND FICR_SHT_NM = @FICR_SHT_NM
		IF  @@error != 0 
		  BEGIN 
			exec OthInsErrorMessage @SessionId, @FunctionName, 51813, 11, 'ICR Data: delete statement did not succeed', @FICR_RPT_DESC
			return 51813
		  END
	END 

--ICR DATA INSERT STATEMENT START HERE

	BEGIN
		IF @FICR_RPT_DESC = 'TOTAL_AUTO' 
		BEGIN
			INSERT INTO [dbo].FACT_IND_COMB_RTO 
			(
			FICR_BPM_LN_OF_BUS, FICR_SHT_NM, FICR_RPT_DESC, FICR_ST_CD, FICR_ST_NM, FICR_CHNL_GRP_NM, FICR_RPT_MO, FICR_RPT_YR, 
			FICR_RPT_YR_MO, FICR_TOT_PCT
			)
			SELECT 'Auto', @FICR_SHT_NM, 'Total Retail', '', '', '', @FICR_RPT_MO, @FICR_RPT_YR, @FICR_RPT_YR_MO, @Arg1
			UNION ALL SELECT 'Auto', @FICR_SHT_NM, 'Total Domestics', '', '', '', @FICR_RPT_MO, @FICR_RPT_YR, @FICR_RPT_YR_MO, @Arg2
			UNION ALL SELECT 'Auto', @FICR_SHT_NM, 'Affinity', '', '', '', @FICR_RPT_MO, @FICR_RPT_YR, @FICR_RPT_YR_MO, @Arg3
			UNION ALL SELECT 'Auto', @FICR_SHT_NM, 'Runoff', '', '', '', @FICR_RPT_MO, @FICR_RPT_YR, @FICR_RPT_YR_MO, @Arg4
			UNION ALL SELECT 'Auto', @FICR_SHT_NM, 'Total Standard Vol Auto', '', '', '', @FICR_RPT_MO, @FICR_RPT_YR, @FICR_RPT_YR_MO, @Arg5
		END
		ELSE IF @FICR_RPT_DESC = 'TOTAL_PROPERTY' 
		BEGIN
			INSERT INTO [dbo].FACT_IND_COMB_RTO 
			(
			FICR_BPM_LN_OF_BUS, FICR_SHT_NM, FICR_RPT_DESC, FICR_ST_CD, FICR_ST_NM, FICR_CHNL_GRP_NM, FICR_RPT_MO, FICR_RPT_YR, 
			FICR_RPT_YR_MO, FICR_TOT_PCT
			)
			SELECT 'Property', @FICR_SHT_NM, 'Total Retail', '', '', '', @FICR_RPT_MO, @FICR_RPT_YR, @FICR_RPT_YR_MO, @Arg1
			UNION ALL SELECT 'Property', @FICR_SHT_NM, 'Total Domestics', '', '', '', @FICR_RPT_MO, @FICR_RPT_YR, @FICR_RPT_YR_MO, @Arg2
			UNION ALL SELECT 'Property', @FICR_SHT_NM, 'Affinity', '', '', '', @FICR_RPT_MO, @FICR_RPT_YR, @FICR_RPT_YR_MO, @Arg3
			UNION ALL SELECT 'Property', @FICR_SHT_NM, 'Geico', '', '', '', @FICR_RPT_MO, @FICR_RPT_YR, @FICR_RPT_YR_MO, @Arg4
			UNION ALL SELECT 'Property', @FICR_SHT_NM, 'Runoff', '', '', '', @FICR_RPT_MO, @FICR_RPT_YR, @FICR_RPT_YR_MO, @Arg5
			UNION ALL SELECT 'Property', @FICR_SHT_NM, 'Total Property', '', '', '', @FICR_RPT_MO, @FICR_RPT_YR, @FICR_RPT_YR_MO, @Arg6
		END
		ELSE IF @FICR_RPT_DESC = 'TOTAL_HO' 
		BEGIN
			INSERT INTO [dbo].FACT_IND_COMB_RTO 
			(
			FICR_BPM_LN_OF_BUS, FICR_SHT_NM, FICR_RPT_DESC, FICR_ST_CD, FICR_ST_NM, FICR_CHNL_GRP_NM, FICR_RPT_MO, FICR_RPT_YR, 
			FICR_RPT_YR_MO, FICR_TOT_PCT
			)
			SELECT 'Property', @FICR_SHT_NM, 'Total Homeowners', '', '', '', @FICR_RPT_MO, @FICR_RPT_YR, @FICR_RPT_YR_MO, @Arg1
		END
		ELSE IF @FICR_RPT_DESC = 'TOTAL_OPL' 
		BEGIN
			INSERT INTO [dbo].FACT_IND_COMB_RTO 
			(
			FICR_BPM_LN_OF_BUS, FICR_SHT_NM, FICR_RPT_DESC, FICR_ST_CD, FICR_ST_NM, FICR_CHNL_GRP_NM, FICR_RPT_MO, FICR_RPT_YR, 
			FICR_RPT_YR_MO, FICR_TOT_PCT
			)
			SELECT 'Property', @FICR_SHT_NM, 'Total Specialty', '', '', '', @FICR_RPT_MO, @FICR_RPT_YR, @FICR_RPT_YR_MO, @Arg1
		END
		ELSE IF @FICR_RPT_DESC IN ('RETAIL', 'AFFINITY', 'RUNOFF', 'FLORIDA', 'MASSACHUSETTS', 'NEW_JERSEY')
		BEGIN
			SET @FICR_RPT_DESC = REPLACE(@FICR_RPT_DESC, '_', ' ')
			SET @FICR_ST_CD = (CASE WHEN @FICR_RPT_DESC = 'FLORIDA' THEN 'FL' WHEN @FICR_RPT_DESC = 'MASSACHUSETTS' THEN 'MA' WHEN @FICR_RPT_DESC = 'NEW JERSEY' THEN 'NJ' ELSE '' END)
			SET @FICR_ST_NM = (CASE WHEN @FICR_RPT_DESC IN ('FLORIDA', 'MASSACHUSETTS', 'NEW JERSEY') THEN @FICR_RPT_DESC ELSE '' END)
			SET @FICR_CHNL_GRP_NM = (CASE WHEN @FICR_RPT_DESC IN ('RETAIL', 'AFFINITY', 'RUNOFF') THEN @FICR_RPT_DESC ELSE '' END)

			INSERT INTO [dbo].FACT_IND_COMB_RTO 
			(
			FICR_BPM_LN_OF_BUS, FICR_SHT_NM, FICR_RPT_DESC, FICR_ST_CD, FICR_ST_NM, FICR_CHNL_GRP_NM, FICR_RPT_MO, FICR_RPT_YR, 
			FICR_RPT_YR_MO, FICR_TOT_PCT
			)
			SELECT 'Property', @FICR_SHT_NM, 'Total Homeowners', @FICR_ST_CD, @FICR_ST_NM, @FICR_CHNL_GRP_NM, @FICR_RPT_MO, @FICR_RPT_YR, @FICR_RPT_YR_MO, @Arg1
			UNION ALL SELECT 'Property', @FICR_SHT_NM, 'Total Specialty', @FICR_ST_CD, @FICR_ST_NM, @FICR_CHNL_GRP_NM, @FICR_RPT_MO, @FICR_RPT_YR, @FICR_RPT_YR_MO, @Arg2
			UNION ALL SELECT 'Property', @FICR_SHT_NM, 'Total Property', @FICR_ST_CD, @FICR_ST_NM, @FICR_CHNL_GRP_NM, @FICR_RPT_MO, @FICR_RPT_YR, @FICR_RPT_YR_MO, @Arg3
			UNION ALL SELECT 'Auto', @FICR_SHT_NM, 'Total Standard Vol Auto', @FICR_ST_CD, @FICR_ST_NM, @FICR_CHNL_GRP_NM, @FICR_RPT_MO, @FICR_RPT_YR, @FICR_RPT_YR_MO, @Arg4
		END
		ELSE IF @FICR_RPT_DESC = 'GEICO'
		BEGIN
			INSERT INTO [dbo].FACT_IND_COMB_RTO 
			(
			FICR_BPM_LN_OF_BUS, FICR_SHT_NM, FICR_RPT_DESC, FICR_ST_CD, FICR_ST_NM, FICR_CHNL_GRP_NM, FICR_RPT_MO, FICR_RPT_YR, 
			FICR_RPT_YR_MO, FICR_TOT_PCT
			)
			SELECT 'Property', @FICR_SHT_NM, 'Total Homeowners', '', '', @FICR_RPT_DESC, @FICR_RPT_MO, @FICR_RPT_YR, @FICR_RPT_YR_MO, @Arg1
			UNION ALL SELECT 'Property', @FICR_SHT_NM, 'Total Specialty', '', '', @FICR_RPT_DESC, @FICR_RPT_MO, @FICR_RPT_YR, @FICR_RPT_YR_MO, @Arg2
			UNION ALL SELECT 'Property', @FICR_SHT_NM, 'Total Property', '', '', @FICR_RPT_DESC, @FICR_RPT_MO, @FICR_RPT_YR, @FICR_RPT_YR_MO, @Arg3
		END
		IF  @@error != 0 
		  BEGIN 
			exec OthInsErrorMessage @SessionId, @FunctionName, 51811, 11, 'ICR Data: Insert statement did not succeed', @FICR_RPT_DESC
			return 51811
		  END
	END

--ICR DATA INSERT STATEMENT END HERE

    exec @ret = OthInsUserMessage
                @SessionId, 
                @FunctionName = @FunctionName, 
                @Task_Name = 'Insert Statement: ICR Data',
                @Status = 'Complete',
				@UserName = @UserName

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing insert ICR data complete statement'
		return 50200
	  END

	IF @FICR_RPT_DESC = 'RUNOFF' 
	BEGIN
--EXTRACT STATUS: ICR COLUMN UPDATE STATEMENT START HERE
		UPDATE CRIT_STS_XTRCT SET CSX_IND_COMB_RTO_IND = 'Y', CSX_LST_USER = @UserName, CSX_LST_DT_TM = GETDATE()
		WHERE CSX_YR_MO = @FICR_RPT_YR_MO

		IF  @@error != 0 
		  BEGIN 
			exec OthInsErrorMessage @SessionId, @FunctionName, 50801, 11, 'Extract Status table: Indicated Combined Ratio column update statement did not succeed'
			return 50801
		  END
--EXTRACT STATUS: PIF COLUMN UPDATE STATEMENT END HERE
--SET CURRENT AND NEXT SSIS PACKAGE START HERE--
		exec @ret = OthSetCurrentAndNextSSIS
					@SessionId, 
					@FunctionName = @FunctionName, 
					@UserName = @UserName,
					@Curr_Package_Name = 'Indicated Combined Ratio',
					@Next_Package_Name = 'Policy In Force'
		
		IF  @ret != 0 
		  BEGIN 
			exec OthInsErrorMessage @SessionId, @FunctionName, 100011, 11, 'MSDB Job: update statement did not succeed'
			return 100011
		  END
	  END
--SET CURRENT AND NEXT SSIS PACKAGE START HERE--

  END

set nocount off

RETURN 0

GO
--------------------------------------------------------------------------------------------------------------------------------------------
-- Drop Procedure
--------------------------------------------------------------------------------------------------------------------------------------------
if exists (select * from sys.sysobjects where id = object_id(N'[dbo].[RptInsPIFdata]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[RptInsPIFdata]
GO

--------------------------------------------------------------------------------------------------------------------------------------------
-- Create procedure
--------------------------------------------------------------------------------------------------------------------------------------------
CREATE PROCEDURE RptInsPIFdata
(	@SessionId			udtNumber,
	@FunctionName		udtName,
	@PIF_DESC			UdtName,
	@TOT_PIF_AMT		UdtAmount
)
AS 
--------------------------------------------------------------------------------------------------------------------------------------------
-- OBJECT NAME:    RptInsPIFdata
--------------------------------------------------------------------------------------------------------------------------------------------
-- AUTHOR:         Vijaya Kumar Gulappa
--------------------------------------------------------------------------------------------------------------------------------------------
-- CREATED:        30 Jul 2007
--------------------------------------------------------------------------------------------------------------------------------------------
-- DESCRIPTION:    Insert Current year PIF data table.
--------------------------------------------------------------------------------------------------------------------------------------------
-- PARAMETERS:
--------------------------------------------------------------------------------------------------------------------------------------------
-- RETURNS:        0  -  success
--                 returns from SQL Server
--------------------------------------------------------------------------------------------------------------------------------------------

-- VERSION: $Revision: 13 $  UPDATED: $Modtime: 8/08/07 2:21p $
--------------------------------------------------------------------------------------------------------------------------------------------

declare	@ret int,
		@UserName			udtName,
		@BPM_LN_OF_BUS		UdtLine,
		@PIF_MONTH			UdtEffYrMon,
		@PIF_YEAR			UdtEffYrMon,
		@PIF_YEARMONTH		UdtEffYrMon

set nocount on
Set @FunctionName = OBJECT_NAME(@@PROCID)
SET @ret = 0

SET @PIF_MONTH = (CASE WHEN LEN(DATEPART(M, GETDATE()) - 1) = 1 THEN '0' ELSE '' END) + CAST(DATEPART(M, GETDATE()) - 1 AS VARCHAR(2))
SET @PIF_YEAR = (CASE WHEN DATEPART(M, GETDATE()) = 12 THEN DATEPART(YYYY, GETDATE()) - 1 ELSE DATEPART(YYYY, GETDATE()) END)
SET @PIF_YEARMONTH = CAST(DATEPART(YYYY, GETDATE()) AS VARCHAR(4)) + (CASE WHEN LEN(DATEPART(M, GETDATE())) = 1 THEN '0' ELSE '' END) + CAST(DATEPART(M, GETDATE()) AS VARCHAR(2))
SET @BPM_LN_OF_BUS = (CASE WHEN @PIF_DESC IN ('Mendota NSA', 'NSA', 'AIP', 'Mass Auto') THEN 'Auto' ELSE 'Property' END)

  BEGIN

	Exec @ret = UsrGetSessionInfo @SessionId = @SessionId,
								@FunctionName = @FunctionName,
								@UMS_AT_Name = @UserName Output

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50103, 11, 'Get Session Information: Exec UsrGetSessionInfo failed'
		return 50103
	  END

--PIF DATA INSERT STATEMENT START HERE

	BEGIN
		IF EXISTS(SELECT XPIF_PK_ID FROM XTRCT_POL_IN_FRC WHERE XPIF_YR_MO = @PIF_YEARMONTH AND XPIF_DESC = @PIF_DESC)
		BEGIN
			DELETE FROM XTRCT_POL_IN_FRC WHERE XPIF_YR_MO = @PIF_YEARMONTH AND XPIF_DESC = @PIF_DESC
			IF  @@error != 0 
			  BEGIN 
				exec OthInsErrorMessage @SessionId, @FunctionName, 51313, 11, 'PIF Data: delete statement did not succeed', @PIF_DESC
				return 51313
			  END
		END 

		INSERT INTO [dbo].XTRCT_POL_IN_FRC 
		(
		XPIF_BPM_LN_OF_BUS, XPIF_DESC, XPIF_MO, XPIF_YR, XPIF_YR_MO, XPIF_TOT_AMT
		)
		VALUES 
		(@BPM_LN_OF_BUS, @PIF_DESC, @PIF_MONTH, @PIF_YEAR, @PIF_YEARMONTH, @TOT_PIF_AMT)

		IF  @@error != 0 
		  BEGIN 
			exec OthInsErrorMessage @SessionId, @FunctionName, 51311, 11, 'PIF Data: Insert statement did not succeed', @PIF_DESC
			return 51311
		  END
	END

--PIF DATA INSERT STATEMENT END HERE

    exec @ret = OthInsUserMessage
                @SessionId, 
                @FunctionName = @FunctionName, 
                @Task_Name = 'Insert Statement: PIF Data',
                @Status = 'Complete',
				@UserName = @UserName

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing insert pif data complete statement'
		return 50200
	  END

	IF @PIF_DESC = 'Mass Auto' 
	BEGIN
--EXTRACT STATUS: PIF COLUMN UPDATE STATEMENT START HERE
		UPDATE CRIT_STS_XTRCT SET CSX_POL_IN_FRC_IND = 'Y', CSX_LST_USER = @UserName, CSX_LST_DT_TM = GETDATE()
		WHERE CSX_YR_MO = @PIF_YEARMONTH

		IF  @@error != 0 
		  BEGIN 
			exec OthInsErrorMessage @SessionId, @FunctionName, 50801, 11, 'Extract Status table: Policy In Force column update statement did not succeed'
			return 50801
		  END
--EXTRACT STATUS: PIF COLUMN UPDATE STATEMENT END HERE
--PIF DATA: MERGE PIF DATA WITH DETAIL FINANCIAL MANAGEMENT REPORT TABLE START HERE
		exec @ret = RptInsPIFTotal
					@SessionId, 
					@FunctionName = @FunctionName, 
					@UserName = @UserName
		
		IF  @ret != 0 
		  BEGIN 
			exec OthInsErrorMessage @SessionId, @FunctionName, 50600, 11, 'Combine PIF Data table: insert statement did not succeed'
			return 50600
		  END
--PIF DATA: MERGE PIF DATA WITH DETAIL FINANCIAL MANAGEMENT REPORT TABLE END HERE
--SET CURRENT AND NEXT SSIS PACKAGE START HERE--
		exec @ret = OthSetCurrentAndNextSSIS
					@SessionId, 
					@FunctionName = @FunctionName, 
					@UserName = @UserName,
					@Curr_Package_Name = 'Policy In Force',
					@Next_Package_Name = 'Control Report'
		
		IF  @ret != 0 
		  BEGIN 
			exec OthInsErrorMessage @SessionId, @FunctionName, 100011, 11, 'MSDB Job: update statement did not succeed'
			return 100011
		  END
	  END
--SET CURRENT AND NEXT SSIS PACKAGE START HERE--

  END

set nocount off

RETURN 0

GO

--------------------------------------------------------------------------------------------------------------------------------------------
-- Drop Procedure
--------------------------------------------------------------------------------------------------------------------------------------------
if exists (select * from sys.sysobjects where id = object_id(N'[dbo].[RptInsPIFTotal]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[RptInsPIFTotal]
GO

--------------------------------------------------------------------------------------------------------------------------------------------
-- Create procedure
--------------------------------------------------------------------------------------------------------------------------------------------
CREATE PROCEDURE [dbo].[RptInsPIFTotal]
(	@SessionId		[udtNumber],
	@FunctionName	[udtName],
	@UserName	udtName
)
AS 
--------------------------------------------------------------------------------------------------------------------------------------------
-- OBJECT NAME:    RptInsPIFTotal
--------------------------------------------------------------------------------------------------------------------------------------------
-- AUTHOR:         Vijaya Kumar Gulappa
--------------------------------------------------------------------------------------------------------------------------------------------
-- CREATED:        May-10-2007
--------------------------------------------------------------------------------------------------------------------------------------------
-- DESCRIPTION:    Append NSA, AIP, Flood, MA Auto, Mendota NSA & Mendota Specialty PIF data 
--				   since begin of last year untill current year last month data into FACT_DTL_FIN_MGT_RPT table.
--------------------------------------------------------------------------------------------------------------------------------------------
-- PARAMETERS:
--------------------------------------------------------------------------------------------------------------------------------------------
-- RETURNS:        0  -  success
--                 returns from SQL Server
--------------------------------------------------------------------------------------------------------------------------------------------

-- VERSION: $Revision: 5 $  UPDATED: $Modtime: 8/08/07 2:22p $
--------------------------------------------------------------------------------------------------------------------------------------------

declare	@ret int,
		@RPT_PREV_YEAR			UdtEffYrMon

set nocount on
Set @FunctionName = OBJECT_NAME(@@PROCID)
SET @ret = 0

  BEGIN

	Exec @ret = ConGetSystemPreferenceValue	@FunctionName = @FunctionName,
									@Code = 'RPY',
									@Value = @RPT_PREV_YEAR Output

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 51503, 11, 'Get Session Information: Exec UsrGetSessionInfo failed'
		return 51503
	  END

	IF EXISTS(SELECT FDFMR_PK_ID FROM FACT_DTL_FIN_MGT_RPT WHERE FDFMR_SRC_NM = 'PIF')
	BEGIN
		DELETE FROM FACT_DTL_FIN_MGT_RPT WHERE FDFMR_SRC_NM = 'PIF'
		IF  @@error != 0 
		  BEGIN 
			exec OthInsErrorMessage @SessionId, @FunctionName, 50602, 11, 'FACT_DTL_FIN_MGT_RPT table: Policy In Force delete statement did not succeed'
			return 50602
		  END
	END

--PIF DATA INSERT STATEMENT START HERE--
	INSERT INTO [dbo].FACT_DTL_FIN_MGT_RPT
	( 
	FDFMR_SRC_NM, FDFMR_BPM_LN_OF_BUS, FDFMR_BPM_SEG_NM, FDFMR_BPM_PRDCT_NM, FDFMR_RT_PLN_GRP_NM, FDFMR_TRM, FDFMR_CHNL_GRP_NM, 
	FDFMR_CHNL_NM, FDFMR_SUB_CHNL, FDFMR_PM_RGN_NM, FDFMR_STRG, FDFMR_ST_NM, FDFMR_ST_CD,
	FDFMR_SPC, FDFMR_EFF_YR, FDFMR_EFF_MO, FDFMR_MO_NM, FDFMR_EFF_YR_MO, FDFMR_FISC_YR, 
	FDFMR_ARB_ULT_POL_CNT, FDFMR_ARB_POL_CNT, FDFMR_ARB_POL_CNT_FST_ON, FDFMR_ARB_POL_CNT_SEC_ON, FDFMR_ARB_POL_CNT_FST_OFF, 
	FDFMR_ARB_ULT_POL_CNT_SEC_OFF, FDFMR_ARB_FC_CO, FDFMR_ARB_FC_AGT_NP_FST_ON, FDFMR_ARB_FC_AGT_NP_SEC_ON, FDFMR_ARB_FC_AGT_NP_ON, 
	FDFMR_ARB_FC_AGT_NP_FST_OFF, FDFMR_ARB_FC_AGT_NP_SEC_OFF, FDFMR_ARB_FC_AGT_NP_OFF, FDFMR_ARB_ULT_FC_AGT_NP, FDFMR_ARB_MT, FDFMR_ARB_ULT_MT, FDFMR_ARB_RET,
	FDFMR_ARB_ULT_RET, FDFMR_ORA_POL_CNT, FDFMR_ORA_POL_CNT_FST_ON, FDFMR_ORA_POL_CNT_SEC_ON, FDFMR_ORA_POL_CNT_FST_OFF,
	FDFMR_ORA_POL_CNT_SEC_OFF, FDFMR_ORA_FC_CO, FDFMR_ORA_FC_AGT_NP_FST_ON, FDFMR_ORA_FC_AGT_NP_SEC_ON, FDFMR_ORA_FC_AGT_NP_ON,
	FDFMR_ORA_FC_AGT_NP_FST_OFF, FDFMR_ORA_FC_AGT_NP_SEC_OFF, FDFMR_ORA_FC_AGT_NP_OFF, FDFMR_ORA_ULT_FC_AGT_NP, FDFMR_ORA_MT, FDFMR_ORA_ULT_MT,
	FDFMR_ORA_REW, FDFMR_ORA_ULT_REW, FDFMR_ORA_RET, FDFMR_ORA_ULT_RET, FDFMR_BNB_POL_CNT, FDFMR_BNB_POL_CNT_FST_ON, FDFMR_BNB_POL_CNT_SEC_ON,
	FDFMR_BNB_POL_CNT_FST_OFF, FDFMR_BNB_POL_CNT_SEC_OFF, FDFMR_BNB_ULT_POL_CNT, FDFMR_BNB_FC_CO, FDFMR_BNB_FC_AGT_NP_FST_ON, FDFMR_BNB_FC_AGT_NP_SEC_ON, 
	FDFMR_BNB_FC_AGT_NP_ON, FDFMR_BNB_FC_AGT_NP_FST_OFF, FDFMR_BNB_FC_AGT_NP_SEC_OFF, FDFMR_BNB_FC_AGT_NP_OFF, FDFMR_BNB_ULT_FC_AGT_NP, FDFMR_BNB_MT,
	FDFMR_BNB_ULT_MT, FDFMR_BNB_REW, FDFMR_BNB_ULT_REW, FDFMR_BNB_RET, FDFMR_BNB_ULT_RET, FDFMR_NB_CHG_EFF_DT,
	FDFMR_RRA_POL_CNT, FDFMR_RRA_POL_CNT_FST_ON, FDFMR_RRA_POL_CNT_SEC_ON, FDFMR_RRA_POL_CNT_FST_OFF, FDFMR_RRA_POL_CNT_SEC_OFF,
	FDFMR_RRA_FC_CO, FDFMR_RRA_FC_AGT_NP_FST_ON, FDFMR_RRA_FC_AGT_NP_SEC_ON, FDFMR_RRA_FC_AGT_NP_ON, FDFMR_RRA_FC_AGT_NP_FST_OFF, FDFMR_RRA_FC_AGT_NP_SEC_OFF,
	FDFMR_RRA_FC_AGT_NP_OFF, FDFMR_RRA_ULT_FC_AGT_NP, FDFMR_RRA_MT, FDFMR_RRA_ULT_MT, FDFMR_RRA_REW, FDFMR_RRA_ULT_REW,
	FDFMR_RRA_RET, FDFMR_RRA_ULT_RET, FDFMR_RPC_AMT_FST_ON, FDFMR_BAS_WRT_PRM_FST_ON, FDFMR_RPC_RT_AMT_FST_ON, FDFMR_RPC_AIL_AMT_FST_ON, FDFMR_RPC_EXPOS_AMT_FST_ON,
	FDFMR_RPC_AMT, FDFMR_BAS_WRT_PRM, FDFMR_RPC_RT_AMT, FDFMR_RPC_AIL_AMT, FDFMR_RPC_EXPOS_AMT, FDFMR_ANNL_WRT_PRM_AMT_RB,
	FDFMR_ANNL_WRT_PRM_AMT_BNB, FDFMR_ORG_WRT_PRM_AMT, FDFMR_ACQN_WRT_PRM_AMT, FDFMR_COMB_WRT_PRM_AMT, FDFMR_PRR_IN_FRC_AMT, FDFMR_YR_END_IN_FRC_AMT,
	FDFMR_CURR_IN_FRC_AMT, FDFMR_CTL_LS_AMT, FDFMR_EARN_PRM_AMT, FDFMR_PIF_AMT,
	FDFMR_LST_USER, FDFMR_LST_DT_TM, FDFMR_CREAT_USER, FDFMR_CREAT_DT_TM
	)
	SELECT SOURCE = 'PIF', LINE = (CASE WHEN XPIF_DESC IN ('NSA', 'AIP', 'Mass Auto', 'Mendota NSA') THEN 'Auto'
	WHEN XPIF_DESC IN ('Mendota Specialty', 'Flood') THEN 'Property' ELSE '' END),
	SEGMENT = (CASE WHEN XPIF_DESC IN ('NSA', 'Mendota NSA') THEN 'Non Standard Auto'
	WHEN XPIF_DESC IN ('Flood', 'Mendota Specialty') THEN 'Other Personal Lines'
	WHEN XPIF_DESC = 'AIP' THEN 'Involuntary Auto' WHEN XPIF_DESC = 'Mass Auto' THEN 'Standard Auto' ELSE '' END),
	PRODUCT = (CASE WHEN XPIF_DESC IN ('NSA', 'Mendota NSA') THEN 'TSA-TIC'
	WHEN XPIF_DESC = 'AIP' THEN 'AIP' WHEN XPIF_DESC = 'Flood' THEN 'Flood' 
	WHEN XPIF_DESC = 'Mass Auto' THEN 'Standard Auto' WHEN XPIF_DESC = 'Mendota Specialty' THEN 'Specialty' ELSE '' END),
	RATEPLAN = 'Legacy', TERM = 12, CHANNEL = (CASE WHEN XPIF_DESC = 'AIP' THEN 'AIP Channel' ELSE 'Traditional Distribution' END),
	CHANNEL_TYPE = (CASE WHEN XPIF_DESC = 'AIP' THEN 'AIP Channel' ELSE 'Domestics' END), SUB_CHANNEL = XPIF_DESC, 
	PRODUCTREGION = (CASE WHEN XPIF_DESC IN ('NSA', 'AIP', 'Mendota NSA') THEN 'Domestic'
	WHEN XPIF_DESC IN ('Flood', 'Mendota Specialty') THEN 'Other' 
	WHEN XPIF_DESC  = 'Mass Auto' THEN 'MA Office' ELSE '' END), 
	STRATEGY = '', STATENAME = 'UNKNOWN', STATECODE = 'XX', SPECTRUM = 'No', 
	EFF_YEAR = XPIF_YR, EFF_MONTH = XPIF_MO, 
	MONTHNAME = DATENAME(MONTH, CAST(XPIF_YR AS VARCHAR(4)) +  '-' + CAST(XPIF_MO AS VARCHAR(2)) + '-01'),
	YEARMONTH = CAST(XPIF_YR AS VARCHAR(4)) + (CASE WHEN LEN(XPIF_MO) = 1 THEN '0' ELSE '' END) + CAST(XPIF_MO AS VARCHAR(2)), 
	FISCALYEAR = (CASE WHEN XPIF_MO < 4 THEN 'Q1' WHEN XPIF_MO < 7 THEN 'Q2' WHEN XPIF_MO < 10 THEN 'Q3' ELSE 'Q4' END),
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, XPIF_TOT_AMT,
	@UserName, GETDATE(), @UserName, GETDATE()
	FROM XTRCT_POL_IN_FRC
	WHERE XPIF_YR >= @RPT_PREV_YEAR

	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50600, 11, 'FACT_DTL_FIN_MGT_RPT table: insert statement from XTRCT_POL_IN_FRC PIF data did not succeed'
		return 50600
	  END

    exec @ret = OthInsUserMessage
                @SessionId, 
                @FunctionName = @FunctionName, 
                @Task_Name = 'Insert Statement: FACT_DTL_FIN_MGT_RPT <-- From XTRCT_POL_IN_FRC PIF data',
                @Status = 'Complete',
				@UserName = @UserName

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing insert FACT_DTL_FIN_MGT_RPT from XTRCT_POL_IN_FRC PIF data table complete statement'
		return 50200
	  END
--PIF DATA INSERT STATEMENT END HERE--
  END

set nocount off

RETURN 0

GO

-- 
--------------------------------------------------------------------------------------------------------------------------------------------
-- Drop Procedure
--------------------------------------------------------------------------------------------------------------------------------------------
if exists (select * from sys.sysobjects where id = object_id(N'[dbo].[RtGetCycleNumber]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[RtGetCycleNumber]
GO

CREATE PROCEDURE RtGetCycleNumber
(	@SessionId				[udtInteger],
	@FunctionName			[udtName],
	@CMCN_PK_ID				[udtInteger] = 1,
	@CMCN_AT_FTCurrent		[udtInteger] = 0 output,
	@CMCN_AT_WPCurrent		[udtInteger] = 0 output,
	@CMCN_AT_FTYrPrior		[udtInteger] = 0 output,
	@CMCN_AT_WPYrPrior		[udtInteger] = 0 output,
	@CMCN_AT_FTLatestYrEnd	[udtInteger] = 0 output,
	@CMCN_AT_WPLatestYrEnd	[udtInteger] = 0 output,
	@LastUser				[udtUserName] = null output,
	@LastDateTime			[udtDateTime] = null output,
	@CreateUser				[udtUserName] = null output,
	@CreateDateTime			[udtDateTime] = null  output
)
AS
--------------------------------------------------------------------------------------------------------------------------------------------
-- OBJECT NAME:    RtGetCycleNumber
--------------------------------------------------------------------------------------------------------------------------------------------
-- AUTHOR:		   Vijaya Kumar Gulappa
--------------------------------------------------------------------------------------------------------------------------------------------
-- CREATED:		   May-10-2007
--------------------------------------------------------------------------------------------------------------------------------------------
-- DESCRIPTION:    Get First Trenton & Written Production Cycle Number
--------------------------------------------------------------------------------------------------------------------------------------------
-- PARAMETERS:     <To be inserted>
--------------------------------------------------------------------------------------------------------------------------------------------
-- RETURNS:        0                -  success
--                 <To be inserted>
--                 returns from SQL Server
--------------------------------------------------------------------------------------------------------------------------------------------

-- VERSION: $Revision: 4 $  UPDATED: $Modtime: 8/01/07 3:46p $
--------------------------------------------------------------------------------------------------------------------------------------------


declare	@ret		int

set nocount on
Set @FunctionName = OBJECT_NAME(@@PROCID)

SELECT	@CMCN_AT_FTCurrent = CMCN_TNJ_CURR, @CMCN_AT_WPCurrent = CMCN_WRT_PRM_CURR, 
		@CMCN_AT_FTYrPrior = CMCN_TNJ_YR_PRR, @CMCN_AT_WPYrPrior = CMCN_WRT_PRM_YR_PRR,
		@CMCN_AT_FTLatestYrEnd = CMCN_TNJ_LT_YR_END, @CMCN_AT_WPLatestYrEnd = CMCN_WRT_PRM_LT_YR_END,
		@LastUser = CMCN_LST_USER, @LastDateTIme = CMCN_LST_DT_TM, 
		@CreateUser = CMCN_CREAT_USER, @CreateDateTime = CMCN_CREAT_DT_TM
FROM	CNFG_MSTR_CYC_NBR
where	CMCN_PK_ID = @CMCN_PK_ID

IF  @@error != 0 
  BEGIN 
    exec OthInsErrorMessage @SessionId, @FunctionName, 50303, 11, 'Get Cycle Number failed'
	return 50303
  END

set nocount off

return 0

GO
--------------------------------------------------------------------------------------------------------------------------------------------
-- Drop Procedure
--------------------------------------------------------------------------------------------------------------------------------------------
if exists (select * from sys.sysobjects where id = object_id(N'[dbo].[RtInsCombineTrentonAndFindb]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[RtInsCombineTrentonAndFindb]
GO

--------------------------------------------------------------------------------------------------------------------------------------------
-- Create procedure
--------------------------------------------------------------------------------------------------------------------------------------------
CREATE PROCEDURE RtInsCombineTrentonAndFindb
(	@SessionId		[udtNumber],
	@FunctionName	[udtName],
	@UserName	udtName
)
AS 
--------------------------------------------------------------------------------------------------------------------------------------------
-- OBJECT NAME:    RtInsCombineTrentonAndFindb
--------------------------------------------------------------------------------------------------------------------------------------------
-- AUTHOR:         Vijaya Kumar Gulappa
--------------------------------------------------------------------------------------------------------------------------------------------
-- CREATED:        May-10-2007
--------------------------------------------------------------------------------------------------------------------------------------------
-- DESCRIPTION:    Combine First Trenton Current And Findb data into FACT_DTL_FIN_MGT_RPT table.
--------------------------------------------------------------------------------------------------------------------------------------------
-- PARAMETERS:
--------------------------------------------------------------------------------------------------------------------------------------------
-- RETURNS:        0  -  success
--                 returns from SQL Server
--------------------------------------------------------------------------------------------------------------------------------------------

-- VERSION: $Revision: 21 $  UPDATED: $Modtime: 8/08/07 2:23p $
--------------------------------------------------------------------------------------------------------------------------------------------

declare	@ret int,
		@Value	udtName
set nocount on
Set @FunctionName = OBJECT_NAME(@@PROCID)
SET @ret = 0

  BEGIN

	Exec @ret = ConGetSystemPreferenceValue	@FunctionName = @FunctionName,
									@Code = 'RSY',
									@Value = @Value Output

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 51503, 11, 'Get Session Information: Exec UsrGetSessionInfo failed'
		return 51503
	  END

	TRUNCATE TABLE [dbo].FACT_DTL_FIN_MGT_RPT 
	
	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50603, 11, 'FACT_DTL_FIN_MGT_RPT table: truncation did not succeed'
		return 50603
	  END

    exec @ret = OthInsUserMessage
                @SessionId, 
                @FunctionName = @FunctionName, 
                @Task_Name = 'Truncate Table: FACT_DTL_FIN_MGT_RPT',
                @Status = 'Complete',
				@UserName = @UserName

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing truncate FACT_DTL_FIN_MGT_RPT table complete statement'
		return 50200
	  END

	INSERT INTO [dbo].FACT_DTL_FIN_MGT_RPT
	( 
	FDFMR_SRC_NM, FDFMR_BPM_LN_OF_BUS, FDFMR_BPM_SEG_NM, FDFMR_BPM_PRDCT_NM, FDFMR_RT_PLN_GRP_NM, FDFMR_TRM, FDFMR_CHNL_GRP_NM, 
	FDFMR_CHNL_NM, FDFMR_SUB_CHNL, FDFMR_PM_RGN_NM, FDFMR_STRG, FDFMR_ST_NM, FDFMR_ST_CD,
	FDFMR_SPC, FDFMR_EFF_YR, FDFMR_EFF_MO, FDFMR_MO_NM, FDFMR_EFF_YR_MO, FDFMR_FISC_YR, 
	FDFMR_ARB_ULT_POL_CNT, FDFMR_ARB_POL_CNT, FDFMR_ARB_POL_CNT_FST_ON, FDFMR_ARB_POL_CNT_SEC_ON, FDFMR_ARB_POL_CNT_FST_OFF, 
	FDFMR_ARB_ULT_POL_CNT_SEC_OFF, FDFMR_ARB_FC_CO, FDFMR_ARB_FC_AGT_NP_FST_ON, FDFMR_ARB_FC_AGT_NP_SEC_ON, FDFMR_ARB_FC_AGT_NP_ON, 
	FDFMR_ARB_FC_AGT_NP_FST_OFF, FDFMR_ARB_FC_AGT_NP_SEC_OFF, FDFMR_ARB_FC_AGT_NP_OFF, FDFMR_ARB_ULT_FC_AGT_NP, FDFMR_ARB_MT, FDFMR_ARB_ULT_MT, FDFMR_ARB_RET,
	FDFMR_ARB_ULT_RET, FDFMR_ORA_POL_CNT, FDFMR_ORA_POL_CNT_FST_ON, FDFMR_ORA_POL_CNT_SEC_ON, FDFMR_ORA_POL_CNT_FST_OFF,
	FDFMR_ORA_POL_CNT_SEC_OFF, FDFMR_ORA_FC_CO, FDFMR_ORA_FC_AGT_NP_FST_ON, FDFMR_ORA_FC_AGT_NP_SEC_ON, FDFMR_ORA_FC_AGT_NP_ON,
	FDFMR_ORA_FC_AGT_NP_FST_OFF, FDFMR_ORA_FC_AGT_NP_SEC_OFF, FDFMR_ORA_FC_AGT_NP_OFF, FDFMR_ORA_ULT_FC_AGT_NP, FDFMR_ORA_MT, FDFMR_ORA_ULT_MT,
	FDFMR_ORA_REW, FDFMR_ORA_ULT_REW, FDFMR_ORA_RET, FDFMR_ORA_ULT_RET, FDFMR_BNB_POL_CNT, FDFMR_BNB_POL_CNT_FST_ON, FDFMR_BNB_POL_CNT_SEC_ON,
	FDFMR_BNB_POL_CNT_FST_OFF, FDFMR_BNB_POL_CNT_SEC_OFF, FDFMR_BNB_ULT_POL_CNT, FDFMR_BNB_FC_CO, FDFMR_BNB_FC_AGT_NP_FST_ON, FDFMR_BNB_FC_AGT_NP_SEC_ON, 
	FDFMR_BNB_FC_AGT_NP_ON, FDFMR_BNB_FC_AGT_NP_FST_OFF, FDFMR_BNB_FC_AGT_NP_SEC_OFF, FDFMR_BNB_FC_AGT_NP_OFF, FDFMR_BNB_ULT_FC_AGT_NP, FDFMR_BNB_MT,
	FDFMR_BNB_ULT_MT, FDFMR_BNB_REW, FDFMR_BNB_ULT_REW, FDFMR_BNB_RET, FDFMR_BNB_ULT_RET, FDFMR_NB_CHG_EFF_DT,
	FDFMR_RRA_POL_CNT, FDFMR_RRA_POL_CNT_FST_ON, FDFMR_RRA_POL_CNT_SEC_ON, FDFMR_RRA_POL_CNT_FST_OFF, FDFMR_RRA_POL_CNT_SEC_OFF,
	FDFMR_RRA_FC_CO, FDFMR_RRA_FC_AGT_NP_FST_ON, FDFMR_RRA_FC_AGT_NP_SEC_ON, FDFMR_RRA_FC_AGT_NP_ON, FDFMR_RRA_FC_AGT_NP_FST_OFF, FDFMR_RRA_FC_AGT_NP_SEC_OFF,
	FDFMR_RRA_FC_AGT_NP_OFF, FDFMR_RRA_ULT_FC_AGT_NP, FDFMR_RRA_MT, FDFMR_RRA_ULT_MT, FDFMR_RRA_REW, FDFMR_RRA_ULT_REW,
	FDFMR_RRA_RET, FDFMR_RRA_ULT_RET, FDFMR_RPC_AMT_FST_ON, FDFMR_BAS_WRT_PRM_FST_ON, FDFMR_RPC_RT_AMT_FST_ON, FDFMR_RPC_AIL_AMT_FST_ON, FDFMR_RPC_EXPOS_AMT_FST_ON,
	FDFMR_RPC_AMT, FDFMR_BAS_WRT_PRM, FDFMR_RPC_RT_AMT, FDFMR_RPC_AIL_AMT, FDFMR_RPC_EXPOS_AMT, FDFMR_ANNL_WRT_PRM_AMT_RB,
	FDFMR_ANNL_WRT_PRM_AMT_BNB, FDFMR_ORG_WRT_PRM_AMT, FDFMR_ACQN_WRT_PRM_AMT, FDFMR_COMB_WRT_PRM_AMT, FDFMR_PRR_IN_FRC_AMT, FDFMR_YR_END_IN_FRC_AMT,
	FDFMR_CURR_IN_FRC_AMT, FDFMR_CTL_LS_AMT, FDFMR_EARN_PRM_AMT, FDFMR_PIF_AMT,
	FDFMR_LST_USER, FDFMR_LST_DT_TM, FDFMR_CREAT_USER, FDFMR_CREAT_DT_TM
	)
	SELECT 
	'FIRST TRENTON', STD_BPM_LN_OF_BUS, STD_BPM_SEG_NM, STD_BPM_PRDCT_NM, 'Legacy', STD_CURR_TRM, 
	CASE WHEN STD_CHNL_GRP_NM = 'Affinity' THEN 'Affinity' ELSE 'Traditional Distribution' END AS STD_CHNL_GRP_NM, 
	STD_CHNL_NM, 'First Trenton', STD_PM_RGN_NM, STD_STRG, STD_ST_NM, STD_ST_CD, '', STD_EFF_YR, STD_EFF_MO, 
	DATENAME(MONTH, CAST(STD_EFF_YR AS VARCHAR(4)) +  '-' + CAST(STD_EFF_MO AS VARCHAR(2)) + '-01'),
	STD_EFF_YR_MO, STD_FISC_YR, 
	Sum(STD_ARB_POL_CNT), Sum(STD_ARB_POL_CNT), Sum(STD_ARB_POL_CNT_FST_ON), Sum(STD_ARB_POL_CNT_SEC_ON), 
	Sum(STD_ARB_POL_CNT_FST_OFF), Sum(STD_ARB_ULT_POL_CNT_SEC_OFF), Sum(STD_ARB_FC_CO), Sum(STD_ARB_FC_AGT_NP_FST_ON), 
	Sum(STD_ARB_FC_AGT_NP_SEC_ON), Sum(STD_ARB_FC_AGT_NP_ON), Sum(STD_ARB_FC_AGT_NP_FST_OFF), Sum(STD_ARB_FC_AGT_NP_SEC_OFF), 
	Sum(STD_ARB_FC_AGT_NP_OFF), Sum(STD_ARB_ULT_FC_AGT_NP), Sum(STD_ARB_MT), Sum(STD_ARB_ULT_MT), Sum(STD_ARB_RET), 
	Sum(STD_ARB_ULT_RET), Sum(STD_NPH_BAS), Sum(STD_ORA_POL_CNT_FST_ON), Sum(STD_ORA_POL_CNT_SEC_ON), 
	Sum(STD_ORA_POL_CNT_FST_OFF), Sum(STD_ORA_POL_CNT_SEC_OFF), Sum(STD_ORA_FC_CO), Sum(STD_ORA_FC_AGT_NP_FST_ON), 
	Sum(STD_ORA_FC_AGT_NP_SEC_ON), Sum(STD_ORA_FC_AGT_NP_ON), Sum(STD_ORA_FC_AGT_NP_FST_OFF), Sum(STD_ORA_FC_AGT_NP_SEC_OFF), 
	Sum(STD_ORA_FC_AGT_NP_OFF), Sum(STD_ORA_ULT_FC_AGT_NP), Sum(STD_ORA_MT),  Sum(STD_ORA_ULT_MT), 
	Sum(STD_ORA_REW), Sum(STD_ORA_ULT_REW), Sum(STD_ORA_RET), Sum(STD_ORA_ULT_RET), Sum(STD_BNB_POL_CNT), 
	Sum(STD_BNB_POL_CNT_FST_ON), Sum(STD_BNB_POL_CNT_SEC_ON), Sum(STD_BNB_POL_CNT_FST_OFF), Sum(STD_BNB_POL_CNT_SEC_OFF), Sum(STD_BNB_ULT_POL_CNT), 
	Sum(STD_BNB_FC_CO), Sum(STD_BNB_FC_AGT_NP_FST_ON), Sum(STD_BNB_FC_AGT_NP_SEC_ON), Sum(STD_BNB_FC_AGT_NP_ON), Sum(STD_BNB_FC_AGT_NP_FST_OFF), 
	Sum(STD_BNB_FC_AGT_NP_SEC_OFF), Sum(STD_BNB_FC_AGT_NP_OFF), Sum(STD_BNB_ULT_FC_AGT_NP), Sum(STD_BNB_MT), Sum(STD_BNB_ULT_MT), 
	Sum(STD_BNB_REW), Sum(STD_BNB_ULT_REW), Sum(STD_BNB_RET),  Sum(STD_BNB_ULT_RET), Sum(STD_BNB_CH_EFF_DT), 
	Sum(STD_RRA_POL_CNT), Sum(STD_RRA_POL_CNT_FST_ON), Sum(STD_RRA_POL_CNT_SEC_ON), Sum(STD_RRA_POL_CNT_FST_OFF), 
	Sum(STD_RRA_POL_CNT_SEC_OFF), Sum(STD_RRA_FC_CO), Sum(STD_RRA_FC_AGT_NP_FST_ON), Sum(STD_RRA_FC_AGT_NP_SEC_ON), Sum(STD_RRA_FC_AGT_NP_ON), 
	Sum(STD_RRA_FC_AGT_NP_FST_OFF), Sum(STD_RRA_FC_AGT_NP_SEC_OFF), Sum(STD_RRA_FC_AGT_NP_OFF), Sum(STD_RRA_ULT_FC_AGT_NP), Sum(STD_RRA_MT), 
	Sum(STD_RRA_ULT_MT), Sum(STD_RRA_REW), Sum(STD_RRA_ULT_REW), Sum(STD_RRA_RET), Sum(STD_RRA_ULT_RET), 
	Sum(STD_RPC_FST_ON), Sum(STD_RET_FST_ON), Sum(STD_RPC_RT_FST_ON), Sum(STD_RPC_AIL_FST_ON), Sum(STD_RPC_EXPOS_FST_ON), 
	Sum(STD_RPC), Sum(STD_RET), Sum(STD_RPC_RT), Sum(STD_RPC_AIL), Sum(STD_RPC_EXPOS), 
	Sum(STD_ANNL_WRT_PRM_RB), Sum(STD_ANNL_WRT_PRM_BNB), Sum(STD_ORG_WRT_PRM), Sum(STD_ACQN_WRT_PRM), Sum(STD_COMB_WRT_PRM), 
	Sum(STD_PRR_IN_FRC), Sum(STD_YR_END_IN_FRC), 0, 0, 0, 0, @UserName, getdate(), @UserName, getdate()
	FROM STG_TNJ_DATA
	GROUP BY 
	STD_BPM_LN_OF_BUS, STD_BPM_SEG_NM, STD_BPM_PRDCT_NM,
	CASE WHEN STD_CHNL_GRP_NM = 'Affinity' THEN 'Affinity' ELSE 'Traditional Distribution' END, 
	STD_CHNL_NM, STD_CURR_TRM, STD_ST_NM, STD_ST_CD, 
	STD_PM_RGN_NM, STD_STRG, STD_EFF_YR, STD_EFF_MO, STD_EFF_YR_MO, STD_FISC_YR
	HAVING 
	[STD_EFF_YR] > @Value;

	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50600, 11, 'FACT_DTL_FIN_MGT_RPT table: insert statement from first trenton data did not succeed'
		return 50600
	  END

    exec @ret = OthInsUserMessage
                @SessionId, 
                @FunctionName = @FunctionName, 
                @Task_Name = 'Insert Statement: FACT_DTL_FIN_MGT_RPT <-- From First Trenton Data',
                @Status = 'Complete',
				@UserName = @UserName

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing insert FACT_DTL_FIN_MGT_RPT from first trenton data table complete statement'
		return 50200
	  END

	INSERT INTO [dbo].FACT_DTL_FIN_MGT_RPT
	( 
	FDFMR_SRC_NM, FDFMR_BPM_LN_OF_BUS, FDFMR_BPM_SEG_NM, FDFMR_BPM_PRDCT_NM, FDFMR_RT_PLN_GRP_NM, FDFMR_TRM, FDFMR_CHNL_GRP_NM, 
	FDFMR_CHNL_NM, FDFMR_SUB_CHNL, FDFMR_PM_RGN_NM, FDFMR_STRG, FDFMR_ST_NM, FDFMR_ST_CD,
	FDFMR_SPC, FDFMR_EFF_YR, FDFMR_EFF_MO, FDFMR_MO_NM, FDFMR_EFF_YR_MO, FDFMR_FISC_YR, 
	FDFMR_ARB_ULT_POL_CNT, FDFMR_ARB_POL_CNT, FDFMR_ARB_POL_CNT_FST_ON, FDFMR_ARB_POL_CNT_SEC_ON, FDFMR_ARB_POL_CNT_FST_OFF, 
	FDFMR_ARB_ULT_POL_CNT_SEC_OFF, FDFMR_ARB_FC_CO, FDFMR_ARB_FC_AGT_NP_FST_ON, FDFMR_ARB_FC_AGT_NP_SEC_ON, FDFMR_ARB_FC_AGT_NP_ON, 
	FDFMR_ARB_FC_AGT_NP_FST_OFF, FDFMR_ARB_FC_AGT_NP_SEC_OFF, FDFMR_ARB_FC_AGT_NP_OFF, FDFMR_ARB_ULT_FC_AGT_NP, FDFMR_ARB_MT, FDFMR_ARB_ULT_MT, FDFMR_ARB_RET,
	FDFMR_ARB_ULT_RET, FDFMR_ORA_POL_CNT, FDFMR_ORA_POL_CNT_FST_ON, FDFMR_ORA_POL_CNT_SEC_ON, FDFMR_ORA_POL_CNT_FST_OFF,
	FDFMR_ORA_POL_CNT_SEC_OFF, FDFMR_ORA_FC_CO, FDFMR_ORA_FC_AGT_NP_FST_ON, FDFMR_ORA_FC_AGT_NP_SEC_ON, FDFMR_ORA_FC_AGT_NP_ON,
	FDFMR_ORA_FC_AGT_NP_FST_OFF, FDFMR_ORA_FC_AGT_NP_SEC_OFF, FDFMR_ORA_FC_AGT_NP_OFF, FDFMR_ORA_ULT_FC_AGT_NP, FDFMR_ORA_MT, FDFMR_ORA_ULT_MT,
	FDFMR_ORA_REW, FDFMR_ORA_ULT_REW, FDFMR_ORA_RET, FDFMR_ORA_ULT_RET, FDFMR_BNB_POL_CNT, FDFMR_BNB_POL_CNT_FST_ON, FDFMR_BNB_POL_CNT_SEC_ON,
	FDFMR_BNB_POL_CNT_FST_OFF, FDFMR_BNB_POL_CNT_SEC_OFF, FDFMR_BNB_ULT_POL_CNT, FDFMR_BNB_FC_CO, FDFMR_BNB_FC_AGT_NP_FST_ON, FDFMR_BNB_FC_AGT_NP_SEC_ON, 
	FDFMR_BNB_FC_AGT_NP_ON, FDFMR_BNB_FC_AGT_NP_FST_OFF, FDFMR_BNB_FC_AGT_NP_SEC_OFF, FDFMR_BNB_FC_AGT_NP_OFF, FDFMR_BNB_ULT_FC_AGT_NP, FDFMR_BNB_MT,
	FDFMR_BNB_ULT_MT, FDFMR_BNB_REW, FDFMR_BNB_ULT_REW, FDFMR_BNB_RET, FDFMR_BNB_ULT_RET, FDFMR_NB_CHG_EFF_DT,
	FDFMR_RRA_POL_CNT, FDFMR_RRA_POL_CNT_FST_ON, FDFMR_RRA_POL_CNT_SEC_ON, FDFMR_RRA_POL_CNT_FST_OFF, FDFMR_RRA_POL_CNT_SEC_OFF,
	FDFMR_RRA_FC_CO, FDFMR_RRA_FC_AGT_NP_FST_ON, FDFMR_RRA_FC_AGT_NP_SEC_ON, FDFMR_RRA_FC_AGT_NP_ON, FDFMR_RRA_FC_AGT_NP_FST_OFF, FDFMR_RRA_FC_AGT_NP_SEC_OFF,
	FDFMR_RRA_FC_AGT_NP_OFF, FDFMR_RRA_ULT_FC_AGT_NP, FDFMR_RRA_MT, FDFMR_RRA_ULT_MT, FDFMR_RRA_REW, FDFMR_RRA_ULT_REW,
	FDFMR_RRA_RET, FDFMR_RRA_ULT_RET, FDFMR_RPC_AMT_FST_ON, FDFMR_BAS_WRT_PRM_FST_ON, FDFMR_RPC_RT_AMT_FST_ON, FDFMR_RPC_AIL_AMT_FST_ON, FDFMR_RPC_EXPOS_AMT_FST_ON,
	FDFMR_RPC_AMT, FDFMR_BAS_WRT_PRM, FDFMR_RPC_RT_AMT, FDFMR_RPC_AIL_AMT, FDFMR_RPC_EXPOS_AMT, FDFMR_ANNL_WRT_PRM_AMT_RB,
	FDFMR_ANNL_WRT_PRM_AMT_BNB, FDFMR_ORG_WRT_PRM_AMT, FDFMR_ACQN_WRT_PRM_AMT, FDFMR_COMB_WRT_PRM_AMT, FDFMR_PRR_IN_FRC_AMT, FDFMR_YR_END_IN_FRC_AMT,
	FDFMR_CURR_IN_FRC_AMT, FDFMR_CTL_LS_AMT, FDFMR_EARN_PRM_AMT, FDFMR_PIF_AMT,
	FDFMR_LST_USER, FDFMR_LST_DT_TM, FDFMR_CREAT_USER, FDFMR_CREAT_DT_TM
	)
	SELECT 
	'FINDB', SWPMR_BPM_LN_OF_BUS, SWPMR_BPM_SEG_NM, SWPMR_BPM_PRDCT_NM, SWPMR_RT_PLN_GRP_NM, SWPMR_TRM, SWPMR_CHNL_GRP_NM, 
	SWPMR_CHNL_NM, (CASE WHEN SWPMR_CHNL_NM = 'Agent Sold' THEN 'Agent' ELSE SWPMR_SUB_CHNL END),	
	SWPMR_PM_RGN_NM, SWPMR_STRG, SWPMR_ST_NM, SWPMR_ST_CD, SWPMR_SPC, SWPMR_EFF_YR, SWPMR_EFF_MO, 
	DATENAME(MONTH, CAST(SWPMR_EFF_YR AS VARCHAR(4)) +  '-' + CAST(SWPMR_EFF_MO AS VARCHAR(2)) + '-01'),
	SWPMR_EFF_YR_MO, SWPMR_FISC_YR, 
	Sum(SWPMR_ARB_ULT_POL_CNT), Sum(SWPMR_ARB_POL_CNT), Sum(SWPMR_ARB_POL_CNT_FST_ON), Sum(SWPMR_ARB_POL_CNT_SEC_ON), 
	Sum(SWPMR_ARB_POL_CNT_FST_OFF), Sum(SWPMR_ARB_ULT_POL_CNT_SEC_OFF), Sum(SWPMR_ARB_FC_CO), Sum(SWPMR_ARB_FC_AGT_NP_FST_ON), 
	Sum(SWPMR_ARB_FC_AGT_NP_SEC_ON), Sum(SWPMR_ARB_FC_AGT_NP_ON), Sum(SWPMR_ARB_FC_AGT_NP_FST_OFF), Sum(SWPMR_ARB_FC_AGT_NP_SEC_OFF), 
	Sum(SWPMR_ARB_FC_AGT_NP_OFF), Sum(SWPMR_ARB_ULT_FC_AGT_NP), Sum(SWPMR_ARB_MT), Sum(SWPMR_ARB_ULT_MT), Sum(SWPMR_ARB_RET), 
	Sum(SWPMR_ARB_ULT_RET), Sum(SWPMR_ORA_POL_CNT), Sum(SWPMR_ORA_POL_CNT_FST_ON), Sum(SWPMR_ORA_POL_CNT_SEC_ON), 
	Sum(SWPMR_ORA_POL_CNT_FST_OFF), Sum(SWPMR_ORA_POL_CNT_SEC_OFF), Sum(SWPMR_ORA_FC_CO), Sum(SWPMR_ORA_FC_AGT_NP_FST_ON), 
	Sum(SWPMR_ORA_FC_AGT_NP_SEC_ON), Sum(SWPMR_ORA_FC_AGT_NP_ON), Sum(SWPMR_ORA_FC_AGT_NP_FST_OFF), Sum(SWPMR_ORA_FC_AGT_NP_SEC_OFF), 
	Sum(SWPMR_ORA_FC_AGT_NP_OFF), Sum(SWPMR_ORA_ULT_FC_AGT_NP), Sum(SWPMR_ORA_MT), Sum(SWPMR_ORA_ULT_MT), Sum(SWPMR_ORA_REW), 
	Sum(SWPMR_ORA_ULT_REW), Sum(SWPMR_ORA_RET), Sum(SWPMR_ORA_ULT_RET), Sum(SWPMR_BNB_POL_CNT), Sum(SWPMR_BNB_POL_CNT_FST_ON), 
	Sum(SWPMR_BNB_POL_CNT_SEC_ON), Sum(SWPMR_BNB_POL_CNT_FST_OFF), Sum(SWPMR_BNB_POL_CNT_SEC_OFF), Sum(SWPMR_BNB_ULT_POL_CNT), 
	Sum(SWPMR_BNB_FC_CO), Sum(SWPMR_BNB_FC_AGT_NP_FST_ON), Sum(SWPMR_BNB_FC_AGT_NP_SEC_ON), Sum(SWPMR_BNB_FC_AGT_NP_ON), 
	Sum(SWPMR_BNB_FC_AGT_NP_FST_OFF), Sum(SWPMR_BNB_FC_AGT_NP_SEC_OFF), Sum(SWPMR_BNB_FC_AGT_NP_OFF), Sum(SWPMR_BNB_ULT_FC_AGT_NP), 
	Sum(SWPMR_BNB_MT), Sum(SWPMR_BNB_ULT_MT), Sum(SWPMR_BNB_REW), Sum(SWPMR_BNB_ULT_REW), Sum(SWPMR_BNB_RET), Sum(SWPMR_BNB_ULT_RET), 
	0, Sum(SWPMR_RRA_POL_CNT), Sum(SWPMR_RRA_POL_CNT_FST_ON), Sum(SWPMR_RRA_POL_CNT_SEC_ON), Sum(SWPMR_RRA_POL_CNT_FST_OFF), 
	Sum(SWPMR_RRA_POL_CNT_SEC_OFF), Sum(SWPMR_RRA_FC_CO), Sum(SWPMR_RRA_FC_AGT_NP_FST_ON), Sum(SWPMR_RRA_FC_AGT_NP_SEC_ON), 
	Sum(SWPMR_RRA_FC_AGT_NP_ON), Sum(SWPMR_RRA_FC_AGT_NP_FST_OFF), Sum(SWPMR_RRA_FC_AGT_NP_SEC_OFF), Sum(SWPMR_RRA_FC_AGT_NP_OFF), 
	Sum(SWPMR_RRA_ULT_FC_AGT_NP), Sum(SWPMR_RRA_MT), Sum(SWPMR_RRA_ULT_MT), Sum(SWPMR_RRA_REW), Sum(SWPMR_RRA_ULT_REW), 
	Sum(SWPMR_RRA_RET), Sum(SWPMR_RRA_ULT_RET), Sum(SWPMR_RPC_AMT_FST_ON), Sum(SWPMR_BAS_WRT_PRM_FST_ON), 
	Sum(SWPMR_RPC_RT_AMT_FST_ON), Sum(SWPMR_RPC_AIL_AMT_FST_ON), Sum(SWPMR_RPC_EXPOS_AMT_FST_ON), Sum(SWPMR_RPC_AMT), 
	Sum(SWPMR_BAS_WRT_PRM), Sum(SWPMR_RPC_RT_AMT), Sum(SWPMR_RPC_AIL_AMT), Sum(SWPMR_RPC_EXPOS_AMT), 
	Sum(SWPMR_ANNL_WRT_PRM_AMT_RB), Sum(SWPMR_ANNL_WRT_PRM_AMT_BNB), Sum(SWPMR_ORG_WRT_PRM_AMT), Sum(SWPMR_ACQN_WRT_PRM_AMT), 
	Sum(SWPMR_COMB_WRT_PRM_AMT), Sum(SWPMR_PRR_IN_FRC_AMT), Sum(SWPMR_YR_END_IN_FRC_AMT), Sum(SWPMR_CURR_IN_FRC_AMT), 0, 0, 0,
	@UserName, getdate(), @UserName, getdate()
	FROM STG_WRT_PRDCT_MO_RPT
	GROUP BY
	SWPMR_BPM_LN_OF_BUS, SWPMR_BPM_SEG_NM, SWPMR_BPM_PRDCT_NM, SWPMR_RT_PLN_GRP_NM, SWPMR_TRM, SWPMR_CHNL_GRP_NM, 
	SWPMR_CHNL_NM, (CASE WHEN SWPMR_CHNL_NM = 'Agent Sold' THEN 'Agent' ELSE SWPMR_SUB_CHNL END),	
	SWPMR_PM_RGN_NM, SWPMR_STRG, SWPMR_ST_NM, SWPMR_ST_CD, SWPMR_SPC, SWPMR_EFF_YR, SWPMR_EFF_MO, 
	SWPMR_EFF_YR_MO, SWPMR_FISC_YR
	HAVING 
	SWPMR_EFF_YR > @Value;	

	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50600, 11, 'FACT_DTL_FIN_MGT_RPT table: insert statement from written production data did not succeed'
		return 50600
	  END

    exec @ret = OthInsUserMessage
                @SessionId, 
                @FunctionName = @FunctionName, 
                @Task_Name = 'Insert Statement: FACT_DTL_FIN_MGT_RPT <-- From Retention Data',
                @Status = 'Complete',
				@UserName = @UserName 

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing insert FACT_DTL_FIN_MGT_RPT from retention data table complete statement'
		return 50200
	  END

	UPDATE FACT_DTL_FIN_MGT_RPT SET FDFMR_BPM_PRDCT_NM = 'Tenant' WHERE FDFMR_BPM_PRDCT_NM = 'Tenants' 
	
	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50601, 11, 'FACT_DTL_FIN_MGT_RPT table: Replace Tenants with Tenant update statement did not succeed'
		return 50601
	  END

	UPDATE FACT_DTL_FIN_MGT_RPT SET FDFMR_BPM_PRDCT_NM = 'Homesaver' WHERE FDFMR_BPM_PRDCT_NM = 'Homesavers' 
	
	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50601, 11, 'FACT_DTL_FIN_MGT_RPT table: Replace Homesavers with Homesaver update statement did not succeed'
		return 50601
	  END
	
	
  END

set nocount off

RETURN 0

GO
--------------------------------------------------------------------------------------------------------------------------------------------
-- Drop Procedure
--------------------------------------------------------------------------------------------------------------------------------------------
if exists (select * from sys.sysobjects where id = object_id(N'[dbo].[RtInsFindbData]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[RtInsFindbData]
GO

--------------------------------------------------------------------------------------------------------------------------------------------
-- Create procedure
--------------------------------------------------------------------------------------------------------------------------------------------
CREATE PROCEDURE RtInsFindbData
(	@SessionId		[udtNumber],
	@FunctionName	[udtName],
	@UserName		udtName
)
AS 
--------------------------------------------------------------------------------------------------------------------------------------------
-- OBJECT NAME:    RtInsFindbData
--------------------------------------------------------------------------------------------------------------------------------------------
-- AUTHOR:         Vijaya Kumar Gulappa
--------------------------------------------------------------------------------------------------------------------------------------------
-- CREATED:        May-10-2007
--------------------------------------------------------------------------------------------------------------------------------------------
-- DESCRIPTION:    Insert Summary Written Production data to the Retention Data table.
--------------------------------------------------------------------------------------------------------------------------------------------
-- PARAMETERS:
--------------------------------------------------------------------------------------------------------------------------------------------
-- RETURNS:        0  -  success
--                 returns from SQL Server
--------------------------------------------------------------------------------------------------------------------------------------------

-- VERSION: $Revision: 21 $  UPDATED: $Modtime: 8/08/07 2:25p $
--------------------------------------------------------------------------------------------------------------------------------------------

declare	@ret int

DECLARE 
@CMCN_AT_WPCurrent udtInteger, 
@CMCN_AT_WPYrPrior udtInteger,  
@CMCN_AT_WPLatestYrEnd udtInteger,
@YearMonth	udtEffYrMon

set nocount on
Set @FunctionName = OBJECT_NAME(@@PROCID)
SET @YearMonth = CAST(DATEPART (YYYY, GETDATE()) AS VARCHAR(4)) + (CASE WHEN LEN(DATEPART(M, GETDATE())) = 1 THEN '0' ELSE '' END) + CAST(DATEPART(M, GETDATE()) AS VARCHAR(2))
SET @ret = 0
--@UserName should be replace with username/session id parameter
  BEGIN

	Exec @ret = RtGetCycleNumber	
		@SessionId = @SessionId,
		@FunctionName = @FunctionName,
		@CMCN_PK_ID = 1,
		@CMCN_AT_WPCurrent = @CMCN_AT_WPCurrent Output,
		@CMCN_AT_WPYrPrior = @CMCN_AT_WPYrPrior Output,
		@CMCN_AT_WPLatestYrEnd = @CMCN_AT_WPLatestYrEnd Output

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50303, 11, 'select statement failed: Cycle Number'
		return 50303
	  END
      
	TRUNCATE TABLE [dbo].STG_WRT_PRDCT_MO_RPT 
	
	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50503, 11, 'Written Production Data: truncation did not succeed'
		return 50503
	  END

    exec @ret = OthInsUserMessage
                @SessionId, 
                @FunctionName = @FunctionName, 
                @Task_Name = 'Truncate Table : Written Production Data',
                @Status = 'Complete',
				@UserName = @UserName

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing truncate retention data table complete statement'
		return 50200
	  END

	INSERT INTO [dbo].STG_WRT_PRDCT_MO_RPT
	(
		SWPMR_BPM_LN_OF_BUS, SWPMR_BPM_SEG_NM, SWPMR_BPM_PRDCT_NM, SWPMR_RT_PLN_GRP_NM, SWPMR_TRM, SWPMR_CHNL_GRP_NM, SWPMR_SUB_CHNL, 
		SWPMR_CHNL_NM, SWPMR_PM_RGN_NM, SWPMR_ST_CD, SWPMR_ST_NM, SWPMR_SPC, SWPMR_STRG, SWPMR_EFF_YR_MO, SWPMR_EFF_YR, SWPMR_EFF_MO, SWPMR_FISC_YR, 
		SWPMR_ARB_POL_CNT_FST_ON, SWPMR_ARB_POL_CNT_SEC_ON, SWPMR_ARB_POL_CNT_FST_OFF, SWPMR_ARB_ULT_POL_CNT_SEC_OFF, 
		SWPMR_ARB_FC_CO_FST_ON,SWPMR_ARB_FC_CO_SEC_ON, SWPMR_ARB_FC_CO_FST_OFF, SWPMR_ARB_FC_CO_SEC_OFF, SWPMR_ARB_FC_AGT_NP_FST_ON,
		SWPMR_ARB_FC_AGT_NP_SEC_ON, SWPMR_ARB_FC_AGT_NP_FST_OFF, SWPMR_ARB_FC_AGT_NP_SEC_OFF, SWPMR_ORA_POL_CNT_FST_ON,
		SWPMR_ORA_POL_CNT_SEC_ON, SWPMR_ORA_POL_CNT_FST_OFF, SWPMR_ORA_POL_CNT_SEC_OFF, SWPMR_ORA_FC_CO_FST_ON, 
		SWPMR_ORA_FC_CO_SEC_ON, SWPMR_ORA_FC_CO_FST_OFF, SWPMR_ORA_FC_CO_SEC_OFF, SWPMR_ORA_FC_AGT_NP_FST_ON, 
		SWPMR_ORA_FC_AGT_NP_SEC_ON, SWPMR_ORA_FC_AGT_NP_FST_OFF, SWPMR_ORA_FC_AGT_NP_SEC_OFF, SWPMR_BNB_POL_CNT_FST_ON, 
		SWPMR_BNB_POL_CNT_SEC_ON, SWPMR_BNB_POL_CNT_FST_OFF, SWPMR_BNB_POL_CNT_SEC_OFF, SWPMR_BNB_FC_CO_FST_ON, 
		SWPMR_BNB_FC_CO_SEC_ON, SWPMR_BNB_FC_CO_FST_OFF, SWPMR_BNB_FC_CO_SEC_OFF,	SWPMR_BNB_FC_AGT_NP_FST_ON, 
		SWPMR_BNB_FC_AGT_NP_SEC_ON, SWPMR_BNB_FC_AGT_NP_FST_OFF, SWPMR_BNB_FC_AGT_NP_SEC_OFF, SWPMR_RRA_POL_CNT_FST_ON, 
		SWPMR_RRA_POL_CNT_SEC_ON, SWPMR_RRA_POL_CNT_FST_OFF, SWPMR_RRA_POL_CNT_SEC_OFF, SWPMR_RRA_FC_CO_FST_ON, 
		SWPMR_RRA_FC_CO_SEC_ON, SWPMR_RRA_FC_CO_FST_OFF, SWPMR_RRA_FC_CO_SEC_OFF, SWPMR_RRA_FC_AGT_NP_FST_ON,
		SWPMR_RRA_FC_AGT_NP_SEC_ON, SWPMR_RRA_FC_AGT_NP_FST_OFF, SWPMR_RRA_FC_AGT_NP_SEC_OFF, SWPMR_BAS_WRT_PRM_FST_ON, 
		SWPMR_RPC_AMT_FST_ON,	SWPMR_RPC_RT_AMT_FST_ON, SWPMR_RPC_AIL_AMT_FST_ON, SWPMR_RPC_EXPOS_AMT_FST_ON, 
		SWPMR_ARB_ULT_POL_CNT, SWPMR_ARB_POL_CNT, SWPMR_ARB_FC_CO, SWPMR_ARB_ULT_FC_CO, SWPMR_ARB_FC_AGT_NP_ON, 
		SWPMR_ARB_FC_AGT_NP_OFF, SWPMR_ARB_ULT_FC_AGT_NP, SWPMR_ARB_MT, SWPMR_ARB_ULT_MT, SWPMR_ARB_RET, SWPMR_ARB_ULT_RET, 
		SWPMR_ORA_POL_CNT, SWPMR_ORA_ULT_POL_CNT, SWPMR_ORA_FC_CO, SWPMR_ORA_ULT_FC_CO, SWPMR_ORA_FC_AGT_NP_ON, 
		SWPMR_ORA_FC_AGT_NP_OFF, SWPMR_ORA_ULT_FC_AGT_NP, SWPMR_ORA_MT, SWPMR_ORA_ULT_MT, SWPMR_ORA_REW, SWPMR_ORA_ULT_REW, 
		SWPMR_ORA_RET, SWPMR_ORA_ULT_RET, SWPMR_BNB_POL_CNT, SWPMR_BNB_ULT_POL_CNT, SWPMR_BNB_FC_CO, SWPMR_BNB_ULT_FC_CO, 
		SWPMR_BNB_FC_AGT_NP_ON, SWPMR_BNB_FC_AGT_NP_OFF, SWPMR_BNB_ULT_FC_AGT_NP, SWPMR_BNB_MT, SWPMR_BNB_ULT_MT, SWPMR_BNB_REW, 
		SWPMR_BNB_ULT_REW, SWPMR_BNB_RET, SWPMR_BNB_ULT_RET, SWPMR_RRA_POL_CNT, SWPMR_RRA_ULT_POL_CNT, SWPMR_RRA_FC_CO, 
		SWPMR_RRA_ULT_FC_CO, SWPMR_RRA_FC_AGT_NP_ON, SWPMR_RRA_FC_AGT_NP_OFF, SWPMR_RRA_MT, SWPMR_RRA_ULT_MT, SWPMR_RRA_REW, 
		SWPMR_RRA_ULT_REW, SWPMR_RRA_RET, SWPMR_RRA_ULT_RET, SWPMR_RRA_ULT_FC_AGT_NP, SWPMR_BAS_WRT_PRM, SWPMR_RPC_AMT, 
		SWPMR_RPC_RT_AMT, SWPMR_RPC_AIL_AMT, SWPMR_RPC_EXPOS_AMT, SWPMR_ANNL_WRT_PRM_AMT_RB,  SWPMR_ANNL_WRT_PRM_AMT_BNB, 
		SWPMR_ORG_WRT_PRM_AMT, SWPMR_ACQN_WRT_PRM_AMT, SWPMR_COMB_WRT_PRM_AMT, SWPMR_CURR_IN_FRC_AMT, SWPMR_PRR_IN_FRC_AMT, 
		SWPMR_YR_END_IN_FRC_AMT, SWPMR_LST_USER, SWPMR_LST_DT_TM, SWPMR_CREAT_USER, SWPMR_CREAT_DT_TM
	)
	SELECT 
		WMR.XWPMR_BPM_LN_OF_BUS, WMR.XWPMR_BPM_SEG_NM, WMR.XWPMR_BPM_PRDCT_NM, WMR.XWPMR_RT_PLN_GRP_NM, WMR.XWPMR_TRM, 
		WMR.XWPMR_CHNL_GRP_NM, WMR.XWPMR_SUB_CHNL, 
		WMR.XWPMR_CHNL_NM, WMR.XWPMR_PM_RGN_NM, WMR.XWPMR_ST_CD, SN.CMSN_ST_NM, SN.CMSN_SPC, '' As Strategy, 
		CAST(WMR.XWPMR_EFF_YR AS VARCHAR(4)) + (CASE WHEN LEN(WMR.XWPMR_EFF_MO) = 1 THEN '0' ELSE '' END) + CAST(XWPMR_EFF_MO AS VARCHAR(2)),
		WMR.XWPMR_EFF_YR, WMR.XWPMR_EFF_MO, 
		CASE WHEN WMR.XWPMR_EFF_MO < 4 THEN 'Q1' WHEN WMR.XWPMR_EFF_MO < 7 THEN 'Q2' WHEN WMR.XWPMR_EFF_MO < 10 THEN 'Q3' ELSE 'Q4' END, 
		SUM(CASE WHEN WMR.XWPMR_AGE = 1 THEN WMR.XWPMR_ARB_POL_CNT ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 2 THEN WMR.XWPMR_ARB_POL_CNT ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 7 THEN WMR.XWPMR_ARB_POL_CNT ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 8 THEN WMR.XWPMR_ARB_ULT_POL_CNT ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 1 THEN WMR.XWPMR_ARB_FC_CO ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 2 THEN WMR.XWPMR_ARB_FC_CO ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 7 THEN WMR.XWPMR_ARB_FC_CO ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 8 THEN WMR.XWPMR_ARB_FC_CO ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 1 THEN WMR.XWPMR_ARB_FC_AGT_NP_ON ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 2 THEN WMR.XWPMR_ARB_FC_AGT_NP_ON ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 7 THEN WMR.XWPMR_ARB_FC_AGT_NP_OFF ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 8 THEN WMR.XWPMR_ARB_FC_AGT_NP_OFF ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 1 THEN WMR.XWPMR_ORA_POL_CNT ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 2 THEN WMR.XWPMR_ORA_POL_CNT ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 7 THEN WMR.XWPMR_ORA_POL_CNT ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 8 THEN WMR.XWPMR_ORA_POL_CNT ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 1 THEN WMR.XWPMR_ORA_FC_CO ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 2 THEN WMR.XWPMR_ORA_FC_CO ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 7 THEN WMR.XWPMR_ORA_FC_CO ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 8 THEN WMR.XWPMR_ORA_FC_CO ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 1 THEN WMR.XWPMR_ORA_FC_AGT_NP_ON ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 2 THEN WMR.XWPMR_ORA_FC_AGT_NP_ON ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 7 THEN WMR.XWPMR_ORA_FC_AGT_NP_OFF ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 8 THEN WMR.XWPMR_ORA_FC_AGT_NP_OFF ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 1 THEN WMR.XWPMR_BNB_POL_CNT ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 2 THEN WMR.XWPMR_BNB_POL_CNT ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 7 THEN WMR.XWPMR_BNB_POL_CNT ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 8 THEN WMR.XWPMR_BNB_POL_CNT ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 1 THEN WMR.XWPMR_BNB_FC_CO ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 2 THEN WMR.XWPMR_BNB_FC_CO ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 7 THEN WMR.XWPMR_BNB_FC_CO ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 8 THEN WMR.XWPMR_BNB_FC_CO ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 1 THEN WMR.XWPMR_BNB_FC_AGT_NP_ON ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 2 THEN WMR.XWPMR_BNB_FC_AGT_NP_ON ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 7 THEN WMR.XWPMR_BNB_FC_AGT_NP_OFF ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 8 THEN WMR.XWPMR_BNB_FC_AGT_NP_OFF ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 1 THEN WMR.XWPMR_RRA_POL_CNT ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 2 THEN WMR.XWPMR_RRA_POL_CNT ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 7 THEN WMR.XWPMR_RRA_POL_CNT ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 8 THEN WMR.XWPMR_RRA_POL_CNT ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 1 THEN WMR.XWPMR_RRA_FC_CO ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 2 THEN WMR.XWPMR_RRA_FC_CO ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 7 THEN WMR.XWPMR_RRA_FC_CO ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 8 THEN WMR.XWPMR_RRA_FC_CO ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 1 THEN WMR.XWPMR_RRA_FC_AGT_NP_ON ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 2 THEN WMR.XWPMR_RRA_FC_AGT_NP_ON ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 7 THEN WMR.XWPMR_RRA_FC_AGT_NP_OFF ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 8 THEN WMR.XWPMR_RRA_FC_AGT_NP_OFF ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 1 THEN WMR.XWPMR_BAS_WRT_PRM  ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 1 THEN WMR.XWPMR_RPC_AMT  ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 1 THEN WMR.XWPMR_RPC_RT_AMT  ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 1 THEN WMR.XWPMR_RPC_AIL_AMT  ELSE 0 END), 
		SUM(CASE WHEN WMR.XWPMR_AGE = 1 THEN WMR.XWPMR_RPC_EXPOS_AMT  ELSE 0 END),
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_ARB_ULT_POL_CNT ELSE
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_ARB_ULT_POL_CNT ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_ARB_POL_CNT ELSE
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_ARB_POL_CNT ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_ARB_FC_CO ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_ARB_FC_CO ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_ARB_ULT_FC_CO ELSE
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_ARB_ULT_FC_CO ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_ARB_FC_AGT_NP_ON ELSE
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_ARB_FC_AGT_NP_ON ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_ARB_FC_AGT_NP_OFF ELSE
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_ARB_FC_AGT_NP_OFF ELSE 0 END) END),
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_ARB_ULT_FC_AGT_NP ELSE
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_ARB_ULT_FC_AGT_NP ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_ARB_MT ELSE
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_ARB_MT ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_ARB_ULT_MT ELSE
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_ARB_ULT_MT ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_ARB_RET 
			ELSE (CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_ARB_RET ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_ARB_ULT_RET ELSE
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_ARB_ULT_RET ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_ORA_POL_CNT ELSE
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_ORA_POL_CNT ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_ORA_ULT_POL_CNT ELSE
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_ORA_ULT_POL_CNT ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_ORA_FC_CO ELSE
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_ORA_FC_CO ELSE 0 END) END),  
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_ORA_ULT_FC_CO ELSE
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_ORA_ULT_FC_CO ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_ORA_FC_AGT_NP_ON ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_ORA_FC_AGT_NP_ON ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_ORA_FC_AGT_NP_OFF ELSE
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_ORA_FC_AGT_NP_OFF ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_ORA_ULT_FC_AGT_NP ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_ORA_ULT_FC_AGT_NP ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_ORA_MT ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_ORA_MT ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_ORA_ULT_MT ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_ORA_ULT_MT ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_ORA_REW ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_ORA_REW ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_ORA_ULT_REW ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_ORA_ULT_REW ELSE 0 END)	END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_ORA_RET ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_ORA_RET ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_ORA_ULT_RET ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_ORA_ULT_RET ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_BNB_POL_CNT ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_BNB_POL_CNT ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_BNB_ULT_POL_CNT ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_BNB_ULT_POL_CNT ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_BNB_FC_CO ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_BNB_FC_CO ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_BNB_ULT_FC_CO ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_BNB_ULT_FC_CO ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_BNB_FC_AGT_NP_ON ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_BNB_FC_AGT_NP_ON ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_BNB_FC_AGT_NP_OFF ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_BNB_FC_AGT_NP_OFF ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_BNB_ULT_FC_AGT_NP ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_BNB_ULT_FC_AGT_NP ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_BNB_MT ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_BNB_MT ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_BNB_ULT_MT ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_BNB_ULT_MT ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_BNB_REW ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_BNB_REW ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_BNB_ULT_REW ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_BNB_ULT_REW ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_BNB_RET ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_BNB_RET ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_BNB_ULT_RET ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_BNB_ULT_RET ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_RRA_POL_CNT ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_RRA_POL_CNT ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_RRA_ULT_POL_CNT ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_RRA_ULT_POL_CNT ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_RRA_FC_CO ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_RRA_FC_CO ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_RRA_ULT_FC_CO ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_RRA_ULT_FC_CO ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_RRA_FC_AGT_NP_ON ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_RRA_FC_AGT_NP_ON ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_RRA_FC_AGT_NP_OFF ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_RRA_FC_AGT_NP_OFF ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_RRA_MT ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_RRA_MT ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_RRA_ULT_MT ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_RRA_ULT_MT ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_RRA_REW ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_RRA_REW ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_RRA_ULT_REW ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_RRA_ULT_REW ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_RRA_RET ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_RRA_RET ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_RRA_ULT_RET ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_RRA_ULT_RET ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_RRA_ULT_FC_AGT_NP ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_RRA_ULT_FC_AGT_NP ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_BAS_WRT_PRM ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_BAS_WRT_PRM  ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_RPC_AMT ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_RPC_AMT  ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_RPC_RT_AMT ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_RPC_RT_AMT  ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_RPC_AIL_AMT ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_RPC_AIL_AMT  ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_RPC_EXPOS_AMT ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_RPC_EXPOS_AMT  ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_ANNL_WRT_PRM_AMT_RB ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_ANNL_WRT_PRM_AMT_RB ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_ANNL_WRT_PRM_AMT_BNB ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_ANNL_WRT_PRM_AMT_BNB ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_ANNL_WRT_PRM_AMT_RB + WMR.XWPMR_ANNL_WRT_PRM_AMT_BNB ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_ANNL_WRT_PRM_AMT_RB + WMR.XWPMR_ANNL_WRT_PRM_AMT_BNB ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN WMR.XWPMR_ANNL_WRT_PRM_AMT_RRA ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_ANNL_WRT_PRM_AMT_RRA ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN 
			WMR.XWPMR_ANNL_WRT_PRM_AMT_RB + WMR.XWPMR_ANNL_WRT_PRM_AMT_BNB + WMR.XWPMR_ANNL_WRT_PRM_AMT_RRA ELSE 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN WMR.XWPMR_ANNL_WRT_PRM_AMT_RB + WMR.XWPMR_ANNL_WRT_PRM_AMT_BNB + WMR.XWPMR_ANNL_WRT_PRM_AMT_RRA 
			ELSE 0 END) END), 
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPCurrent THEN 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN 0 ELSE WMR.XWPMR_ARB_RET + WMR.XWPMR_ORA_RET + WMR.XWPMR_BNB_RET + 
			WMR.XWPMR_RRA_RET END) ELSE 0 END),
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPYrPrior THEN 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN 0 ELSE WMR.XWPMR_ARB_RET + WMR.XWPMR_ORA_RET + WMR.XWPMR_BNB_RET + 
			WMR.XWPMR_RRA_RET END) ELSE 0 END),
		SUM(CASE WHEN WMR.XWPMR_EVAL_PERD_KEY = @CMCN_AT_WPLatestYrEnd THEN 
			(CASE WHEN WMR.XWPMR_AGE = 13 THEN 0 ELSE WMR.XWPMR_ARB_RET + WMR.XWPMR_ORA_RET + WMR.XWPMR_BNB_RET + 
				WMR.XWPMR_RRA_RET END) ELSE 0 END), @UserName, getdate(), @UserName, getdate()
	FROM 
		XTRCT_WRT_PRDCT_MO_RPT WMR LEFT JOIN CNFG_MSTR_ST_NM SN ON WMR.XWPMR_ST_CD = SN.CMSN_ST_CD
	GROUP BY 
		WMR.XWPMR_BPM_LN_OF_BUS, WMR.XWPMR_BPM_SEG_NM, WMR.XWPMR_BPM_PRDCT_NM, WMR.XWPMR_RT_PLN_GRP_NM, WMR.XWPMR_TRM, WMR.XWPMR_CHNL_GRP_NM, WMR.XWPMR_SUB_CHNL, 
		WMR.XWPMR_CHNL_NM, WMR.XWPMR_PM_RGN_NM, WMR.XWPMR_ST_CD, SN.CMSN_ST_NM, SN.CMSN_SPC,  WMR.XWPMR_EFF_YR, WMR.XWPMR_EFF_MO, 
		CASE WHEN WMR.XWPMR_EFF_MO < 4 THEN 'Q1' WHEN WMR.XWPMR_EFF_MO < 7 THEN 'Q2' WHEN WMR.XWPMR_EFF_MO < 10 THEN 'Q3' ELSE 'Q4' END


	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50500, 11, 'Written Production Data table: insert statement from first trenton current did not succeed'
		return 50500
	  END


    exec @ret = OthInsUserMessage
                @SessionId, 
                @FunctionName = @FunctionName, 
                @Task_Name = 'Insert Statement: Written Production Data <-- From XTRCT_WRT_PRDCT_MO_RPT & StateNames',
                @Status = 'Complete',
				@UserName = @UserName

   	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing insert written production & statename table complete statement'
		return 50200
	  END

	DELETE FROM STG_WRT_PRDCT_MO_RPT WHERE SWPMR_RT_PLN_GRP_NM = 'AIP/Facility'
	
	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50502, 11, 'Written Production Data table: AIP/Facility rate plan delete statement did not succeed'
		return 50502
	  END

	DELETE FROM STG_WRT_PRDCT_MO_RPT WHERE SWPMR_BPM_SEG_NM = 'Involuntary Auto'
	
	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50502, 11, 'Written Production Data table: Involuntary Auto SWPMR_BPM_SEG_NM plan delete statement did not succeed'
		return 50502
	  END

--EXTRACT STATUS: FINDB COLUMN UPDATE STATEMENT START HERE

	UPDATE CRIT_STS_XTRCT SET CSX_FDB_IND = 'Y', CSX_LST_USER = @UserName, CSX_LST_DT_TM = GETDATE()
	WHERE CSX_YR_MO = @YearMonth

	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50801, 11, 'Extract Status table: FINDB column update statement did not succeed'
		return 50801
	  END

--EXTRACT STATUS: FINDB COLUMN UPDATE STATEMENT END HERE

  END

set nocount off

RETURN 0

GO
--------------------------------------------------------------------------------------------------------------------------------------------
-- Drop Procedure
--------------------------------------------------------------------------------------------------------------------------------------------
if exists (select * from sys.sysobjects where id = object_id(N'[dbo].[RtInsFirstTrentonData]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[RtInsFirstTrentonData]
GO

--------------------------------------------------------------------------------------------------------------------------------------------
-- Create procedure
--------------------------------------------------------------------------------------------------------------------------------------------
CREATE PROCEDURE RtInsFirstTrentonData
(	@SessionId		[udtNumber],
	@FunctionName	[udtName],
	@UserName		udtName
)
AS 
--------------------------------------------------------------------------------------------------------------------------------------------
-- OBJECT NAME:    RtInsFirstTrentonData
--------------------------------------------------------------------------------------------------------------------------------------------
-- AUTHOR:         Vijaya Kumar Gulappa
--------------------------------------------------------------------------------------------------------------------------------------------
-- CREATED:        May-03-2007
--------------------------------------------------------------------------------------------------------------------------------------------
-- STD_DESC:    Insert & Append First Trenton Current & History datab to the First Trenton Data table.
--------------------------------------------------------------------------------------------------------------------------------------------
-- PARAMETERS:
--------------------------------------------------------------------------------------------------------------------------------------------
-- RETURNS:        0  -  success
--                 returns from SQL Server
--------------------------------------------------------------------------------------------------------------------------------------------

-- VERSION: $Revision: 34 $  UPDATED: $Modtime: 8/08/07 2:27p $
--------------------------------------------------------------------------------------------------------------------------------------------

declare	@ret int

DECLARE 
@CMCN_AT_FTCurrent udtInteger, 
@CMCN_AT_WPCurrent udtInteger, 
@CMCN_AT_FTYrPrior udtInteger, 
@CMCN_AT_WPYrPrior udtInteger, 
@CMCN_AT_FTLatestYrEnd udtInteger, 
@CMCN_AT_WPLatestYrEnd udtInteger

set nocount on
Set @FunctionName = OBJECT_NAME(@@PROCID)
SET @ret = 0

  BEGIN

	TRUNCATE TABLE [dbo].STG_TNJ_DATA 
	
    -- Error messSTD_AGE record should go here
	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50403, 11, 'First Trenton Data table: truncation did not succeed'
		return 50403
	  END

    exec @ret = OthInsUserMessage
                @SessionId = @SessionId, 
                @FunctionName = @FunctionName, 
                @Task_Name = 'Truncate Table: First Trenton Data',
                @Status = 'Complete',
				@UserName = @UserName

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing truncate first trenton data table complete STD_ST_CDment'
		return 50200
	  END

	INSERT INTO [dbo].STG_TNJ_DATA
	(
	STD_BPM_LN_OF_BUS, STD_FM, STD_BPM_SEG_NM, STD_BPM_PRDCT_NM, STD_CD, STD_DESC, STD_MKT_CD, STD_SUB_MKT, 
	STD_CHNL_GRP_NM, STD_SUB_CHNL, STD_CHNL_NM, STD_ST_CD, STD_ST_NM, STD_CURR_TRM, STD_PREV_TRM, STD_AGE, STD_LOOK, 
	STD_CYC, STD_PM_RGN_NM, STD_STRG, STD_CURR_YR_DESC, STD_PRR_YR_DESC, STD_YR_END_DESC, STD_EFF_YR_MO, STD_EFF_YR, 
	STD_EFF_MO, STD_FISC_YR, STD_ZIP_CD5, STD_ZIP_CD4, STD_LCL_MKT_NM, STD_PLN_LCL_MKT_NM,
	STD_RB_BAS, STD_RB_FC_CO, STD_RB_REW, STD_RB_FC_AGT, 
	STD_RB_FC_NP, STD_RB_MT, STD_NPH_BAS, STD_NPH_FC_CO, STD_NPH_REW, STD_NPH_FC_AGT, STD_NPH_FC_NP, STD_NPH_MT, 
	STD_BNB, STD_NB_FC_CO, STD_NB_REW, STD_NB_FC_AGT, STD_NB_FC_NP, STD_NB_MT, STD_NB_WRT_PRM, STD_PRR_WRT_PRM, 
	STD_RETN_WRT_PRM, STD_RPC_SEC_ON, STD_RPC_AIL_SEC_ON, STD_RPC_RT_SEC_ON, STD_RPC_EXPOS_SEC_ON, STD_ACTUL_WRT_PRM, 
	STD_RB_FC_AGT_NP, STD_RB_RET, STD_NPH_FC_AGT_NP, STD_NPH_RET, STD_NB_FC_AGT_NP, STD_NB_RET, STD_RB_AGT_NP_UTL, 
	STD_RB_MT_UTL, STD_RB_RET_UTL, STD_NPH_AGT_NP_ULT, STD_NPH_MT_ULT, STD_NPH_RET_ULT, STD_BNB_ULT, STD_NB_AGT_NP_ULT, 
	STD_NB_MT_ULT, STD_NB_RET_ULT, STD_ARB_POL_CNT, STD_ARB_POL_CNT_FST_ON, STD_ARB_POL_CNT_SEC_ON, 
	STD_ARB_POL_CNT_FST_OFF, STD_ARB_ULT_POL_CNT_SEC_OFF, STD_ARB_FC_CO, STD_ARB_FC_AGT_NP_FST_ON, 
	STD_ARB_FC_AGT_NP_SEC_ON, STD_ARB_FC_AGT_NP_ON, STD_ARB_FC_AGT_NP_FST_OFF, STD_ARB_FC_AGT_NP_SEC_OFF, STD_ARB_FC_AGT_NP_OFF, 
	STD_ARB_ULT_FC_AGT_NP, STD_ARB_MT, STD_ARB_ULT_MT, STD_ARB_RET, STD_ARB_ULT_RET, STD_ORA_POL_CNT_FST_ON, 
	STD_ORA_POL_CNT_SEC_ON, STD_ORA_POL_CNT_FST_OFF, STD_ORA_POL_CNT_SEC_OFF, STD_ORA_FC_CO, STD_ORA_FC_AGT_NP_FST_ON, 
	STD_ORA_FC_AGT_NP_SEC_ON, STD_ORA_FC_AGT_NP_ON, STD_ORA_FC_AGT_NP_FST_OFF, STD_ORA_FC_AGT_NP_SEC_OFF, STD_ORA_FC_AGT_NP_OFF, 
	STD_ORA_ULT_FC_AGT_NP, STD_ORA_MT, STD_ORA_ULT_MT, STD_ORA_REW, STD_ORA_ULT_REW, STD_ORA_RET, STD_ORA_ULT_RET, 
	STD_BNB_POL_CNT, STD_BNB_POL_CNT_FST_ON, STD_BNB_POL_CNT_SEC_ON, STD_BNB_POL_CNT_FST_OFF, STD_BNB_POL_CNT_SEC_OFF, 
	STD_BNB_ULT_POL_CNT, STD_BNB_FC_CO, STD_BNB_FC_AGT_NP_FST_ON, STD_BNB_FC_AGT_NP_SEC_ON, STD_BNB_FC_AGT_NP_ON, 
	STD_BNB_FC_AGT_NP_FST_OFF, STD_BNB_FC_AGT_NP_SEC_OFF, STD_BNB_FC_AGT_NP_OFF, STD_BNB_ULT_FC_AGT_NP, STD_BNB_MT, 
	STD_BNB_ULT_MT, STD_BNB_REW, STD_BNB_ULT_REW, STD_BNB_RET, STD_BNB_ULT_RET, STD_BNB_CH_EFF_DT, STD_RRA_POL_CNT, 
	STD_RRA_POL_CNT_FST_ON, STD_RRA_POL_CNT_SEC_ON, STD_RRA_POL_CNT_FST_OFF, STD_RRA_POL_CNT_SEC_OFF, STD_RRA_FC_CO, 
	STD_RRA_FC_AGT_NP_FST_ON, STD_RRA_FC_AGT_NP_SEC_ON, STD_RRA_FC_AGT_NP_ON, STD_RRA_FC_AGT_NP_FST_OFF, 
	STD_RRA_FC_AGT_NP_SEC_OFF, STD_RRA_FC_AGT_NP_OFF, STD_RRA_ULT_FC_AGT_NP, STD_RRA_MT, STD_RRA_ULT_MT, STD_RRA_REW, 
	STD_RRA_ULT_REW, STD_RRA_RET, STD_RRA_ULT_RET, STD_RPC_FST_ON, STD_RET_FST_ON, STD_RPC_RT_FST_ON, STD_RPC_AIL_FST_ON, 
	STD_RPC_EXPOS_FST_ON, STD_RPC, STD_RET, STD_RPC_RT, STD_RPC_AIL, STD_RPC_EXPOS, STD_ANNL_WRT_PRM_RB, 
	STD_ANNL_WRT_PRM_BNB, STD_ORG_WRT_PRM, STD_ACQN_WRT_PRM, STD_COMB_WRT_PRM, STD_PRR_IN_FRC, STD_YR_END_IN_FRC,
	STD_LST_USER, STD_LST_DT_TM, STD_CREAT_USER, STD_CREAT_DT_TM
	)
	SELECT 
	'', XTC_FM, '', '', '', '', XTC_MKT_CD, XTC_SUB_MKT, '', '', '', XTC_ST_CD, 'New Jersey', XTC_CURR_TRM, XTC_PREV_TRM, 
	XTC_AGE, CASE WHEN XTC_AGE = 1 THEN '1-Look' ELSE (CASE WHEN XTC_AGE = 2 THEN '2-Look' ELSE '3-Look' END) END AS STD_LOOK,	
	XTC_CYC,  'Domestic', 'Grow' , 'Other', 'Other', 'Other', XTC_EFF_YR_MO, Left(XTC_EFF_YR_MO,4), Right(XTC_EFF_YR_MO,2), 
	CASE WHEN Right(XTC_EFF_YR_MO,2) < 4 THEN 'Q1' WHEN Right(XTC_EFF_YR_MO,2) < 7 THEN 'Q2'
		 WHEN Right(XTC_EFF_YR_MO,2) < 10 THEN 'Q3' ELSE 'Q4'
	END, 
	XTC_ZIP_CD5, XTC_ZIP_CD4, 'Other', 'Unsupported',
	XTC_RB_BAS_AMT, XTC_RB_FC_CO_AMT, XTC_RB_REW_AMT, XTC_RB_FC_AGT_AMT, XTC_RB_FC_NP_AMT, 
	XTC_RB_MT_AMT, XTC_NPH_BAS_AMT, XTC_NPH_FC_CO_AMT, XTC_NPH_REW_AMT, XTC_NPH_FC_AGT_AMT, XTC_NPH_FC_NP_AMT, 
	XTC_NPH_MT_AMT, XTC_BNB_AMT, XTC_NB_FC_CO_AMT, XTC_NB_REW_AMT, XTC_NB_FC_AGT_AMT, XTC_NB_FC_NP_AMT, XTC_NB_MT_AMT, 
	XTC_NB_WRT_PRM_AMT, XTC_PRR_WRT_PRM_AMT, XTC_RETN_WRT_PRM_AMT, XTC_RPC_AMT, XTC_RPC_AIL_AMT, XTC_RPC_RT_AMT, 
	XTC_RPC_EXPOS_AMT, XTC_ACTUL_WRT_PRM_AMT, (XTC_RB_FC_AGT_AMT + XTC_RB_FC_NP_AMT), (XTC_RB_BAS_AMT - XTC_RB_FC_CO_AMT - 
	XTC_RB_REW_AMT - XTC_RB_FC_AGT_AMT - XTC_RB_FC_NP_AMT - XTC_RB_MT_AMT),	(XTC_NPH_FC_AGT_AMT + XTC_NPH_FC_NP_AMT), 
	(XTC_NPH_BAS_AMT - XTC_NPH_FC_CO_AMT - XTC_NPH_REW_AMT - XTC_NPH_FC_AGT_AMT - XTC_NPH_FC_NP_AMT - XTC_NPH_MT_AMT),
	(XTC_NB_FC_AGT_AMT + XTC_NB_FC_NP_AMT), (XTC_BNB_AMT - XTC_NB_FC_CO_AMT - XTC_NB_REW_AMT - XTC_NB_FC_AGT_AMT - 
	XTC_NB_FC_NP_AMT - XTC_NB_MT_AMT), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0,	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	@UserName, getdate(), @UserName, getdate()
	FROM XTRCT_TNJ_CURR

	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50400, 11, 'First Trenton Data table: insert statement from first trenton current did not succeed'
		return 50400
	  END

    exec @ret = OthInsUserMessage
                @SessionId, 
                @FunctionName = @FunctionName, 
                @Task_Name = 'Insert statement: STG_TNJ_DATA <-- From First Trention Current',
                @Status = 'Complete',
				@UserName = @UserName

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing insert first trenton current table complete statement'
		return 50200
	  END

	INSERT INTO [dbo].STG_TNJ_DATA 
	(
	STD_BPM_LN_OF_BUS, STD_FM, STD_BPM_SEG_NM, STD_BPM_PRDCT_NM, STD_CD, STD_DESC, STD_MKT_CD, STD_SUB_MKT, 
	STD_CHNL_GRP_NM, STD_SUB_CHNL, STD_CHNL_NM, STD_ST_CD, STD_ST_NM, STD_CURR_TRM, STD_PREV_TRM, STD_AGE, STD_LOOK, 
	STD_CYC, STD_PM_RGN_NM, STD_STRG, STD_CURR_YR_DESC, STD_PRR_YR_DESC, STD_YR_END_DESC, STD_EFF_YR_MO, STD_EFF_YR, 
	STD_EFF_MO, STD_FISC_YR, STD_ZIP_CD5, STD_ZIP_CD4, STD_LCL_MKT_NM, STD_PLN_LCL_MKT_NM, 
	STD_RB_BAS, STD_RB_FC_CO, STD_RB_REW, STD_RB_FC_AGT, STD_RB_FC_NP, STD_RB_MT, STD_NPH_BAS, STD_NPH_FC_CO, 
	STD_NPH_REW, STD_NPH_FC_AGT, STD_NPH_FC_NP, STD_NPH_MT, STD_BNB, STD_NB_FC_CO, STD_NB_REW, 
	STD_NB_FC_AGT, STD_NB_FC_NP, STD_NB_MT, STD_NB_WRT_PRM, STD_PRR_WRT_PRM, STD_RETN_WRT_PRM, STD_RPC_SEC_ON, STD_RPC_AIL_SEC_ON, STD_RPC_RT_SEC_ON, 
	STD_RPC_EXPOS_SEC_ON, STD_ACTUL_WRT_PRM, STD_RB_FC_AGT_NP, STD_RB_RET, STD_NPH_FC_AGT_NP, STD_NPH_RET, STD_NB_FC_AGT_NP, 
	STD_NB_RET, STD_RB_AGT_NP_UTL, STD_RB_MT_UTL, STD_RB_RET_UTL, STD_NPH_AGT_NP_ULT, STD_NPH_MT_ULT, STD_NPH_RET_ULT, 
	STD_BNB_ULT, STD_NB_AGT_NP_ULT, STD_NB_MT_ULT, STD_NB_RET_ULT, 
	STD_ARB_POL_CNT, STD_ARB_POL_CNT_FST_ON, STD_ARB_POL_CNT_SEC_ON, STD_ARB_POL_CNT_FST_OFF, STD_ARB_ULT_POL_CNT_SEC_OFF, STD_ARB_FC_CO, 
	STD_ARB_FC_AGT_NP_FST_ON, STD_ARB_FC_AGT_NP_SEC_ON, STD_ARB_FC_AGT_NP_ON, STD_ARB_FC_AGT_NP_FST_OFF, STD_ARB_FC_AGT_NP_SEC_OFF, STD_ARB_FC_AGT_NP_OFF, 
	STD_ARB_ULT_FC_AGT_NP, STD_ARB_MT, STD_ARB_ULT_MT, STD_ARB_RET, STD_ARB_ULT_RET, STD_ORA_POL_CNT_FST_ON, 
	STD_ORA_POL_CNT_SEC_ON, STD_ORA_POL_CNT_FST_OFF, STD_ORA_POL_CNT_SEC_OFF, STD_ORA_FC_CO, STD_ORA_FC_AGT_NP_FST_ON, 
	STD_ORA_FC_AGT_NP_SEC_ON, STD_ORA_FC_AGT_NP_ON, STD_ORA_FC_AGT_NP_FST_OFF, STD_ORA_FC_AGT_NP_SEC_OFF, STD_ORA_FC_AGT_NP_OFF, 
	STD_ORA_ULT_FC_AGT_NP, STD_ORA_MT, STD_ORA_ULT_MT, STD_ORA_REW, STD_ORA_ULT_REW, STD_ORA_RET, 
	STD_ORA_ULT_RET, STD_BNB_POL_CNT, STD_BNB_POL_CNT_FST_ON, STD_BNB_POL_CNT_SEC_ON, STD_BNB_POL_CNT_FST_OFF, STD_BNB_POL_CNT_SEC_OFF, 
	STD_BNB_ULT_POL_CNT, STD_BNB_FC_CO, STD_BNB_FC_AGT_NP_FST_ON, STD_BNB_FC_AGT_NP_SEC_ON, STD_BNB_FC_AGT_NP_ON, STD_BNB_FC_AGT_NP_FST_OFF, 
	STD_BNB_FC_AGT_NP_SEC_OFF, STD_BNB_FC_AGT_NP_OFF, STD_BNB_ULT_FC_AGT_NP, STD_BNB_MT, STD_BNB_ULT_MT, STD_BNB_REW, 
	STD_BNB_ULT_REW, STD_BNB_RET, STD_BNB_ULT_RET, STD_BNB_CH_EFF_DT, STD_RRA_POL_CNT, STD_RRA_POL_CNT_FST_ON, 
	STD_RRA_POL_CNT_SEC_ON, STD_RRA_POL_CNT_FST_OFF, STD_RRA_POL_CNT_SEC_OFF, STD_RRA_FC_CO, STD_RRA_FC_AGT_NP_FST_ON, 
	STD_RRA_FC_AGT_NP_SEC_ON, STD_RRA_FC_AGT_NP_ON, STD_RRA_FC_AGT_NP_FST_OFF, STD_RRA_FC_AGT_NP_SEC_OFF, STD_RRA_FC_AGT_NP_OFF, 
	STD_RRA_ULT_FC_AGT_NP, STD_RRA_MT, STD_RRA_ULT_MT, STD_RRA_REW, STD_RRA_ULT_REW, STD_RRA_RET, STD_RRA_ULT_RET, 
	STD_RPC_FST_ON, STD_RET_FST_ON, STD_RPC_RT_FST_ON, STD_RPC_AIL_FST_ON, STD_RPC_EXPOS_FST_ON, STD_RPC, STD_RET, 
	STD_RPC_RT, STD_RPC_AIL, STD_RPC_EXPOS, STD_ANNL_WRT_PRM_RB, STD_ANNL_WRT_PRM_BNB, 
	STD_ORG_WRT_PRM, STD_ACQN_WRT_PRM, STD_COMB_WRT_PRM, STD_PRR_IN_FRC, STD_YR_END_IN_FRC,
	STD_LST_USER, STD_LST_DT_TM, STD_CREAT_USER, STD_CREAT_DT_TM
	)
	SELECT 
	'', XTH_FM, '', '', '', '', XTH_MKT_CD, XTH_SUB_MKT, '', '', '', XTH_ST_CD, 'New Jersey', XTH_CURR_TRM, XTH_PREV_TRM, 
	XTH_AGE, CASE WHEN XTH_AGE = 1 THEN '1-Look' ELSE (CASE WHEN XTH_AGE = 2 THEN '2-Look' ELSE '3-Look' END) END AS STD_LOOK,	
	XTH_CYC,  'Domestic', 'Grow' , 'Other', 'Other', 'Other', XTH_EFF_YR_MO, Left(XTH_EFF_YR_MO,4), Right(XTH_EFF_YR_MO,2), 
	CASE WHEN Right(XTH_EFF_YR_MO,2) < 4 THEN 'Q1' WHEN Right(XTH_EFF_YR_MO,2) < 7 THEN 'Q2'
		 WHEN Right(XTH_EFF_YR_MO,2) < 10 THEN 'Q3' ELSE 'Q4'
	END, 
	'00000', '0000', 'Other', 'Unsupported', 
	XTH_RB_BAS_AMT, XTH_RB_FC_CO_AMT, XTH_RB_REW_AMT, XTH_RB_FC_AGT_AMT, XTH_RB_FC_NP_AMT, 
	XTH_RB_MT_AMT, XTH_NPH_BAS_AMT, XTH_NPH_FC_CO_AMT, XTH_NPH_REW_AMT, XTH_NPH_FC_AGT_AMT, XTH_NPH_FC_NP_AMT, 
	XTH_NPH_MT_AMT, XTH_BNB_AMT, XTH_NB_FC_CO_AMT, XTH_NB_REW_AMT, XTH_NB_FC_AGT_AMT, XTH_NB_FC_NP_AMT, XTH_NB_MT_AMT, 
	XTH_NB_WRT_PRM_AMT, XTH_PRR_WRT_PRM_AMT, XTH_RETN_WRT_PRM_AMT, XTH_RPC_AMT, XTH_RPC_AIL_AMT, XTH_RPC_RT_AMT, 
	XTH_RPC_EXPOS_AMT, XTH_ACTUL_WRT_PRM_AMT, (XTH_RB_FC_AGT_AMT + XTH_RB_FC_NP_AMT), (XTH_RB_BAS_AMT - XTH_RB_FC_CO_AMT - 
	XTH_RB_REW_AMT - XTH_RB_FC_AGT_AMT - XTH_RB_FC_NP_AMT - XTH_RB_MT_AMT),	(XTH_NPH_FC_AGT_AMT + XTH_NPH_FC_NP_AMT), 
	(XTH_NPH_BAS_AMT - XTH_NPH_FC_CO_AMT - XTH_NPH_REW_AMT - XTH_NPH_FC_AGT_AMT - XTH_NPH_FC_NP_AMT - XTH_NPH_MT_AMT),
	(XTH_NB_FC_AGT_AMT + XTH_NB_FC_NP_AMT), (XTH_BNB_AMT - XTH_NB_FC_CO_AMT - XTH_NB_REW_AMT - XTH_NB_FC_AGT_AMT - 
	XTH_NB_FC_NP_AMT - XTH_NB_MT_AMT), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0,	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	@UserName, getdate(), @UserName, getdate()
	FROM XTRCT_TNJ_HS

	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50400, 11, 'First Trenton Data table: insert statement from first trenton data did not succeed'
		return 50400
	  END

    exec @ret = OthInsUserMessage
                @SessionId, 
                @FunctionName = @FunctionName, 
                @Task_Name = 'Insert statement: STG_TNJ_DATA <-- From First Trenton History',
                @Status = 'Complete',
				@UserName = @UserName

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing insert first trenton history table complete statement'
		return 50200
	  END

--STD_CYC NUMBER INSERT/UPDATE STD_ST_CDMENT START HERE

	SELECT @CMCN_AT_FTCurrent = MAX(STD_CYC) FROM STG_TNJ_DATA
	SET @CMCN_AT_WPCurrent = CAST(@CMCN_AT_FTCurrent AS VARCHAR) + '00'
	SET @CMCN_AT_FTYrPrior = @CMCN_AT_FTCurrent - 100
	SET @CMCN_AT_WPYrPrior = CAST(@CMCN_AT_FTCurrent AS VARCHAR) + '00' - 10000
	SET @CMCN_AT_FTLatestYrEnd = (LEFT(@CMCN_AT_FTCurrent, 4) - 1) * 100 + 12
	SET @CMCN_AT_WPLatestYrEnd = (LEFT(CAST(@CMCN_AT_FTCurrent AS VARCHAR) + '00', 4) - 1) * 10000 + 1200

	IF EXISTS (SELECT CMCN_PK_ID FROM CNFG_MSTR_CYC_NBR)
	BEGIN
		UPDATE [dbo].CNFG_MSTR_CYC_NBR SET
		CMCN_TNJ_CURR = @CMCN_AT_FTCurrent, 
		CMCN_WRT_PRM_CURR = @CMCN_AT_WPCurrent, 
		CMCN_TNJ_YR_PRR = @CMCN_AT_FTYrPrior, 
		CMCN_WRT_PRM_YR_PRR = @CMCN_AT_WPYrPrior, 
		CMCN_TNJ_LT_YR_END = @CMCN_AT_FTLatestYrEnd, 
		CMCN_WRT_PRM_LT_YR_END = @CMCN_AT_WPLatestYrEnd, 
		CMCN_LST_USER = @UserName,
		CMCN_LST_DT_TM = getdate()

		IF  @@error != 0 
		  BEGIN 
			exec OthInsErrorMessage @SessionId, @FunctionName, 50301, 11, 'STD_CYC Number: Update statement did not succeed'
			return 50301
		  END
	END
	ELSE
	BEGIN
		INSERT INTO [dbo].CNFG_MSTR_CYC_NBR 
		(
		CMCN_TNJ_CURR, CMCN_WRT_PRM_CURR, CMCN_TNJ_YR_PRR, CMCN_WRT_PRM_YR_PRR, CMCN_TNJ_LT_YR_END, 
		CMCN_WRT_PRM_LT_YR_END, CMCN_LST_USER, CMCN_LST_DT_TM, CMCN_CREAT_USER, 
		CMCN_CREAT_DT_TM
		)
		VALUES 
		(@CMCN_AT_FTCurrent, @CMCN_AT_WPCurrent, @CMCN_AT_FTYrPrior, @CMCN_AT_WPYrPrior, @CMCN_AT_FTLatestYrEnd, 
		@CMCN_AT_WPLatestYrEnd, @UserName, getdate(), @UserName, getdate())
		IF  @@error != 0 
		  BEGIN 
			exec OthInsErrorMessage @SessionId, @FunctionName, 50300, 11, 'STD_CYC Number: Insert statement did not succeed'
			return 50300
		  END
	END

--STD_CYC NUMBER INSERT/UPDATE STD_ST_CDMENT END HERE

    exec @ret = OthInsUserMessage
                @SessionId, 
                @FunctionName = @FunctionName, 
                @Task_Name = 'Insert/Update STD_ST_CDment: STD_CYC Number',
                @Status = 'Complete',
				@UserName = @UserName

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing insert/update STD_CYC number table complete STD_ST_CDment'
		return 50200
	  END

  END

set nocount off

RETURN 0

GO
--------------------------------------------------------------------------------------------------------------------------------------------
-- Drop Procedure
--------------------------------------------------------------------------------------------------------------------------------------------
if exists (select * from sys.sysobjects where id = object_id(N'[dbo].[RtReconcile]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[RtReconcile]
GO

--------------------------------------------------------------------------------------------------------------------------------------------
-- Create procedure
--------------------------------------------------------------------------------------------------------------------------------------------
CREATE PROCEDURE RtReconcile
(	@SessionId		[udtNumber],
	@FunctionName	[udtName]
)
AS 
--------------------------------------------------------------------------------------------------------------------------------------------
-- OBJECT NAME:    RtInsRetention
--------------------------------------------------------------------------------------------------------------------------------------------
-- AUTHOR:         Vijaya Kumar Gulappa
--------------------------------------------------------------------------------------------------------------------------------------------
-- CREATED:        May-10-2007
--------------------------------------------------------------------------------------------------------------------------------------------
-- DESCRIPTION:    Combine First Trenton Current And Findb data into FACT_DTL_FIN_MGT_RPT table.
--------------------------------------------------------------------------------------------------------------------------------------------
-- PARAMETERS:
--------------------------------------------------------------------------------------------------------------------------------------------
-- RETURNS:        0  -  success
--                 returns from SQL Server
--------------------------------------------------------------------------------------------------------------------------------------------

-- VERSION: $Revision: 14 $  UPDATED: $Modtime: 8/08/07 2:30p $
--------------------------------------------------------------------------------------------------------------------------------------------

declare	@ret int,
		@UserName	udtName
set nocount on
Set @FunctionName = OBJECT_NAME(@@PROCID)

SET @ret = 0

	BEGIN

		Exec @ret = UsrGetSessionInfo @SessionId = @SessionId,
									@FunctionName = @FunctionName,
									@UMS_AT_Name = @UserName Output

		IF  @ret != 0 
		  BEGIN 
			exec OthInsErrorMessage @SessionId, @FunctionName, 50103, 11, 'Get Session Information: Exec UsrGetSessionInfo failed'
			return 50103
		  END

		exec @ret = RtInsFirstTrentonData
					@SessionId, 
					@FunctionName = @FunctionName, 
					@UserName = @UserName
		
		IF  @ret != 0 
		  BEGIN 
			exec OthInsErrorMessage @SessionId, @FunctionName, 50400, 11, 'STG_TNJ_DATA table: current & history insert statement did not succeed'
			return 50400
		  END

		exec @ret = OthInsUserMessage
					@SessionId, 
					@FunctionName = @FunctionName, 
					@Task_Name = 'Insert Statement: STG_TNJ_DATA',
					@Status = 'Complete'

		IF  @ret != 0 
		  BEGIN 
			exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing insert STG_TNJ_DATA table complete statement'
			return 50200
		  END


		exec @ret = RtUpdFirstTrentonData
					@SessionId, 
					@FunctionName = @FunctionName, 
					@UserName = @UserName
		
		IF  @ret != 0 
		  BEGIN 
			exec OthInsErrorMessage @SessionId, @FunctionName, 50401, 11, 'STG_TNJ_DATA table: update statement did not succeed'
			return 50401
		  END

		exec @ret = OthInsUserMessage
					@SessionId, 
					@FunctionName = @FunctionName, 
					@Task_Name = 'Update Statement: STG_TNJ_DATA',
					@Status = 'Complete'

		IF  @ret != 0 
		  BEGIN 
			exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing update STG_TNJ_DATA table complete statement'
			return 50200
		  END
	    
		exec @ret = RtInsFindbData
					@SessionId, 
					@FunctionName = @FunctionName, 
					@UserName = @UserName
		
		IF  @ret != 0 
		  BEGIN 
			exec OthInsErrorMessage @SessionId, @FunctionName, 50500, 11, 'Written Production Data table: insert statement did not succeed'
			return 50500
		  END

		exec @ret = OthInsUserMessage
					@SessionId, 
					@FunctionName = @FunctionName, 
					@Task_Name = 'Insert Statement: From Written Production Data',
					@Status = 'Complete'

		IF  @ret != 0 
		  BEGIN 
			exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing insert written production table complete statement'
			return 50200
		  END
	    
/*
--Update Findb Strategy Auto, Prop and Geico is not required.  Confirmed by Carla on 06/12/2007 by email subject as
-- "RE: Pending Task & Queries".

		exec @ret = RtUpdFindbData
					@SessionId, 
					@FunctionName = @FunctionName, 
					@UserName = @UserName
		
		IF  @ret != 0 
		  BEGIN 
			exec OthInsErrorMessage @SessionId, @FunctionName, 50501, 11, 'Findb Data table: update statement did not succeed'
			return 50501
		  END

		exec @ret = OthInsUserMessage
					@SessionId, 
					@FunctionName = @FunctionName, 
					@Task_Name = 'Update Statement: Findb Data',
					@Status = 'Complete'

		IF  @ret != 0 
		  BEGIN 
			exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing update findb data table complete statement'
			return 50200
		  END
*/

		exec @ret = ArcCurrentFMRDataExcludeICR
					@SessionId, 
					@FunctionName = @FunctionName, 
					@UserName = @UserName
		
		IF  @ret != 0 
		  BEGIN 
			exec OthInsErrorMessage @SessionId, @FunctionName, 52199, 11, 'Archive Data : insert statement did not succeed'
			return 52199
		  END

		exec @ret = OthInsUserMessage
					@SessionId, 
					@FunctionName = @FunctionName, 
					@Task_Name = 'Insert Statement: Archive Data',
					@Status = 'Complete'

		IF  @ret != 0 
		  BEGIN 
			exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing archive data complete statement'
			return 50200
		  END

		exec @ret = RtInsCombineTrentonAndFindb
					@SessionId, 
					@FunctionName = @FunctionName, 
					@UserName = @UserName
		
		IF  @ret != 0 
		  BEGIN 
			exec OthInsErrorMessage @SessionId, @FunctionName, 50600, 11, 'Combine Trenton & Written Production Data table: insert statement did not succeed'
			return 50600
		  END

		exec @ret = OthInsUserMessage
					@SessionId, 
					@FunctionName = @FunctionName, 
					@Task_Name = 'Insert Statement: From Trenton & Written Production Data Table',
					@Status = 'Complete'

		IF  @ret != 0 
		  BEGIN 
			exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing insert trenton & written production table complete statement'
			return 50200
		  END

		exec @ret = OthSetCurrentAndNextSSIS
					@SessionId, 
					@FunctionName = @FunctionName, 
					@UserName = @UserName,
					@Curr_Package_Name = 'Retention',
					@Next_Package_Name = 'Earned Premium And Loss Ratio'
		
		IF  @ret != 0 
		  BEGIN 
			exec OthInsErrorMessage @SessionId, @FunctionName, 100011, 11, 'MSDB Job: update statement did not succeed'
			return 100011
		  END

	END

set nocount off

RETURN @ret

GO
--------------------------------------------------------------------------------------------------------------------------------------------
-- Drop Procedure
--------------------------------------------------------------------------------------------------------------------------------------------
if exists (select * from sys.sysobjects where id = object_id(N'[dbo].[RtUpdFindbData]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[RtUpdFindbData]
GO

--------------------------------------------------------------------------------------------------------------------------------------------
-- Create procedure
--------------------------------------------------------------------------------------------------------------------------------------------
CREATE PROCEDURE RtUpdFindbData
(	@SessionId		[udtNumber],
	@FunctionName	[udtName],
	@UserName		udtName
)
AS 
--------------------------------------------------------------------------------------------------------------------------------------------
-- OBJECT NAME:    RtUpdFindbData
--------------------------------------------------------------------------------------------------------------------------------------------
-- AUTHOR:         Vijaya Kumar Gulappa
--------------------------------------------------------------------------------------------------------------------------------------------
-- CREATED:        May-29-2007
--------------------------------------------------------------------------------------------------------------------------------------------
-- DESCRIPTION:    Update Findb Data table.
--------------------------------------------------------------------------------------------------------------------------------------------
-- PARAMETERS:
--------------------------------------------------------------------------------------------------------------------------------------------
-- RETURNS:        0  -  success
--                 returns from SQL Server
--------------------------------------------------------------------------------------------------------------------------------------------

-- VERSION: $Revision: 8 $  UPDATED: $Modtime: 8/08/07 2:30p $
--------------------------------------------------------------------------------------------------------------------------------------------

declare	@ret int
DECLARE 
@YearMonth	udtEffYrMon

set nocount on
Set @FunctionName = OBJECT_NAME(@@PROCID)
SET @YearMonth = CAST(DATEPART (YYYY, GETDATE()) AS VARCHAR(4)) + (CASE WHEN LEN(DATEPART(M, GETDATE())) = 1 THEN '0' ELSE '' END) + CAST(DATEPART(M, GETDATE()) AS VARCHAR(2))
SET @ret = 0

  BEGIN

--STRATEGY AUTO UPDATE STATEMENT START HERE

	--SELECT SA.CMSN_AT_Strategy
	UPDATE STG_WRT_PRDCT_MO_RPT
	SET SWPMR_STRG = SA.CMSN_AT_Strategy, SWPMR_LST_USER = @UserName, SWPMR_LST_DT_TM = getdate()
	FROM STG_WRT_PRDCT_MO_RPT FD LEFT JOIN Con_Mas_Strategy_Auto SA ON FD.SWPMR_ST_CD = SA.CMSN_AT_State_Code
	WHERE FD.SWPMR_BPM_LN_OF_BUS = 'Auto'

	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50501, 11, 'Strategy Auto: Update Statement failed'
		return 50501
	  END

    exec @ret = OthInsUserMessage
                @SessionId, 
                @FunctionName = @FunctionName, 
                @Task_Name = 'Update Statement: Strategy Auto ',
                @Status = 'Complete',
				@UserName = @UserName

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing update statement strategy auto complete statement'
		return 50200
	  END

--STRATEGY AUTO UPDATE STATEMENT END HERE

--STRATEGY GEICO UPDATE STATEMENT START HERE

	--SELECT SG.CMSN_AT_Dwelling_Strategy
	UPDATE STG_WRT_PRDCT_MO_RPT
	SET SWPMR_STRG = SG.CMSN_AT_Dwelling_Strategy, SWPMR_LST_USER = @UserName, SWPMR_LST_DT_TM = getdate()
	FROM STG_WRT_PRDCT_MO_RPT FD LEFT JOIN Con_Mas_Strategy_Geico SG ON FD.SWPMR_ST_CD = SG.CMSN_AT_State_Code
	WHERE FD.SWPMR_CHNL_GRP_NM = 'Geico'

	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50501, 11, 'Strategy Geico: Update Statement failed'
		return 50501
	  END

    exec @ret = OthInsUserMessage
                @SessionId, 
                @FunctionName = @FunctionName, 
                @Task_Name = 'Update Statement: Strategy Geico ',
                @Status = 'Complete',
				@UserName = @UserName

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing update statement strategy geico complete statement'
		return 50200
	  END

--STRATEGY GEICO UPDATE STATEMENT END HERE

--STRATEGY PROPERTY UPDATE STATEMENT START HERE

	--SELECT SP.CMSN_AT_Dwelling_Strategy
	UPDATE STG_WRT_PRDCT_MO_RPT
	SET SWPMR_STRG = SP.CMSN_AT_Dwelling_Strategy, SWPMR_LST_USER = @UserName, SWPMR_LST_DT_TM = getdate()
	FROM STG_WRT_PRDCT_MO_RPT FD LEFT JOIN Con_Mas_Strategy_Prop SP ON FD.SWPMR_ST_CD = SP.CMSN_AT_State_Code
	WHERE FD.SWPMR_BPM_LN_OF_BUS = 'Property'  And SP.CMSN_AT_DevSTGrp Not In ('NYH', 'NYL', 'NYU') And SWPMR_CHNL_NM Not In ('Geico')

	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50501, 11, 'Strategy Property: Update Statement failed'
		return 50501
	  END

    exec @ret = OthInsUserMessage
                @SessionId, 
                @FunctionName = @FunctionName, 
                @Task_Name = 'Update Statement: Strategy Property ',
                @Status = 'Complete',
				@UserName = @UserName

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing update statement strategy property complete statement'
		return 50200
	  END

--STRATEGY PROPERTY UPDATE STATEMENT END HERE

--EXTRACT STATUS: FINDB COLUMN UPDATE STATEMENT START HERE

	UPDATE CRIT_STS_XTRCT SET CSX_FDB_IND = 'Y', CSX_LST_USER = @UserName, CSX_LST_DT_TM = GETDATE()
	WHERE CSX_YR_MO = @YearMonth

	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50801, 11, 'Extract Status table: FINDB column update statement did not succeed'
		return 50801
	  END

--EXTRACT STATUS: FINDB COLUMN UPDATE STATEMENT END HERE

  END

set nocount off

RETURN 0

GO
--------------------------------------------------------------------------------------------------------------------------------------------
-- Drop Procedure
--------------------------------------------------------------------------------------------------------------------------------------------
if exists (select * from sys.sysobjects where id = object_id(N'[dbo].[RtUpdFirstTrentonData]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[RtUpdFirstTrentonData]
GO

--------------------------------------------------------------------------------------------------------------------------------------------
-- Create procedure
--------------------------------------------------------------------------------------------------------------------------------------------
CREATE PROCEDURE RtUpdFirstTrentonData
(	@SessionId		[udtNumber],
	@FunctionName	[udtName],
	@UserName		udtName
)
AS 
--------------------------------------------------------------------------------------------------------------------------------------------
-- OBJECT NAME:    RtUpdFirstTrentonData
--------------------------------------------------------------------------------------------------------------------------------------------
-- AUTHOR:         Vijaya Kumar Gulappa
--------------------------------------------------------------------------------------------------------------------------------------------
-- CREATED:        May-07-2007
--------------------------------------------------------------------------------------------------------------------------------------------
-- DESCRIPTION:    Update First Trenton Data table.
--------------------------------------------------------------------------------------------------------------------------------------------
-- PARAMETERS:
--------------------------------------------------------------------------------------------------------------------------------------------
-- RETURNS:        0  -  success
--                 returns from SQL Server
--------------------------------------------------------------------------------------------------------------------------------------------

-- VERSION: $Revision: 22 $  UPDATED: $Modtime: 8/08/07 2:32p $
--------------------------------------------------------------------------------------------------------------------------------------------

declare	@ret int
DECLARE 
@CMCN_AT_FTCurrent udtInteger, 
@CMCN_AT_FTYrPrior udtInteger, 
@CMCN_AT_FTLatestYrEnd udtInteger,
@YearMonth	udtEffYrMon

set nocount on
Set @FunctionName = OBJECT_NAME(@@PROCID)
SET @YearMonth = CAST(DATEPART (YYYY, GETDATE()) AS VARCHAR(4)) + (CASE WHEN LEN(DATEPART(M, GETDATE())) = 1 THEN '0' ELSE '' END) + CAST(DATEPART(M, GETDATE()) AS VARCHAR(2))
SET @ret = 0
--suser_sname() should be replace with username/session id parameter
  BEGIN

	Exec @ret = RtGetCycleNumber	
		@SessionId = @SessionId,
		@FunctionName = @FunctionName,
		@CMCN_PK_ID = 1,
		@CMCN_AT_FTCurrent = @CMCN_AT_FTCurrent Output,
		@CMCN_AT_FTYrPrior = @CMCN_AT_FTYrPrior Output,
		@CMCN_AT_FTLatestYrEnd = @CMCN_AT_FTLatestYrEnd Output

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50303, 11, 'select statement failed: Cycle Number'
		return 50303
	  END


--FORM & MARKET DECODE UPDATE STATEMENT START HERE

	--SELECT [FD].Product, [FD].[Sub_Product], [FD].Code, [FD].Description
	UPDATE STG_TNJ_DATA 
	SET STD_BPM_SEG_NM = CASE WHEN FD.CMFD_BPM_SEG_NM = 'Auto' THEN 'Standard Auto' 
						WHEN FD.CMFD_BPM_SEG_NM = 'Other' THEN 'Other Personal Lines' 
						ELSE FD.CMFD_BPM_SEG_NM 
				  END,
	STD_BPM_PRDCT_NM = CASE WHEN FD.CMFD_BPM_PRDCT_NM = 'Dwelling/Fire' THEN 'Homesavers' 
			ELSE FD.CMFD_BPM_PRDCT_NM END,
	STD_CD = FD.CMFD_CD, STD_DESC = FD.CMFD_DESC, STD_LST_USER = @UserName, STD_LST_DT_TM = getdate()
	FROM STG_TNJ_DATA FTD, CNFG_MSTR_FM_DECODE FD WHERE FTD.STD_FM = FD.CMFD_FM

	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50401, 11, 'First Trenton Data & Form Decode: Update Statement failed'
		return 50401
	  END

    exec @ret = OthInsUserMessage
                @SessionId, 
                @FunctionName = @FunctionName, 
                @Task_Name = 'Update Statement: Form Decode ',
                @Status = 'Complete',
				@UserName = @UserName

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing update statement form decode complete statement'
		return 50200
	  END

	--SELECT MD.[Mkt_Grp] AS Market, MD.[Mkt_Use_Grp] AS [Sub Market]
	UPDATE STG_TNJ_DATA 
	SET STD_CHNL_GRP_NM = MD.CMMD_CHNL_GRP_NM, STD_SUB_CHNL = MD.CMMD_MKT_USER_GRP, STD_LST_USER = @UserName, STD_LST_DT_TM = getdate()
	FROM STG_TNJ_DATA FTD, CNFG_MSTR_MKT_DECODE MD 
	WHERE FTD.STD_MKT_CD = MD.CMMD_MKT_CD AND FTD.STD_SUB_MKT = MD.CMMD_SUB_MKT

	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50401, 11, 'First Trenton Data & Market Decode: Update Statement failed'
		return 50401
	  END

    exec @ret = OthInsUserMessage
                @SessionId, 
                @FunctionName = @FunctionName, 
                @Task_Name = 'Update Statement: Market Decode',
                @Status = 'Complete',
				@UserName = @UserName

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing update statement market decode complete statement'
		return 50200
	  END

--FORM & MARKET DECODE UPDATE STATEMENT END HERE

--LOCAL MARKET UPDATE STATEMENT START HERE

	--SELECT CASE WHEN ZC.Local_Market_TR IS NULL THEN 'Other' ELSE ZC.Local_Market_TR END AS [Local_Market]
	UPDATE STG_TNJ_DATA 
	SET STD_LCL_MKT_NM = (CASE WHEN ZC.CMZ_LCL_MKT_TR IS NULL THEN 'Other' ELSE ZC.CMZ_LCL_MKT_TR END),
	STD_PLN_LCL_MKT_NM = (CASE WHEN ZC.CMZ_LCL_MKT_TR_PLN IS NULL THEN 'Unsupported' ELSE ZC.CMZ_LCL_MKT_TR_PLN END),
	STD_LST_USER = @UserName, STD_LST_DT_TM = getdate()
	FROM STG_TNJ_DATA FTD LEFT JOIN CNFG_MSTR_ZIPCD ZC ON FTD.STD_ZIP_CD5 = ZC.CMZ_ZIP_CD

	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50401, 11, 'First Trenton Data & ZipCode: Update Statement failed'
		return 50401
	  END

    exec @ret = OthInsUserMessage
                @SessionId, 
                @FunctionName = @FunctionName, 
                @Task_Name = 'Update Statement: ZipCode',
                @Status = 'Complete',
				@UserName = @UserName

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing update statement zipcode complete statement'
		return 50200
	  END

--LOCAL MARKET UPDATE STATEMENT END HERE

--CURRENT, PRIOR, YREND DESCRIPTIVE UPDATE STATEMENT START HERE

/*
SELECT 
CASE WHEN STD_LOOK = '3-Look' THEN 
	(CASE WHEN STD_AGE = 13 THEN 'Current' ELSE (CASE WHEN FTD.STD_CYC = @CMCN_AT_FTCurrent THEN 'Current' ELSE 'Other' END) END) 
ELSE (CASE WHEN FTD.STD_CYC = @CMCN_AT_FTCurrent THEN 'Current' ELSE 'Other' END) END AS [Current]

SELECT 
CASE WHEN STD_AGE = 13 THEN 'Other' ELSE (CASE WHEN FTD.STD_CYC = @CMCN_AT_FTLatestYrEnd THEN 'YrEnd' ELSE 'Other' END) END AS YrEnd
FROM STG_TNJ_DATA FTD

SELECT 
CASE WHEN STD_AGE = 13 THEN 'Other' ELSE (CASE WHEN FTD.STD_CYC = @CMCN_AT_FTYrPrior THEN 'Prior' ELSE 'Other' END) END AS [Prior]
FROM STG_TNJ_DATA FTD 

*/
	UPDATE STG_TNJ_DATA 
	SET 
		STD_CURR_YR_DESC = (CASE WHEN STD_LOOK = '3-Look' THEN 
		(CASE WHEN STD_AGE = 13 THEN 'Current' ELSE (CASE WHEN FTD.STD_CYC = @CMCN_AT_FTCurrent THEN 'Current' ELSE 'Other' END) 
		END) ELSE (CASE WHEN FTD.STD_CYC = @CMCN_AT_FTCurrent THEN 'Current' ELSE 'Other' END) END),
		STD_YR_END_DESC = CASE WHEN STD_AGE = 13 THEN 'Other' ELSE 
			(CASE WHEN FTD.STD_CYC = @CMCN_AT_FTLatestYrEnd THEN 'YrEnd' ELSE 'Other' END) END,
		STD_PRR_YR_DESC = CASE WHEN STD_AGE = 13 THEN 'Other' ELSE 
			(CASE WHEN FTD.STD_CYC = @CMCN_AT_FTYrPrior THEN 'Prior' ELSE 'Other' END) END,
		STD_LST_USER = @UserName, STD_LST_DT_TM = getdate()
	FROM STG_TNJ_DATA FTD

	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50401, 11, 'First Trenton Data & Cycle Number: Update Statement failed'
		return 50401
	  END

    exec @ret = OthInsUserMessage
                @SessionId, 
                @FunctionName = @FunctionName, 
                @Task_Name = 'Update Statement: Current, Year End and Prior Descriptive',
                @Status = 'Complete',
				@UserName = @UserName

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing update statement current, year dnd and prior descriptive complete statement'
		return 50200
	  END

--CURRENT, PRIOR, YREND DESCRIPTIVE UPDATE STATEMENT END HERE

--DEV FACTORS UPDATE STATEMENT START HERE

	UPDATE STG_TNJ_DATA 
	SET 
		STD_RB_AGT_NP_UTL = CASE WHEN DF.CMDF_RFA IS NULL THEN 0 ELSE DF.CMDF_RFA / 100 END * FTD.STD_RB_BAS + FTD.STD_RB_FC_AGT_NP,
		STD_RB_MT_UTL = CASE WHEN DF.CMDF_RMC IS NULL THEN 0 ELSE DF.CMDF_RMC / 100 END * FTD.STD_RB_BAS + FTD.STD_RB_MT, 
		STD_RB_RET_UTL = (FTD.STD_RB_BAS - FTD.STD_RB_FC_CO - FTD.STD_RB_REW - (CASE WHEN DF.CMDF_RFA IS NULL 
		THEN 0 ELSE DF.CMDF_RFA / 100 END * FTD.STD_RB_BAS + FTD.STD_RB_FC_AGT_NP) - (CASE WHEN DF.CMDF_RMC IS NULL 
		THEN 0 ELSE DF.CMDF_RMC / 100 END * FTD.STD_RB_BAS + FTD.STD_RB_MT)), 
		STD_NPH_AGT_NP_ULT = CASE WHEN DF.CMDF_RFA IS NULL THEN 0 ELSE DF.CMDF_RFA / 100 END * FTD.STD_NPH_BAS + FTD.STD_NPH_FC_AGT_NP, 
		STD_NPH_MT_ULT = CASE WHEN DF.CMDF_RMC IS NULL THEN 0 ELSE DF.CMDF_RMC / 100 END * FTD.STD_NPH_BAS + FTD.STD_NPH_MT, 
		STD_NPH_RET_ULT = (FTD.STD_NPH_BAS - FTD.STD_NPH_FC_CO - FTD.STD_NPH_REW - (CASE WHEN DF.CMDF_RFA IS NULL 
		THEN 0 ELSE DF.CMDF_RFA / 100 END * FTD.STD_NPH_BAS + FTD.STD_NPH_FC_AGT_NP) - (CASE WHEN DF.CMDF_RMC IS NULL 
		THEN 0 ELSE DF.CMDF_RMC / 100 END * FTD.STD_NPH_BAS + FTD.STD_NPH_MT)), 
		STD_BNB_ULT = CASE WHEN DF.CMDF_NBLI IS NULL THEN 0 ELSE DF.CMDF_NBLI END * FTD.STD_BNB, 
		STD_NB_AGT_NP_ULT = ((CASE WHEN DF.CMDF_NFA IS NULL THEN 0 ELSE DF.CMDF_NFA / 100 END) 
		* (CASE WHEN DF.CMDF_NBLI IS NULL THEN 1 ELSE DF.CMDF_NBLI END) * FTD.STD_BNB + FTD.STD_NB_FC_AGT_NP), 
		STD_NB_MT_ULT = CASE WHEN DF.CMDF_NMC IS NULL THEN 0 ELSE DF.CMDF_NMC / 100 END * CASE WHEN DF.CMDF_NBLI IS NULL 
		THEN 1 ELSE DF.CMDF_NBLI END * FTD.STD_BNB + FTD.STD_NB_MT, 
		STD_NB_RET_ULT = ((CASE WHEN DF.CMDF_NBLI IS NULL THEN 0 ELSE DF.CMDF_NBLI END * FTD.STD_BNB) -
		FTD.STD_NB_FC_CO-FTD.STD_NB_REW - 
		(CASE WHEN DF.CMDF_NFA IS NULL THEN 0 ELSE DF.CMDF_NFA / 100 END 
		* CASE WHEN DF.CMDF_NBLI IS NULL THEN 1 ELSE DF.CMDF_NBLI END * FTD.STD_BNB + FTD.STD_NB_FC_AGT_NP) -
		(CASE WHEN DF.CMDF_NMC IS NULL THEN 0 ELSE DF.CMDF_NMC / 100 END * CASE WHEN DF.CMDF_NBLI IS NULL 
		THEN 1 ELSE DF.CMDF_NBLI END * FTD.STD_BNB + FTD.STD_NB_MT)),
		STD_LST_USER = @UserName, STD_LST_DT_TM = getdate()
	FROM STG_TNJ_DATA FTD LEFT OUTER JOIN CNFG_MSTR_DVLP_FCT DF ON 
	FTD.STD_AGE = DF.CMDF_AGE AND FTD.STD_CHNL_GRP_NM = DF.CMDF_CHNL AND FTD.STD_CD = DF.CMDF_CD

	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50401, 11, 'First Trenton Data & Dev Factor: Update Statement failed'
		return 50401
	  END

    exec @ret = OthInsUserMessage
                @SessionId, 
                @FunctionName = @FunctionName, 
                @Task_Name = 'Update Statement: Dev Factors',
                @Status = 'Complete',
				@UserName = @UserName

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing update statement dev factors complete statement'
		return 50200
	  END
--DEV FACTORS UPDATE STATEMENT END HERE

--OTHER COLUMNS UPDATE STATEMENT START HERE


	UPDATE  STG_TNJ_DATA SET  
	STD_ARB_POL_CNT = (CASE WHEN STD_CURR_YR_DESC = 'Current' THEN STD_RB_BAS ELSE 0 END), 
	STD_ARB_POL_CNT_FST_ON = (CASE WHEN STD_LOOK = '1-Look' THEN STD_RB_BAS ELSE 0 END), 
	STD_ARB_POL_CNT_SEC_ON = (CASE WHEN STD_LOOK = '2-Look' THEN STD_RB_BAS ELSE 0 END), 
	STD_ARB_POL_CNT_FST_OFF = 0, STD_ARB_ULT_POL_CNT_SEC_OFF = 0, 
	STD_ARB_FC_CO = (CASE WHEN STD_CURR_YR_DESC = 'Current' THEN STD_RB_FC_CO ELSE 0 END), 
	STD_ARB_FC_AGT_NP_FST_ON = (CASE WHEN STD_LOOK = '1-Look' THEN STD_RB_FC_AGT_NP ELSE 0 END) , 
	STD_ARB_FC_AGT_NP_SEC_ON = (CASE WHEN STD_LOOK = '2-Look' THEN STD_RB_FC_AGT_NP ELSE 0 END) , 
	STD_ARB_FC_AGT_NP_ON = (CASE WHEN STD_CURR_YR_DESC = 'Current' THEN STD_RB_FC_AGT_NP ELSE 0 END), 
	STD_ARB_FC_AGT_NP_FST_OFF = 0, STD_ARB_FC_AGT_NP_SEC_OFF = 0, STD_ARB_FC_AGT_NP_OFF = 0, 
	STD_ARB_ULT_FC_AGT_NP = (CASE WHEN STD_CURR_YR_DESC = 'Current' THEN STD_RB_AGT_NP_UTL ELSE 0 END), 
	STD_ARB_MT = (CASE WHEN STD_CURR_YR_DESC = 'Current' THEN STD_RB_MT ELSE 0 END), 
	STD_ARB_ULT_MT = (CASE WHEN STD_CURR_YR_DESC = 'Current' THEN STD_RB_MT_UTL ELSE 0 END), 
	STD_ARB_RET = (CASE WHEN STD_CURR_YR_DESC = 'Current' THEN STD_RB_RET ELSE 0 END), 
	STD_ARB_ULT_RET = (CASE WHEN STD_CURR_YR_DESC = 'Current' THEN STD_RB_RET_UTL ELSE 0 END), 
	STD_NPH_BAS = (CASE WHEN STD_CURR_YR_DESC = 'Current' THEN STD_NPH_BAS ELSE 0 END), 
	STD_ORA_POL_CNT_FST_ON = (CASE WHEN STD_LOOK = '1-Look' THEN STD_NPH_BAS ELSE 0 END), 
	STD_ORA_POL_CNT_SEC_ON = (CASE WHEN STD_LOOK = '2-Look' THEN STD_NPH_BAS ELSE 0 END), 
	STD_ORA_POL_CNT_FST_OFF = 0, STD_ORA_POL_CNT_SEC_OFF = 0, 
	STD_ORA_FC_CO = (CASE WHEN STD_CURR_YR_DESC = 'Current' THEN STD_NPH_FC_CO ELSE 0 END), 
	STD_ORA_FC_AGT_NP_FST_ON = (CASE WHEN STD_LOOK = '1-Look' THEN STD_NPH_FC_AGT_NP ELSE 0 END), 
	STD_ORA_FC_AGT_NP_SEC_ON = (CASE WHEN STD_LOOK = '2-Look' THEN STD_NPH_FC_AGT_NP ELSE 0 END), 
	STD_ORA_FC_AGT_NP_ON = (CASE WHEN STD_CURR_YR_DESC = 'Current' THEN STD_NPH_FC_AGT_NP ELSE 0 END), 
	STD_ORA_FC_AGT_NP_FST_OFF = 0, STD_ORA_FC_AGT_NP_SEC_OFF = 0, STD_ORA_FC_AGT_NP_OFF = 0, 
	STD_ORA_ULT_FC_AGT_NP = (CASE WHEN STD_CURR_YR_DESC = 'Current' THEN STD_NPH_AGT_NP_ULT ELSE 0 END), 
	STD_ORA_MT = (CASE WHEN STD_CURR_YR_DESC = 'Current' THEN STD_NPH_MT ELSE 0 END), 
	STD_ORA_ULT_MT = (CASE WHEN STD_CURR_YR_DESC = 'Current' THEN STD_NPH_MT_ULT ELSE 0 END), 
	STD_ORA_REW = (CASE WHEN STD_CURR_YR_DESC = 'Current' THEN STD_RB_REW + STD_NPH_REW ELSE 0 END), 
	STD_ORA_ULT_REW = (CASE WHEN STD_CURR_YR_DESC = 'Current' THEN STD_RB_REW + STD_NPH_REW ELSE 0 END), 
	STD_ORA_RET = (CASE WHEN STD_CURR_YR_DESC = 'Current' THEN STD_NPH_RET ELSE 0 END), 
	STD_ORA_ULT_RET = (CASE WHEN STD_CURR_YR_DESC = 'Current' THEN STD_NPH_RET_ULT ELSE 0 END), 
	STD_BNB_POL_CNT = (CASE WHEN STD_CURR_YR_DESC = 'Current' THEN STD_BNB ELSE 0 END), 
	STD_BNB_POL_CNT_FST_ON = (CASE WHEN STD_LOOK = '1-Look' THEN STD_BNB ELSE 0 END), 
	STD_BNB_POL_CNT_SEC_ON = (CASE WHEN STD_LOOK = '2-Look' THEN STD_BNB ELSE 0 END), 
	STD_BNB_POL_CNT_FST_OFF = 0, STD_BNB_POL_CNT_SEC_OFF = 0, 
	STD_BNB_ULT_POL_CNT = (CASE WHEN STD_CURR_YR_DESC = 'Current' THEN STD_BNB_ULT ELSE 0 END), 
	STD_BNB_FC_CO = (CASE WHEN STD_CURR_YR_DESC = 'Current' THEN STD_NB_FC_CO ELSE 0 END), 
	STD_BNB_FC_AGT_NP_FST_ON = (CASE WHEN STD_LOOK = '1-Look' THEN STD_NB_FC_AGT_NP ELSE 0 END), 
	STD_BNB_FC_AGT_NP_SEC_ON = (CASE WHEN STD_LOOK = '2-Look' THEN STD_NB_FC_AGT_NP ELSE 0 END), 
	STD_BNB_FC_AGT_NP_ON = (CASE WHEN STD_CURR_YR_DESC = 'Current' THEN STD_NB_FC_AGT_NP ELSE 0 END), 
	STD_BNB_FC_AGT_NP_FST_OFF = 0, STD_BNB_FC_AGT_NP_SEC_OFF = 0, STD_BNB_FC_AGT_NP_OFF = 0, 
	STD_BNB_ULT_FC_AGT_NP = (CASE WHEN STD_CURR_YR_DESC = 'Current' THEN STD_NB_AGT_NP_ULT ELSE 0 END), 
	STD_BNB_MT = (CASE WHEN STD_CURR_YR_DESC = 'Current' THEN STD_NB_MT ELSE 0 END), 
	STD_BNB_ULT_MT = (CASE WHEN STD_CURR_YR_DESC = 'Current' THEN STD_NB_MT_ULT ELSE 0 END), 
	STD_BNB_REW = (CASE WHEN STD_CURR_YR_DESC = 'Current' THEN STD_NB_REW ELSE 0 END), 
	STD_BNB_ULT_REW = (CASE WHEN STD_CURR_YR_DESC = 'Current' THEN STD_NB_REW ELSE 0 END), 
	STD_BNB_RET = (CASE WHEN STD_CURR_YR_DESC = 'Current' THEN STD_NB_RET ELSE 0 END), 
	STD_BNB_ULT_RET = (CASE WHEN STD_CURR_YR_DESC = 'Current' THEN STD_NB_RET_ULT ELSE 0 END), 
	STD_BNB_CH_EFF_DT = 0, STD_RRA_POL_CNT = 0, STD_RRA_POL_CNT_FST_ON = 0, STD_RRA_POL_CNT_SEC_ON = 0, STD_RRA_POL_CNT_FST_OFF = 0, 
	STD_RRA_POL_CNT_SEC_OFF = 0, STD_RRA_FC_CO = 0, STD_RRA_FC_AGT_NP_FST_ON = 0, STD_RRA_FC_AGT_NP_SEC_ON = 0, STD_RRA_FC_AGT_NP_ON = 0, STD_RRA_FC_AGT_NP_FST_OFF = 0, 
	STD_RRA_FC_AGT_NP_SEC_OFF = 0, STD_RRA_FC_AGT_NP_OFF = 0, STD_RRA_ULT_FC_AGT_NP = 0, STD_RRA_MT = 0, STD_RRA_ULT_MT = 0, STD_RRA_REW = 0, 
	STD_RRA_ULT_REW = 0, STD_RRA_RET = 0, STD_RRA_ULT_RET = 0, 
	STD_RPC_FST_ON = (CASE WHEN STD_LOOK = '1-Look' THEN STD_RPC_SEC_ON ELSE 0 END), 
	STD_RET_FST_ON = (CASE WHEN STD_LOOK = '1-Look' THEN STD_RETN_WRT_PRM ELSE 0 END), 
	STD_RPC_RT_FST_ON = (CASE WHEN STD_LOOK = '1-Look' THEN STD_RPC_RT_SEC_ON ELSE 0 END), 
	STD_RPC_AIL_FST_ON = (CASE WHEN STD_LOOK = '1-Look' THEN STD_RPC_AIL_SEC_ON ELSE 0 END), 
	STD_RPC_EXPOS_FST_ON = (CASE WHEN STD_LOOK = '1-Look' THEN STD_RPC_EXPOS_SEC_ON ELSE 0 END), 
	STD_RPC = (CASE WHEN STD_CURR_YR_DESC = 'Current' THEN STD_RPC_SEC_ON ELSE 0 END), 
	STD_RET = (CASE WHEN STD_CURR_YR_DESC = 'Current' THEN STD_RETN_WRT_PRM ELSE 0 END), 
	STD_RPC_RT = (CASE WHEN STD_CURR_YR_DESC = 'Current' THEN STD_RPC_RT_SEC_ON ELSE 0 END), 
	STD_RPC_AIL = (CASE WHEN STD_CURR_YR_DESC = 'Current' THEN STD_RPC_AIL_SEC_ON ELSE 0 END), 
	STD_RPC_EXPOS = (CASE WHEN STD_CURR_YR_DESC = 'Current' THEN STD_RPC_EXPOS_SEC_ON ELSE 0 END), 
	STD_ANNL_WRT_PRM_RB = (CASE WHEN STD_CURR_YR_DESC = 'Current' THEN STD_ACTUL_WRT_PRM - STD_NB_WRT_PRM ELSE 0 END), 
	STD_ANNL_WRT_PRM_BNB = (CASE WHEN STD_CURR_YR_DESC = 'Current' THEN STD_NB_WRT_PRM ELSE 0 END), 
	STD_ORG_WRT_PRM = (CASE WHEN STD_CURR_YR_DESC = 'Current' THEN STD_ACTUL_WRT_PRM ELSE 0 END), STD_ACQN_WRT_PRM = 0, 
	STD_COMB_WRT_PRM = (CASE WHEN STD_CURR_YR_DESC = 'Current' THEN STD_ACTUL_WRT_PRM ELSE 0 END), 
	STD_PRR_IN_FRC = (CASE WHEN STD_PRR_YR_DESC = 'Prior' THEN STD_RB_RET + STD_NPH_RET + STD_NB_RET ELSE 0 END), 
	STD_YR_END_IN_FRC = (CASE WHEN STD_YR_END_DESC = 'YREnd' THEN STD_RB_RET + STD_NPH_RET + STD_NB_RET ELSE 0 END),
	STD_LST_USER = @UserName, STD_LST_DT_TM = getdate()
	FROM STG_TNJ_DATA FTD
	
	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50401, 11, 'First Trenton Data Measure Columns: Update Statement failed'
		return 50401
	  END

    exec @ret = OthInsUserMessage
                @SessionId, 
                @FunctionName = @FunctionName, 
                @Task_Name = 'Update Statement: Measure Columns',
                @Status = 'Complete',
				@UserName = @UserName

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing update statement measure columns complete statement'
		return 50200
	  END

--OTHER COLUMNS UPDATE STATEMENT END HERE


--LINE UPDATE STATEMENT START HERE

	--SELECT [FD].Product, [FD].[Sub_Product], [FD].Code, [FD].Description
	UPDATE STG_TNJ_DATA 
	SET STD_BPM_LN_OF_BUS = CASE WHEN STD_BPM_SEG_NM = 'Standard Auto' THEN 'Auto' ELSE 'Property' END,
	STD_CHNL_NM = CASE WHEN STD_CHNL_GRP_NM = 'Affinity' THEN 'STD_AGEnt Sold' ELSE 'Domestics' END,
	STD_LST_USER = @UserName, STD_LST_DT_TM = getdate()
	FROM STG_TNJ_DATA FTD

	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50401, 11, 'First Trenton Data Line & Channel_Type Columns: Update Statement failed'
		return 50401
	  END

    exec @ret = OthInsUserMessage
                @SessionId, 
                @FunctionName = @FunctionName, 
                @Task_Name = 'Update Statement: Line & Channel_Type',
                @Status = 'Complete',
				@UserName = @UserName

	IF  @ret != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing update statement line & channel_type column complete statement'
		return 50200
	  END

--LINE UPDATE STATEMENT END HERE

--EXTRACT STATUS: TRENTON COLUMN UPDATE STATEMENT START HERE

	UPDATE CRIT_STS_XTRCT SET CSX_TNJ_IND = 'Y', CSX_LST_USER = @UserName, CSX_LST_DT_TM = GETDATE()
	WHERE CSX_YR_MO = @YearMonth

	IF  @@error != 0 
	  BEGIN 
		exec OthInsErrorMessage @SessionId, @FunctionName, 50801, 11, 'Extract Status table: Trenton column update statement did not succeed'
		return 50801
	  END

--EXTRACT STATUS: TRENTON COLUMN UPDATE STATEMENT END HERE

  END

set nocount off

RETURN 0

GO
--------------------------------------------------------------------------------------------------------------------------------------------
-- Drop Procedure
--------------------------------------------------------------------------------------------------------------------------------------------
if exists (select * from sys.sysobjects where id = object_id(N'[dbo].[UsrGetSessionId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[UsrGetSessionId]
GO

CREATE PROCEDURE UsrGetSessionId
(
	@FunctionName	udtName,
	@UserCode		udtCode,
	@DomainName		udtName,
	@MachineName	udtName,
	@SessionId		udtInteger output
)
AS
--------------------------------------------------------------------------------------------------------------------------------------------
-- OBJECT NAME:    UsrGetSessionId
--------------------------------------------------------------------------------------------------------------------------------------------
-- AUTHOR:			VIJAYA KUMAR GULAPPA
--------------------------------------------------------------------------------------------------------------------------------------------
-- CREATED:			MAY 17 2007
--------------------------------------------------------------------------------------------------------------------------------------------
-- DESCRIPTION:    Get Session ID
--------------------------------------------------------------------------------------------------------------------------------------------
-- PARAMETERS:     <To be inserted>
--------------------------------------------------------------------------------------------------------------------------------------------
-- RETURNS:        0                -  success
--                 <To be inserted>
--                 returns from SQL Server
--------------------------------------------------------------------------------------------------------------------------------------------

-- VERSION: $Revision: 8 $  UPDATED: $Modtime: 8/02/07 3:49p $
--------------------------------------------------------------------------------------------------------------------------------------------

declare	
	@LDomainName	udtName, 
	@LMachineName	udtName

set nocount on
Set @FunctionName = OBJECT_NAME(@@PROCID)
Set	@SessionId = 0

SELECT	@SessionId = UMS_PK_ID, @LDomainName = UMS_DOM_NM, @LMachineName = UMS_MACH_NM
FROM	USER_MSTR_SESS
WHERE 	UMS_CD = @UserCode And UMS_DOM_NM = @DomainName And UMS_MACH_NM = @MachineName And
UMS_ENAB_IND = 'Y'

IF  @@error != 0 
  BEGIN 
    exec OthInsErrorMessage @SessionId, @FunctionName, 50103, 11, 'Get user record failed', @UserCode
	return 50103
  END

IF @SessionId = 0
  BEGIN 
    exec OthInsErrorMessage @SessionId, @FunctionName, 50104, 11, 'User code does not exists', @UserCode
	return 50104
  END

set nocount off
select @SessionId
return 0

GO
--------------------------------------------------------------------------------------------------------------------------------------------
-- Drop Procedure
--------------------------------------------------------------------------------------------------------------------------------------------
if exists (select * from sys.sysobjects where id = object_id(N'[dbo].[UsrGetSessionInfo]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[UsrGetSessionInfo]
GO

CREATE PROCEDURE UsrGetSessionInfo
(	@SessionId				[udtInteger],
	@FunctionName			[udtName],
	@UMS_AT_Code			[udtCode] = null output,
	@UMS_AT_Name			[udtName] = null output,
	@UMS_AT_DomainName		[udtName] = null output,
	@UMS_AT_MachineName		[udtName] = null output,
	@UMS_AT_Enabled			[udtName] = null output,
	@LastUser				[udtUserName] = null output,
	@LastDateTime			[udtDateTime] = null output,
	@CreateUser				[udtUserName] = null output,
	@CreateDateTime			[udtDateTime] = null  output
)

AS 
--------------------------------------------------------------------------------------------------------------------------------------------
-- OBJECT NAME:    UsrGetSessionInfo
--------------------------------------------------------------------------------------------------------------------------------------------
-- AUTHOR:			VIJAYA KUMAR GULAPPA
--------------------------------------------------------------------------------------------------------------------------------------------
-- CREATED:			MAY 17 2007
--------------------------------------------------------------------------------------------------------------------------------------------
-- DESCRIPTION:    	Get User record for a given session id
--------------------------------------------------------------------------------------------------------------------------------------------
-- PARAMETERS:     <To be inserted>
--------------------------------------------------------------------------------------------------------------------------------------------
-- RETURNS:        0                -  success
--                 <To be inserted>
--                 returns from SQL Server
--------------------------------------------------------------------------------------------------------------------------------------------

-- VERSION: $Revision: 5 $  UPDATED: $Modtime: 8/08/07 2:33p $
--------------------------------------------------------------------------------------------------------------------------------------------

declare @ret int

set nocount on
Set @FunctionName = OBJECT_NAME(@@PROCID)

SELECT 
	@UMS_AT_Code = UMS_CD,	@UMS_AT_Name = UMS_NM,	@UMS_AT_DomainName = UMS_DOM_NM,	
	@UMS_AT_MachineName = UMS_MACH_NM, @UMS_AT_Enabled = UMS_ENAB_IND, 
	@LastUser = UMS_LST_USER, @LastDateTime = UMS_LST_DT_TM,
	@CreateUser = UMS_CREAT_USER, @CreateDateTime = UMS_CREAT_DT_TM
FROM USER_MSTR_SESS
WHERE UMS_PK_ID = @SessionId

IF  @@error != 0 
  BEGIN 
    exec OthInsErrorMessage @SessionId, @FunctionName, 50103, 11, @FunctionName
	return 50103
  END

set nocount off

return 0

GO

-- 
--------------------------------------------------------------------------------------------------------------------------------------------
-- Drop Procedure
--------------------------------------------------------------------------------------------------------------------------------------------
if exists (select * from sysobjects where id = object_id(N'[dbo].[ConCheckHoliday]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ConCheckHoliday]
GO

CREATE PROCEDURE ConCheckHoliday
(	
	@SessionId		[udtNumber],
	@FunctionName	[udtName],
	@UserName		[udtName],
	@Hol_Date		[udtDateTime],
	@IsHoliday		[udtNumber] output
)
AS
--------------------------------------------------------------------------------------------------------------------------------------------
-- OBJECT NAME:    	ConCheckHoliday
--------------------------------------------------------------------------------------------------------------------------------------------
-- AUTHOR:			VIJAYA KUMAR GULAPPA
--------------------------------------------------------------------------------------------------------------------------------------------
-- CREATED:			AUG 15 2007
--------------------------------------------------------------------------------------------------------------------------------------------
-- DESCRIPTION:    	Checks if the date is a holiday and returns 0/1
--------------------------------------------------------------------------------------------------------------------------------------------
-- PARAMETERS:     	
--------------------------------------------------------------------------------------------------------------------------------------------
-- RETURNS:        	0               -  	success
--                 	1		-	failure
--------------------------------------------------------------------------------------------------------------------------------------------
-- VERSION: $Revision: 1 $  UPDATED: $Modtime: 8/15/07 8:57a $
--------------------------------------------------------------------------------------------------------------------------------------------

declare	@ret int

set nocount on
set @IsHoliday = 0
set @ret = 0

if exists(select CMH_PK_ID from CNFG_MSTR_HOL where CMH_DT = @Hol_Date)
begin
	Set @IsHoliday = 1
end

IF  @@error != 0 
  BEGIN 
	exec OthInsErrorMessage @SessionId, @FunctionName, 52203, 11, 'CNFG_MSTR_HOL: select Statement failed'
	return 52203
  END

exec @ret = OthInsUserMessage
            @SessionId, 
            @FunctionName = @FunctionName, 
            @Task_Name = 'Select Statement: CNFG_MSTR_HOL ',
            @Status = 'Complete',
			@UserName = @UserName

IF  @ret != 0 
  BEGIN 
	exec OthInsErrorMessage @SessionId, @FunctionName, 50200, 11, 'Whilst writing select statement CNFG_MSTR_HOL complete statement'
	return 50200
  END

set nocount off

return 0

GO

PRINT '======= FMR Stored Procedure Objects Complete ========'
PRINT ''

IF EXISTS (SELECT OBJECT_ID FROM SYS.VIEWS WHERE NAME = 'EMR_Auto_Retention_Report')
DROP VIEW EMR_Auto_Retention_Report
GO

CREATE VIEW EMR_Auto_Retention_Report AS
SELECT 
	FDFMR_SRC_NM, FDFMR_BPM_LN_OF_BUS, FDFMR_BPM_SEG_NM, FDFMR_BPM_PRDCT_NM AS Products, FDFMR_RT_PLN_GRP_NM, FDFMR_CHNL_GRP_NM, FDFMR_CHNL_NM, 
	FDFMR_SUB_CHNL, FDFMR_ST_NM, FDFMR_SPC, FDFMR_PM_RGN_NM, FDFMR_STRG, FDFMR_TRM, 
	FDFMR_EFF_YR, FDFMR_EFF_MO, FDFMR_FISC_YR, 
	Sum(FDFMR_ARB_ULT_POL_CNT) AS [Available Base], Sum(FDFMR_ARB_ULT_RET) AS [Ultimate Avail Retained], 
	Sum(FDFMR_ORA_ULT_RET) AS [Ultimate Other Renewal Retained], Sum(FDFMR_BNB_ULT_RET) AS [Ultimate Booked New Retained], 
	Sum(FDFMR_RRA_ULT_RET) AS [Ultimate Acquisition Retained], Sum(FDFMR_RPC_AMT) AS [RPC Dollars], 
	Sum(FDFMR_BAS_WRT_PRM) AS [Retained WP], Sum(FDFMR_RPC_RT_AMT) AS [Rate Dollars], 
	Sum(FDFMR_ARB_RET) AS [Current Avail Retained], 
	Sum(FDFMR_ORA_RET) AS [Current Other Renewal Retained], Sum(FDFMR_BNB_RET) AS [Current Booked New Retained], 
	Sum(FDFMR_RRA_RET) AS [Current Acquisition Retained], Sum(FDFMR_PRR_IN_FRC_AMT) AS [Prior In Force], 
	Sum(FDFMR_YR_END_IN_FRC_AMT) AS [YE In Force], Sum(FDFMR_COMB_WRT_PRM_AMT) AS [Written Premium], 
	Sum(FDFMR_CURR_IN_FRC_AMT) AS PIF 
FROM FACT_DTL_FIN_MGT_RPT
WHERE FDFMR_BPM_LN_OF_BUS = 'Auto'
GROUP BY 
	FDFMR_SRC_NM, FDFMR_BPM_LN_OF_BUS, FDFMR_BPM_SEG_NM, FDFMR_BPM_PRDCT_NM, FDFMR_RT_PLN_GRP_NM, FDFMR_CHNL_GRP_NM, FDFMR_CHNL_NM, 
	FDFMR_SUB_CHNL, FDFMR_ST_NM, FDFMR_SPC, 
	FDFMR_PM_RGN_NM, FDFMR_STRG, FDFMR_TRM, FDFMR_EFF_YR, FDFMR_EFF_MO, FDFMR_FISC_YR
HAVING FDFMR_EFF_YR >= 2004;
GO

IF EXISTS (SELECT OBJECT_ID FROM SYS.VIEWS WHERE NAME = 'EMR_Prop_Retention_Report')
DROP VIEW EMR_Prop_Retention_Report
GO

CREATE VIEW EMR_Prop_Retention_Report AS
SELECT 
	FDFMR_SRC_NM, FDFMR_BPM_LN_OF_BUS, FDFMR_BPM_SEG_NM, FDFMR_BPM_PRDCT_NM AS Products, FDFMR_RT_PLN_GRP_NM, FDFMR_CHNL_GRP_NM, FDFMR_CHNL_NM, 
	FDFMR_SUB_CHNL, FDFMR_ST_NM, FDFMR_PM_RGN_NM, FDFMR_STRG, FDFMR_TRM, 
	FDFMR_EFF_YR, FDFMR_EFF_MO, FDFMR_FISC_YR, 
	Sum(FDFMR_ARB_ULT_POL_CNT) AS [Available Base], Sum(FDFMR_ARB_ULT_RET) AS [Ultimate Avail Retained], 
	Sum(FDFMR_ORA_ULT_RET) AS [Ultimate Other Renewal Retained], Sum(FDFMR_BNB_ULT_RET) AS [Ultimate Booked New Retained], 
	Sum(FDFMR_RRA_ULT_RET) AS [Ultimate Acquisition Retained], Sum(FDFMR_RPC_AMT) AS [RPC Dollars], 
	Sum(FDFMR_BAS_WRT_PRM) AS [Retained WP], Sum(FDFMR_RPC_RT_AMT) AS [Rate Dollars], 
	Sum(FDFMR_ARB_RET) AS [Current Avail Retained], 
	Sum(FDFMR_ORA_RET) AS [Current Other Renewal Retained], Sum(FDFMR_BNB_RET) AS [Current Booked New Retained], 
	Sum(FDFMR_RRA_RET) AS [Current Acquisition Retained], Sum(FDFMR_PRR_IN_FRC_AMT) AS [Prior In Force], 
	Sum(FDFMR_YR_END_IN_FRC_AMT) AS [YE In Force], Sum(FDFMR_COMB_WRT_PRM_AMT) AS [Written Premium], 
	Sum(FDFMR_CURR_IN_FRC_AMT) AS PIF 
FROM FACT_DTL_FIN_MGT_RPT
WHERE FDFMR_BPM_LN_OF_BUS = 'Property'
GROUP BY 
	FDFMR_SRC_NM, FDFMR_BPM_LN_OF_BUS, FDFMR_BPM_SEG_NM, FDFMR_BPM_PRDCT_NM, FDFMR_RT_PLN_GRP_NM, FDFMR_CHNL_GRP_NM, FDFMR_CHNL_NM, 
	FDFMR_SUB_CHNL, FDFMR_ST_NM, FDFMR_PM_RGN_NM, FDFMR_STRG, FDFMR_TRM, 
	FDFMR_EFF_YR, FDFMR_EFF_MO, FDFMR_FISC_YR
HAVING FDFMR_EFF_YR >= 2004;
GO

IF EXISTS (SELECT OBJECT_ID FROM SYS.VIEWS WHERE NAME = 'EMR_Prop_RPC_Dev_Report')
DROP VIEW EMR_Prop_RPC_Dev_Report
GO

CREATE VIEW EMR_Prop_RPC_Dev_Report AS
SELECT 
	FDFMR_SRC_NM, FDFMR_BPM_LN_OF_BUS, FDFMR_BPM_SEG_NM, FDFMR_BPM_PRDCT_NM AS Products, FDFMR_RT_PLN_GRP_NM, FDFMR_CHNL_GRP_NM, 
	FDFMR_ST_NM, FDFMR_TRM, FDFMR_EFF_YR, FDFMR_EFF_MO, FDFMR_FISC_YR,
	Sum(FDFMR_ARB_ULT_POL_CNT) AS [Available Base], Sum(FDFMR_ARB_ULT_RET) AS [Ultimate Avail Retained], 
	Sum(FDFMR_ORA_ULT_RET) AS [Ultimate Other Renewal Retained], Sum(FDFMR_BNB_ULT_RET) AS [Ultimate Booked New Retained], 
	Sum(FDFMR_RRA_ULT_RET) AS [Ultimate Acquisition Retained], Sum(FDFMR_RPC_AMT) AS [RPC Dollars], 
	Sum(FDFMR_BAS_WRT_PRM) AS [Retained WP], Sum(FDFMR_RPC_RT_AMT) AS [Rate Dollars], 
	Sum(FDFMR_ARB_RET) AS [Current Avail Retained], Sum(FDFMR_ORA_RET) AS [Current Other Renewal Retained], 
	Sum(FDFMR_BNB_RET) AS [Current Booked New Retained], Sum(FDFMR_RRA_RET) AS [Current Acquisition Retained], 
	Sum(FDFMR_PRR_IN_FRC_AMT) AS [Prior In Force], Sum(FDFMR_YR_END_IN_FRC_AMT) AS [YE In Force], 
	Sum(FDFMR_COMB_WRT_PRM_AMT) AS [Written Premium], Sum(FDFMR_CURR_IN_FRC_AMT) AS PIF 
FROM FACT_DTL_FIN_MGT_RPT
WHERE FDFMR_BPM_LN_OF_BUS = 'Property'
GROUP BY
	FDFMR_SRC_NM, FDFMR_BPM_LN_OF_BUS, FDFMR_BPM_SEG_NM, FDFMR_BPM_PRDCT_NM, FDFMR_RT_PLN_GRP_NM, FDFMR_CHNL_GRP_NM, 
	FDFMR_ST_NM, FDFMR_TRM, FDFMR_EFF_YR, FDFMR_EFF_MO, FDFMR_FISC_YR
HAVING FDFMR_EFF_YR >= 2004;
GO

IF EXISTS (SELECT OBJECT_ID FROM SYS.VIEWS WHERE NAME = 'TM1_Production_Data')
DROP VIEW TM1_Production_Data
GO

CREATE VIEW TM1_Production_Data AS
SELECT 
	CASE WHEN DATEPART(M, GETDATE()) = 1 THEN CAST(DATEPART(YYYY, GETDATE()) - 1 AS VARCHAR(4)) + '12' ELSE
	CAST(DATEPART(YYYY, GETDATE()) AS VARCHAR(4)) + '0' + RIGHT(DATEPART(M, GETDATE()) - 1, 2)
	END AS [Evaluation Period],
	FDFMR_SRC_NM, FDFMR_BPM_LN_OF_BUS, FDFMR_BPM_SEG_NM, 
	(CASE WHEN FDFMR_BPM_PRDCT_NM = 'Plus' THEN 'OPL - Umbrella' ELSE 
		(CASE WHEN FDFMR_BPM_SEG_NM = 'Homeowners' THEN 'HO - ' + FDFMR_BPM_PRDCT_NM ELSE 
			(CASE WHEN FDFMR_BPM_SEG_NM IN ('Other Personal Lines', 'Specialty') THEN 'OPL - ' + FDFMR_BPM_PRDCT_NM ELSE 
				(CASE WHEN FDFMR_BPM_PRDCT_NM = 'AIPCR' THEN 'AIP - Credit' ELSE 
					(CASE WHEN FDFMR_RT_PLN_GRP_NM = 'AIP/Facility' THEN 'Auto - TAP' ELSE
						(CASE WHEN FDFMR_RT_PLN_GRP_NM = 'Trav Auto Pgm' THEN 'Auto - TAP' ELSE 
							(CASE WHEN FDFMR_BPM_PRDCT_NM = 'Standard Auto' THEN 'Auto - ' + FDFMR_RT_PLN_GRP_NM ELSE
								(CASE WHEN FDFMR_BPM_PRDCT_NM = 'Basic' THEN 'Auto - ' + FDFMR_BPM_PRDCT_NM ELSE 
									(CASE WHEN FDFMR_BPM_PRDCT_NM = 'Standard' THEN 'Auto - ' + FDFMR_BPM_PRDCT_NM END)
								END)
							END)
						END)
					END)
				END)
			END)
		END)
	END) AS Products,
	(CASE WHEN FDFMR_CHNL_NM IN ('Retail', 'Domestics') THEN FDFMR_CHNL_NM ELSE FDFMR_CHNL_GRP_NM END) AS Channels,
	(CASE WHEN FDFMR_CHNL_NM = 'Domestics' THEN FDFMR_SUB_CHNL ELSE 
		(CASE WHEN FDFMR_SUB_CHNL = 'Partnership' THEN FDFMR_CHNL_GRP_NM + ' ' + FDFMR_SUB_CHNL ELSE
			(CASE WHEN FDFMR_CHNL_GRP_NM = 'Affinity' THEN FDFMR_CHNL_GRP_NM + ' ' + FDFMR_CHNL_NM 
				ELSE FDFMR_CHNL_NM 
			END) 
		END) 
	END) AS Sub_Channel,
	FDFMR_ST_NM, FDFMR_PM_RGN_NM, FDFMR_STRG, FDFMR_TRM, 
	FDFMR_EFF_YR, FDFMR_EFF_MO, FDFMR_EFF_YR_MO, FDFMR_FISC_YR, 
	Sum(FDFMR_ARB_ULT_POL_CNT) AS [Available Base], Sum(FDFMR_ARB_POL_CNT) AS [Not Ult AB], 
	Sum(FDFMR_ARB_ULT_RET) AS [Ultimate Avail Retained], Sum(FDFMR_ORA_ULT_RET) AS [Ultimate Other Renewal Retained], 
	Sum(FDFMR_BNB_ULT_RET) AS [Ultimate Booked New Retained], Sum(FDFMR_RRA_ULT_RET) AS [Ultimate Acquisition Retained], 
	Sum(FDFMR_RPC_AMT) AS [RPC Dollars], Sum(FDFMR_BAS_WRT_PRM) AS [Retained WP], Sum(FDFMR_RPC_RT_AMT) AS [Rate Dollars], 
	Sum(FDFMR_ARB_RET) AS [Current Avail Retained], Sum(FDFMR_ORA_RET) AS [Current Other Renewal Retained], 
	Sum(FDFMR_BNB_RET) AS [Current Booked New Retained], Sum(FDFMR_RRA_RET) AS [Current Acquisition Retained], 
	Sum(FDFMR_COMB_WRT_PRM_AMT) AS [Written Premium]
FROM FACT_DTL_FIN_MGT_RPT
GROUP BY 
	FDFMR_SRC_NM, FDFMR_BPM_LN_OF_BUS, FDFMR_BPM_SEG_NM, 
	(CASE WHEN FDFMR_BPM_PRDCT_NM = 'Plus' THEN 'OPL - Umbrella' ELSE 
		(CASE WHEN FDFMR_BPM_SEG_NM = 'Homeowners' THEN 'HO - ' + FDFMR_BPM_PRDCT_NM ELSE 
			(CASE WHEN FDFMR_BPM_SEG_NM IN ('Other Personal Lines', 'Specialty') THEN 'OPL - ' + FDFMR_BPM_PRDCT_NM ELSE 
				(CASE WHEN FDFMR_BPM_PRDCT_NM = 'AIPCR' THEN 'AIP - Credit' ELSE 
					(CASE WHEN FDFMR_RT_PLN_GRP_NM = 'AIP/Facility' THEN 'Auto - TAP' ELSE
						(CASE WHEN FDFMR_RT_PLN_GRP_NM = 'Trav Auto Pgm' THEN 'Auto - TAP' ELSE 
							(CASE WHEN FDFMR_BPM_PRDCT_NM = 'Standard Auto' THEN 'Auto - ' + FDFMR_RT_PLN_GRP_NM ELSE
								(CASE WHEN FDFMR_BPM_PRDCT_NM = 'Basic' THEN 'Auto - ' + FDFMR_BPM_PRDCT_NM ELSE 
									(CASE WHEN FDFMR_BPM_PRDCT_NM = 'Standard' THEN 'Auto - ' + FDFMR_BPM_PRDCT_NM END)
								END)
							END)
						END)
					END)
				END)
			END)
		END)
	END),
	(CASE WHEN FDFMR_CHNL_NM IN ('Retail', 'Domestics') THEN FDFMR_CHNL_NM ELSE FDFMR_CHNL_GRP_NM END), 
	(CASE WHEN FDFMR_CHNL_NM = 'Domestics' THEN FDFMR_SUB_CHNL ELSE 
		(CASE WHEN FDFMR_SUB_CHNL = 'Partnership' THEN FDFMR_CHNL_GRP_NM + ' ' + FDFMR_SUB_CHNL ELSE
			(CASE WHEN FDFMR_CHNL_GRP_NM = 'Affinity' THEN FDFMR_CHNL_GRP_NM + ' ' + FDFMR_CHNL_NM 
				ELSE FDFMR_CHNL_NM 
			END) 
		END) 
	END),
	FDFMR_ST_NM, FDFMR_PM_RGN_NM, FDFMR_STRG, 
	FDFMR_TRM, FDFMR_EFF_YR, FDFMR_EFF_MO, FDFMR_EFF_YR_MO, FDFMR_FISC_YR
--HAVING FDFMR_EFF_YR >= 2004;
GO

IF EXISTS (SELECT OBJECT_ID FROM SYS.VIEWS WHERE NAME = 'Auto_Home_PIF')
DROP VIEW Auto_Home_PIF
GO

CREATE VIEW Auto_Home_PIF AS 
SELECT 
CASE WHEN DATEPART(M, GETDATE()) = 1 THEN 12 ELSE DATEPART(M, GETDATE()) - 1 END AS [RPT Month],
FDFMR_BPM_LN_OF_BUS, FDFMR_BPM_SEG_NM AS Product, FDFMR_BPM_PRDCT_NM AS [Sub Product], FDFMR_RT_PLN_GRP_NM, FDFMR_CHNL_GRP_NM AS Market, 
FDFMR_CHNL_NM, FDFMR_PM_RGN_NM AS Region, FDFMR_ST_NM AS [State Name], 
SUM(CASE WHEN FDFMR_EFF_YR = DATEPART(YYYY, GETDATE()) - 1 AND 
FDFMR_EFF_MO <= (CASE WHEN DATEPART(M, GETDATE()) = 1 THEN 12 ELSE DATEPART(M, GETDATE()) - 1 END)
THEN (FDFMR_BNB_ULT_RET + FDFMR_RRA_ULT_RET) ELSE 0 END) AS [PY Ult NB],
SUM(CASE WHEN FDFMR_EFF_YR = DATEPART(YYYY, GETDATE()) THEN (FDFMR_BNB_ULT_RET + FDFMR_RRA_ULT_RET) 
ELSE 0 END) AS [CY Ult NB], 
SUM(CASE WHEN FDFMR_EFF_YR = DATEPART(YYYY, GETDATE()) And 
FDFMR_EFF_MO = (CASE WHEN DATEPART(M, GETDATE()) = 1 THEN 12 ELSE DATEPART(M, GETDATE()) - 1 END)
THEN (FDFMR_ARB_ULT_RET + FDFMR_ORA_ULT_RET + FDFMR_BNB_ULT_RET + FDFMR_RRA_ULT_RET) ELSE 0 END) AS [CM Ult Pols], 
SUM(CASE WHEN FDFMR_EFF_YR = DATEPART(YYYY, GETDATE()) - 1 And 
FDFMR_EFF_MO = (CASE WHEN DATEPART(M, GETDATE()) = 1 THEN 12 ELSE DATEPART(M, GETDATE()) - 1 END) 
THEN (FDFMR_ARB_ULT_RET + FDFMR_ORA_ULT_RET + FDFMR_BNB_ULT_RET + FDFMR_RRA_ULT_RET) ELSE 0 END) AS [PM Ult Pols], 
SUM (CASE WHEN FDFMR_EFF_YR = DATEPART(YYYY, GETDATE()) - 1  
THEN (FDFMR_ARB_ULT_RET + FDFMR_ORA_ULT_RET + FDFMR_BNB_ULT_RET + FDFMR_RRA_ULT_RET) ELSE 0 END) AS [PY End Ult Pols], 
(SUM(CASE WHEN FDFMR_EFF_YR = DATEPART(YYYY, GETDATE()) - 1 And 
FDFMR_EFF_MO > (CASE WHEN DATEPART(M, GETDATE()) = 1 THEN 12 ELSE DATEPART(M, GETDATE()) - 1 END)
THEN (FDFMR_ARB_ULT_RET + FDFMR_ORA_ULT_RET + FDFMR_BNB_ULT_RET + FDFMR_RRA_ULT_RET) ELSE 0 END)) + 
(SUM(CASE WHEN FDFMR_EFF_YR = DATEPART(YYYY, GETDATE()) And 
FDFMR_EFF_MO <= (CASE WHEN DATEPART(M, GETDATE()) = 1 THEN 12 ELSE DATEPART(M, GETDATE()) - 1 END)
THEN (FDFMR_ARB_ULT_RET + FDFMR_ORA_ULT_RET + FDFMR_BNB_ULT_RET + FDFMR_RRA_ULT_RET) ELSE 0 END)) AS [R12 Writ Pols], 
SUM(CASE WHEN FDFMR_YR_END_IN_FRC_AMT != 0 THEN FDFMR_YR_END_IN_FRC_AMT ELSE 0 END) AS [PY End PIF], 
SUM(CASE WHEN FDFMR_PRR_IN_FRC_AMT != 0 THEN FDFMR_PRR_IN_FRC_AMT ELSE 0 END) AS [PY PIF],
(SUM(CASE WHEN FDFMR_EFF_YR = DATEPART(YYYY, GETDATE()) - 1 And 
FDFMR_EFF_MO > (CASE WHEN DATEPART(M, GETDATE()) = 1 THEN 12 ELSE DATEPART(M, GETDATE()) - 1 END)
THEN (FDFMR_ARB_RET + FDFMR_ORA_RET + FDFMR_BNB_RET + FDFMR_RRA_RET) ELSE 0 END)) + 
(SUM(CASE WHEN FDFMR_EFF_YR = DATEPART(YYYY, GETDATE()) And 
FDFMR_EFF_MO <= (CASE WHEN DATEPART(M, GETDATE()) = 1 THEN 12 ELSE DATEPART(M, GETDATE()) - 1 END)
THEN (FDFMR_ARB_RET + FDFMR_ORA_RET + FDFMR_BNB_RET + FDFMR_RRA_RET) ELSE 0 END))  AS [CY PIF], 
(SUM(CASE WHEN FDFMR_EFF_YR = DATEPART(YYYY, GETDATE()) - 1 And 
FDFMR_EFF_MO > (CASE WHEN DATEPART(M, GETDATE()) = 1 THEN 12 ELSE DATEPART(M, GETDATE()) - 1 END)
THEN FDFMR_ARB_ULT_POL_CNT ELSE 0 END)) + 
(SUM(CASE WHEN FDFMR_EFF_YR = DATEPART(YYYY, GETDATE()) And 
FDFMR_EFF_MO <= (CASE WHEN DATEPART(M, GETDATE()) = 1 THEN 12 ELSE DATEPART(M, GETDATE()) - 1 END)
THEN FDFMR_ARB_ULT_POL_CNT ELSE 0 END)) AS [12M Avail Base], 
FDFMR_CURR_IN_FRC_AMT
FROM FACT_DTL_FIN_MGT_RPT
GROUP BY 
FDFMR_BPM_LN_OF_BUS, FDFMR_BPM_SEG_NM, FDFMR_BPM_PRDCT_NM, FDFMR_RT_PLN_GRP_NM, FDFMR_CHNL_GRP_NM, 
FDFMR_CHNL_NM, FDFMR_PM_RGN_NM, FDFMR_ST_NM, FDFMR_CURR_IN_FRC_AMT
GO

IF EXISTS (SELECT OBJECT_ID FROM SYS.VIEWS WHERE NAME = 'JENS_AUTO_HOME')
DROP VIEW JENS_AUTO_HOME
GO

CREATE VIEW JENS_AUTO_HOME AS
SELECT 
FDFMR_BPM_LN_OF_BUS, FDFMR_BPM_SEG_NM, FDFMR_ST_NM, FDFMR_EFF_YR, 
SUM(FDFMR_CTL_LS_AMT) AS FDFMR_CTL_LS_AMT, SUM(FDFMR_EARN_PRM_AMT) AS FDFMR_EARN_PRM_AMT
FROM FACT_DTL_FIN_MGT_RPT
WHERE FDFMR_SRC_NM = 'PRODUCT REGION' AND 
FDFMR_BPM_SEG_NM = (CASE WHEN FDFMR_BPM_LN_OF_BUS = 'Property' THEN 'Homeowners' ELSE FDFMR_BPM_SEG_NM END)
GROUP BY FDFMR_BPM_LN_OF_BUS, FDFMR_BPM_SEG_NM, FDFMR_ST_NM, FDFMR_EFF_YR
GO

PRINT '======= FMR View Objects Complete ========'
PRINT ''

if exists (select * from sys.sysusers where name = N'FmrAdministrators')
  EXEC sp_droprole N'FmrAdministrators'
GO

EXEC sp_addrole N'FmrAdministrators'
GO

if exists (select * from sysusers where name = N'FmrDevelopers')
  EXEC sp_droprole N'FmrDevelopers'
GO

EXEC sp_addrole N'FmrDevelopers'
GO

if exists (select * from sysusers where name = N'FmrStaff')
  EXEC sp_droprole N'FmrStaff'
GO

EXEC sp_addrole N'FmrStaff'
GO

PRINT '======= FMR Database Roles Complete ========'
PRINT ''

USE [msdb]
GO
/****** Object:  Job [Control Report]    Script Date: 08/14/2007 08:46:18 ******/
IF  EXISTS (SELECT job_id FROM msdb.dbo.sysjobs_view WHERE name = N'Control Report')
EXEC msdb.dbo.sp_delete_job @job_name=N'Control Report', @delete_unused_schedule=1

/****** Object:  Job [Control Report]    Script Date: 08/13/2007 13:33:33 ******/
BEGIN TRANSACTION
DECLARE @ReturnCode INT
SELECT @ReturnCode = 0
/****** Object:  JobCategory [[Uncategorized (Local)]]]    Script Date: 08/13/2007 13:33:33 ******/
IF NOT EXISTS (SELECT name FROM msdb.dbo.syscategories WHERE name=N'[Uncategorized (Local)]' AND category_class=1)
BEGIN
EXEC @ReturnCode = msdb.dbo.sp_add_category @class=N'JOB', @type=N'LOCAL', @name=N'[Uncategorized (Local)]'
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback

END

DECLARE @jobId BINARY(16)
EXEC @ReturnCode =  msdb.dbo.sp_add_job @job_name=N'Control Report', 
		@enabled=1, 
		@notify_level_eventlog=0, 
		@notify_level_email=0, 
		@notify_level_netsend=0, 
		@notify_level_page=0, 
		@delete_level=0, 
		@description=N'No description available.', 
		@category_name=N'[Uncategorized (Local)]', 
		@owner_login_name=N'sa', @job_id = @jobId OUTPUT
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
/****** Object:  Step [Control Report]    Script Date: 08/13/2007 13:33:34 ******/
EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id=@jobId, @step_name=N'Control Report', 
		@step_id=1, 
		@cmdexec_success_code=0, 
		@on_success_action=1, 
		@on_success_step_id=0, 
		@on_fail_action=2, 
		@on_fail_step_id=0, 
		@retry_attempts=0, 
		@retry_interval=0, 
		@os_run_priority=0, @subsystem=N'SSIS', 
		@command=N'/FILE "C:\automation\Control Report.dtsx" /MAXCONCURRENT " -1 " /CHECKPOINTING OFF /REPORTING E', 
		@database_name=N'master', 
		@flags=0
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_update_job @job_id = @jobId, @start_step_id = 1
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_add_jobschedule @job_id=@jobId, @name=N'Control Report', 
		@enabled=1, 
		@freq_type=4, 
		@freq_interval=1, 
		@freq_subday_type=8, 
		@freq_subday_interval=1, 
		@freq_relative_interval=0, 
		@freq_recurrence_factor=0, 
		@active_start_date=20070813, 
		@active_end_date=99991231, 
		@active_start_time=0, 
		@active_end_time=235959
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_add_jobserver @job_id = @jobId, @server_name = N'(local)'
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
COMMIT TRANSACTION
GOTO EndSave
QuitWithRollback:
    IF (@@TRANCOUNT > 0) ROLLBACK TRANSACTION
EndSave:
GO

USE [msdb]
GO
/****** Object:  Job [Control Report]    Script Date: 08/14/2007 08:46:18 ******/
IF  EXISTS (SELECT job_id FROM msdb.dbo.sysjobs_view WHERE name = N'Earned Premium And Loss Ratio -- Disabled')
EXEC msdb.dbo.sp_delete_job @job_name=N'Earned Premium And Loss Ratio -- Disabled', @delete_unused_schedule=1
GO

/****** Object:  Job [Earned Premium And Loss Ratio -- Disabled]    Script Date: 08/13/2007 13:43:47 ******/
BEGIN TRANSACTION
DECLARE @ReturnCode INT
SELECT @ReturnCode = 0
/****** Object:  JobCategory [[Uncategorized (Local)]]]    Script Date: 08/13/2007 13:43:47 ******/
IF NOT EXISTS (SELECT name FROM msdb.dbo.syscategories WHERE name=N'[Uncategorized (Local)]' AND category_class=1)
BEGIN
EXEC @ReturnCode = msdb.dbo.sp_add_category @class=N'JOB', @type=N'LOCAL', @name=N'[Uncategorized (Local)]'
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback

END

DECLARE @jobId BINARY(16)
EXEC @ReturnCode =  msdb.dbo.sp_add_job @job_name=N'Earned Premium And Loss Ratio -- Disabled', 
		@enabled=0, 
		@notify_level_eventlog=0, 
		@notify_level_email=0, 
		@notify_level_netsend=0, 
		@notify_level_page=0, 
		@delete_level=0, 
		@description=N'No description available.', 
		@category_name=N'[Uncategorized (Local)]', 
		@owner_login_name=N'sa', @job_id = @jobId OUTPUT
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
/****** Object:  Step [Earned Premium And Loss Ratio -- Disabled]    Script Date: 08/13/2007 13:43:47 ******/
EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id=@jobId, @step_name=N'Earned Premium And Loss Ratio -- Disabled', 
		@step_id=1, 
		@cmdexec_success_code=0, 
		@on_success_action=1, 
		@on_success_step_id=0, 
		@on_fail_action=2, 
		@on_fail_step_id=0, 
		@retry_attempts=0, 
		@retry_interval=0, 
		@os_run_priority=0, @subsystem=N'SSIS', 
		@command=N'/FILE "C:\automation\Earned Premium And Loss Ratio.dtsx" /MAXCONCURRENT " -1 " /CHECKPOINTING OFF /REPORTING E', 
		@database_name=N'master', 
		@flags=0
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_update_job @job_id = @jobId, @start_step_id = 1
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_add_jobschedule @job_id=@jobId, @name=N'Earned Premium And Loss Ratio -- Disabled', 
		@enabled=0, 
		@freq_type=4, 
		@freq_interval=1, 
		@freq_subday_type=8, 
		@freq_subday_interval=1, 
		@freq_relative_interval=0, 
		@freq_recurrence_factor=0, 
		@active_start_date=20070813, 
		@active_end_date=99991231, 
		@active_start_time=0, 
		@active_end_time=235959
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_add_jobserver @job_id = @jobId, @server_name = N'(local)'
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
COMMIT TRANSACTION
GOTO EndSave
QuitWithRollback:
    IF (@@TRANCOUNT > 0) ROLLBACK TRANSACTION
EndSave:
GO

USE [msdb]
GO
/****** Object:  Job [Control Report]    Script Date: 08/14/2007 08:46:18 ******/
IF  EXISTS (SELECT job_id FROM msdb.dbo.sysjobs_view WHERE name = N'Indicated Combined Ratio -- Disabled')
EXEC msdb.dbo.sp_delete_job @job_name=N'Indicated Combined Ratio -- Disabled', @delete_unused_schedule=1
GO

/****** Object:  Job [Indicated Combined Ratio -- Disabled]    Script Date: 08/13/2007 13:45:33 ******/
BEGIN TRANSACTION
DECLARE @ReturnCode INT
SELECT @ReturnCode = 0
/****** Object:  JobCategory [[Uncategorized (Local)]]]    Script Date: 08/13/2007 13:45:33 ******/
IF NOT EXISTS (SELECT name FROM msdb.dbo.syscategories WHERE name=N'[Uncategorized (Local)]' AND category_class=1)
BEGIN
EXEC @ReturnCode = msdb.dbo.sp_add_category @class=N'JOB', @type=N'LOCAL', @name=N'[Uncategorized (Local)]'
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback

END

DECLARE @jobId BINARY(16)
EXEC @ReturnCode =  msdb.dbo.sp_add_job @job_name=N'Indicated Combined Ratio -- Disabled', 
		@enabled=0, 
		@notify_level_eventlog=0, 
		@notify_level_email=0, 
		@notify_level_netsend=0, 
		@notify_level_page=0, 
		@delete_level=0, 
		@description=N'No description available.', 
		@category_name=N'[Uncategorized (Local)]', 
		@owner_login_name=N'sa', @job_id = @jobId OUTPUT
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
/****** Object:  Step [Indicated Combined Ratio -- Disabled]    Script Date: 08/13/2007 13:45:34 ******/
EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id=@jobId, @step_name=N'Indicated Combined Ratio -- Disabled', 
		@step_id=1, 
		@cmdexec_success_code=0, 
		@on_success_action=1, 
		@on_success_step_id=0, 
		@on_fail_action=2, 
		@on_fail_step_id=0, 
		@retry_attempts=0, 
		@retry_interval=0, 
		@os_run_priority=0, @subsystem=N'SSIS', 
		@command=N'/FILE "C:\automation\Indicated Combined Ratio.dtsx" /MAXCONCURRENT " -1 " /CHECKPOINTING OFF /REPORTING E', 
		@database_name=N'master', 
		@flags=0
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_update_job @job_id = @jobId, @start_step_id = 1
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_add_jobschedule @job_id=@jobId, @name=N'Indicated Combined Ratio -- Disabled', 
		@enabled=0, 
		@freq_type=4, 
		@freq_interval=1, 
		@freq_subday_type=8, 
		@freq_subday_interval=1, 
		@freq_relative_interval=0, 
		@freq_recurrence_factor=0, 
		@active_start_date=20070813, 
		@active_end_date=99991231, 
		@active_start_time=0, 
		@active_end_time=235959
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_add_jobserver @job_id = @jobId, @server_name = N'(local)'
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
COMMIT TRANSACTION
GOTO EndSave
QuitWithRollback:
    IF (@@TRANCOUNT > 0) ROLLBACK TRANSACTION
EndSave:
GO

USE [msdb]
GO
/****** Object:  Job [Control Report]    Script Date: 08/14/2007 08:46:18 ******/
IF  EXISTS (SELECT job_id FROM msdb.dbo.sysjobs_view WHERE name = N'Policy In Force -- Disabled')
EXEC msdb.dbo.sp_delete_job @job_name=N'Policy In Force -- Disabled', @delete_unused_schedule=1
GO

/****** Object:  Job [Policy In Force -- Disabled]    Script Date: 08/13/2007 13:35:21 ******/
BEGIN TRANSACTION
DECLARE @ReturnCode INT
SELECT @ReturnCode = 0
/****** Object:  JobCategory [[Uncategorized (Local)]]]    Script Date: 08/13/2007 13:35:22 ******/
IF NOT EXISTS (SELECT name FROM msdb.dbo.syscategories WHERE name=N'[Uncategorized (Local)]' AND category_class=1)
BEGIN
EXEC @ReturnCode = msdb.dbo.sp_add_category @class=N'JOB', @type=N'LOCAL', @name=N'[Uncategorized (Local)]'
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback

END

DECLARE @jobId BINARY(16)
EXEC @ReturnCode =  msdb.dbo.sp_add_job @job_name=N'Policy In Force -- Disabled', 
		@enabled=0, 
		@notify_level_eventlog=0, 
		@notify_level_email=0, 
		@notify_level_netsend=0, 
		@notify_level_page=0, 
		@delete_level=0, 
		@description=N'No description available.', 
		@category_name=N'[Uncategorized (Local)]', 
		@owner_login_name=N'sa', @job_id = @jobId OUTPUT
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
/****** Object:  Step [Policy In Force -- Disabled]    Script Date: 08/13/2007 13:35:22 ******/
EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id=@jobId, @step_name=N'Policy In Force -- Disabled', 
		@step_id=1, 
		@cmdexec_success_code=0, 
		@on_success_action=1, 
		@on_success_step_id=0, 
		@on_fail_action=2, 
		@on_fail_step_id=0, 
		@retry_attempts=0, 
		@retry_interval=0, 
		@os_run_priority=0, @subsystem=N'SSIS', 
		@command=N'/FILE "C:\automation\Policy In Force.dtsx" /MAXCONCURRENT " -1 " /CHECKPOINTING OFF /REPORTING E', 
		@database_name=N'master', 
		@flags=0
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_update_job @job_id = @jobId, @start_step_id = 1
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_add_jobschedule @job_id=@jobId, @name=N'Policy In Force -- Disabled', 
		@enabled=0, 
		@freq_type=4, 
		@freq_interval=1, 
		@freq_subday_type=8, 
		@freq_subday_interval=1, 
		@freq_relative_interval=0, 
		@freq_recurrence_factor=0, 
		@active_start_date=20070813, 
		@active_end_date=99991231, 
		@active_start_time=0, 
		@active_end_time=235959
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_add_jobserver @job_id = @jobId, @server_name = N'(local)'
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
COMMIT TRANSACTION
GOTO EndSave
QuitWithRollback:
    IF (@@TRANCOUNT > 0) ROLLBACK TRANSACTION
EndSave:
GO

USE [msdb]
GO
/****** Object:  Job [Control Report]    Script Date: 08/14/2007 08:46:18 ******/
IF  EXISTS (SELECT job_id FROM msdb.dbo.sysjobs_view WHERE name = N'Retention -- Disabled')
EXEC msdb.dbo.sp_delete_job @job_name=N'Retention -- Disabled', @delete_unused_schedule=1
GO

/****** Object:  Job [Retention -- Disabled]    Script Date: 08/13/2007 13:46:52 ******/
BEGIN TRANSACTION
DECLARE @ReturnCode INT
SELECT @ReturnCode = 0
/****** Object:  JobCategory [[Uncategorized (Local)]]]    Script Date: 08/13/2007 13:46:52 ******/
IF NOT EXISTS (SELECT name FROM msdb.dbo.syscategories WHERE name=N'[Uncategorized (Local)]' AND category_class=1)
BEGIN
EXEC @ReturnCode = msdb.dbo.sp_add_category @class=N'JOB', @type=N'LOCAL', @name=N'[Uncategorized (Local)]'
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback

END

DECLARE @jobId BINARY(16)
EXEC @ReturnCode =  msdb.dbo.sp_add_job @job_name=N'Retention -- Disabled', 
		@enabled=0, 
		@notify_level_eventlog=0, 
		@notify_level_email=0, 
		@notify_level_netsend=0, 
		@notify_level_page=0, 
		@delete_level=0, 
		@description=N'No description available.', 
		@category_name=N'[Uncategorized (Local)]', 
		@owner_login_name=N'sa', @job_id = @jobId OUTPUT
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
/****** Object:  Step [Retention -- Disabled]    Script Date: 08/13/2007 13:46:52 ******/
EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id=@jobId, @step_name=N'Retention -- Disabled', 
		@step_id=1, 
		@cmdexec_success_code=0, 
		@on_success_action=1, 
		@on_success_step_id=0, 
		@on_fail_action=2, 
		@on_fail_step_id=0, 
		@retry_attempts=0, 
		@retry_interval=0, 
		@os_run_priority=0, @subsystem=N'SSIS', 
		@command=N'/FILE "C:\automation\Retention.dtsx" /MAXCONCURRENT " -1 " /CHECKPOINTING OFF /REPORTING E', 
		@database_name=N'master', 
		@flags=0
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_update_job @job_id = @jobId, @start_step_id = 1
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_add_jobschedule @job_id=@jobId, @name=N'Retention -- Disabled', 
		@enabled=0, 
		@freq_type=4, 
		@freq_interval=1, 
		@freq_subday_type=8, 
		@freq_subday_interval=1, 
		@freq_relative_interval=0, 
		@freq_recurrence_factor=0, 
		@active_start_date=20070813, 
		@active_end_date=99991231, 
		@active_start_time=0, 
		@active_end_time=235959
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_add_jobserver @job_id = @jobId, @server_name = N'(local)'
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
COMMIT TRANSACTION
GOTO EndSave
QuitWithRollback:
    IF (@@TRANCOUNT > 0) ROLLBACK TRANSACTION
EndSave:
GO

PRINT '======= FMR Database Jobs Complete ========'
PRINT ''

use master
GO
--------------------------------------------------------------------------------------------------------------------------------------------
-- HISTORY:
--
-- $History: SystemMessages.SQL $
-- 
--------------------------------------------------------------------------------------------------------------------------------------------
/* Retention File Extract: Current & History Trenton and Findb  */
/* Numbers from 50001 to 50099 */ 
exec sp_addmessage @msgnum = 50001, @severity=11, @msgtext='Error reading Trenton History file! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50002, @severity=11, @msgtext='Trenton History file (%s) does not exist!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50003, @severity=11, @msgtext='Trenton History file (%s) has no data!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50004, @severity=11, @msgtext='Error Trenton History file transfer failed! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50011, @severity=11, @msgtext='Error reading Trenton Current file! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50012, @severity=11, @msgtext='Trenton Current file (%s) does not exist!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50013, @severity=11, @msgtext='Trenton Current file (%s) has no data!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50014, @severity=11, @msgtext='Error Trenton Current file transfer failed! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50021, @severity=11, @msgtext='Error reading FINDB file! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50022, @severity=11, @msgtext='FINDB file (%s) does not exist!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50023, @severity=11, @msgtext='FINDB file (%s) has no data!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50024, @severity=11, @msgtext='Error FINDB file transfer failed! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50099, @severity=11, @msgtext='Error reading file transfer extract connection! %s', @lang='us_english', @replace='replace'

/* Session */
/* Numbers from 50100 to 50199 */ 
exec sp_addmessage @msgnum = 50100, @severity=11, @msgtext='Error adding User record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50101, @severity=11, @msgtext='Error updating User record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50102, @severity=11, @msgtext='Error deleting User record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50103, @severity=11, @msgtext='Error reading User record! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50104, @severity=11, @msgtext='User %s not found!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50105, @severity=11, @msgtext='Error reading User Id! %s', @lang='us_english', @replace='replace'

/* Message Log */
/* Numbers from 50200 to 50299 */ 
exec sp_addmessage @msgnum = 50200, @severity=11, @msgtext='Error adding Message Log record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50201, @severity=11, @msgtext='Error updating Message Log record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50202, @severity=11, @msgtext='Error deleting Message Log record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50203, @severity=11, @msgtext='Error reading Message Log record!', @lang='us_english', @replace='replace'

/* Cycle Number */
/* Numbers from 50300 to 50399 */ 
exec sp_addmessage @msgnum = 50300, @severity=11, @msgtext='Error adding Cycle Number record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50301, @severity=11, @msgtext='Error updating Cycle Number record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50302, @severity=11, @msgtext='Error deleting Cycle Number record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50303, @severity=11, @msgtext='Error reading Cycle Number record!', @lang='us_english', @replace='replace'

/* First Trenton */
/* Numbers from 50400 to 50499 */ 
exec sp_addmessage @msgnum = 50400, @severity=11, @msgtext='Error adding First Trenton Data record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50401, @severity=11, @msgtext='Error updating First Trenton Data record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50402, @severity=11, @msgtext='Error deleting First Trenton Data record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50403, @severity=11, @msgtext='Error truncating First Trenton Data table!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50404, @severity=11, @msgtext='Error reading First Trenton Data record!', @lang='us_english', @replace='replace'

/* Findb */
/* Numbers from 50500 to 50599 */ 
exec sp_addmessage @msgnum = 50500, @severity=11, @msgtext='Error adding Written Production Data record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50501, @severity=11, @msgtext='Error updating Written Production Data record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50502, @severity=11, @msgtext='Error deleting Written Production Data record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50503, @severity=11, @msgtext='Error truncating Written Production Data table!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50504, @severity=11, @msgtext='Error reading Written Production Data record!', @lang='us_english', @replace='replace'


/* Retention */
/* Numbers from 50600 to 50699 */ 
exec sp_addmessage @msgnum = 50600, @severity=11, @msgtext='Error adding FACT_DTL_FIN_MGT_RPT record! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50601, @severity=11, @msgtext='Error updating FACT_DTL_FIN_MGT_RPT record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50602, @severity=11, @msgtext='Error deleting FACT_DTL_FIN_MGT_RPT record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50603, @severity=11, @msgtext='Error truncating FACT_DTL_FIN_MGT_RPT table!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50604, @severity=11, @msgtext='Error reading FACT_DTL_FIN_MGT_RPT record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50699, @severity=11, @msgtext='Error Retention Reconcile!', @lang='us_english', @replace='replace'

/* Control Report: Current & Previous Month*/
/* Numbers from 50700 to 50799 */ 
exec sp_addmessage @msgnum = 50700, @severity=11, @msgtext='Error reading Current Month Control Data file! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50701, @severity=11, @msgtext='Current Month Control Data file (%s) does not exist!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50702, @severity=11, @msgtext='Current Month Control Data file (%s) has no data!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50703, @severity=11, @msgtext='Error Current Month Control Data file transfer failed! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50711, @severity=11, @msgtext='Error reading Previous Month Control Data file! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50712, @severity=11, @msgtext='Previous Month Control Data (%s) file does not exist!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50713, @severity=11, @msgtext='Previous Month Control Data (%s) file has no data!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50714, @severity=11, @msgtext='Error Previous Month Control Data file transfer failed! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50721, @severity=11, @msgtext='Error adding Control Report Data record! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50722, @severity=11, @msgtext='Error updating Control Report Data record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50723, @severity=11, @msgtext='Error deleting Control Report Data record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50724, @severity=11, @msgtext='Error truncating Control Report Data table!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50725, @severity=11, @msgtext='Error reading Control Report Data record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50799, @severity=11, @msgtext='Error reading file transfer extract connection! %s', @lang='us_english', @replace='replace'

/* Extract Status*/
/* Numbers from 50800 to 50810 */ 
exec sp_addmessage @msgnum = 50800, @severity=11, @msgtext='Error adding Extract Status (CRIT_STS_XTRCT) record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50801, @severity=11, @msgtext='Error updating Extract Status (CRIT_STS_XTRCT) record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50802, @severity=11, @msgtext='Error deleting Extract Status (CRIT_STS_XTRCT) record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50803, @severity=11, @msgtext='Error truncating Extract Status (CRIT_STS_XTRCT) record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50804, @severity=11, @msgtext='Control report extract is not complete!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50805, @severity=11, @msgtext='PIF data extract is not complete!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50806, @severity=11, @msgtext='Control report and PIF data extract is not complete!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50807, @severity=11, @msgtext='Trenton extract is not complete!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50808, @severity=11, @msgtext='Findb extract is not complete!', @lang='us_english', @replace='replace'

/* Message */
/* Numbers from 50900 to 50999 */ 
exec sp_addmessage @msgnum = 50900, @severity=11, @msgtext='Error adding Message record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50901, @severity=11, @msgtext='Error updating Message record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50902, @severity=11, @msgtext='Error deleting Message record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50903, @severity=11, @msgtext='Error reading Message record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 50904, @severity=11, @msgtext='Message not found!', @lang='us_english', @replace='replace'

/* MessageTemplate */
/* Numbers from 51000 to 51099 */ 
exec sp_addmessage @msgnum = 51000, @severity=11, @msgtext='Error adding MessageTemplate record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51001, @severity=11, @msgtext='Error updating MessageTemplate record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51002, @severity=11, @msgtext='Error deleting MessageTemplate record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51003, @severity=11, @msgtext='Error reading MessageTemplate record! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51004, @severity=11, @msgtext='MessageTemplate not found! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51099, @severity=11, @msgtext='Error Email Reconcile! %s', @lang='us_english', @replace='replace'

/* Recipient */
/* Numbers from 51100 to 51199 */ 
exec sp_addmessage @msgnum = 51100, @severity=11, @msgtext='Error adding Recipient record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51101, @severity=11, @msgtext='Error updating Recipient record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51102, @severity=11, @msgtext='Error deleting Recipient record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51103, @severity=11, @msgtext='Error reading Recipient record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51104, @severity=11, @msgtext='Recipient not found!', @lang='us_english', @replace='replace'

/* Address Book */
/* Numbers from 51200 to 51299 */ 
exec sp_addmessage @msgnum = 51200, @severity=11, @msgtext='Error adding Address Book record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51201, @severity=11, @msgtext='Error updating Address Book record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51202, @severity=11, @msgtext='Error deleting Address Book record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51203, @severity=11, @msgtext='Error reading Address Book record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51204, @severity=11, @msgtext='Address Book not found!', @lang='us_english', @replace='replace'


/* PIF data: Current & Previous Month*/
/* Numbers from 51300 to 51399 */ 
exec sp_addmessage @msgnum = 51300, @severity=11, @msgtext='Error reading PIF data file! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51301, @severity=11, @msgtext='PIF data file (%s) does not exist!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51302, @severity=11, @msgtext='PIF data file (%s) has no data!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51303, @severity=11, @msgtext='Error reading PIF data current year month data! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51304, @severity=11, @msgtext='Error PIF data file transfer failed! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51311, @severity=11, @msgtext='Error adding PIF data record! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51322, @severity=11, @msgtext='Error updating PIF data record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51313, @severity=11, @msgtext='Error deleting PIF data record! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51314, @severity=11, @msgtext='Error truncating PIF data table!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51315, @severity=11, @msgtext='Error reading PIF data record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51316, @severity=11, @msgtext='Error adding/updating PIF data record! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51399, @severity=11, @msgtext='Error reading file PIF data transfer extract connection! %s', @lang='us_english', @replace='replace'

/* Lookup/Dimension: Form Decode, Market Decode, Dev Facs, ZipCode, StateName, Strategy Auto, Strategy Prop 
and Strategy Geico */
/* Numbers from 51400 to 51499 */ 
exec sp_addmessage @msgnum = 51400, @severity=11, @msgtext='Error reading Form Decode file! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51401, @severity=11, @msgtext='Form Decode file (%s) does not exist!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51402, @severity=11, @msgtext='Form Decode file (%s) has no data!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51403, @severity=11, @msgtext='Error Form Decode file transfer failed! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51404, @severity=11, @msgtext='Error reading Form Decode file transfer extract connection! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51410, @severity=11, @msgtext='Error reading Market Decode file! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51411, @severity=11, @msgtext='Market Decode file (%s) does not exist!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51412, @severity=11, @msgtext='Market Decode file (%s) has no data!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51413, @severity=11, @msgtext='Error Market Decode file transfer failed! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51414, @severity=11, @msgtext='Error reading Market Decode file transfer extract connection! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51420, @severity=11, @msgtext='Error reading Dev Facs file! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51421, @severity=11, @msgtext='Dev Facs file (%s) does not exist!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51422, @severity=11, @msgtext='Dev Facs file (%s) has no data!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51423, @severity=11, @msgtext='Error Dev Facs file transfer failed! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51424, @severity=11, @msgtext='Error reading Dev Facs file transfer extract connection! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51430, @severity=11, @msgtext='Error reading ZipCode file! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51431, @severity=11, @msgtext='ZipCode file (%s) does not exist!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51432, @severity=11, @msgtext='ZipCode file (%s) has no data!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51433, @severity=11, @msgtext='Error ZipCode file transfer failed! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51434, @severity=11, @msgtext='Error reading ZipCode file transfer extract connection! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51440, @severity=11, @msgtext='Error reading StateName file! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51441, @severity=11, @msgtext='StateName file (%s) does not exist!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51442, @severity=11, @msgtext='StateName file (%s) has no data!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51443, @severity=11, @msgtext='Error StateName file transfer failed! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51444, @severity=11, @msgtext='Error reading StateName file transfer extract connection! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51450, @severity=11, @msgtext='Error reading Strategy Auto file! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51451, @severity=11, @msgtext='Strategy Auto file (%s) does not exist!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51452, @severity=11, @msgtext='Strategy Auto file (%s) has no data!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51453, @severity=11, @msgtext='Error Strategy Auto file transfer failed! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51454, @severity=11, @msgtext='Error reading Strategy Auto file transfer extract connection! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51460, @severity=11, @msgtext='Error reading Strategy Prop file! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51461, @severity=11, @msgtext='Strategy Prop file (%s) does not exist!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51462, @severity=11, @msgtext='Strategy Prop file (%s) has no data!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51463, @severity=11, @msgtext='Error Strategy Prop file transfer failed! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51464, @severity=11, @msgtext='Error reading Strategy Prop file transfer extract connection! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51470, @severity=11, @msgtext='Error reading Strategy Geico file! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51471, @severity=11, @msgtext='Strategy Geico file (%s) does not exist!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51472, @severity=11, @msgtext='Strategy Geico file (%s) has no data!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51473, @severity=11, @msgtext='Error Strategy Geico file transfer failed! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51474, @severity=11, @msgtext='Error reading Strategy Geico file transfer extract connection! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51499, @severity=11, @msgtext='Error reading file transfer extract connection! %s', @lang='us_english', @replace='replace'


/* SystemPreference */
/* Numbers from 51500 to 51599 */ 
exec sp_addmessage @msgnum = 51500, @severity=11, @msgtext='Error adding SystemPreference record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51501, @severity=11, @msgtext='Error updating SystemPreference record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51502, @severity=11, @msgtext='Error deleting SystemPreference record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51503, @severity=11, @msgtext='Error reading SystemPreference record! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51504, @severity=11, @msgtext='SystemPreference not found! %s', @lang='us_english', @replace='replace'

/* Direct Written Premium: */
/* Numbers from 51600 to 51699 */ 
exec sp_addmessage @msgnum = 51600, @severity=11, @msgtext='Error reading Direct Written Premium file! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51601, @severity=11, @msgtext='Direct Written Premium file (%s) does not exist!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51602, @severity=11, @msgtext='Direct Written Premium file (%s) has no data!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51603, @severity=11, @msgtext='Error Direct Written Premium file transfer failed! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51699, @severity=11, @msgtext='Error reading file transfer extract connection! %s', @lang='us_english', @replace='replace'

/* FMR Fact */
/* Numbers from 51700 to 51799 */ 
exec sp_addmessage @msgnum = 51700, @severity=11, @msgtext='Error adding Rpt_Fmr_Fct record! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51701, @severity=11, @msgtext='Error updating Rpt_Fmr_Fct record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51702, @severity=11, @msgtext='Error deleting Rpt_Fmr_Fct record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51703, @severity=11, @msgtext='Error truncating Rpt_Fmr_Fct table!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51704, @severity=11, @msgtext='Error reading Rpt_Fmr_Fct record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51799, @severity=11, @msgtext='Error Rpt_Fmr_Fct Fact data!', @lang='us_english', @replace='replace'

/* ICR data: Current & Previous Month*/
/* Numbers from 51800 to 51900 */ 
exec sp_addmessage @msgnum = 51800, @severity=11, @msgtext='Error reading ICR data file! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51801, @severity=11, @msgtext='ICR data file (%s) does not exist!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51802, @severity=11, @msgtext='ICR data file (%s) has no data!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51803, @severity=11, @msgtext='Error reading ICR data current year data! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51804, @severity=11, @msgtext='Error ICR data file transfer failed! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51811, @severity=11, @msgtext='Error adding ICR data record! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51812, @severity=11, @msgtext='Error updating ICR data record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51813, @severity=11, @msgtext='Error deleting ICR data record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51814, @severity=11, @msgtext='Error truncating ICR data table!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51815, @severity=11, @msgtext='Error reading ICR data record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51816, @severity=11, @msgtext='Error adding/updating ICR data record! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51821, @severity=11, @msgtext='Error adding ICR archive data record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51822, @severity=11, @msgtext='Error archive (ARCHV_IND_COMB_RTO) data!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51899, @severity=11, @msgtext='Error reading file ICR data transfer extract connection! %s', @lang='us_english', @replace='replace'

/* Earned Premium and Controllable Loss Ratio Extract: Market & Product Region and Local Market File */
/* Numbers from 51901 to 51999 */ 
exec sp_addmessage @msgnum = 51901, @severity=11, @msgtext='Error reading Market Region file! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51902, @severity=11, @msgtext='Market Region file (%s) does not exist!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51903, @severity=11, @msgtext='Market Region file (%s) has no data!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51904, @severity=11, @msgtext='Error Market Region file transfer failed! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51911, @severity=11, @msgtext='Error reading Product Region file! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51912, @severity=11, @msgtext='Product Region file (%s) does not exist!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51913, @severity=11, @msgtext='Product Region file (%s) has no data!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51914, @severity=11, @msgtext='Error Product Region file transfer failed! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51921, @severity=11, @msgtext='Error reading Local Market file! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51922, @severity=11, @msgtext='Local Market file (%s) does not exist!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51923, @severity=11, @msgtext='Local Market file (%s) has no data!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51924, @severity=11, @msgtext='Error Local Market file transfer failed! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 51999, @severity=11, @msgtext='Error reading file market & region and local market extract connection! %s', @lang='us_english', @replace='replace'

/* XTRCT_MKT_PRDCT_LCL_MKT_RGN */
/* Numbers from 52000 to 52099 */ 
exec sp_addmessage @msgnum = 52000, @severity=11, @msgtext='Error adding XTRCT_MKT_PRDCT_LCL_MKT_RGN record! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 52001, @severity=11, @msgtext='Error updating XTRCT_MKT_PRDCT_LCL_MKT_RGN record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 52002, @severity=11, @msgtext='Error deleting XTRCT_MKT_PRDCT_LCL_MKT_RGN record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 52003, @severity=11, @msgtext='Error truncating XTRCT_MKT_PRDCT_LCL_MKT_RGN table!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 52004, @severity=11, @msgtext='Error reading XTRCT_MKT_PRDCT_LCL_MKT_RGN record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 52099, @severity=11, @msgtext='Error XTRCT_MKT_PRDCT_LCL_MKT_RGN Fact data!', @lang='us_english', @replace='replace'

/* ARCHV_DTL_FIN_MGT_RPT */
/* Numbers from 52100 to 52199 */ 
exec sp_addmessage @msgnum = 52100, @severity=11, @msgtext='Error adding ARCHV_DTL_FIN_MGT_RPT record! %s', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 52101, @severity=11, @msgtext='Error updating ARCHV_DTL_FIN_MGT_RPT record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 52102, @severity=11, @msgtext='Error deleting ARCHV_DTL_FIN_MGT_RPT record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 52103, @severity=11, @msgtext='Error truncating ARCHV_DTL_FIN_MGT_RPT table!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 52104, @severity=11, @msgtext='Error reading ARCHV_DTL_FIN_MGT_RPT record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 52199, @severity=11, @msgtext='Error ARCHV_DTL_FIN_MGT_RPT table Archive!', @lang='us_english', @replace='replace'

/* Holiday */
/* Numbers from 52200 to 52210 */ 
exec sp_addmessage @msgnum = 52200, @severity=11, @msgtext='Error adding Holiday record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 52201, @severity=11, @msgtext='Error updating Holiday record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 52202, @severity=11, @msgtext='Error deleting Holiday record!', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum = 52203, @severity=11, @msgtext='Error reading Holiday record!', @lang='us_english', @replace='replace'

/* ************************************************************************************************************************* */
/* General Error Messages */
/* ************************************************************************************************************************* */
/* Numbers from 100000 to 149999 */ 
exec sp_addmessage @msgnum=100000, @severity=11, @msgtext='Error creating Id()', @with_log='true', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum=100001, @severity=11, @msgtext='Error declaring cusror %s', @with_log='true', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum=100002, @severity=11, @msgtext='Error opening cusror %s', @with_log='true', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum=100003, @severity=11, @msgtext='Error closing cusror %s', @with_log='true', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum=100004, @severity=11, @msgtext='Error deallocating cusror %s', @with_log='true', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum=100005, @severity=11, @msgtext='Error fetching cursor record %s', @with_log='true', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum=100006, @severity=11, @msgtext='No records to process for cursor %s', @with_log='true', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum=100007, @severity=11, @msgtext='This record has child and parent relation delete the child first  %s', @with_log='true', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum=100008, @severity=11, @msgtext='This value already exists in table. Please choose a different value %s', @with_log='true', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum=100009, @severity=11, @msgtext='Error updating msdb.dbo.sysjobs record %s', @with_log='true', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum=100010, @severity=11, @msgtext='Error updating msdb.dbo.sysschedules record %s', @with_log='true', @lang='us_english', @replace='replace'
exec sp_addmessage @msgnum=100011, @severity=11, @msgtext='Error updating msdb job record', @with_log='true', @lang='us_english', @replace='replace'
GO

PRINT '======= FMR Database SysMessage Complete ========'
PRINT ''