DROP XML SCHEMA COLLECTION EmployeeSchema
GO
/*
We have just seen how to define custom types. This example explains
how to create a derived type which inherits the rules defined in a parent
type. 

The following SCHEMA defines a type "EmployeeType". "ProjectManagerType" 
and "SupportEngineerType" inherit from "EmployeeType". Each of the
derived types has their own elements and can have own validation rules.
All the elements, properties and validation rules defined in the parent
type will be available to the derived type too.
*/
CREATE XML SCHEMA COLLECTION EmployeeSchema AS '
<xs:schema xmlns:xs="http://www.w3.org/2001/XMLSchema">
  <xs:element name="Team">
    <xs:complexType>
      <xs:sequence>
        <xs:element name="ProjectManager" type="ProjectManagerType" />
        <xs:element name="SupportEngineer" type="SupportEngineerType" />
      </xs:sequence>
    </xs:complexType>
  </xs:element>
  <xs:complexType name="EmployeeType">
    <xs:sequence>
      <xs:element name="FullName" type="xs:string"/>
      <xs:element name="Department" type="xs:string"/>
      <xs:element name="ReportsTo" type="xs:string"/>
    </xs:sequence>
  </xs:complexType>
  <xs:complexType name="ProjectManagerType">
    <xs:complexContent>
      <xs:extension base="EmployeeType">
        <xs:sequence>
          <xs:element name="ProjectName" type="xs:string"/>
          <xs:element name="Technology" type="xs:string"/>
        </xs:sequence>
      </xs:extension>
    </xs:complexContent>
  </xs:complexType>
  <xs:complexType name="SupportEngineerType">
    <xs:complexContent>
      <xs:extension base="EmployeeType">
        <xs:sequence>
          <xs:element name="Phone" type="xs:string"/>
          <xs:element name="Skype" type="xs:string"/>
          <xs:element name="IM" type="xs:string"/>
        </xs:sequence>
      </xs:extension>
    </xs:complexContent>
  </xs:complexType>
</xs:schema>
'
GO

/*
Here is the XML that validates with the above schema. Note that we have
two elements: ProjectManager and SupportEngineer. Both of them have all 
the elements defined in the EmployeeType: FullName, Department and 
ReportsTo.
*/

DECLARE @emp AS XML(EmployeeSchema)
SET @emp = '
<Team>
	<ProjectManager>
		<FullName>Robert V</FullName>
		<Department>Software</Department>
		<ReportsTo>CEO</ReportsTo>
		<ProjectName>Virtual Earth</ProjectName>
		<Technology>ASP.NET</Technology>
	</ProjectManager>
	<SupportEngineer>
		<FullName>Michael M</FullName>
		<Department>Tech Support</Department>
		<ReportsTo>Robert V</ReportsTo>
		<Phone>999-999-9999</Phone>
		<Skype>whoami</Skype>
		<IM>whoami@whereami.com</IM>
	</SupportEngineer>
</Team>
'
