DROP XML SCHEMA COLLECTION EmployeeSchema
GO
/*
Here is the final version of the schema. I have broken all the elements into various
custom types. 
*/
CREATE XML SCHEMA COLLECTION EmployeeSchema AS '
<xs:schema xmlns:xs="http://www.w3.org/2001/XMLSchema">
  <xs:element name="Employee">
    <xs:complexType>
      <xs:sequence>
        <xs:element name="FullName" type="xs:string" />
        <xs:element name="Age" type="AgeType" />
        <xs:element name="Nationality" type="NationalityType" />
        <xs:element name="Gender" type="GenderType" />
        <xs:element name="Salary" type="SalaryType" />
      </xs:sequence>
      <xs:attribute name="EmployeeNumber" use="required" type="EmployeeNumberType" />
      <xs:attribute name="LoginName" use="required" type="LoginNameType" />
    </xs:complexType>
  </xs:element>
  <xs:simpleType name="AgeType">
    <xs:restriction base="xs:integer">
      <xs:minInclusive value="18" />
      <xs:maxInclusive value="65" />
    </xs:restriction>
  </xs:simpleType>
  <xs:simpleType name="NationalityType">
    <xs:restriction base="xs:string">
      <xs:enumeration value="Indian" />
      <xs:enumeration value="British" />
      <xs:enumeration value="American" />
    </xs:restriction>
  </xs:simpleType>
  <xs:simpleType name="GenderType">
    <xs:restriction base="xs:string">
      <xs:pattern value="male|female" />
    </xs:restriction>
  </xs:simpleType>
  <xs:simpleType name="SalaryType">
    <xs:restriction base="xs:decimal">
      <xs:fractionDigits value="2" />
    </xs:restriction>
  </xs:simpleType>
  <xs:simpleType name="EmployeeNumberType" >
    <xs:restriction base="xs:integer">
      <xs:totalDigits value="6" />
    </xs:restriction>
  </xs:simpleType>
  <xs:simpleType name="LoginNameType">
    <xs:restriction base="xs:string">
      <xs:minLength value="6" />
      <xs:maxLength value="8" />
      <xs:pattern value="([a-z])*" />
    </xs:restriction>
  </xs:simpleType>
</xs:schema>
'
GO

/*
The following is a correct XML value that validates with the above SCHEMA. Note
that the changes in the schema structure did not affect the validation rules. 
*/
DECLARE @emp AS XML(EmployeeSchema)
SET @emp = '
<Employee EmployeeNumber="1001" LoginName="jacobs" >
	<FullName>Jacob</FullName>
	<Age>30</Age>
	<Nationality>Indian</Nationality>
	<Gender>male</Gender>
	<Salary>10000.00</Salary>
</Employee>
'