CREATE PROCEDURE usp_ReadXMLParams
@strXMLStarletCmd	VARCHAR(2000)	OUTPUT
AS
declare curParams CURSOR for Select NodeType, XPathExpression from #tblXMLParams 
			     	Where LOWER(NodeType) Not In ('record_node','delimiter')
			     	Order by XPathOrder, NodeType Desc
declare
	@strNodeType		VARCHAR(20),
	@strXPathExpr		VARCHAR(500),
	@strDelimiter		VARCHAR(5),
	@strRecordNode		VARCHAR(500),
	@strErrorMsg		VARCHAR(500)
begin
	Select @strXMLStarletCmd = ''
	
	Select @strRecordNode = XPathExpression From #tblXMLParams Where LOWER(NodeType) = 'record_node'
	If @@ROWCOUNT = 0
	BEGIN
		Set @strErrorMsg = 'Record Node not specified in #tblXMLParams'
		RAISERROR (@strErrorMsg, 16, 127)
	END
	Else
	BEGIN
		PRINT 'Record Node -> ' + @strRecordNode
		Select @strXMLStarletCmd = @strXMLStarletCmd + '-m "' + @strRecordNode + '" '
	END

	Select @strDelimiter = XPathExpression From #tblXMLParams Where LOWER(NodeType) = 'delimiter'
	If @@ROWCOUNT = 0
	BEGIN
		Select @strDelimiter = ','
	END
	PRINT 'Delimiter -> ' + @strDelimiter

	open curParams
	fetch next from curParams into @strNodeType, @strXPathExpr
	WHILE @@FETCH_STATUS = 0
	BEGIN
		Select @strNodeType = lower(@strNodeType)
		PRINT @strNodeType + ' -> ' + @strXPathExpr
		
		IF @strNodeType = 'node'
		BEGIN
			Select @strXMLStarletCmd = @strXMLStarletCmd + ' -c "' + @strXPathExpr + '" '
			Select @strXMLStarletCmd = @strXMLStarletCmd + ' -o "' + @strDelimiter + '" '			
		END

		IF @strNodeType = 'attribute' or @strNodeType = 'xpath'
		BEGIN
			Select @strXMLStarletCmd = @strXMLStarletCmd + ' -v "' + @strXPathExpr + '" '
			Select @strXMLStarletCmd = @strXMLStarletCmd + ' -o "' + @strDelimiter + '" '			
		END
		
		fetch next from curParams into @strNodeType, @strXPathExpr
	END
	DEALLOCATE curParams
	
	select @strXMLStarletCmd = LTRIM(RTRIM(SUBSTRING(@strXMLStarletCmd, 1, (len(@strXMLStarletCmd) - CHARINDEX('o-', REVERSE(@strXMLStarletCmd))))))
	select @strXMLStarletCmd = @strXMLStarletCmd + ' -n '

	PRINT ''
	PRINT 'Command line parameters for XMLStarlet (excluding the filename):'
	PRINT @strXMLStarletCmd
END

GO
