CREATE Procedure usp_ImportXML
	@strXMLFileName		VARCHAR(500),		
	@strTableName		VARCHAR(100),
	@blnReplace		BIT = 0,
	@strXMLStarletPath	VARCHAR(500) = '',
	@strDelimiter		VARCHAR(1) = ','
AS
DECLARE
	@strRandomName	UniqueIdentifier,
	@strCmd		NVARCHAR(2000),
	@strXMLCmd	NVARCHAR(2000),
	@strTempDir	VARCHAR(100)
BEGIN	
	Select @strXMLCmd = ''
	Select @strRandomName = NEWID()
	exec usp_ReadXMLParams @strXMLCmd OUTPUT
	IF @strXMLStarletPath = ''
	BEGIN
		Select @strCmd = 'C:\XML\xmlstarlet-1.0.1\xml sel -T -t ' + @strXMLCmd + @strXMLFileName + ' > %TEMP%\' + CAST(@strRandomName AS VARCHAR(50))
	END
	ELSE
	BEGIN
		Select @strCmd = @strXMLStarletPath + '\xml sel -T -t ' + @strXMLCmd + @strXMLFileName + ' > %TEMP%\' + CAST(@strRandomName AS VARCHAR(50))		
	END
	PRINT @strCmd
	exec master..xp_cmdshell @strCmd

	Create Table #tblTmp ([Output] Varchar(100))
	Insert Into #tblTmp([Output]) exec master..xp_cmdshell 'echo %TEMP%'
	Delete From #tblTmp Where [Output] IS NULL
	Select @strTempDir = [Output] From #tblTmp
	Drop table #tblTmp
	PRINT 'Temp Directory is ' + @strTempDir

	WAITFOR DELAY '000:00:01'

	BEGIN TRANSACTION
	IF @blnReplace = 1
	BEGIN
		declare @strSQL NVARCHAR(1000)
		Select @strSQL ='DELETE FROM ' + @strTableName
		PRINT 'Deleting existing data....'
		exec sp_executesql @strSQL
	END
	Select @strCmd ='BULK INSERT ' + @strTableName + 
			' FROM ''' + @strTempDir + '\' + CAST(@strRandomName AS VARCHAR(50)) + '''' +
			' WITH (
				FIELDTERMINATOR = ''' + @strDelimiter + ''',
				ROWTERMINATOR = ''\n''
			     )'
	PRINT 'Bulk Insert statement is: ' + @strCmd			
	exec sp_executesql @strCmd
	
	IF @@error != 0
	BEGIN
		ROLLBACK TRANSACTION
	END
	ELSE
	BEGIN
		COMMIT TRANSACTION
	END
	
	PRINT 'Deleting the temp file....'
	Select @strCmd = 'del %TEMP%\' + CAST(@strRandomName AS VARCHAR(50))
	PRINT @strCmd
	exec master..xp_cmdshell @strCmd
END
GO
