DECLARE @art AS XML(ArticleNotificationSchema)
SET @art = '
<ArticleNotification Url="http://www.sqlservercentral.com/3120.asp">
  Hi <Name>Jacob</Name>,
  Please note that your article 
  <Title>XML Workshop VII - Validating values with SCHEMA</Title> 
  is scheduled for publication 
  on <ScheduledDate>2007-01-01Z</ScheduledDate>.
</ArticleNotification>
'

/*
Read the entire text from the "ArticleNotification" element.
*/

SELECT
	x.a.value('(data(/))[1]', 'varchar(max)') AS Summary
FROM @art.nodes('/ArticleNotification') x(a)

/*
OUTPUT:

Summary
---------------------------------------------------

  Hi Jacob,
  Please note that your article 
  XML Workshop VII - Validating values with SCHEMA 
  is scheduled for publication 
  on 2007-01-01Z.


(1 row(s) affected)

*/