DECLARE @art AS XML(ArticleNotificationSchema)
SET @art = '
<ArticleNotification Url="http://www.sqlservercentral.com/3120.asp">
  Hi<Name>Jacob</Name>,
  Please note that your article 
  <Title>XML Workshop VII - Validating values with SCHEMA</Title> 
  is scheduled for publication 
  on <ScheduledDate>2007-01-01Z</ScheduledDate>.
</ArticleNotification>
'

/*
Let us make sure that the value is stored correctly.
Try to retrieve the "Url" attribute from the XML.
*/
SELECT
	x.a.value('(@Url)[1]', 'varchar(50)') AS Url
FROM @art.nodes('/ArticleNotification') x(a)

/*
OUTPUT:

Url
----------------------------------------
http://www.sqlservercentral.com/3120.asp

(1 row(s) affected)
*/

/*
Reading "name" and "title" is pretty simple.
*/

SELECT
	x.a.value('(Name)[1]', 'varchar(10)') AS [Name],
	x.a.value('(Title)[1]','varchar(50)') AS Title,
	x.a.value('(ScheduledDate)[1]','datetime') AS ScheduledDate
FROM @art.nodes('/ArticleNotification') x(a)

/*
OUTPUT:

Name   Title                                            ScheduledDate
------ ------------------------------------------------ -------------------
Jacob  XML Workshop VII - Validating values with SCHEMA 2007-01-01 00:00:00

(1 row(s) affected)

*/