CREATE XML SCHEMA COLLECTION ArticleNotificationSchema AS '
<xs:schema xmlns:xs="http://www.w3.org/2001/XMLSchema">
  <xs:element name="ArticleNotification">
    <xs:complexType mixed="true">
      <xs:sequence>
        <xs:element name="Name" type="xs:string" />
        <xs:element name="Title" type="xs:string"/>
        <xs:element name="ScheduledDate" type="xs:date"/>
      </xs:sequence>
      <xs:attribute name="Url" type ="xs:string" />
    </xs:complexType>
  </xs:element>
</xs:schema>
'
GO

/*
Let us test the schema by assigning a value with the
desired structure to an XML variable which is bound to the
above schema.
*/

DECLARE @art AS XML(ArticleNotificationSchema)
SET @art = '
<ArticleNotification Url="http://www.sqlservercentral.com/3120.asp">
  Hi<Name>Jacob</Name>,
  Please note that your article 
  <Title>XML Workshop VII - Validating values with SCHEMA</Title> 
  is scheduled for publication 
  on <ScheduledDate>2007-01-01Z</ScheduledDate>.
</ArticleNotification>
'