--Listing 5.6: Full backup of TestDB
BACKUP DATABASE TestDB
TO DISK ='C:\Backups\TestDB.bak'
WITH INIT;
GO

--Listing 5.7: Inserting an 11th row into TestDB
USE TestDB
GO
INSERT INTO [TestDB].[dbo].[LogTest]
           ([SomeInt]
           ,[SomeLetters2])
     VALUES
           (66666,
           'ST')
           
SELECT * FROM dbo.LogTest

--Listing 5.8: A log backup of TestDB
USE master
GO
BACKUP Log TestDB
TO DISK ='C:\Backups\TestDB_log.bak'
WITH INIT;
GO

--Listing 5.9: Disaster!
USE TestDB
GO
DROP TABLE dbo.LogTest ;

-- another log backup of TestDB
USE master
GO
BACKUP Log TestDB
TO DISK ='C:\Backups\TestDB_log2.bak'
WITH INIT;
GO

-- Listing 5.10
-- restore a copy of the TestDB database, called
-- ANewTestDB, in STANDBY mode
USE master ;
GO
RESTORE DATABASE ANewTestDB
   FROM DISK ='C:\Backups\TestDB.bak'
   WITH STANDBY='C:\Backups\ANEWTestDB.bak',
   MOVE 'TestDB_dat' TO 'C:\Standby\ANewTestDB.mdf', 
   MOVE 'TestDB_log' TO 'C:\Standby\ANewTestDB.ldf'
GO


--Listing 5.11: Restore a log backup to the ANewTestDB database, in STANDBY mode
USE master
GO
RESTORE LOG ANewTestDB
FROM DISK = 'C:\Backups\TestDB_log.bak'
   WITH STANDBY='C:\Backups\ANewTestDB_log.bak'
