-- FULL BACKUP at 2AM
USE master ;
BACKUP DATABASE TestDB
TO DISK = 'C:\Backups\TestDB.bak'
WITH INIT ;
GO

-- LOG BACKUP 1 at 2.15 AM
USE master ;
BACKUP LOG TestDB
TO DISK = 'C:\Backups\TestDB_log.bak'
WITH INIT ;
GO

-- LOG BACKUP 2 at 2.30 AM
USE master ;
BACKUP LOG TestDB
TO DISK = 'C:\Backups\TestDB_log2.bak'
WITH INIT ;
GO

--RESTORE Full backup
RESTORE DATABASE TestDB
FROM DISK = 'C:\Backups\TestDB.bak'
WITH NORECOVERY;

--RESTORE Log file 1
RESTORE LOG TestDB
FROM DISK = 'C:\Backups\TestDB_log.bak'
WITH NORECOVERY, STOPAT = 'Jan 01, 2020 12:00 AM';

--RESTORE Log file 2
RESTORE LOG TestDB
FROM DISK = 'C:\Backups\TestDB_Log2.bak'
WITH NORECOVERY, STOPAT = 'Jan 01, 2020 12:00 AM';

--Recover the database
RESTORE DATABASE TestDB
WITH RECOVERY;
GO
