-- Perform a full backup of the Test database
-- The WITH FORMAT option starts a new backup set
-- Be careful, as it will overwrite any existing sets
-- The full backup becomes the first file in the set
BACKUP DATABASE TestDB
TO DISK = 'C:\Backups\TestDB.bak'
WITH FORMAT;
GO

-- Perform a transaction log backup of the Test database
-- This is the second file in the set
BACKUP Log TestDB
TO DISK = 'C:\Backups\TestDB.bak'
GO

-- ....<FAILURE OCCURS HERE>....

-- The RESTORE HEADERONLY command is optional.
-- It simply confirms the files that comprise 
-- the current set
RESTORE HEADERONLY
FROM DISK = 'C:\Backups\TestDB.bak'
GO

-- Back up the tail of the log to prepare for restore
-- This will become the third file of the bakup set
BACKUP Log TestDB
TO DISK = 'C:\Backups\TestDB.bak'
WITH NORECOVERY;
GO

-- Restore the full backup
RESTORE DATABASE TestDB
FROM DISK = 'C:\Backups\TestDB.bak'
WITH FILE=1, NORECOVERY;

-- Apply the transaction log backup
RESTORE LOG TestDB
FROM DISK = 'C:\Backups\TestDB.bak'
WITH FILE=2, NORECOVERY;

-- Apply the tail log backup
RESTORE LOG TestDB
FROM DISK = 'C:\Backups\TestDB.bak'
WITH FILE=3, NORECOVERY;

-- Recover the database
RESTORE DATABASE TestDB
WITH RECOVERY;
GO

