USE master
GO

IF EXISTS ( SELECT  name
            FROM    sys.databases
            WHERE   name = 'TestDB' ) 
    DROP DATABASE TestDB ;

CREATE DATABASE TestDB ON
(
  NAME = TestDB_dat,
  FILENAME = 'C:\Program Files\Microsoft SQL Server\MSSQL10.MSSQLSERVER\MSSQL\Data\TestDB.mdf'
) LOG ON
(
  NAME = TestDB_log,
  FILENAME = 'C:\Program Files\Microsoft SQL Server\MSSQL10.MSSQLSERVER\MSSQL\Data\TestDB.ldf'
) ;

USE TestDB
GO
IF OBJECT_ID('dbo.LogTest', 'U') IS NOT NULL 
    DROP TABLE dbo.LogTest ;
SELECT TOP 10
  SomeID = IDENTITY( INT,1,1 ),
  SomeInt = ABS(CHECKSUM(NEWID())) % 50000 + 1 ,
  SomeLetters2 = CHAR(ABS(CHECKSUM(NEWID())) % 26 + 65)
  + CHAR(ABS(CHECKSUM(NEWID())) % 26 + 65)
INTO    dbo.LogTest
FROM    sys.all_columns ac1
        CROSS JOIN sys.all_columns ac2 ;
GO
USE master
GO