@ECHO OFF
@SETLOCAL ENABLEEXTENSIONS
::-----------------------------------------------------------------------------
:: Name:        TSSQLEX.bat.bat
::-----------------------------------------------------------------------------
:: Description: Check for errors in the SQL Server Errors
::              LOG, even if the service is not running.
::              Patterns to search for are stored in separate
::              files.
::
::              Use /H for full parameter details.
::-----------------------------------------------------------------------------
:: Error pattern files:
:: - SEVERITY_LEVEL_11.txt
:: - SEVERITY_LEVEL_12.txt
:: - SEVERITY_LEVEL_13.txt
:: - SEVERITY_LEVEL_14.txt
:: - SEVERITY_LEVEL_16.txt  (Backup)
:: - SEVERITY_LEVEL_16R.txt (Restore)
:: - SEVERITY_LEVEL_17.txt
:: - SEVERITY_LEVEL_18.txt
:: - SEVERITY_LEVEL_19.txt
:: - SEVERITY_LEVEL_20.txt
:: - SEVERITY_LEVEL_21.txt
:: - SEVERITY_LEVEL_22.txt
:: - SEVERITY_LEVEL_23.txt
:: - SEVERITY_LEVEL_24.txt
:: - TEST_SEARCH.txt
::-----------------------------------------------------------------------------
:: Simple processing of the input parameters which ignores the order they appear
:: /H (help) and /O (output to file) will jump to respective labels.
::-----------------------------------------------------------------------------
:: Variable initialization
::-----------------------------------------------------------------------------
@SET DO_PRINT="NOPRINT" 
@SET SKIP_TEST="TEST" 
@SET VERBOSE="QUIET"
@SET CURRDIR=%~dp0
@SET SEARCH_DRIVE=%1
::-----------------------------------------------------------------------------
@IF /i "%1"=="/H" ( @GOTO :HELP )
@IF /i "%2"=="/H" ( @GOTO :HELP )
@IF /i "%3"=="/H" ( @GOTO :HELP )
@IF /i "%4"=="/H" ( @GOTO :HELP )
@IF /i "%5"=="/H" ( @GOTO :HELP ) 
@IF /i "%2"=="/P" ( @SET DO_PRINT="PRINT" )
@IF /i "%3"=="/P" ( @SET DO_PRINT="PRINT" )
@IF /i "%4"=="/P" ( @SET DO_PRINT="PRINT" )
@IF /i "%5"=="/P" ( @SET DO_PRINT="PRINT" )
@IF /i "%2"=="/S" ( @SET SKIP_TEST="NOTEST" )
@IF /i "%3"=="/S" ( @SET SKIP_TEST="NOTEST" )
@IF /i "%4"=="/S" ( @SET SKIP_TEST="NOTEST" )
@IF /i "%5"=="/S" ( @SET SKIP_TEST="NOTEST" )
@IF /i "%2"=="/V" ( @SET VERBOSE="ON" )
@IF /i "%3"=="/V" ( @SET VERBOSE="ON" )
@IF /i "%4"=="/V" ( @SET VERBOSE="ON" )
@IF /i "%5"=="/V" ( @SET VERBOSE="ON" )
@IF /i "%2"=="/O" ( @GOTO :WRITEFILE )
@IF /i "%3"=="/O" ( @GOTO :WRITEFILE )
@IF /i "%4"=="/O" ( @GOTO :WRITEFILE )
@IF /i "%5"=="/O" ( @GOTO :WRITEFILE )
::-----------------------------------------------------------------------------
:: If no parameters are passed, print the README
@IF /i "%1"=="" ( @GOTO :QUICK_HELP )
::-----------------------------------------------------------------------------
@ECHO -------------------------------------------------------------------------
@ECHO This computer name:   %COMPUTERNAME%
@ECHO Fully qualified name: %COMPUTERNAME%.%USERDNSDOMAIN%
@ECHO Current user:         %USERNAME%
@ECHO SQL Log drive:        %SEARCH_DRIVE%:\
@ECHO -------------------------------------------------------------------------
@ECHO The current system date and time:
@ECHO  %date%-%time%
@ECHO -------------------------------------------------------------------------
@ECHO Operating system: 
@VER |FIND /I "Windows"
::-----------------------------------------------------------------------------
:: Fetch the SQL Server Log file directory from the Registry
:: NOTE: This will fail to find more than one directory if multiple instances
::       exist on the server.
:: If the registry entry does not exist, then the program will display a message 
:: and exit.
::-----------------------------------------------------------------------------
@SET LOGDIR=NOT_FOUND
@FOR /F %%A IN ('dir /s /b %SEARCH_DRIVE%:\ERRORLOG ^| findstr /i /e "errorlog" ^| find /i /V "roaming"') DO (
	@SET LOGDIR=%%A
)
@IF %LOGDIR%==NOT_FOUND (
    @COLOR 0C
	@ECHO SQL Server Log directory not found, the program will be terminated. 
	@PAUSE
	@COLOR
	@GOTO :EOF
)
@SET LOGDIR=%LOGDIR%*
::-----------------------------------------------------------------------------
:: Test search to verify that the search patterns are working correctly.
::-----------------------------------------------------------------------------
@IF /i NOT %SKIP_TEST%=="NOTEST" (
@ECHO -------------------------------------------------------------------------
@ECHO Testing Error Search: FINDSTR /I /R /G:"%CURRDIR%TEST_SEARCH.txt" "%LOGDIR%"
@ECHO This should match once in every log file.
@FINDSTR /R /I /A:02 /G:"%CURRDIR%TEST_SEARCH.txt" "%LOGDIR%" || @ECHO [Failed] Test string not found.
)
@ECHO -------------------------------------------------------------------------
@ECHO Severity Level 10 ( Memory )
@IF /I %VERBOSE%=="ON" (
@ECHO Indicates that the given object or entity does not exist.
@ECHO -------------------------------------------------------------------------
)
@IF /i %DO_PRINT%=="print" ( @ECHO Command: FINDSTR /I /R /G:"%CURRDIR%SEVERITY_LEVEL_10M.txt" "%LOGDIR%" )
@FINDSTR /R /I /A:0C /G:"%CURRDIR%SEVERITY_LEVEL_10M.txt" "%LOGDIR%" || @ECHO No Severity Level 10 ( Memory ) errors found.
@ECHO -------------------------------------------------------------------------
@ECHO Severity Level 10 ( Disk )
@IF /I %VERBOSE%=="ON" (
@ECHO Indicates that the given object or entity does not exist.
@ECHO -------------------------------------------------------------------------
)
@IF /i %DO_PRINT%=="print" ( @ECHO Command: FINDSTR /I /R /G:"%CURRDIR%SEVERITY_LEVEL_10D.txt" "%LOGDIR%" )
@FINDSTR /R /I /A:0C /G:"%CURRDIR%SEVERITY_LEVEL_10D.txt" "%LOGDIR%" || @ECHO No Severity Level 10 ( Disk ) errors found.
@ECHO -------------------------------------------------------------------------
@ECHO Severity Level 11
@IF /I %VERBOSE%=="ON" (
@ECHO Indicates that the given object or entity does not exist.
@ECHO -------------------------------------------------------------------------
)
@IF /i %DO_PRINT%=="print" ( @ECHO Command: FINDSTR /I /R /G:"%CURRDIR%SEVERITY_LEVEL_11.txt" "%LOGDIR%" )
@FINDSTR /R /I /A:0C /G:"%CURRDIR%SEVERITY_LEVEL_11.txt" "%LOGDIR%" || @ECHO No Severity Level 11 errors found.
@ECHO -------------------------------------------------------------------------
@ECHO Severity Level 12
@IF /I %VERBOSE%=="ON" (
@ECHO A special severity for queries that do not use locking because of special 
@ECHO query hints. In some cases, read operations performed by these statements 
@ECHO could result in inconsistent data, since locks are not taken to guarantee 
@ECHO consistency.
@ECHO -------------------------------------------------------------------------
)
@IF /i %DO_PRINT%=="print" ( @ECHO Command: FINDSTR /I /R /G:"%CURRDIR%SEVERITY_LEVEL_12.txt" "%LOGDIR%" )
@FINDSTR /R /I /A:0C /G:"%CURRDIR%SEVERITY_LEVEL_12.txt" "%LOGDIR%" || @ECHO No Severity Level 12 errors found.
@ECHO -------------------------------------------------------------------------
@ECHO Severity Level 13
@IF /I %VERBOSE%=="ON" (
@ECHO Indicates transaction deadlock errors.
@ECHO -------------------------------------------------------------------------
)
@IF /i %DO_PRINT%=="print" ( @ECHO Command: FINDSTR /I /R /G:"%CURRDIR%SEVERITY_LEVEL_13.txt" "%LOGDIR%" )
@FINDSTR /R /I /A:0C /G:"%CURRDIR%SEVERITY_LEVEL_13.txt" "%LOGDIR%" || @ECHO No Severity Level 13 errors found.
@ECHO -------------------------------------------------------------------------
@ECHO Severity Level 14
@IF /I %VERBOSE%=="ON" (
@ECHO Indicates security-related errors, such as permission denied.
@ECHO -------------------------------------------------------------------------
)
@IF /i %DO_PRINT%=="print" ( @ECHO Command: FINDSTR /I /R /G:"%CURRDIR%SEVERITY_LEVEL_14.txt" "%LOGDIR%" )
@FINDSTR /R /I /A:0C /G:"%CURRDIR%SEVERITY_LEVEL_14.txt" "%LOGDIR%" || @ECHO No Severity Level 14 errors found.
@ECHO -------------------------------------------------------------------------
@ECHO Severity Level 16 (Backup)
@IF /I %VERBOSE%=="ON" (
@ECHO Indicates general errors that can be corrected by the user. This section
@ECHO looks for backup related errors.
@ECHO -------------------------------------------------------------------------
)
@IF /i %DO_PRINT%=="print" ( @ECHO Command: FINDSTR /I /R /G:"%CURRDIR%SEVERITY_LEVEL_16.txt" "%LOGDIR%" )
@FINDSTR /R /I /A:0C /G:"%CURRDIR%SEVERITY_LEVEL_16.txt" "%LOGDIR%" || @ECHO No Severity Level 16 (Backup) errors found.
@ECHO -------------------------------------------------------------------------
@ECHO Severity Level 16 (Restore)
@IF /I %VERBOSE%=="ON" (
@ECHO Indicates general errors that can be corrected by the user. This section
@ECHO looks for restore related errors.
@ECHO -------------------------------------------------------------------------
)
@IF /i %DO_PRINT%=="print" ( @ECHO Command: FINDSTR /I /R /G:"%CURRDIR%SEVERITY_LEVEL_16R.txt" "%LOGDIR%" )
@FINDSTR /R /I /A:0C /G:"%CURRDIR%SEVERITY_LEVEL_16R.txt" "%LOGDIR%" || @ECHO No Severity Level 16 (Restore) errors found.
@ECHO -------------------------------------------------------------------------
@ECHO Severity Level 17
@IF /I %VERBOSE%=="ON" (
@ECHO Indicates that the statement caused SQL Server to run out of resources 
@ECHO such as memory, locks, disk space for the database or to exceed 
@ECHO some limit set by the system administrator.
@ECHO -------------------------------------------------------------------------
)
@IF /i %DO_PRINT%=="print" ( @ECHO Command: FINDSTR /I /R /G:"%CURRDIR%SEVERITY_LEVEL_17.txt" "%LOGDIR%" )
@FINDSTR /R /I /A:0C /G:"%CURRDIR%SEVERITY_LEVEL_17.txt" "%LOGDIR%" || @ECHO No Severity Level 17 errors found.
@ECHO -------------------------------------------------------------------------
@ECHO Severity Level 18
@IF /I %VERBOSE%=="ON" (
@ECHO Indicates a problem in the Database Engine software, but the statement 
@ECHO completes execution, and the connection to the instance of the Database 
@ECHO Engine is maintained. The system administrator should be informed every 
@ECHO time a message with a severity level of 18 occurs.
@ECHO -------------------------------------------------------------------------
)
@IF /i %DO_PRINT%=="print" ( @ECHO Command: FINDSTR /I /R /G:"%CURRDIR%SEVERITY_LEVEL_18.txt" "%LOGDIR%" )
@FINDSTR /R /I /A:0C /G:"%CURRDIR%SEVERITY_LEVEL_18.txt" "%LOGDIR%" || @ECHO No Severity Level 18 errors found.
@ECHO -------------------------------------------------------------------------
@ECHO Severity Level 19
@IF /I %VERBOSE%=="ON" (
@ECHO Indicates that a nonconfigurable Database Engine limit has been exceeded 
@ECHO and the current batch process has been terminated. Error messages with a 
@ECHO severity level of 19 or higher stop the execution of the current batch. 
@ECHO Severity level 19 errors are rare and must be corrected by the system 
@ECHO administrator or your primary support provider. Contact your system 
@ECHO administrator when a message with a severity level 19 is raised. Error 
@ECHO messages with a severity level from 19 through 25 are written to the 
@ECHO error log.
@ECHO -------------------------------------------------------------------------
)
@IF /i %DO_PRINT%=="print" ( @ECHO Command: FINDSTR /I /R /G:"%CURRDIR%SEVERITY_LEVEL_19.txt" "%LOGDIR%" )
@FINDSTR /R /I /A:0C /G:"%CURRDIR%SEVERITY_LEVEL_19.txt" "%LOGDIR%" || @ECHO No Severity Level 19 errors found.
@ECHO -------------------------------------------------------------------------
@ECHO Severity Level 20
@IF /I %VERBOSE%=="ON" (
@ECHO Indicates that a statement has encountered a problem. Because the problem 
@ECHO has affected only the current task, it is unlikely that the database
@ECHO  itself has been damaged.
@ECHO -------------------------------------------------------------------------
)
@IF /i %DO_PRINT%=="print" ( @ECHO Command: FINDSTR /I /R /G:"%CURRDIR%SEVERITY_LEVEL_20.txt" "%LOGDIR%" )
@FINDSTR /R /I /A:0C /G:"%CURRDIR%SEVERITY_LEVEL_20.txt" "%LOGDIR%" || @ECHO No Severity Level 20 errors found.
@ECHO -------------------------------------------------------------------------
@ECHO Severity Level 21
@IF /I %VERBOSE%=="ON" (
@ECHO Indicates that a problem has been encountered that affects all tasks in 
@ECHO the current database, but it is unlikely that the database itself has been 
@ECHO damaged.
@ECHO -------------------------------------------------------------------------
)
@IF /i %DO_PRINT%=="print" ( @ECHO Command: FINDSTR /I /R /G:"%CURRDIR%SEVERITY_LEVEL_21.txt" "%LOGDIR%" )
@FINDSTR /R /I /A:0C /G:"%CURRDIR%SEVERITY_LEVEL_21.txt" "%LOGDIR%" || @ECHO No Severity Level 21 errors found.
@ECHO -------------------------------------------------------------------------
@ECHO Severity Level 22
@IF /I %VERBOSE%=="ON" (
@ECHO Indicates that the table or index specified in the message has been 
@ECHO damaged by a software or hardware problem.
@ECHO. 
@ECHO Severity level 22 errors occur rarely. If one occurs, run DBCC CHECKDB to 
@ECHO determine whether other objects in the database are also damaged. The 
@ECHO problem might be in the buffer cache only and not on the disk itself. If 
@ECHO so, restarting the instance of the Database Engine corrects the problem. 
@ECHO To continue working, you must reconnect to the instance of the Database 
@ECHO Engine; otherwise, use DBCC to repair the problem. In some cases, you may 
@ECHO have to restore the database.
@ECHO -------------------------------------------------------------------------
)
@IF /i %DO_PRINT%=="print" ( @ECHO Command: FINDSTR /I /R /G:"%CURRDIR%SEVERITY_LEVEL_22.txt" "%LOGDIR%" )
@FINDSTR /R /I /A:0C /G:"%CURRDIR%SEVERITY_LEVEL_22.txt" "%LOGDIR%" || @ECHO No Severity Level 22 errors found.
@ECHO -------------------------------------------------------------------------
@ECHO Severity Level 23
@IF /I %VERBOSE%=="ON" (
@ECHO Indicates that the integrity of the entire database is in question because 
@ECHO of a hardware or software problem.
@ECHO.
@ECHO Severity level 23 errors occur rarely. If one occurs, run DBCC CHECKDB to 
@ECHO determine the extent of the damage. The problem might be in the cache only 
@ECHO and not on the disk itself. If so, restarting the instance of the Database 
@ECHO Engine corrects the problem. To continue working, you must reconnect to 
@ECHO the instance of the Database Engine; otherwise, use DBCC to repair the 
@ECHO problem. In some cases, you may have to restore the database.
@ECHO -------------------------------------------------------------------------
)
@IF /i %DO_PRINT%=="print" ( @ECHO Command: FINDSTR /I /R /G:"%CURRDIR%SEVERITY_LEVEL_23.txt" "%LOGDIR%" )
@FINDSTR /R /I /A:0C /G:"%CURRDIR%SEVERITY_LEVEL_23.txt" "%LOGDIR%" || @ECHO No Severity Level 23 errors found.
@ECHO -------------------------------------------------------------------------
@ECHO Severity Level 24
@IF /I %VERBOSE%=="ON" (
@ECHO Indicates a media failure. The system administrator may have to restore 
@ECHO the database. You may also have to call your hardware vendor.
@ECHO -------------------------------------------------------------------------
)
@IF /i %DO_PRINT%=="print" ( @ECHO Command: FINDSTR /I /R /G:"%CURRDIR%SEVERITY_LEVEL_24.txt" "%LOGDIR%" )
@FINDSTR /R /I /A:0C /G:"%CURRDIR%SEVERITY_LEVEL_24.txt" "%LOGDIR%" || @ECHO No Severity Level 24 errors found.
@ECHO -------------------------------------------------------------------------
@GOTO :EOF
@:HELP
@MORE %CURRDIR%README.txt
@GOTO :EOF
@:QUICK_HELP
@ECHO Search for error entries in the SQL Server Error Log files.
@ECHO. 
@ECHO Syntax: 
@ECHO. 
@ECHO TSSQLELX.bat [Drive letter] [/S] [/P] [/V] [/H] [/O] 
@ECHO Parameters:
@ECHO   The first parameter must either be a single character drive letter of 
@ECHO   the drive to search or the /H switch, if no arguments are passed, the 
@ECHO   syntax is printed.
@ECHO.      
@ECHO Switches:
@ECHO.      
@ECHO   /S Skip the functionality test
@ECHO      The functionality test asserts the search functionality by looking
@ECHO      for a pattern that appears in all error log files.
@ECHO.      
@ECHO   /P Print the individual commands before executing
@ECHO      Useful for repeating searches for individual error level by copying
@ECHO      the command and re-run it from the command prompt.
@ECHO.      
@ECHO   /V Verbose, print additional information for each error level.
@ECHO      Prints the error level description text from BOL.
@ECHO.      
@ECHO   /H Help, prints the full Readme.txt
@ECHO      The message can be found in the README.txt file in the batch file's 
@ECHO      directory.
@ECHO.      
@ECHO   /O Writes the output to a file called COMPUTERNAME.USERDNSDOMAIN_TSSQLEX.txt.
@ECHO      The file is created or overwritten in the batch file's directory.
@GOTO :EOF
@:WRITEFILE
@SET P0=%1
@SET P1=
@SET P2=
@SET P3=
@IF /i %SKIP_TEST%=="NOTEST" ( @SET P1=/S )
@IF /i %VERBOSE%=="ON" ( @SET P2=/v )
@IF /i %DO_PRINT%=="PRINT" ( @SET P3=/P )
@%0 %P0% %P1% %P2% %P3% >%~dp0%COMPUTERNAME%.%USERDNSDOMAIN%_TSSQLEX.txt

@GOTO :EOF