/**********************************************
 * StairwayToSQLCLR-06_TestQueries-01.sql
 * 
 * Example Code for
 * Stairway to SQLCLR - Level 6: Development Tools
 * http://www.sqlservercentral.com/articles/SQLCLR/
 * 
 * Copyright (C) 2016 Solomon Rutzky. All Rights Reserved.
 * 
 **********************************************/

SET ANSI_NULLS ON;
SET QUOTED_IDENTIFIER ON;
SET NOCOUNT ON;
GO
------------------------------
-- IGNORE THIS SECTION
IF (OBJECT_ID(N'tempdb..#F5') IS NULL)
BEGIN
	CREATE TABLE #F5 (Col1 INT);
END;
SET NOEXEC ON;
GO
-- IGNORE THIS SECTION
------------------------------

USE [StairwayToSQLCLR-06_ConnectionTypeTest];

SELECT assembly_id, name, clr_name FROM sys.assemblies WHERE assembly_id <> 1;
SELECT * FROM sys.assembly_files WHERE assembly_id <> 1;

------------------------------------------------
-- Queries that work when using the Context Connection

SELECT dbo.StairwayToSQLCLR_ConnectionTest(N'SELECT GETDATE();', NULL);

SELECT dbo.StairwayToSQLCLR_ConnectionTest(N'SELECT COUNT(*) FROM sys.objects;', NULL);

DECLARE @SQL NVARCHAR(MAX);
SET @SQL = N'
DECLARE @Test INT = 5,
        @Counter INT = 0;
WHILE (@Counter < 10)
BEGIN
  SET @Test *= 7;
  SET @Counter += 1;
END;
SELECT @Test;
';
SELECT dbo.StairwayToSQLCLR_ConnectionTest(@SQL, NULL); -- 1412376245

GO
------------------------------------------------
-- Is the Context Connection part of the same transaction?
-- When the value of "transaction_id" changes, that denotes a different Transaction.

SELECT transaction_id FROM sys.dm_tran_current_transaction;
GO 3

SELECT dbo.StairwayToSQLCLR_ConnectionTest(N'SELECT transaction_id FROM sys.dm_tran_current_transaction;', NULL);
GO 3


-- transaction_id should be the same across the next 3 SELECTs.
BEGIN TRAN;
SELECT transaction_id FROM sys.dm_tran_current_transaction;
SELECT transaction_id FROM sys.dm_tran_current_transaction;
SELECT transaction_id FROM sys.dm_tran_current_transaction;
ROLLBACK;


-- transaction_id should also be the same across the next 4 SELECTs.
BEGIN TRAN;
SELECT transaction_id FROM sys.dm_tran_current_transaction;
SELECT dbo.StairwayToSQLCLR_ConnectionTest(N'SELECT transaction_id FROM sys.dm_tran_current_transaction;', NULL);
SELECT dbo.StairwayToSQLCLR_ConnectionTest(N'SELECT transaction_id FROM sys.dm_tran_current_transaction;', NULL);
SELECT transaction_id FROM sys.dm_tran_current_transaction;
ROLLBACK;

GO
------------------------------------------------
-- Try some operations that cannot be done in T-SQL UDFs

SELECT dbo.StairwayToSQLCLR_ConnectionTest(N'SELECT NEWID();', NULL);
/*
Msg 6522, Level 16, State 1, Line 1
A .NET Framework error occurred during execution of user-defined routine or aggregate "StairwayToSQLCLR_ConnectionTest": 
System.Data.SqlClient.SqlException: Invalid use of a side-effecting operator 'SELECT WITHOUT QUERY' within a function.
*/

SELECT dbo.StairwayToSQLCLR_ConnectionTest(N'SET NOCOUNT ON;', NULL);
/*
Msg 6522, Level 16, State 1, Line 1
A .NET Framework error occurred during execution of user-defined routine or aggregate "StairwayToSQLCLR_ConnectionTest": 
System.Data.SqlClient.SqlException: Invalid use of a side-effecting operator 'SET ON/OFF' within a function.
*/

CREATE TABLE #StairwayTest (Col1 INT);
INSERT INTO #StairwayTest (Col1) VALUES (1),(10),(100);

SELECT dbo.StairwayToSQLCLR_ConnectionTest(N'INSERT INTO #StairwayTest (Col1) VALUES (2),(20),(200);', NULL);
/*
Msg 6522, Level 16, State 1, Line 1
A .NET Framework error occurred during execution of user-defined routine or aggregate "StairwayToSQLCLR_ConnectionTest": 
System.Data.SqlClient.SqlException: Invalid use of a side-effecting operator 'INSERT' within a function.
*/

SELECT dbo.StairwayToSQLCLR_ConnectionTest(N'SELECT SUM(Col1) FROM #StairwayTest;', NULL); -- 111
/*
  Wait. This one actually worked. Wouldn't this fail in a T-SQL UDF?
*/
GO
CREATE FUNCTION dbo.TempTable ()
RETURNS INT
AS
BEGIN
	DECLARE @ReturnValue INT;

	SELECT @ReturnValue = SUM(Col1)
	FROM #StairwayTest;

	RETURN @ReturnValue;
END;
GO
/*
Msg 2772, Level 16, State 1, Procedure TempTable, Line 8
Cannot access temporary tables from within a function.
*/
-- Why yes. It certainly would fail in a T-SQL UDF. Score 1 for SQLCLR :-)
GO

------------------------------------------------
-- Try some operations that we might not be sure of

SELECT dbo.StairwayToSQLCLR_ConnectionTest(N'SELECT GETDATE();', 1);
/*
Msg 6522, Level 16, State 1, Line 1
A .NET Framework error occurred during execution of user-defined routine or aggregate "StairwayToSQLCLR_ConnectionTest": 
System.Security.SecurityException: Request for the permission of type 'System.Security.Permissions.SecurityPermission, mscorlib, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089' failed.
System.Security.SecurityException: 
   at System.Data.SqlServer.Internal.ClrLevelContext.get_WindowsIdentity()
*/
-- So we need to set the Assembly to EXTERNAL_ACCESS. In order to do that
-- we will need to sign the Assembly, create an Asymmetric Key from the
-- Assembly, and then create a Login from the Asymmetric Key.

SELECT dbo.StairwayToSQLCLR_ConnectionTest(NULL, 0);
/*
Msg 6522, Level 16, State 1, Line 1
A .NET Framework error occurred during execution of user-defined routine or aggregate "StairwayToSQLCLR_ConnectionTest": 
System.Data.SqlTypes.SqlNullValueException: Data is Null. This method or property cannot be called on Null values.
System.Data.SqlTypes.SqlNullValueException: 
   at System.Data.SqlTypes.SqlString.get_Value()
*/
-- We should probably prevent this error from happening.


------------------------------
-- IGNORE THIS SECTION
GO
SET NOEXEC OFF;
IF (OBJECT_ID(N'tempdb..#F5') IS NOT NULL)
BEGIN
	RAISERROR(N'	Please do not hit F5 / Control-E / "! Execute" button for this script.
	Please highlight and run each section separately.', 16, 1);
	DROP TABLE #F5;
END;
GO
-- IGNORE THIS SECTION
------------------------------
