/**********************************************
 * GetLocalServerNameForConnectionString
 * 
 * Example Code for
 * Stairway to SQLCLR - Level 6: Development Tools
 * http://www.sqlservercentral.com/articles/SQLCLR/
 * 
 * Copyright (C) 2016 Sql Quantum Leap. All Rights Reserved.
 * http://www.SqlQuantumLeap.com/
 * 
 **********************************************/

USE [StairwayToSQLCLR-06_ConnectionTypeTest];
SET ANSI_NULLS ON;
SET QUOTED_IDENTIFIER ON;
SET NOCOUNT ON;
GO
------------------------------

IF (OBJECT_ID(N'dbo.GetLocalServerNameForConnectionString') IS NULL)
BEGIN
    EXEC(N'CREATE FUNCTION dbo.GetLocalServerNameForConnectionString () RETURNS NVARCHAR(200) AS BEGIN RETURN @@SERVERNAME; END;');
END
GO
/**********************************************
 * Function:  GetLocalServerNameForConnectionString
 * Date:      2016-01-20
 * By:        Solomon Rutzky
 * Of:        Sql Quantum Leap ( http://SqlQuantumLeap.com )
 * 
 * Stairway to SQLCLR - Level 6: Development Tools
 *
 * Stairway to SQLCLR series:
 * http://www.sqlservercentral.com/stairway/105855/
 * 
 **********************************************/

ALTER FUNCTION dbo.GetLocalServerNameForConnectionString (@Template NVARCHAR(1000))
RETURNS NVARCHAR(1000)
AS
BEGIN
    DECLARE @ServerName NVARCHAR(1000);

    SET @ServerName = @@SERVERNAME;

    IF (CONVERT(BIT, SERVERPROPERTY('IsLocalDB')) = 1)
    BEGIN
        -- np:\\.\pipe\LOCALDB#SH666D8E\tsql\query
        -- "SH" at the beginning means "Shared Instance"
        SET @ServerName = N'np:\\.\pipe\' +
                          CONVERT(sysname, SERVERPROPERTY('InstanceName')) +
                          N'\tsql\query';
    END;

    IF (ISNULL(@Template, N'') <> N'')
    BEGIN
        SET @ServerName = REPLACE(@Template, N'{{ServerName}}', @ServerName);
    END;

    RETURN @ServerName;
END;
GO
